/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.block;

import java.util.List;
import java.util.Random;
import net.minecraft.block.Block;
import net.minecraft.block.BlockBush;
import net.minecraft.block.IGrowable;
import net.minecraft.block.SoundType;
import net.minecraft.block.properties.IProperty;
import net.minecraft.block.properties.PropertyInteger;
import net.minecraft.block.state.BlockStateContainer;
import net.minecraft.block.state.IBlockState;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.EnumFacing;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IPlantable;

class BlockXercaCrop
extends BlockBush
implements IGrowable {
    private Item seed;
    private Item crop;
    private static final PropertyInteger AGE = PropertyInteger.func_177719_a((String)"age", (int)0, (int)3);
    private static final AxisAlignedBB[] CROPS_AABB = new AxisAlignedBB[]{new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.125, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.375, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 0.625, 1.0), new AxisAlignedBB(0.0, 0.0, 0.0, 1.0, 1.0, 1.0)};

    BlockXercaCrop() {
        this.func_180632_j(this.field_176227_L.func_177621_b().func_177226_a((IProperty)this.getAge(), (Comparable)Integer.valueOf(0)));
        this.func_149675_a(true);
        this.func_149647_a(null);
        this.func_149711_c(0.0f);
        this.func_149672_a(SoundType.field_185850_c);
        this.func_149649_H();
    }

    void setSeed(Item seed) {
        this.seed = seed;
    }

    void setCrop(Item crop) {
        this.crop = crop;
    }

    public AxisAlignedBB func_185496_a(IBlockState state, IBlockAccess source, BlockPos pos) {
        return CROPS_AABB[(Integer)state.func_177229_b((IProperty)this.getAge())];
    }

    private PropertyInteger getAge() {
        return AGE;
    }

    private int getMaxAge() {
        return 3;
    }

    private int getAge(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAge());
    }

    private IBlockState getState(int age) {
        return this.func_176223_P().func_177226_a((IProperty)this.getAge(), (Comparable)Integer.valueOf(age));
    }

    private boolean isFullyGrown(IBlockState state) {
        return (Integer)state.func_177229_b((IProperty)this.getAge()) >= this.getMaxAge();
    }

    public void func_180650_b(World worldIn, BlockPos pos, IBlockState state, Random rand) {
        float f;
        int i;
        super.func_180650_b(worldIn, pos, state, rand);
        if (worldIn.func_175671_l(pos.func_177984_a()) >= 9 && (i = this.getAge(state)) < this.getMaxAge() && rand.nextInt((int)(25.0f / (f = BlockXercaCrop.getGrowthChance((Block)this, worldIn, pos))) + 1) == 0) {
            worldIn.func_180501_a(pos, this.getState(i + 1), 2);
        }
    }

    private int randomHelper(World worldIn) {
        return MathHelper.func_76136_a((Random)worldIn.field_73012_v, (int)2, (int)5);
    }

    private static float getGrowthChance(Block blockIn, World worldIn, BlockPos pos) {
        boolean flag1;
        float f = 1.0f;
        BlockPos blockpos = pos.func_177977_b();
        for (int i = -1; i <= 1; ++i) {
            for (int j = -1; j <= 1; ++j) {
                float f1 = 0.0f;
                IBlockState iblockstate = worldIn.func_180495_p(blockpos.func_177982_a(i, 0, j));
                if (iblockstate.func_177230_c().canSustainPlant(iblockstate, (IBlockAccess)worldIn, blockpos.func_177982_a(i, 0, j), EnumFacing.UP, (IPlantable)blockIn)) {
                    f1 = 1.0f;
                    if (iblockstate.func_177230_c().isFertile(worldIn, blockpos.func_177982_a(i, 0, j))) {
                        f1 = 3.0f;
                    }
                }
                if (i != 0 || j != 0) {
                    f1 /= 4.0f;
                }
                f += f1;
            }
        }
        BlockPos blockpos1 = pos.func_177978_c();
        BlockPos blockpos2 = pos.func_177968_d();
        BlockPos blockpos3 = pos.func_177976_e();
        BlockPos blockpos4 = pos.func_177974_f();
        boolean flag = blockIn == worldIn.func_180495_p(blockpos3).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4).func_177230_c();
        boolean bl = flag1 = blockIn == worldIn.func_180495_p(blockpos1).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos2).func_177230_c();
        if (flag && flag1) {
            f /= 2.0f;
        } else {
            boolean flag2;
            boolean bl2 = flag2 = blockIn == worldIn.func_180495_p(blockpos3.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177978_c()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos4.func_177968_d()).func_177230_c() || blockIn == worldIn.func_180495_p(blockpos3.func_177968_d()).func_177230_c();
            if (flag2) {
                f /= 2.0f;
            }
        }
        return f;
    }

    public boolean func_180671_f(World worldIn, BlockPos pos, IBlockState state) {
        IBlockState soil = worldIn.func_180495_p(pos.func_177977_b());
        return (worldIn.func_175699_k(pos) >= 8 || worldIn.func_175678_i(pos)) && soil.func_177230_c().canSustainPlant(soil, (IBlockAccess)worldIn, pos.func_177977_b(), EnumFacing.UP, (IPlantable)this);
    }

    private Item getSeed() {
        return this.seed;
    }

    private Item getCrop() {
        return this.crop;
    }

    public List<ItemStack> getDrops(IBlockAccess world, BlockPos pos, IBlockState state, int fortune) {
        Random rand;
        List ret = super.getDrops(world, pos, state, fortune);
        int age = this.getAge(state);
        Random random = rand = world instanceof World ? ((World)world).field_73012_v : new Random();
        if (age >= this.getMaxAge()) {
            for (int i = 0; i < 3 + fortune; ++i) {
                if (rand.nextInt(2 * this.getMaxAge()) > age) continue;
                ret.add(new ItemStack(this.getSeed(), 1, 0));
            }
        }
        return ret;
    }

    private void grow(World worldIn, BlockPos pos, IBlockState state) {
        int j;
        int i = this.getAge(state) + this.randomHelper(worldIn);
        if (i > (j = this.getMaxAge())) {
            i = j;
        }
        worldIn.func_180501_a(pos, this.getState(i), 2);
    }

    public void func_180653_a(World worldIn, BlockPos pos, IBlockState state, float chance, int fortune) {
        super.func_180653_a(worldIn, pos, state, chance, 0);
    }

    public Item func_180660_a(IBlockState state, Random rand, int fortune) {
        return this.isFullyGrown(state) ? this.getCrop() : this.getSeed();
    }

    public boolean func_176473_a(World worldIn, BlockPos pos, IBlockState state, boolean isClient) {
        return !this.isFullyGrown(state);
    }

    public boolean func_180670_a(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        return true;
    }

    public void func_176474_b(World worldIn, Random rand, BlockPos pos, IBlockState state) {
        this.grow(worldIn, pos, state);
    }

    public IBlockState func_176203_a(int meta) {
        return this.getState(meta);
    }

    public int func_176201_c(IBlockState state) {
        return this.getAge(state);
    }

    protected BlockStateContainer func_180661_e() {
        return new BlockStateContainer((Block)this, new IProperty[]{AGE});
    }
}

