/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.entity;

import io.netty.buffer.ByteBuf;
import java.util.List;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.item.EntityItem;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.DamageSource;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.common.eventhandler.Event;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import xerca.xercamod.common.HookReturningEvent;
import xerca.xercamod.common.XercaSoundEvents;
import xerca.xercamod.common.item.XercaItems;

public class EntityHook
extends Entity
implements IEntityAdditionalSpawnData {
    private static final DataParameter<Integer> cau_ent = EntityDataManager.func_187226_a(EntityHook.class, (DataSerializer)DataSerializers.field_187192_b);
    private int xTile = -1;
    private int yTile = -1;
    private int zTile = -1;
    private Block inTile;
    private boolean inGround;
    private EntityPlayer angler;
    private int ticksInAir;
    public Entity caughtEntity;
    private double fishX;
    private double fishY;
    private double fishZ;
    private double fishYaw;
    private double fishPitch;
    public boolean isReturning;
    @SideOnly(value=Side.CLIENT)
    private double clientMotionX;
    @SideOnly(value=Side.CLIENT)
    private double clientMotionY;
    @SideOnly(value=Side.CLIENT)
    private double clientMotionZ;

    public EntityHook(World worldIn) {
        super(worldIn);
        this.func_70105_a(0.25f, 0.25f);
        this.field_70158_ak = true;
        this.isReturning = false;
    }

    @SideOnly(value=Side.CLIENT)
    public EntityHook(World worldIn, double x, double y, double z, EntityPlayer anglerIn) {
        this(worldIn, anglerIn);
        this.func_70107_b(x, y, z);
        this.field_70158_ak = true;
        this.angler = anglerIn;
        this.isReturning = false;
    }

    public EntityHook(World worldIn, EntityPlayer fishingPlayer) {
        super(worldIn);
        this.field_70158_ak = true;
        this.angler = fishingPlayer;
        this.func_70105_a(0.25f, 0.25f);
        this.func_70012_b(fishingPlayer.field_70165_t, fishingPlayer.field_70163_u + (double)fishingPlayer.func_70047_e(), fishingPlayer.field_70161_v, fishingPlayer.field_70177_z, fishingPlayer.field_70125_A);
        this.field_70165_t -= (double)(MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.16f);
        this.field_70163_u -= (double)0.1f;
        this.field_70161_v -= (double)(MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * 0.16f);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        float f = 0.4f;
        this.field_70159_w = -MathHelper.func_76126_a((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180))) * f;
        this.field_70179_y = MathHelper.func_76134_b((float)(this.field_70177_z * ((float)Math.PI / 180))) * MathHelper.func_76134_b((float)(this.field_70125_A * ((float)Math.PI / 180))) * f;
        this.field_70181_x = -MathHelper.func_76126_a((float)(this.field_70125_A * ((float)Math.PI / 180))) * f;
        this.handleHookCasting(this.field_70159_w, this.field_70181_x, this.field_70179_y, 1.5f, 1.0f);
        this.isReturning = false;
    }

    public EntityPlayer getAngler() {
        return this.angler;
    }

    protected void func_70088_a() {
        this.func_184212_Q().func_187214_a(cau_ent, (Object)0);
    }

    public void func_184206_a(DataParameter<?> key) {
        int i;
        if (cau_ent.equals(key) && (i = ((Integer)this.func_184212_Q().func_187225_a(cau_ent)).intValue()) > 0 && this.caughtEntity != null) {
            this.caughtEntity = null;
        }
        super.func_184206_a(key);
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_70112_a(double distance) {
        double d0 = this.func_174813_aQ().func_72320_b() * 4.0;
        if (Double.isNaN(d0)) {
            d0 = 4.0;
        }
        return distance < (d0 *= 64.0) * d0;
    }

    public void handleHookCasting(double p_146035_1_, double p_146035_3_, double p_146035_5_, float p_146035_7_, float p_146035_8_) {
        float f = MathHelper.func_76133_a((double)(p_146035_1_ * p_146035_1_ + p_146035_3_ * p_146035_3_ + p_146035_5_ * p_146035_5_));
        p_146035_1_ /= (double)f;
        p_146035_3_ /= (double)f;
        p_146035_5_ /= (double)f;
        p_146035_1_ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_146035_8_;
        p_146035_3_ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_146035_8_;
        p_146035_5_ += this.field_70146_Z.nextGaussian() * (double)0.0075f * (double)p_146035_8_;
        this.field_70159_w = p_146035_1_ *= (double)p_146035_7_;
        this.field_70181_x = p_146035_3_ *= (double)p_146035_7_;
        this.field_70179_y = p_146035_5_ *= (double)p_146035_7_;
        float f1 = MathHelper.func_76133_a((double)(p_146035_1_ * p_146035_1_ + p_146035_5_ * p_146035_5_));
        this.field_70126_B = this.field_70177_z = (float)(MathHelper.func_181159_b((double)p_146035_1_, (double)p_146035_5_) * 57.29577951308232);
        this.field_70127_C = this.field_70125_A = (float)(MathHelper.func_181159_b((double)p_146035_3_, (double)f1) * 57.29577951308232);
    }

    @SideOnly(value=Side.CLIENT)
    public void setPositionAndRotation2(double x, double y, double z, float yaw, float pitch, int posRotationIncrements, boolean p_180426_10_) {
        this.fishX = x;
        this.fishY = y;
        this.fishZ = z;
        this.fishYaw = yaw;
        this.fishPitch = pitch;
        this.field_70159_w = this.clientMotionX;
        this.field_70181_x = this.clientMotionY;
        this.field_70179_y = this.clientMotionZ;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70016_h(double x, double y, double z) {
        this.clientMotionX = this.field_70159_w = x;
        this.clientMotionY = this.field_70181_x = y;
        this.clientMotionZ = this.field_70179_y = z;
    }

    private void rayTrace() {
        Vec3d vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        Vec3d vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        RayTraceResult raytraceresult = this.field_70170_p.func_72933_a(vec3d1, vec3d);
        vec3d1 = new Vec3d(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        vec3d = new Vec3d(this.field_70165_t + this.field_70159_w, this.field_70163_u + this.field_70181_x, this.field_70161_v + this.field_70179_y);
        if (raytraceresult != null) {
            vec3d = new Vec3d(raytraceresult.field_72307_f.field_72450_a, raytraceresult.field_72307_f.field_72448_b, raytraceresult.field_72307_f.field_72449_c);
        }
        Entity entity = null;
        List list = this.field_70170_p.func_72839_b((Entity)this, this.func_174813_aQ().func_72321_a(this.field_70159_w, this.field_70181_x, this.field_70179_y).func_186662_g(1.0));
        double d0 = 0.0;
        for (Entity aList : list) {
            double d1;
            AxisAlignedBB axisalignedbb1;
            RayTraceResult raytraceresult1;
            if (!aList.func_70067_L() || aList == this.angler && this.ticksInAir < 5 || (raytraceresult1 = (axisalignedbb1 = aList.func_174813_aQ().func_186662_g((double)0.3f)).func_72327_a(vec3d1, vec3d)) == null || !((d1 = vec3d1.func_72436_e(raytraceresult1.field_72307_f)) < d0) && d0 != 0.0) continue;
            entity = aList;
            d0 = d1;
        }
        if (entity != null) {
            raytraceresult = new RayTraceResult(entity);
        }
        if (raytraceresult != null) {
            if (raytraceresult.field_72308_g != null) {
                this.field_70170_p.func_184133_a(null, this.func_180425_c(), XercaSoundEvents.hookImpact, SoundCategory.PLAYERS, 1.0f, 1.0f);
                this.caughtEntity = raytraceresult.field_72308_g;
                this.func_184212_Q().func_187227_b(cau_ent, (Object)(this.caughtEntity.func_145782_y() + 1));
                this.caughtEntity = raytraceresult.field_72308_g;
                this.caughtEntity.func_70097_a(DamageSource.func_76356_a((Entity)this, (Entity)this.angler), 3.0f);
                this.caughtEntity.field_70145_X = true;
            } else {
                this.inGround = true;
            }
        }
    }

    private void pullEntity() {
        if (!this.caughtEntity.field_70128_L) {
            Vec3d v2;
            Vec3d v1 = this.angler.func_174791_d();
            Vec3d v = v1.func_178788_d(v2 = this.caughtEntity.func_174791_d());
            if (!(v.func_72433_c() > 2.0)) {
                this.func_70106_y();
                return;
            }
            v = v.func_72432_b();
            this.caughtEntity.field_70159_w = v.field_72450_a;
            this.caughtEntity.field_70181_x = v.field_72448_b;
            this.caughtEntity.field_70179_y = v.field_72449_c;
            this.field_70165_t = this.caughtEntity.field_70165_t;
            double d17 = (double)this.caughtEntity.field_70131_O + 0.5;
            this.field_70163_u = this.caughtEntity.func_174813_aQ().field_72338_b + d17 * 0.8;
            this.field_70161_v = this.caughtEntity.field_70161_v;
            return;
        }
        this.caughtEntity = null;
    }

    public void func_70071_h_() {
        if (!this.field_70170_p.field_72995_K) {
            if (this.angler == null) {
                this.func_70106_y();
                return;
            }
            this.func_70052_a(6, this.func_184202_aL());
        }
        this.func_70030_z();
        if (this.field_70170_p.field_72995_K) {
            int i = (Integer)this.func_184212_Q().func_187225_a(cau_ent);
            if (i > 0 && this.caughtEntity == null) {
                this.caughtEntity = this.field_70170_p.func_73045_a(i - 1);
                MinecraftForge.EVENT_BUS.post((Event)new HookReturningEvent(this));
            }
        } else {
            ItemStack itemstack = this.angler.func_184614_ca();
            if (this.angler.field_70128_L || !this.angler.func_70089_S() || itemstack.func_77973_b() != XercaItems.itemGrabHook || this.func_70068_e((Entity)this.angler) > 1024.0) {
                this.func_70106_y();
                this.angler.field_71104_cf = null;
                return;
            }
        }
        if (this.caughtEntity != null) {
            this.pullEntity();
            return;
        }
        if (this.inGround) {
            this.func_70106_y();
            return;
        }
        ++this.ticksInAir;
        if (this.ticksInAir == 20) {
            this.setReturning();
        }
        if (!this.field_70170_p.field_72995_K) {
            this.rayTrace();
            if (this.isReturning) {
                Vec3d v = this.angler.func_174791_d().func_178788_d(this.func_174791_d());
                if (v.func_72433_c() < 3.0) {
                    this.func_70106_y();
                    return;
                }
                v = v.func_72432_b();
                this.field_70159_w = v.field_72450_a;
                this.field_70181_x = v.field_72448_b;
                this.field_70179_y = v.field_72449_c;
            }
        }
        this.func_70091_d(MoverType.SELF, this.field_70159_w, this.field_70181_x, this.field_70179_y);
        this.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
    }

    private void setReturning() {
        this.isReturning = true;
        MinecraftForge.EVENT_BUS.post((Event)new HookReturningEvent(this));
    }

    public void func_70014_b(NBTTagCompound tagCompound) {
        tagCompound.func_74768_a("xTile", this.xTile);
        tagCompound.func_74768_a("yTile", this.yTile);
        tagCompound.func_74768_a("zTile", this.zTile);
        ResourceLocation resourcelocation = this.inTile.getRegistryName();
        tagCompound.func_74778_a("inTile", resourcelocation == null ? "" : resourcelocation.toString());
        tagCompound.func_74774_a("inGround", (byte)(this.inGround ? 1 : 0));
    }

    public void func_70037_a(NBTTagCompound tagCompund) {
        this.xTile = tagCompund.func_74762_e("xTile");
        this.yTile = tagCompund.func_74762_e("yTile");
        this.zTile = tagCompund.func_74762_e("zTile");
        this.inTile = tagCompund.func_150297_b("inTile", 8) ? Block.func_149684_b((String)tagCompund.func_74779_i("inTile")) : Block.func_149729_e((int)(tagCompund.func_74771_c("inTile") & 0xFF));
        this.inGround = tagCompund.func_74771_c("inGround") == 1;
    }

    public int handleHookRetraction() {
        if (this.field_70170_p.field_72995_K) {
            return 0;
        }
        int i = 0;
        if (this.caughtEntity != null) {
            this.func_184527_k();
            this.field_70170_p.func_72960_a((Entity)this, (byte)31);
            int n = i = this.caughtEntity instanceof EntityItem ? 3 : 5;
        }
        if (this.inGround) {
            i = 2;
        }
        this.func_70106_y();
        this.angler.field_71104_cf = null;
        return i;
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 31 && this.field_70170_p.field_72995_K && this.caughtEntity instanceof EntityPlayer && ((EntityPlayer)this.caughtEntity).func_175144_cb()) {
            this.func_184527_k();
        }
        super.func_70103_a(id);
    }

    protected void func_184527_k() {
        double d0 = this.angler.field_70165_t - this.field_70165_t;
        double d1 = this.angler.field_70163_u - this.field_70163_u;
        double d2 = this.angler.field_70161_v - this.field_70161_v;
        double d3 = MathHelper.func_76133_a((double)(d0 * d0 + d1 * d1 + d2 * d2));
        double d4 = 0.1;
        this.caughtEntity.field_70159_w += d0 * d4;
        this.caughtEntity.field_70181_x += d1 * d4 + (double)MathHelper.func_76133_a((double)d3) * 0.08;
        this.caughtEntity.field_70179_y += d2 * d4;
    }

    public void func_70106_y() {
        super.func_70106_y();
        if (this.caughtEntity != null) {
            this.caughtEntity.field_70145_X = false;
        }
        if (this.angler != null) {
            this.angler.field_71104_cf = null;
        }
    }

    public void setAnglerFish() {
        if (this.angler != null) {
            // empty if block
        }
    }

    public void writeSpawnData(ByteBuf buffer) {
        buffer.writeInt(this.angler != null ? this.angler.func_145782_y() : -1);
    }

    public void readSpawnData(ByteBuf additionalData) {
        int id = additionalData.readInt();
        Entity ent = this.field_70170_p.func_73045_a(id);
        if (ent instanceof EntityPlayer) {
            this.angler = (EntityPlayer)ent;
        }
    }
}

