/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import com.google.common.collect.Multimap;
import javax.annotation.Nonnull;
import net.minecraft.block.state.IBlockState;
import net.minecraft.client.Minecraft;
import net.minecraft.creativetab.CreativeTabs;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnumEnchantmentType;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.AttributeModifier;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.inventory.EntityEquipmentSlot;
import net.minecraft.item.EnumAction;
import net.minecraft.item.IItemPropertyGetter;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.ActionResult;
import net.minecraft.util.EnumActionResult;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;
import net.minecraftforge.oredict.OreDictionary;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.item.ItemXerca;
import xerca.xercamod.common.packets.AttackPacket;

public class ItemWarhammer
extends ItemXerca {
    private final float weaponDamage;
    private final float pushAmount;
    private final Item.ToolMaterial material;

    public ItemWarhammer(String name, Item.ToolMaterial mat) {
        super(name, CreativeTabs.field_78037_j);
        this.material = mat;
        this.field_77777_bU = 1;
        this.func_77656_e(this.material.func_77997_a());
        this.weaponDamage = 1.0f + mat.func_78000_c();
        this.pushAmount = this.getPushFromMaterial(mat);
        this.func_185043_a(new ResourceLocation("pull"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                if (entityIn == null) {
                    return 0.0f;
                }
                ItemStack itemstack = entityIn.func_184607_cu();
                return itemstack.func_77973_b() instanceof ItemWarhammer ? (float)(stack.func_77988_m() - entityIn.func_184605_cv()) / 20.0f : 0.0f;
            }
        });
        this.func_185043_a(new ResourceLocation("pulling"), new IItemPropertyGetter(){

            @SideOnly(value=Side.CLIENT)
            public float func_185085_a(@Nonnull ItemStack stack, World worldIn, EntityLivingBase entityIn) {
                return entityIn != null && entityIn.func_184587_cr() && entityIn.func_184607_cu() == stack ? 1.0f : 0.0f;
            }
        });
    }

    private float getPushFromMaterial(Item.ToolMaterial mat) {
        float push = mat == Item.ToolMaterial.STONE ? 0.15f : (mat == Item.ToolMaterial.IRON ? 0.3f : (mat == Item.ToolMaterial.DIAMOND ? 0.4f : 0.5f));
        return push;
    }

    public float getDamageVsEntity() {
        return this.material.func_78000_c();
    }

    public int func_77619_b() {
        return this.material.func_77995_e();
    }

    public boolean canApplyAtEnchantingTable(ItemStack stack, Enchantment enchantment) {
        return enchantment.field_77351_y == EnumEnchantmentType.BREAKABLE;
    }

    public boolean func_77644_a(ItemStack stack, EntityLivingBase target, EntityLivingBase attacker) {
        stack.func_77972_a(1, attacker);
        return true;
    }

    public boolean func_179218_a(ItemStack stack, World worldIn, IBlockState blockIn, BlockPos pos, EntityLivingBase entityLiving) {
        if ((double)blockIn.func_185887_b(worldIn, pos) != 0.0) {
            stack.func_77972_a(1, entityLiving);
        }
        return true;
    }

    public boolean func_150897_b(IBlockState blockIn) {
        return blockIn.func_177230_c() == Blocks.field_150348_b;
    }

    @SideOnly(value=Side.CLIENT)
    public boolean func_77662_d() {
        return true;
    }

    public String getToolMaterialName() {
        return this.material.toString();
    }

    public boolean func_82789_a(ItemStack toRepair, ItemStack repair) {
        ItemStack mat = this.material.getRepairItemStack();
        if (OreDictionary.itemMatches((ItemStack)mat, (ItemStack)repair, (boolean)false)) {
            return true;
        }
        return super.func_82789_a(toRepair, repair);
    }

    @Nonnull
    public Multimap<String, AttributeModifier> getAttributeModifiers(@Nonnull EntityEquipmentSlot equipmentSlot, ItemStack stack) {
        Multimap multimap = super.getAttributeModifiers(equipmentSlot, stack);
        if (equipmentSlot == EntityEquipmentSlot.MAINHAND) {
            multimap.put((Object)SharedMonsterAttributes.field_111264_e.func_111108_a(), (Object)new AttributeModifier(field_111210_e, "Weapon modifier", (double)this.weaponDamage, 0));
            multimap.put((Object)SharedMonsterAttributes.field_188790_f.func_111108_a(), (Object)new AttributeModifier(field_185050_h, "Weapon modifier", -3.0, 0));
        }
        return multimap;
    }

    @Nonnull
    public EnumAction func_77661_b(ItemStack stack) {
        return EnumAction.BOW;
    }

    public int func_77626_a(ItemStack stack) {
        return 72000;
    }

    @Nonnull
    public ActionResult<ItemStack> func_77659_a(World worldIn, EntityPlayer playerIn, @Nonnull EnumHand hand) {
        ItemStack heldItem = playerIn.func_184586_b(hand);
        playerIn.func_184598_c(hand);
        return new ActionResult(EnumActionResult.SUCCESS, (Object)heldItem);
    }

    public void func_77615_a(ItemStack stack, World worldIn, EntityLivingBase entityLiving, int timeLeft) {
        if (!(entityLiving instanceof EntityPlayer)) {
            return;
        }
        EntityPlayer player = (EntityPlayer)entityLiving;
        int j = this.func_77626_a(stack) - timeLeft;
        float f = (float)j / 20.0f;
        if ((double)(f = (f * f + f * 2.0f) / 3.0f) >= 0.1) {
            float bonusDamage = this.weaponDamage;
            float bonusPush = this.pushAmount;
            if (f >= 1.0f) {
                bonusDamage *= 1.5f;
                bonusPush *= 2.5f;
            } else if (f >= 0.7f) {
                bonusDamage *= 1.0f;
                bonusPush *= 2.0f;
            } else if (f >= 0.4f) {
                bonusDamage *= 0.5f;
                bonusPush *= 1.5f;
            }
            player.func_184609_a(EnumHand.MAIN_HAND);
            if (worldIn.field_72995_K) {
                Minecraft mine = Minecraft.func_71410_x();
                if (mine.field_71476_x != null && mine.field_71476_x.field_72313_a == RayTraceResult.Type.ENTITY) {
                    Entity hedef = mine.field_71476_x.field_72308_g;
                    AttackPacket pack = new AttackPacket(bonusDamage, bonusPush, hedef.func_145782_y(), true);
                    XercaMod.network.sendToServer((IMessage)pack);
                }
            }
        }
    }
}

