/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import io.netty.buffer.ByteBuf;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;

public class AttackPacket
implements IMessage {
    private float damage;
    private float push;
    private int targetId;
    private boolean isHammer;
    private boolean messageIsValid;

    public AttackPacket(float damage, float push, int targetId, boolean isHammer) {
        this.damage = damage;
        this.push = push;
        this.targetId = targetId;
        this.isHammer = isHammer;
    }

    public AttackPacket() {
        this.messageIsValid = false;
    }

    public void fromBytes(ByteBuf buf) {
        try {
            this.damage = buf.readFloat();
            this.push = buf.readFloat();
            this.targetId = buf.readInt();
            this.isHammer = buf.readBoolean();
        }
        catch (IndexOutOfBoundsException ioe) {
            System.err.println("Exception while reading WarhammerPacket: " + ioe);
            return;
        }
        this.messageIsValid = true;
    }

    public void toBytes(ByteBuf buf) {
        buf.writeFloat(this.damage);
        buf.writeFloat(this.push);
        buf.writeInt(this.targetId);
        buf.writeBoolean(this.isHammer);
    }

    public float getDamage() {
        return this.damage;
    }

    public float getPush() {
        return this.push;
    }

    public int getTargetId() {
        return this.targetId;
    }

    public boolean getIsHammer() {
        return this.isHammer;
    }

    public boolean isMessageValid() {
        return this.messageIsValid;
    }
}

