/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.entity.player.EntityPlayerMP;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.WorldServer;
import net.minecraftforge.fml.common.network.simpleimpl.IMessage;
import net.minecraftforge.fml.common.network.simpleimpl.IMessageHandler;
import net.minecraftforge.fml.common.network.simpleimpl.MessageContext;
import net.minecraftforge.fml.relauncher.Side;
import xerca.xercamod.common.XercaSoundEvents;
import xerca.xercamod.common.item.ItemWarhammer;
import xerca.xercamod.common.item.XercaItems;
import xerca.xercamod.common.packets.AttackPacket;

public class AttackPacketHandler
implements IMessageHandler<AttackPacket, IMessage> {
    public IMessage onMessage(final AttackPacket message, MessageContext ctx) {
        if (ctx.side != Side.SERVER) {
            System.err.println("Packet received on wrong side:" + ctx.side);
            return null;
        }
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return null;
        }
        final EntityPlayerMP sendingPlayer = ctx.getServerHandler().field_147369_b;
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when WarhammerPacket was received");
            return null;
        }
        WorldServer mainThread = (WorldServer)ctx.getServerHandler().field_147369_b.field_70170_p;
        mainThread.func_152344_a(new Runnable(){

            @Override
            public void run() {
                AttackPacketHandler.processMessage(message, sendingPlayer);
            }
        });
        return null;
    }

    private static void processMessage(AttackPacket msg, EntityPlayerMP pl) {
        Entity target = pl.field_70170_p.func_73045_a(msg.getTargetId());
        target.func_70097_a(DamageSource.func_76365_a((EntityPlayer)pl), (float)pl.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e() + msg.getDamage());
        if (msg.getIsHammer()) {
            ItemStack st = pl.func_184614_ca();
            if (st.func_77973_b() instanceof ItemWarhammer) {
                Vec3d knockvec = target.func_174791_d().func_178788_d(pl.func_174791_d()).func_72432_b().func_186678_a((double)msg.getPush());
                target.func_70024_g(knockvec.field_72450_a, knockvec.field_72448_b, knockvec.field_72449_c);
                float pitch = 2.0f / msg.getDamage();
                pl.field_70170_p.func_184148_a(null, target.field_70165_t, target.field_70163_u + 0.5, target.field_70161_v, XercaSoundEvents.hammer, SoundCategory.PLAYERS, 1.0f, pl.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.4f + pitch);
                st.func_77972_a(1, (EntityLivingBase)pl);
            } else {
                System.out.println("Elde cekic yok!");
            }
        } else {
            ItemStack st;
            if (pl.func_184614_ca().func_77973_b() == XercaItems.itemKnife) {
                st = pl.func_184614_ca();
            } else if (pl.func_184592_cb().func_77973_b() == XercaItems.itemKnife) {
                st = pl.func_184592_cb();
            } else {
                System.out.println("Elde bicak yok!");
                return;
            }
            st.func_77973_b().func_77644_a(st, (EntityLivingBase)target, (EntityLivingBase)pl);
        }
    }
}

