/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.client;

import net.minecraft.client.Minecraft;
import net.minecraft.client.audio.ISound;
import net.minecraft.client.gui.ScreenManager;
import net.minecraft.entity.Entity;
import net.minecraft.item.ItemStack;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.IItemProvider;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.client.event.ClientPlayerNetworkEvent;
import net.minecraftforge.client.event.ColorHandlerEvent;
import net.minecraftforge.event.entity.EntityEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.client.registry.IRenderFactory;
import net.minecraftforge.fml.client.registry.RenderingRegistry;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import xerca.xercamod.client.GuiFunctionalBookcase;
import xerca.xercamod.client.HookSound;
import xerca.xercamod.client.RenderConfettiBallFactory;
import xerca.xercamod.client.RenderCushionFactory;
import xerca.xercamod.client.RenderHookFactory;
import xerca.xercamod.client.RenderTomatoFactory;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.HookReturningEvent;
import xerca.xercamod.common.Proxy;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.entity.EntityConfettiBall;
import xerca.xercamod.common.entity.EntityCushion;
import xerca.xercamod.common.entity.EntityHook;
import xerca.xercamod.common.entity.EntityTomato;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.tile_entity.XercaTileEntities;

public class ClientProxy
extends Proxy {

    @Mod.EventBusSubscriber(modid="xercamod", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.FORGE)
    static class ForgeBusSubscriber {
        ForgeBusSubscriber() {
        }

        @SubscribeEvent
        public static void hookReturningEvent(HookReturningEvent ev) {
            EntityHook ent = (EntityHook)ev.getEntity();
            if (ent.field_70170_p.field_72995_K) {
                Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new HookSound(ent, true));
            }
        }

        @SubscribeEvent
        public static void entityConstEvent(EntityEvent.EntityConstructing ev) {
            Entity ent = ev.getEntity();
            if (ent instanceof EntityHook) {
                EntityHook hook = (EntityHook)ent;
                if (ent.field_70170_p.field_72995_K) {
                    Minecraft.func_71410_x().func_147118_V().func_147682_a((ISound)new HookSound(hook, false));
                }
            }
        }

        @SubscribeEvent
        public static void onPlayerLoggedOut(ClientPlayerNetworkEvent.LoggedOutEvent event) {
            XercaMod.LOGGER.debug("ClientLoggedOut Event");
            Config.bakeConfig();
        }
    }

    @Mod.EventBusSubscriber(modid="xercamod", value={Dist.CLIENT}, bus=Mod.EventBusSubscriber.Bus.MOD)
    static class ModBusSubscriber {
        ModBusSubscriber() {
        }

        @SubscribeEvent
        public static void clientSetupHandler(FMLClientSetupEvent event) {
            ScreenManager.func_216911_a(XercaTileEntities.CONTAINER_FUNCTIONAL_BOOKCASE, GuiFunctionalBookcase::new);
            RenderingRegistry.registerEntityRenderingHandler(EntityTomato.class, (IRenderFactory)new RenderTomatoFactory());
            RenderingRegistry.registerEntityRenderingHandler(EntityConfettiBall.class, (IRenderFactory)new RenderConfettiBallFactory());
            RenderingRegistry.registerEntityRenderingHandler(EntityHook.class, (IRenderFactory)new RenderHookFactory());
            RenderingRegistry.registerEntityRenderingHandler(EntityCushion.class, (IRenderFactory)new RenderCushionFactory());
        }

        @SubscribeEvent
        public static void handleItemColors(ColorHandlerEvent.Item event) {
            event.getItemColors().func_199877_a((itemStack, colorIndex) -> colorIndex > 0 ? -1 : PotionUtils.func_190932_c((ItemStack)itemStack), new IItemProvider[]{Items.FLASK});
        }
    }
}

