/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common;

import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.List;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import net.minecraft.advancements.CriteriaTriggers;
import net.minecraft.advancements.ICriterionTrigger;
import net.minecraft.block.DispenserBlock;
import net.minecraft.dispenser.IDispenseItemBehavior;
import net.minecraft.dispenser.IPosition;
import net.minecraft.dispenser.ProjectileDispenseBehavior;
import net.minecraft.entity.IProjectile;
import net.minecraft.item.ItemStack;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.World;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DistExecutor;
import net.minecraftforge.fml.InterModComms;
import net.minecraftforge.fml.ModLoadingContext;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.common.ObfuscationReflectionHelper;
import net.minecraftforge.fml.config.ModConfig;
import net.minecraftforge.fml.event.lifecycle.FMLCommonSetupEvent;
import net.minecraftforge.fml.event.lifecycle.InterModEnqueueEvent;
import net.minecraftforge.fml.event.lifecycle.InterModProcessEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xerca.xercamod.client.ClientProxy;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.ContainerFunctionalBookcase;
import xerca.xercamod.common.Proxy;
import xerca.xercamod.common.Triggers;
import xerca.xercamod.common.entity.EntityConfettiBall;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.ConfettiParticlePacket;
import xerca.xercamod.common.packets.ConfettiParticlePacketHandler;
import xerca.xercamod.common.packets.ConfigSyncPacket;
import xerca.xercamod.common.packets.ConfigSyncPacketHandler;
import xerca.xercamod.common.packets.HammerAttackPacket;
import xerca.xercamod.common.packets.HammerAttackPacketHandler;
import xerca.xercamod.common.packets.HammerQuakePacket;
import xerca.xercamod.common.packets.HammerQuakePacketHandler;
import xerca.xercamod.common.packets.KnifeAttackPacket;
import xerca.xercamod.common.packets.KnifeAttackPacketHandler;
import xerca.xercamod.common.packets.QuakeParticlePacket;
import xerca.xercamod.common.packets.QuakeParticlePacketHandler;
import xerca.xercamod.server.ServerProxy;

@Mod(value="xercamod")
public class XercaMod {
    public static final String MODID = "xercamod";
    public static final String NAME = "Xerca Mod";
    public static Proxy proxy = (Proxy)DistExecutor.runForDist(() -> ClientProxy::new, () -> ServerProxy::new);
    private static final String PROTOCOL_VERSION = Integer.toString(1);
    public static final SimpleChannel NETWORK_HANDLER = NetworkRegistry.ChannelBuilder.named((ResourceLocation)new ResourceLocation("xercamod", "main_channel")).clientAcceptedVersions(PROTOCOL_VERSION::equals).serverAcceptedVersions(PROTOCOL_VERSION::equals).networkProtocolVersion(() -> PROTOCOL_VERSION).simpleChannel();
    public static final Logger LOGGER = LogManager.getLogger();

    public XercaMod() {
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::setup);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::enqueueIMC);
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::processIMC);
        MinecraftForge.EVENT_BUS.register((Object)this);
        ModLoadingContext.get().registerConfig(ModConfig.Type.COMMON, Config.COMMON_CONFIG);
        Config.loadConfig(Config.COMMON_CONFIG, FMLPaths.CONFIGDIR.get().resolve("xercamod-common.toml"));
    }

    private void networkRegistry() {
        int msg_id = 0;
        NETWORK_HANDLER.registerMessage(msg_id++, HammerAttackPacket.class, HammerAttackPacket::encode, HammerAttackPacket::decode, HammerAttackPacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, KnifeAttackPacket.class, KnifeAttackPacket::encode, KnifeAttackPacket::decode, KnifeAttackPacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, HammerQuakePacket.class, HammerQuakePacket::encode, HammerQuakePacket::decode, HammerQuakePacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id++, ConfettiParticlePacket.class, ConfettiParticlePacket::encode, ConfettiParticlePacket::decode, ConfettiParticlePacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id, QuakeParticlePacket.class, QuakeParticlePacket::encode, QuakeParticlePacket::decode, QuakeParticlePacketHandler::handle);
        NETWORK_HANDLER.registerMessage(msg_id, ConfigSyncPacket.class, ConfigSyncPacket::encode, ConfigSyncPacket::decode, ConfigSyncPacketHandler::handle);
    }

    private void setup(FMLCommonSetupEvent event) {
        this.networkRegistry();
        this.registerTriggers();
        DispenserBlock.func_199774_a((IItemProvider)Items.ITEM_CONFETTI_BALL, (IDispenseItemBehavior)new ProjectileDispenseBehavior(){

            @Nonnull
            protected IProjectile func_82499_a(@Nonnull World worldIn, @Nonnull IPosition position, @Nonnull ItemStack stackIn) {
                return new EntityConfettiBall(worldIn, position.func_82615_a(), position.func_82617_b(), position.func_82616_c());
            }
        });
    }

    private void registerTriggers() {
        Method method = ObfuscationReflectionHelper.findMethod(CriteriaTriggers.class, (String)"func_192118_a", (Class[])new Class[]{ICriterionTrigger.class});
        method.setAccessible(true);
        for (int i = 0; i < Triggers.TRIGGER_ARRAY.length; ++i) {
            try {
                method.invoke(null, Triggers.TRIGGER_ARRAY[i]);
                continue;
            }
            catch (IllegalAccessException | IllegalArgumentException | InvocationTargetException e) {
                e.printStackTrace();
            }
        }
    }

    private void enqueueIMC(InterModEnqueueEvent event) {
    }

    private void processIMC(InterModProcessEvent event) {
        List list = event.getIMCStream().collect(Collectors.toList());
        LOGGER.info("Got IMC {}", list);
        for (InterModComms.IMCMessage msg : list) {
            if (!msg.getMethod().equals("send_note")) continue;
            Object result = msg.getMessageSupplier().get();
            if (result instanceof ResourceLocation) {
                ResourceLocation itemNoteResourceLocation = (ResourceLocation)result;
                ContainerFunctionalBookcase.acceptedItems.add(itemNoteResourceLocation);
                continue;
            }
            LOGGER.error("send_note from XercaMusic failed to sent a ResourceLocation");
        }
    }
}

