/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.entity;

import javax.annotation.Nullable;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityType;
import net.minecraft.entity.MoverType;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.network.IPacket;
import net.minecraft.network.PacketBuffer;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.SoundEvents;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraft.world.GameRules;
import net.minecraft.world.World;
import net.minecraftforge.fml.common.registry.IEntityAdditionalSpawnData;
import net.minecraftforge.fml.network.FMLPlayMessages;
import net.minecraftforge.fml.network.NetworkHooks;
import xerca.xercamod.common.block.BlockCushion;
import xerca.xercamod.common.entity.Entities;
import xerca.xercamod.common.item.ItemCushion;

public class EntityCushion
extends Entity
implements IEntityAdditionalSpawnData {
    private ItemCushion item;
    public BlockCushion block;
    private int cushionIndex;
    static BlockCushion[] blockCushions;
    static ItemCushion[] itemCushions;

    public EntityCushion(EntityType<? extends EntityCushion> type, World world) {
        super(type, world);
    }

    public EntityCushion(World worldIn) {
        super(Entities.CUSHION, worldIn);
        this.func_189654_d(false);
    }

    public EntityCushion(World worldIn, double x, double y, double z, ItemCushion item) {
        this(worldIn);
        this.field_70165_t = x;
        this.field_70163_u = y;
        this.field_70161_v = z;
        this.item = item;
        this.block = item.getBlock();
        this.cushionIndex = this.block.cushionIndex;
    }

    public EntityCushion(FMLPlayMessages.SpawnEntity spawnEntity, World world) {
        this(world);
    }

    protected void func_70088_a() {
    }

    public void func_70071_h_() {
        super.func_70071_h_();
        this.func_213315_a(MoverType.SELF, new Vec3d(0.0, -0.16, 0.0));
        this.func_174826_a(new AxisAlignedBB(this.field_70165_t - 0.5, this.field_70163_u, this.field_70161_v - 0.5, this.field_70165_t + 0.5, this.field_70163_u + (double)this.func_213302_cg(), this.field_70161_v + 0.5));
    }

    public boolean func_85031_j(Entity entityIn) {
        return entityIn instanceof PlayerEntity && this.func_70097_a(DamageSource.func_76365_a((PlayerEntity)((PlayerEntity)entityIn)), 0.0f);
    }

    public boolean func_70097_a(DamageSource source, float amount) {
        if (this.func_180431_b(source)) {
            return false;
        }
        if (!this.field_70128_L && !this.field_70170_p.field_72995_K) {
            this.func_70106_y();
            this.func_70018_K();
            this.onBroken(source.func_76346_g());
        }
        return true;
    }

    public void onBroken(@Nullable Entity brokenEntity) {
        if (this.field_70170_p.func_82736_K().func_223586_b(GameRules.field_223604_g)) {
            this.func_184185_a(SoundEvents.field_187546_ae, 1.0f, 1.0f);
            if (brokenEntity instanceof PlayerEntity) {
                PlayerEntity entityplayer = (PlayerEntity)brokenEntity;
                if (entityplayer.field_71075_bZ.field_75098_d) {
                    return;
                }
            }
            this.func_199703_a((IItemProvider)this.item);
        }
    }

    public boolean func_70104_M() {
        return true;
    }

    protected void func_70037_a(CompoundNBT compound) {
        this.cushionIndex = compound.func_74762_e("cushion");
        this.block = blockCushions[this.cushionIndex];
        this.item = itemCushions[this.cushionIndex];
    }

    protected void func_213281_b(CompoundNBT compound) {
        compound.func_74768_a("cushion", this.cushionIndex);
    }

    public void writeSpawnData(PacketBuffer buffer) {
        buffer.writeInt(this.cushionIndex);
    }

    public void readSpawnData(PacketBuffer buffer) {
        this.cushionIndex = buffer.readInt();
        this.block = blockCushions[this.cushionIndex];
        this.item = itemCushions[this.cushionIndex];
    }

    public double func_70042_X() {
        return -0.125;
    }

    public boolean func_70067_L() {
        return true;
    }

    public ActionResultType func_184199_a(PlayerEntity player, Vec3d vec, Hand hand) {
        if (!this.field_70170_p.field_72995_K) {
            player.func_184220_m((Entity)this);
        }
        return ActionResultType.SUCCESS;
    }

    public IPacket<?> func_213297_N() {
        return NetworkHooks.getEntitySpawningPacket((Entity)this);
    }

    public boolean func_184230_a(PlayerEntity player, Hand hand) {
        if (player.func_70093_af()) {
            return false;
        }
        if (!this.field_70170_p.field_72995_K && !this.func_184207_aI()) {
            player.func_184220_m((Entity)this);
        }
        return true;
    }
}

