/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.UseAction;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.potion.EffectInstance;
import net.minecraft.potion.PotionUtils;
import net.minecraft.util.ActionResult;
import net.minecraft.util.ActionResultType;
import net.minecraft.util.Hand;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.item.Items;

public class ItemFlask
extends Item {
    public static int maxCharges = 8;
    private boolean hasMilk;

    public ItemFlask(Item.Properties properties, String registryName, boolean hasMilk) {
        super(properties);
        this.setRegistryName(registryName);
        this.hasMilk = hasMilk;
    }

    public int func_77626_a(ItemStack stack) {
        return 32;
    }

    public UseAction func_77661_b(ItemStack stack) {
        return UseAction.DRINK;
    }

    public ActionResult<ItemStack> func_77659_a(World worldIn, PlayerEntity playerIn, @Nonnull Hand handIn) {
        ItemStack itemstack = playerIn.func_184586_b(handIn);
        if (ItemFlask.getCharges(itemstack) > 0) {
            playerIn.func_184598_c(handIn);
            return new ActionResult(ActionResultType.SUCCESS, (Object)itemstack);
        }
        return new ActionResult(ActionResultType.FAIL, (Object)itemstack);
    }

    public ItemStack func_77654_b(@Nonnull ItemStack stack, World worldIn, LivingEntity entityLiving) {
        int charges = ItemFlask.getCharges(stack);
        if (charges > 0) {
            if (entityLiving instanceof PlayerEntity) {
                PlayerEntity entityplayer = (PlayerEntity)entityLiving;
                if (!worldIn.field_72995_K) {
                    if (this.hasMilk) {
                        entityplayer.curePotionEffects(new ItemStack((IItemProvider)net.minecraft.item.Items.field_151117_aB));
                    } else {
                        for (EffectInstance potioneffect : PotionUtils.func_185189_a((ItemStack)stack)) {
                            if (potioneffect.func_188419_a().func_76403_b()) {
                                potioneffect.func_188419_a().func_180793_a((Entity)entityplayer, (Entity)entityplayer, entityLiving, potioneffect.func_76458_c(), 1.0);
                                continue;
                            }
                            entityLiving.func_195064_c(new EffectInstance(potioneffect));
                        }
                    }
                }
            }
            this.decrementCharges(stack);
        }
        if (this.hasMilk && ItemFlask.getCharges(stack) <= 0) {
            stack = new ItemStack((IItemProvider)Items.FLASK);
        }
        return stack;
    }

    public static int getCharges(ItemStack itemstack) {
        CompoundNBT tag;
        if (itemstack.func_77942_o() && (tag = itemstack.func_77978_p()).func_74764_b("charges")) {
            return tag.func_74762_e("charges");
        }
        return 0;
    }

    public static void setCharges(ItemStack itemstack, int charges) {
        if (charges >= 0 && charges <= maxCharges) {
            CompoundNBT tag = itemstack.func_196082_o();
            tag.func_74768_a("charges", charges);
        }
    }

    private boolean decrementCharges(ItemStack itemstack) {
        int oldCharges;
        CompoundNBT tag = itemstack.func_196082_o();
        if (tag.func_74764_b("charges") && (oldCharges = tag.func_74762_e("charges")) > 0) {
            if (oldCharges == 1) {
                tag.func_82580_o("Potion");
            }
            tag.func_74768_a("charges", oldCharges - 1);
            return true;
        }
        return false;
    }

    public String func_77667_c(ItemStack stack) {
        if (this.hasMilk) {
            return this.func_77658_a();
        }
        return PotionUtils.func_185191_c((ItemStack)stack).func_185174_b(this.func_77658_a() + ".effect.");
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        if (this.hasMilk) {
            tooltip.add((ITextComponent)new StringTextComponent("Calcium for your bones"));
        } else {
            PotionUtils.func_185182_a((ItemStack)stack, tooltip, (float)1.0f);
        }
        tooltip.add((ITextComponent)new StringTextComponent(ItemFlask.getCharges(stack) + " charges"));
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean func_77636_d(ItemStack stack) {
        return super.func_77636_d(stack) || this.hasMilk || !PotionUtils.func_185189_a((ItemStack)stack).isEmpty();
    }

    @ParametersAreNonnullByDefault
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!Config.isEnderFlaskEnabled()) {
            return;
        }
        super.func_150895_a(group, items);
    }
}

