/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.item;

import java.util.List;
import javax.annotation.Nullable;
import javax.annotation.ParametersAreNonnullByDefault;
import net.minecraft.client.util.ITooltipFlag;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.util.NonNullList;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import xerca.xercamod.common.Config;
import xerca.xercamod.common.item.Items;

public class ItemTeapot
extends Item {
    public static final int maxTea = 7;
    private final int teaAmount;
    private final boolean isHot;

    public ItemTeapot(int teaAmount, boolean isHot) {
        super((teaAmount == 7 ? new Item.Properties().func_200916_a((ItemGroup)Items.teaTab) : new Item.Properties()).func_200915_b(7));
        this.teaAmount = teaAmount;
        this.isHot = isHot;
        String baseName = isHot ? "item_hot_teapot_" : "item_full_teapot_";
        this.setRegistryName(baseName + teaAmount);
    }

    public int getTeaAmount() {
        return this.teaAmount;
    }

    public boolean isHot() {
        return this.isHot;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_77624_a(ItemStack stack, @Nullable World worldIn, List<ITextComponent> tooltip, ITooltipFlag flagIn) {
        tooltip.add((ITextComponent)new StringTextComponent("Tea amount: " + this.teaAmount));
    }

    public boolean showDurabilityBar(ItemStack stack) {
        return false;
    }

    @ParametersAreNonnullByDefault
    public void func_150895_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (!Config.isTeaEnabled()) {
            return;
        }
        super.func_150895_a(group, items);
    }
}

