/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import java.util.List;
import java.util.function.Supplier;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.enchantment.EnchantmentHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraft.util.Hand;
import net.minecraft.util.SoundCategory;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.Vec3d;
import net.minecraftforge.fml.network.NetworkEvent;
import net.minecraftforge.fml.network.PacketDistributor;
import xerca.xercamod.common.SoundEvents;
import xerca.xercamod.common.Triggers;
import xerca.xercamod.common.XercaMod;
import xerca.xercamod.common.item.ItemWarhammer;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.HammerAttackPacketHandler;
import xerca.xercamod.common.packets.HammerQuakePacket;
import xerca.xercamod.common.packets.QuakeParticlePacket;

public class HammerQuakePacketHandler {
    public static void handle(HammerQuakePacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when HammerQuakePacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> HammerQuakePacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static double rangeForQuake(int quakeLevel) {
        switch (quakeLevel) {
            case 1: {
                return 9.0;
            }
            case 2: {
                return 16.0;
            }
            case 3: {
                return 25.0;
            }
        }
        return 0.0;
    }

    private static void processMessage(HammerQuakePacket msg, ServerPlayerEntity pl) {
        ItemStack st = pl.func_184614_ca();
        Item item = st.func_77973_b();
        if (item instanceof ItemWarhammer) {
            int quakeLevel = EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_QUAKE, (ItemStack)st);
            if (quakeLevel > 0) {
                double range = HammerQuakePacketHandler.rangeForQuake(quakeLevel);
                List targets = pl.field_70170_p.func_175647_a(LivingEntity.class, new AxisAlignedBB(pl.func_174791_d().func_178786_a(5.0, 5.0, 5.0), pl.func_174791_d().func_72441_c(5.0, 5.0, 5.0)), entity -> !entity.func_70028_i((Entity)pl) && entity.func_174791_d().func_72436_e(msg.getPosition()) < range);
                if (targets.size() >= 6) {
                    Triggers.QUAKE.trigger(pl);
                }
                float pull = msg.getPullDuration();
                float mult = HammerAttackPacketHandler.damageBonusMult(pull);
                int heavyLevel = EnchantmentHelper.func_77506_a((Enchantment)Items.ENCHANTMENT_HEAVY, (ItemStack)st);
                float damage = ((float)pl.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e() + (float)heavyLevel * 0.5f) * mult * 0.5f;
                float push = (((ItemWarhammer)item).getPushAmount() + (float)heavyLevel * 0.15f) * mult;
                float pitch = 2.0f / (damage + (float)heavyLevel);
                double volume = Math.log10(10.0 * (double)pull + 1.0);
                if (volume > 1.0) {
                    volume = 1.0;
                }
                Vec3d pos = msg.getPosition();
                for (LivingEntity target : targets) {
                    Vec3d knockvec = target.func_174791_d().func_178788_d(pos).func_72432_b().func_186678_a((double)push);
                    target.func_70024_g(knockvec.field_72450_a, knockvec.field_72448_b, knockvec.field_72449_c);
                    target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)pl), damage);
                }
                st.func_222118_a(1, (LivingEntity)pl, p -> p.func_213334_d(Hand.MAIN_HAND));
                pl.field_70170_p.func_184148_a(null, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, SoundEvents.STOMP, SoundCategory.PLAYERS, (float)volume, pl.field_70170_p.field_73012_v.nextFloat() * 0.1f + 0.4f + pitch);
                int particleCount = (int)(volume * 64.0);
                QuakeParticlePacket pack = new QuakeParticlePacket(particleCount, pos.field_72450_a, pos.field_72448_b, pos.field_72449_c);
                XercaMod.NETWORK_HANDLER.send(PacketDistributor.NEAR.with(() -> new PacketDistributor.TargetPoint(pos.field_72450_a, pos.field_72448_b, pos.field_72449_c, 64.0, pl.field_71093_bK)), (Object)pack);
            } else {
                System.out.println("No quake found in warhammer!");
            }
        } else {
            System.out.println("No warhammer found in hand!");
        }
    }
}

