/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.packets;

import java.util.function.Supplier;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.item.ItemStack;
import net.minecraft.util.DamageSource;
import net.minecraftforge.fml.network.NetworkEvent;
import xerca.xercamod.common.item.Items;
import xerca.xercamod.common.packets.KnifeAttackPacket;

public class KnifeAttackPacketHandler {
    public static void handle(KnifeAttackPacket message, Supplier<NetworkEvent.Context> ctx) {
        if (!message.isMessageValid()) {
            System.err.println("Packet was invalid");
            return;
        }
        ServerPlayerEntity sendingPlayer = ctx.get().getSender();
        if (sendingPlayer == null) {
            System.err.println("EntityPlayerMP was null when KnifeAttackPacket was received");
            return;
        }
        ctx.get().enqueueWork(() -> KnifeAttackPacketHandler.processMessage(message, sendingPlayer));
        ctx.get().setPacketHandled(true);
    }

    private static void processMessage(KnifeAttackPacket msg, ServerPlayerEntity pl) {
        ItemStack st;
        Entity target = pl.field_70170_p.func_73045_a(msg.getTargetId());
        if (pl.func_184614_ca().func_77973_b() == Items.ITEM_KNIFE) {
            st = pl.func_184614_ca();
        } else if (pl.func_184592_cb().func_77973_b() == Items.ITEM_KNIFE) {
            st = pl.func_184592_cb();
        } else {
            System.out.println("No knife at hand!");
            return;
        }
        st.func_77973_b().func_77644_a(st, (LivingEntity)target, (LivingEntity)pl);
        target.func_70097_a(DamageSource.func_76365_a((PlayerEntity)pl), (float)pl.func_110140_aT().func_111151_a(SharedMonsterAttributes.field_111264_e).func_111126_e());
    }
}

