/*
 * Decompiled with CFR 0.152.
 */
package xerca.xercamod.common.tile_entity;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.block.BlockState;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.PlayerInventory;
import net.minecraft.inventory.container.Container;
import net.minecraft.inventory.container.INamedContainerProvider;
import net.minecraft.nbt.CompoundNBT;
import net.minecraft.nbt.INBT;
import net.minecraft.network.NetworkManager;
import net.minecraft.network.play.server.SUpdateTileEntityPacket;
import net.minecraft.state.IProperty;
import net.minecraft.tileentity.TileEntity;
import net.minecraft.util.Direction;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.CapabilityItemHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.ItemStackHandler;
import xerca.xercamod.common.ContainerFunctionalBookcase;
import xerca.xercamod.common.block.BlockFunctionalBookcase;
import xerca.xercamod.common.block.Blocks;
import xerca.xercamod.common.tile_entity.XercaTileEntities;

public class TileEntityFunctionalBookcase
extends TileEntity
implements INamedContainerProvider {
    private static final int NUMBER_OF_SLOTS = 6;
    private final ItemStackHandler inventory = new ItemStackHandler(6){

        protected void onContentsChanged(int slot) {
            TileEntityFunctionalBookcase.this.func_70296_d();
        }
    };
    private final LazyOptional<IItemHandler> inventoryCap = LazyOptional.of(() -> this.inventory);

    public TileEntityFunctionalBookcase() {
        super(XercaTileEntities.FUNCTIONAL_BOOKCASE);
    }

    public int getSizeInventory() {
        return 6;
    }

    public boolean isUsableByPlayer(PlayerEntity player) {
        if (this.field_145850_b.func_175625_s(this.field_174879_c) != this) {
            return false;
        }
        double X_CENTRE_OFFSET = 0.5;
        double Y_CENTRE_OFFSET = 0.5;
        double Z_CENTRE_OFFSET = 0.5;
        double MAXIMUM_DISTANCE_SQ = 64.0;
        return player.func_70092_e((double)this.field_174879_c.func_177958_n() + 0.5, (double)this.field_174879_c.func_177956_o() + 0.5, (double)this.field_174879_c.func_177952_p() + 0.5) < 64.0;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> capability, @Nullable Direction facing) {
        if (capability == CapabilityItemHandler.ITEM_HANDLER_CAPABILITY) {
            return this.inventoryCap.cast();
        }
        return super.getCapability(capability, facing);
    }

    @Nonnull
    public CompoundNBT func_189515_b(CompoundNBT parentNBTTagCompound) {
        super.func_189515_b(parentNBTTagCompound);
        CompoundNBT inventoryTagCompound = this.inventory.serializeNBT();
        parentNBTTagCompound.func_218657_a("inventory", (INBT)inventoryTagCompound);
        return parentNBTTagCompound;
    }

    public void func_145839_a(CompoundNBT parentNBTTagCompound) {
        super.func_145839_a(parentNBTTagCompound);
        CompoundNBT inventoryTagCompound = parentNBTTagCompound.func_74775_l("inventory");
        this.inventory.deserializeNBT(inventoryTagCompound);
    }

    public void closeInventory(PlayerEntity player) {
        int i = this.getBookAmount();
        BlockState st = (BlockState)Blocks.BLOCK_BOOKCASE.func_176223_P().func_206870_a((IProperty)BlockFunctionalBookcase.BOOK_AMOUNT, (Comparable)Integer.valueOf(i));
        this.field_145850_b.func_175656_a(this.field_174879_c, st);
        this.func_70296_d();
    }

    private int getBookAmount() {
        int total = 0;
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            if (this.inventory.getStackInSlot(i).func_190926_b()) continue;
            ++total;
        }
        return total;
    }

    public void func_70296_d() {
        super.func_70296_d();
    }

    @Nullable
    public SUpdateTileEntityPacket func_189518_D_() {
        return new SUpdateTileEntityPacket(this.func_174877_v(), 0, this.func_189517_E_());
    }

    public void onDataPacket(NetworkManager net, SUpdateTileEntityPacket packet) {
        this.func_145839_a(packet.func_148857_g());
    }

    public CompoundNBT func_189517_E_() {
        return this.func_189515_b(new CompoundNBT());
    }

    public void handleUpdateTag(CompoundNBT nbt) {
        this.func_145839_a(nbt);
    }

    public ITextComponent func_145748_c_() {
        return new TranslationTextComponent(Blocks.BLOCK_BOOKCASE.func_149739_a() + ".name", new Object[0]);
    }

    @Nullable
    public Container createMenu(int windowId, PlayerInventory playerInventory, PlayerEntity player) {
        return new ContainerFunctionalBookcase(windowId, playerInventory, this);
    }
}

