/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players;

import com.corosus.modconfig.ConfigMod;
import com.corosus.zombie_players.Zombie_Players;
import com.corosus.zombie_players.config.ConfigZombiePlayers;
import com.corosus.zombie_players.entity.EnumTrainType;
import com.corosus.zombie_players.entity.ZombiePlayer;
import com.corosus.zombie_players.entity.ai.WorkInfo;
import java.util.List;
import java.util.UUID;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.TextComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.MobSpawnType;
import net.minecraft.world.entity.monster.Zombie;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.event.VanillaGameEvent;
import net.minecraftforge.event.entity.living.LivingDeathEvent;
import net.minecraftforge.event.entity.living.LivingSpawnEvent;
import net.minecraftforge.event.entity.player.PlayerEvent;
import net.minecraftforge.event.entity.player.PlayerInteractEvent;
import net.minecraftforge.eventbus.api.Event;
import net.minecraftforge.eventbus.api.EventPriority;
import net.minecraftforge.eventbus.api.SubscribeEvent;

public class EventHandlerForge {
    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onLivingDeath(LivingDeathEvent event) {
        LivingEntity ent = event.getEntityLiving();
        if (ent.f_19853_.m_5776_()) {
            return;
        }
        if (event.isCanceled()) {
            return;
        }
        if (ent instanceof ServerPlayer) {
            ServerPlayer player = (ServerPlayer)event.getEntityLiving();
            if (!ConfigZombiePlayers.requiresDeathByZombieToSpawnZombiePlayer || event.getSource().m_7640_() instanceof Zombie) {
                ZombiePlayer.spawnInPlaceOfPlayer(player);
            }
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onPlayerJoin(PlayerEvent.PlayerLoggedInEvent event) {
        if (ConfigZombiePlayers.automaticallyAddJoinedPlayersToNamesList && !ConfigZombiePlayers.Spawning_playerNamesToUse.contains(event.getEntity().m_5446_().getString())) {
            ConfigZombiePlayers.Spawning_playerNamesToUse = ConfigZombiePlayers.Spawning_playerNamesToUse.length() == 0 ? event.getEntity().m_5446_().getString() : ConfigZombiePlayers.Spawning_playerNamesToUse + ", " + event.getEntity().m_5446_().getString();
            ConfigMod.forceSaveAllFilesFromRuntimeSettings();
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerRightClickBlock(PlayerInteractEvent.RightClickBlock event) {
        if (!event.getWorld().m_5776_() && event.getHand() == InteractionHand.MAIN_HAND) {
            if (event.getPlayer().m_21205_().m_41720_() == Items.f_42434_) {
                if (Zombie_Players.getWorkAreaStage(event.getPlayer()) == 1) {
                    event.getPlayer().getPersistentData().m_128405_(Zombie_Players.ZP_SET_WORK_AREA_STAGE, 2);
                    List listEnts = event.getWorld().m_45976_(ZombiePlayer.class, new AABB(event.getPlayer().m_142538_()).m_82377_(10.0, 5.0, 10.0));
                    for (ZombiePlayer ent : listEnts) {
                        if (!ent.isCalm() || !ent.getWorkInfo().isInAreaSetMode() || !ent.m_142504_().equals(event.getPlayer().m_142081_())) continue;
                        ent.getWorkInfo().setWorkAreaPos1(event.getPos());
                        event.getPlayer().m_6352_((Component)new TextComponent("First work area position set, right click second block with golden hoe"), new UUID(0L, 0L));
                        event.setCanceled(true);
                    }
                } else if (Zombie_Players.getWorkAreaStage(event.getPlayer()) == 2) {
                    event.getPlayer().getPersistentData().m_128405_(Zombie_Players.ZP_SET_WORK_AREA_STAGE, 0);
                    List listEnts = event.getWorld().m_45976_(ZombiePlayer.class, new AABB(event.getPlayer().m_142538_()).m_82377_(10.0, 5.0, 10.0));
                    for (ZombiePlayer ent : listEnts) {
                        if (!ent.isCalm() || !ent.getWorkInfo().isInAreaSetMode() || !ent.m_142504_().equals(event.getPlayer().m_142081_())) continue;
                        AABB aabb = new AABB((double)Math.min(ent.getWorkInfo().getWorkAreaPos1().m_123341_(), event.getPos().m_123341_()), (double)Math.min(ent.getWorkInfo().getWorkAreaPos1().m_123342_(), event.getPos().m_123342_()), (double)Math.min(ent.getWorkInfo().getWorkAreaPos1().m_123343_(), event.getPos().m_123343_()), (double)(Math.max(ent.getWorkInfo().getWorkAreaPos1().m_123341_(), event.getPos().m_123341_()) + 1), (double)(Math.max(ent.getWorkInfo().getWorkAreaPos1().m_123342_(), event.getPos().m_123342_()) + 1), (double)(Math.max(ent.getWorkInfo().getWorkAreaPos1().m_123343_(), event.getPos().m_123343_()) + 1));
                        ent.getWorkInfo().setPosWorkArea(aabb);
                        ent.getWorkInfo().setInAreaSetMode(false);
                        Vec3 center = ent.getWorkInfo().getPosWorkArea().m_82399_();
                        double size = Math.max(ent.getWorkInfo().getPosWorkArea().m_82362_(), ent.getWorkInfo().getPosWorkArea().m_82385_());
                        ent.m_21446_(new BlockPos(center.f_82479_, center.f_82480_ + 1.0, center.f_82481_), (int)size);
                        event.getPlayer().m_6352_((Component)new TextComponent("Zombie Player " + ent.getGameProfile().getName() + " work area set to " + aabb), new UUID(0L, 0L));
                        event.setCanceled(true);
                    }
                }
            }
            this.trainZombiePlayer(event.getPlayer(), event.getWorld(), event.getPos(), EnumTrainType.BLOCK_RIGHT_CLICK, event.getFace(), event.getHitVec());
        }
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerLeftClickBlock(PlayerInteractEvent.LeftClickBlock event) {
        this.trainZombiePlayer(event.getPlayer(), event.getWorld(), event.getPos(), EnumTrainType.BLOCK_LEFT_CLICK, event.getFace(), null);
    }

    @SubscribeEvent(priority=EventPriority.HIGHEST)
    public void onPlayerInteract(PlayerInteractEvent.EntityInteract event) {
    }

    public void trainZombiePlayerSetClick(Player player, Level level, BlockPos pos, EnumTrainType trainType) {
        List listEnts = level.m_45976_(ZombiePlayer.class, new AABB(pos).m_82377_(10.0, 5.0, 10.0));
        for (ZombiePlayer ent : listEnts) {
            if (!ent.isCalm() || !ent.getWorkInfo().isInTrainingMode() || !ent.m_142504_().equals(player.m_142081_())) continue;
            ent.getWorkInfo().setWorkClickLastObserved(trainType);
            player.m_6352_((Component)new TextComponent("Zombie Player " + ent.getGameProfile().getName() + " set click to " + trainType), new UUID(0L, 0L));
        }
    }

    public void trainZombiePlayer(Player player, Level level, BlockPos pos, EnumTrainType trainType, Direction direction, BlockHitResult blockHitResult) {
        List listEnts = level.m_45976_(ZombiePlayer.class, new AABB(pos).m_82377_(10.0, 5.0, 10.0));
        for (ZombiePlayer ent : listEnts) {
            if (!ent.isCalm() || !ent.getWorkInfo().isInTrainingMode() || !ent.m_142504_().equals(player.m_142081_())) continue;
            ent.getWorkInfo().setWorkClickLastObserved(trainType);
            BlockState state = ent.f_19853_.m_8055_(pos);
            ent.getWorkInfo().setStateWorkLastObserved(state);
            ent.getWorkInfo().setWorkClickDirectionLastObserved(direction);
            ent.getWorkInfo().setItemNeededForWork(player.m_21205_());
            ent.getWorkInfo().setBlockHitResult(blockHitResult);
            if (ent.getEntityAIWorkInArea() != null) {
                ent.getEntityAIWorkInArea().setPosNextWorkTarget(pos);
            }
            player.m_6352_((Component)new TextComponent("Zombie Player " + ent.getGameProfile().getName() + " observed " + state + " using " + player.m_21205_() + " click: " + trainType), new UUID(0L, 0L));
            if (ent.getWorkInfo().getPosWorkArea() != WorkInfo.CENTER_ZERO) continue;
            AABB aabb = new AABB((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_(), (double)(pos.m_123341_() + 1), (double)(pos.m_123342_() + 1), (double)(pos.m_123343_() + 1));
            aabb = aabb.m_82377_(4.0, 2.0, 4.0);
            ent.getWorkInfo().setPosWorkArea(aabb);
            Vec3 center = ent.getWorkInfo().getPosWorkArea().m_82399_();
            ent.m_21446_(new BlockPos(center.f_82479_, center.f_82480_ + 1.0, center.f_82481_), (int)ent.getWorkInfo().getPosWorkArea().m_82309_());
        }
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onGameEvent(VanillaGameEvent event) {
        event.setCanceled(true);
    }

    @SubscribeEvent(priority=EventPriority.LOWEST)
    public void onSpawn(LivingSpawnEvent.CheckSpawn event) {
        if (event.getEntity() instanceof ZombiePlayer && event.getSpawnReason() == MobSpawnType.NATURAL && !ConfigZombiePlayers.Spawning_spawnZombiePlayersNaturally) {
            event.setResult(Event.Result.DENY);
        }
    }
}

