/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players.client.entity.render;

import com.corosus.zombie_players.client.entity.model.ZombiePlayerModelZombieBased;
import com.corosus.zombie_players.client.entity.render.ZombiePlayerRendererAbstract;
import com.corosus.zombie_players.entity.ZombiePlayer;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@OnlyIn(value=Dist.CLIENT)
public class ZombiePlayerRendererImpl
extends ZombiePlayerRendererAbstract<ZombiePlayer, ZombiePlayerModelZombieBased<ZombiePlayer>> {
    public ZombiePlayerRendererImpl(EntityRendererProvider.Context p_174458_, ModelLayerLocation p_174459_, ModelLayerLocation p_174460_, ModelLayerLocation p_174461_) {
        super(p_174458_, new ZombiePlayerModelZombieBased(p_174458_.m_174023_(p_174459_)), new ZombiePlayerModelZombieBased(p_174458_.m_174023_(p_174460_)), new ZombiePlayerModelZombieBased(p_174458_.m_174023_(p_174461_)));
    }

    public void render(ZombiePlayer entity, float p_115456_, float partialTicks, PoseStack poseStack, MultiBufferSource p_115459_, int p_115460_) {
        if (entity.risingTime < entity.risingTimeMax) {
            ZombiePlayerRendererImpl.getCachedPlayerData(entity);
            float f = 1.0f - ((float)entity.risingTime + partialTicks) / (float)entity.risingTimeMax;
            float shadowDelay = 20.0f;
            float fInv = ((float)entity.risingTime - shadowDelay + partialTicks) / ((float)entity.risingTimeMax - shadowDelay);
            if (f > 1.0f) {
                f = 1.0f;
            }
            poseStack.m_85837_(0.0, (double)(-f * 0.7f), 0.0);
            this.f_114478_ = 0.0f;
        } else {
            this.f_114478_ = 1.0f;
        }
        if (entity.risingTime >= 0) {
            super.m_7392_((Mob)entity, p_115456_, partialTicks, poseStack, p_115459_, p_115460_);
        }
    }

    protected void setupRotations(ZombiePlayer entityLiving, PoseStack p_115318_, float p_115319_, float p_115320_, float partialTicks) {
        if (entityLiving.risingTime < entityLiving.risingTimeMax) {
            float f = 1.0f - ((float)entityLiving.risingTime + partialTicks) / (float)entityLiving.risingTimeMax;
            if (f > 1.0f) {
                f = 1.0f;
            }
            double rotScale = Math.sin(f);
            double angle = (double)(f * 90.0f) * rotScale;
            double angle2 = 0.0;
            double shakeRange = 30.0;
            double shakeSpeed = 70.0;
            double timeVal = (double)((float)entityLiving.f_19853_.m_46467_() + partialTicks) * shakeSpeed;
            double angle3 = (shakeRange / 2.0 + Math.sin(Math.toRadians(timeVal % 360.0)) * shakeRange) * rotScale;
            p_115318_.m_85845_(Vector3f.f_122223_.m_122240_((float)angle));
            p_115318_.m_85845_(Vector3f.f_122225_.m_122240_((float)(angle2 + angle3)));
        }
        super.m_7523_((LivingEntity)entityLiving, p_115318_, p_115319_, p_115320_, partialTicks);
    }
}

