/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players.config;

import com.corosus.coroutil.util.CULog;
import com.corosus.modconfig.ConfigComment;
import com.corosus.modconfig.ConfigMod;
import com.corosus.modconfig.IConfigCategory;
import com.corosus.zombie_players.Zombie_Players;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraftforge.registries.ForgeRegistries;

public class ConfigZombiePlayers
implements IConfigCategory {
    @ConfigComment(value={"Only spawn a zombie player if the player died by a zombie directly"})
    public static boolean requiresDeathByZombieToSpawnZombiePlayer = false;
    @ConfigComment(value={"Finds visible chests near and randomly moves contents around, only zombie players spawned from actual players use this"})
    public static boolean messUpChests = true;
    public static boolean opensDoors = true;
    public static boolean pickupLootWhenHostile = false;
    public static boolean pickupLootWhenCalm = true;
    @ConfigComment(value={"To help prevent endless multiplication of zombies if you die near your own spawn point"})
    public static int distanceFromPlayerSpawnPointToPreventZombieSpawn = 16;
    @ConfigComment(value={"Spawn zombie players naturally in the world, will spawn in every biome zombies do"})
    public static boolean Spawning_spawnZombiePlayersNaturally = true;
    @ConfigComment(value={"Only used it Spawning_spawnZombiePlayersNaturally is true. Weight of zombie players, higher = more likely to spawn, vanilla sets zombie as 100"})
    public static int Spawning_weight = 40;
    @ConfigComment(value={"Only used it Spawning_spawnZombiePlayersNaturally is true. Minecraft profile names to use when naturally spawning in zombie players"})
    public static String Spawning_playerNamesToUse = "PhoenixfireLune, Corosus, Cojomax99, Mr_okushama, tterrag, medsouz, NotActuallyTerry, MrRube";
    @ConfigComment(value={"Any player that joins your dedicated server will have their name added to the Spawning_playerNamesToUse list"})
    public static boolean automaticallyAddJoinedPlayersToNamesList = false;
    @ConfigComment(value={"Use at own risk, will not support"})
    public static boolean enableAdvancedDeveloperConfigFiles = false;
    @ConfigComment(value={"items that will calm the zombie and let you train them, #food is a special match that will allow anything that the player can eat since a generic food data tag doesnt seem to exist yet"})
    public static String calmingItems = "#food, minecraft:porkchop, minecraft:mutton, minecraft:tropical_fish, minecraft:beef, minecraft:chicken, minecraft:rabbit, minecraft:bread";
    @ConfigComment(value={"Shows name when looked at while hostile"})
    public static boolean showNameWhenHostile = true;

    public String getName() {
        return "Zombie_Players";
    }

    public String getRegistryName() {
        return "zombie_players";
    }

    public String getConfigFileName() {
        return this.getName();
    }

    public String getCategory() {
        return "zombie_players";
    }

    public void hookUpdatedValues() {
        CULog.dbg((String)"Updating Zombie Player names to use");
        String[] names = Spawning_playerNamesToUse.split(",");
        for (int i = 0; i < names.length; ++i) {
            names[i] = names[i].trim();
        }
        Zombie_Players.zombiePlayerNames = names;
        if (enableAdvancedDeveloperConfigFiles) {
            if (!ConfigMod.lookupRegistryNameToConfig.containsKey(Zombie_Players.configDev.getRegistryName())) {
                ConfigMod.addConfigFile(null, (IConfigCategory)Zombie_Players.configDev);
            }
        }
        Zombie_Players.listCalmingItems.clear();
        Zombie_Players.matchAnyFood = false;
        try {
            CULog.dbg((String)"Processing calming items list for Zombie Players");
            String[] names2 = calmingItems.split(",");
            for (int i = 0; i < names2.length; ++i) {
                names2[i] = names2[i].trim();
                if (names2[i].equals("#food")) {
                    CULog.dbg((String)"Matching any food item for zombie players");
                    Zombie_Players.matchAnyFood = true;
                    continue;
                }
                Item item = (Item)ForgeRegistries.ITEMS.getValue(new ResourceLocation(names2[i]));
                if (item == null || item == Items.f_41852_) continue;
                CULog.dbg((String)("adding: " + item.getRegistryName()));
                Zombie_Players.listCalmingItems.add(item);
            }
        }
        catch (Exception ex) {
            CULog.err((String)"CRITICAL ERROR PARSING calmingItems CONFIG STRING FOR ZOMBIE PLAYERS");
            ex.printStackTrace();
        }
    }
}

