/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players.entity.ai;

import com.corosus.zombie_players.entity.ZombiePlayer;
import com.corosus.zombie_players.entity.ai.EntityAIFollowOwnerZombie;
import com.google.common.base.Predicates;
import java.util.EnumSet;
import java.util.List;
import java.util.function.Predicate;
import javax.annotation.Nullable;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.level.pathfinder.Path;
import net.minecraft.world.phys.Vec3;

public class EntityAIAvoidEntityOnLowHealth<T extends Entity>
extends Goal {
    private final Predicate<Entity> canBeSeenSelector = new Predicate<Entity>(){

        @Override
        public boolean test(@Nullable Entity p_apply_1_) {
            return p_apply_1_.m_6084_() && EntityAIAvoidEntityOnLowHealth.this.theEntity.m_21574_().m_148306_(p_apply_1_);
        }
    };
    protected ZombiePlayer theEntity;
    private final double farSpeed;
    private final double nearSpeed;
    protected T closestLivingEntity;
    private final float avoidDistance;
    private Path entityPathEntity;
    private final PathNavigation entityPathNavigate;
    private final Class<T> classToAvoid;
    private final Predicate<? super T> avoidTargetSelector;
    private float healthToAvoid = 0.0f;

    public EntityAIAvoidEntityOnLowHealth(ZombiePlayer theEntityIn, Class<T> classToAvoidIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn, float healthToAvoid) {
        this(theEntityIn, classToAvoidIn, (Predicate<T>)Predicates.alwaysTrue(), avoidDistanceIn, farSpeedIn, nearSpeedIn, healthToAvoid);
    }

    public EntityAIAvoidEntityOnLowHealth(ZombiePlayer theEntityIn, Class<T> classToAvoidIn, Predicate<? super T> avoidTargetSelectorIn, float avoidDistanceIn, double farSpeedIn, double nearSpeedIn, float healthToAvoid) {
        this.theEntity = theEntityIn;
        this.classToAvoid = classToAvoidIn;
        this.avoidTargetSelector = avoidTargetSelectorIn;
        this.avoidDistance = avoidDistanceIn;
        this.farSpeed = farSpeedIn;
        this.nearSpeed = nearSpeedIn;
        this.entityPathNavigate = theEntityIn.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.healthToAvoid = healthToAvoid;
    }

    public boolean m_8036_() {
        if (!this.theEntity.isCalm()) {
            return false;
        }
        if (this.theEntity.m_21223_() > this.healthToAvoid) {
            return false;
        }
        if (this.theEntity instanceof ZombiePlayer && EntityAIFollowOwnerZombie.needsToTeleportToOwner(this.theEntity)) {
            return false;
        }
        List list = this.theEntity.f_19853_.m_6443_(this.classToAvoid, this.theEntity.m_142469_().m_82363_((double)this.avoidDistance, 4.0, (double)this.avoidDistance), ZombiePlayer.ENEMY_PREDICATE);
        if (list.isEmpty()) {
            return false;
        }
        this.closestLivingEntity = (Entity)list.get(0);
        int prevDist = (int)this.theEntity.m_21535_();
        this.theEntity.m_21446_(this.theEntity.m_21534_(), -1);
        Vec3 vec3d = DefaultRandomPos.m_148407_((PathfinderMob)this.theEntity, (int)16, (int)7, (Vec3)new Vec3(this.closestLivingEntity.m_20185_(), this.closestLivingEntity.m_20186_(), this.closestLivingEntity.m_20189_()));
        this.theEntity.m_21446_(this.theEntity.m_21534_(), prevDist);
        if (vec3d == null) {
            return false;
        }
        if (this.closestLivingEntity.m_20275_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_) < this.closestLivingEntity.m_20280_((Entity)this.theEntity)) {
            return false;
        }
        int reachRange = 0;
        this.entityPathEntity = this.entityPathNavigate.m_26524_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, reachRange);
        return this.entityPathEntity != null;
    }

    public boolean m_8045_() {
        return !this.entityPathNavigate.m_26571_();
    }

    public void m_8056_() {
        this.entityPathNavigate.m_26536_(this.entityPathEntity, this.farSpeed);
        this.theEntity.m_6710_(null);
    }

    public void m_8041_() {
        this.closestLivingEntity = null;
    }

    public void m_8037_() {
        if (this.theEntity.m_20280_((Entity)this.closestLivingEntity) < 49.0) {
            this.theEntity.m_21573_().m_26517_(this.nearSpeed);
        } else {
            this.theEntity.m_21573_().m_26517_(this.farSpeed);
        }
    }
}

