/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players.entity.ai;

import com.corosus.zombie_players.entity.ZombiePlayer;
import java.util.EnumSet;
import java.util.Iterator;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.world.Container;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.phys.Vec3;

public class EntityAIEatToHeal
extends Goal {
    private final ZombiePlayer entityObj;
    private int walkingTimeoutMax = 200;
    private int walkingTimeout;
    private int repathPentalty = 0;
    private int lookUpdateTimer = 0;
    private float missingHealthToHeal = 5.0f;
    public BlockPos posCachedBestChest = null;

    public EntityAIEatToHeal(ZombiePlayer entityObjIn) {
        this.entityObj = entityObjIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.entityObj.isFoodNeedUrgent()) {
            this.posCachedBestChest = this.getClosestChestPosWithFood();
            return this.posCachedBestChest != null;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.entityObj.isFoodNeedUrgent() && this.verifyOrGetNewChest();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.posCachedBestChest != null) {
            boolean isClose = false;
            BlockPos blockposGoal = this.posCachedBestChest;
            if (blockposGoal == null) {
                this.m_8041_();
                return;
            }
            double dist = this.entityObj.m_20182_().m_82554_(new Vec3((double)blockposGoal.m_123341_(), (double)blockposGoal.m_123342_(), (double)blockposGoal.m_123343_()));
            if (dist <= 3.8) {
                this.entityObj.openChest(this.posCachedBestChest);
                for (int i = 0; i < 5 && (this.entityObj.m_21223_() < this.entityObj.m_21233_() || this.entityObj.isCalmTimeLow()); ++i) {
                    this.consumeOneStackSizeOfFoodAtChest();
                    this.entityObj.ateCalmingItem(true);
                }
                this.entityObj.m_21573_().m_26573_();
                return;
            }
            if (!isClose) {
                if ((this.entityObj.m_21573_().m_26571_() || this.walkingTimeout <= 0) && this.repathPentalty <= 0) {
                    int i = blockposGoal.m_123341_();
                    int j = blockposGoal.m_123342_();
                    int k = blockposGoal.m_123343_();
                    boolean success = false;
                    if (this.entityObj.m_20238_(Vec3.m_82512_((Vec3i)blockposGoal)) > 256.0) {
                        Vec3 vec3d = DefaultRandomPos.m_148412_((PathfinderMob)this.entityObj, (int)14, (int)3, (Vec3)new Vec3((double)i + 0.5, (double)j, (double)k + 0.5), (double)1.5707963705062866);
                        if (vec3d != null) {
                            success = this.entityObj.m_21573_().m_26519_(vec3d.f_82479_, vec3d.f_82480_ + 1.0, vec3d.f_82481_, 1.3);
                        }
                    } else {
                        success = this.entityObj.m_21573_().m_26519_((double)i + 0.5, (double)j, (double)k + 0.5, 1.3);
                    }
                    if (!success) {
                        this.repathPentalty = 40;
                    } else {
                        this.walkingTimeout = this.walkingTimeoutMax;
                    }
                } else if (this.walkingTimeout > 0) {
                    --this.walkingTimeout;
                }
            }
            if (this.repathPentalty > 0) {
                --this.repathPentalty;
            }
            if (this.lookUpdateTimer > 0) {
                --this.lookUpdateTimer;
            }
        }
    }

    public void m_8056_() {
        super.m_8056_();
        this.entityObj.m_21573_().m_26573_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.walkingTimeout = 0;
    }

    public BlockPos getClosestChestPosWithFood() {
        Iterator<BlockPos> it = this.entityObj.listPosChests.iterator();
        double closestDist = Double.MAX_VALUE;
        BlockPos closestPos = null;
        while (it.hasNext()) {
            double dist;
            BlockPos pos = it.next();
            if (!this.entityObj.isValidChestForFood(pos, false) || !((dist = this.entityObj.m_142538_().m_123331_((Vec3i)pos)) < closestDist)) continue;
            closestDist = dist;
            closestPos = pos;
        }
        return closestPos;
    }

    public ItemStack consumeOneStackSizeOfFoodAtChest() {
        BlockEntity tile;
        if (this.posCachedBestChest != null && (tile = this.entityObj.f_19853_.m_7702_(this.posCachedBestChest)) instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)tile;
            return this.consumeOneStackSizeOfFood((Container)chest);
        }
        return null;
    }

    public ItemStack consumeOneStackSizeOfFood(Container inv) {
        for (int i = 0; i < inv.m_6643_(); ++i) {
            ItemStack stack = inv.m_8020_(i);
            if (stack.m_41619_() || stack.m_41613_() <= 0 || !this.entityObj.isCalmingItem(stack)) continue;
            stack.m_41774_(1);
            if (stack.m_41613_() <= 0) {
                inv.m_6836_(i, ItemStack.f_41583_);
            }
            return new ItemStack((ItemLike)stack.m_41720_(), 1, stack.m_41783_());
        }
        return null;
    }

    public boolean verifyOrGetNewChest() {
        if (this.posCachedBestChest == null) {
            return false;
        }
        if (!this.entityObj.isValidChestForFood(this.posCachedBestChest, false)) {
            this.posCachedBestChest = this.getClosestChestPosWithFood();
        }
        return this.posCachedBestChest != null;
    }
}

