/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players.entity.ai;

import com.corosus.coroutil.util.CULog;
import com.corosus.coroutil.util.CoroUtilEntity;
import com.corosus.zombie_players.config.ConfigZombiePlayers;
import com.corosus.zombie_players.entity.ZombiePlayer;
import com.corosus.zombie_players.util.UtilScanner;
import java.util.EnumSet;
import javax.annotation.Nullable;
import net.minecraft.core.BlockPos;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.ChestBlockEntity;
import net.minecraft.world.phys.Vec3;

public class EntityAIInteractChest
extends Goal {
    protected final ZombiePlayer entity;
    protected double x;
    protected double y;
    protected double z;
    protected final double speed;
    protected int executionChance;
    protected boolean mustUpdate;
    public int ticksChestOpen = 0;
    public int ticksChestOpenMax = 10;

    public EntityAIInteractChest(ZombiePlayer creatureIn, double speedIn, int chance) {
        this.entity = creatureIn;
        this.speed = speedIn;
        this.executionChance = chance;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!ConfigZombiePlayers.messUpChests || !this.entity.spawnedFromPlayerDeath) {
            return false;
        }
        if (this.entity.isCalm()) {
            return false;
        }
        if (!this.mustUpdate && this.entity.m_21187_().nextInt(this.executionChance) != 0) {
            return false;
        }
        Vec3 vec3d = this.getPosition();
        if (vec3d == null) {
            return false;
        }
        this.x = vec3d.f_82479_;
        this.y = vec3d.f_82480_;
        this.z = vec3d.f_82481_;
        this.mustUpdate = false;
        return true;
    }

    @Nullable
    protected Vec3 getPosition() {
        BlockPos pos = UtilScanner.findBlock((LivingEntity)this.entity, 16, 1, 10, UtilScanner::isChest);
        if (pos != null && CoroUtilEntity.canSee((Entity)this.entity, (BlockPos)new BlockPos(pos.m_123341_(), pos.m_123342_() + 1, pos.m_123343_()))) {
            CULog.dbg((String)"found visible chest coord, pathing");
            return new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
        }
        return null;
    }

    public boolean m_8045_() {
        return !this.entity.m_21573_().m_26571_() || this.ticksChestOpen < this.ticksChestOpenMax;
    }

    public void m_8056_() {
        this.entity.m_21573_().m_26519_(this.x, this.y, this.z, this.speed);
    }

    public void m_8037_() {
        super.m_8037_();
        double dist = Mth.m_14116_((float)((float)this.entity.m_20275_(this.x + 0.5, this.y + 0.5, this.z + 0.5)));
        if (dist < 2.5) {
            this.entity.m_21573_().m_26573_();
            if (this.ticksChestOpen == 0) {
                this.shuffleSingleItemStack(new BlockPos(this.x, this.y, this.z));
            }
            if (this.ticksChestOpen < this.ticksChestOpenMax) {
                ++this.ticksChestOpen;
            }
        }
    }

    public void shuffleSingleItemStack(BlockPos pos) {
        BlockEntity tEnt = this.entity.f_19853_.m_7702_(pos);
        if (tEnt instanceof ChestBlockEntity) {
            ChestBlockEntity chest = (ChestBlockEntity)tEnt;
            int randSlot1 = 0;
            for (int i = 0; i < chest.m_6643_(); ++i) {
                if (chest.m_8020_(i).m_41619_()) continue;
                randSlot1 = i;
                break;
            }
            int randSlot2 = this.entity.f_19853_.f_46441_.nextInt(chest.m_6643_());
            ItemStack stack1 = chest.m_8020_(randSlot1);
            ItemStack stack2 = chest.m_8020_(randSlot2);
            chest.m_6836_(randSlot1, stack2);
            chest.m_6836_(randSlot2, stack1);
            this.entity.m_6674_(InteractionHand.MAIN_HAND);
            if (!this.entity.hasOpenedChest) {
                this.entity.openChest(new BlockPos(this.x, this.y, this.z));
            }
            CULog.dbg((String)"EntityAIInteractChest swapped item contents");
        } else {
            this.m_8041_();
        }
    }

    public void m_8041_() {
        CULog.dbg((String)"reset task");
        this.entity.m_21573_().m_26573_();
        this.ticksChestOpen = 0;
        super.m_8041_();
    }
}

