/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players.entity.ai;

import com.corosus.coroutil.util.CU;
import com.corosus.zombie_players.entity.ZombiePlayer;
import com.google.common.base.Predicate;
import java.util.Collections;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.OwnableEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.goal.target.TargetGoal;
import net.minecraft.world.entity.monster.Ghast;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.phys.AABB;

public class EntityAINearestAttackableTargetIfCalm<T extends LivingEntity>
extends TargetGoal {
    protected final Class<T> targetClass;
    private final int targetChance;
    protected final Sorter sorter;
    protected final Predicate<? super T> targetEntitySelector;
    protected T targetEntity;
    protected ZombiePlayer entity;
    public boolean invert = false;

    public EntityAINearestAttackableTargetIfCalm(ZombiePlayer creature, Class<T> classTarget, boolean checkSight, boolean attackIfHostile) {
        this(creature, classTarget, checkSight, false, attackIfHostile);
    }

    public EntityAINearestAttackableTargetIfCalm(ZombiePlayer creature, Class<T> classTarget, boolean checkSight, boolean onlyNearby, boolean attackIfHostile) {
        this(creature, classTarget, 10, checkSight, onlyNearby, null, attackIfHostile);
    }

    public EntityAINearestAttackableTargetIfCalm(ZombiePlayer creature, Class<T> classTarget, int chance, boolean checkSight, boolean onlyNearby, final @Nullable Predicate<? super T> targetSelector, boolean attackIfHostile) {
        super((Mob)creature, checkSight, onlyNearby);
        this.invert = attackIfHostile;
        this.entity = creature;
        this.targetClass = classTarget;
        this.targetChance = chance;
        this.sorter = new Sorter((Entity)creature);
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
        this.targetEntitySelector = new Predicate<T>(){

            public boolean apply(@Nullable T p_apply_1_) {
                if (p_apply_1_ == null) {
                    return false;
                }
                if (targetSelector != null && !targetSelector.apply(p_apply_1_)) {
                    return false;
                }
                return false;
            }
        };
    }

    public static boolean canAttackClass(Class<? extends LivingEntity> cls) {
        return cls != Ghast.class;
    }

    public static boolean isSuitableTarget2(Mob p_179445_0_, @Nullable LivingEntity p_179445_1_, boolean p_179445_3_) {
        if (p_179445_1_ == null) {
            return false;
        }
        if (p_179445_1_ == p_179445_0_) {
            return false;
        }
        if (!p_179445_1_.m_6084_()) {
            return false;
        }
        if (!EntityAINearestAttackableTargetIfCalm.canAttackClass(p_179445_1_.getClass())) {
            return false;
        }
        if (p_179445_0_ instanceof OwnableEntity && ((OwnableEntity)p_179445_0_).m_142504_() != null) {
            if (p_179445_1_ instanceof OwnableEntity && ((OwnableEntity)p_179445_0_).m_142504_().equals(((OwnableEntity)p_179445_1_).m_142504_())) {
                return false;
            }
            if (p_179445_1_ == ((OwnableEntity)p_179445_0_).m_142480_()) {
                return false;
            }
        }
        return !p_179445_3_ || p_179445_0_.m_21574_().m_148306_((Entity)p_179445_1_);
    }

    public boolean m_8036_() {
        if (this.invert ? this.entity.getCalmTime() > 0 : this.entity.getCalmTime() == 0) {
            return false;
        }
        if (this.entity.getCalmTime() > 0 && this.entity.isHealthLow()) {
            return false;
        }
        if (this.entity.getWorkInfo().isInTrainingMode()) {
            return false;
        }
        if (this.targetChance > 0 && CU.rand().nextInt(this.targetChance) != 0) {
            return false;
        }
        if (this.targetClass != Player.class && this.targetClass != ServerPlayer.class) {
            List list = this.entity.f_19853_.m_6443_(this.targetClass, this.getTargetableArea(this.entity.m_21051_(Attributes.f_22277_).m_22135_()), this.targetEntitySelector);
            if (list.isEmpty()) {
                return false;
            }
            Collections.sort(list, this.sorter);
            this.targetEntity = (LivingEntity)list.get(0);
            return true;
        }
        this.targetEntity = this.entity.f_19853_.m_5788_(this.entity.m_20185_(), this.entity.m_20186_() + (double)this.entity.m_20192_(), this.entity.m_20189_(), this.m_7623_(), this.targetEntitySelector);
        return this.targetEntity != null;
    }

    protected double m_7623_() {
        return this.f_26135_.m_21133_(Attributes.f_22277_);
    }

    protected AABB getTargetableArea(double targetDistance) {
        return this.entity.m_142469_().m_82377_(targetDistance, 4.0, targetDistance);
    }

    public void m_8056_() {
        this.entity.m_6710_((LivingEntity)this.targetEntity);
        super.m_8056_();
    }

    public static class Sorter
    implements Comparator<Entity> {
        private final Entity entity;

        public Sorter(Entity entityIn) {
            this.entity = entityIn;
        }

        @Override
        public int compare(Entity p_compare_1_, Entity p_compare_2_) {
            double d1;
            double d0 = this.entity.m_20280_(p_compare_1_);
            if (d0 < (d1 = this.entity.m_20280_(p_compare_2_))) {
                return -1;
            }
            return d0 > d1 ? 1 : 0;
        }
    }
}

