/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players.entity.ai;

import com.corosus.coroutil.util.CU;
import com.corosus.zombie_players.entity.ZombiePlayer;
import java.util.EnumSet;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;

public class EntityAIPlayZombiePlayer
extends Goal {
    private final ZombiePlayer zombiePlayer;
    private LivingEntity target;
    private final double speed;
    private int playTime;
    private long lastPlayTime = -1L;
    private long playTimeCoolDownAmount = 6000L;

    public EntityAIPlayZombiePlayer(ZombiePlayer villagerIn, double speedIn) {
        this.zombiePlayer = villagerIn;
        this.speed = speedIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE));
    }

    public boolean m_8036_() {
        if (!this.zombiePlayer.isCalm() || this.zombiePlayer.shouldFollowOwner || !this.zombiePlayer.shouldWander) {
            return false;
        }
        if (this.zombiePlayer.getWorkInfo().isPerformingWork()) {
            return false;
        }
        if (this.zombiePlayer.m_183503_().m_46467_() < this.lastPlayTime + this.playTimeCoolDownAmount) {
            return false;
        }
        if (CU.rand().nextInt(200) != 0) {
            return false;
        }
        if (!this.zombiePlayer.canPlay()) {
            return false;
        }
        List list = this.zombiePlayer.f_19853_.m_45976_(ZombiePlayer.class, this.zombiePlayer.m_142469_().m_82377_(12.0, 3.0, 12.0));
        double d0 = Double.MAX_VALUE;
        for (ZombiePlayer entityvillager : list) {
            double d1;
            if (entityvillager == this.zombiePlayer || entityvillager.isPlaying() || !((d1 = entityvillager.m_20280_((Entity)this.zombiePlayer)) <= d0)) continue;
            d0 = d1;
            this.target = entityvillager;
        }
        return this.target != null;
    }

    public boolean m_8045_() {
        return this.playTime > 0;
    }

    public void m_8056_() {
        if (this.target != null) {
            this.zombiePlayer.setPlaying(true);
        }
        this.zombiePlayer.markStartPlaying();
        this.playTime = 1000;
        this.lastPlayTime = this.zombiePlayer.m_183503_().m_46467_();
    }

    public void m_8041_() {
        this.zombiePlayer.setPlaying(false);
        this.target = null;
    }

    public void m_8037_() {
        --this.playTime;
        if (this.playTime % 20 == 0 && this.zombiePlayer.m_20096_() && CU.rand().nextInt(3) == 0) {
            this.zombiePlayer.m_21569_().m_24901_();
        }
        if (this.target != null) {
            if (this.zombiePlayer.m_20280_((Entity)this.target) > 4.0) {
                this.zombiePlayer.m_21573_().m_5624_((Entity)this.target, this.speed);
            }
        } else if (this.zombiePlayer.m_21573_().m_26571_()) {
            Vec3 vec3d = DefaultRandomPos.m_148403_((PathfinderMob)this.zombiePlayer, (int)16, (int)3);
            if (vec3d == null) {
                return;
            }
            this.zombiePlayer.m_21573_().m_26519_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, this.speed);
        }
    }
}

