/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players.entity.ai;

import com.corosus.zombie_players.entity.ZombiePlayer;
import java.util.EnumSet;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.LeavesBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.pathfinder.BlockPathTypes;
import net.minecraft.world.level.pathfinder.WalkNodeEvaluator;

public class EntityAIStayAtHomePosition
extends Goal {
    private final ZombiePlayer entity;
    Level world;
    private final double followSpeed;
    private final PathNavigation petPathfinder;
    private int timeToRecalcPath;
    private float oldWaterCost;
    public static double TP_RANGE_SQ = 1024.0;

    public EntityAIStayAtHomePosition(ZombiePlayer tameableIn, double followSpeedIn) {
        this.entity = tameableIn;
        this.world = tameableIn.f_19853_;
        this.followSpeed = followSpeedIn;
        this.petPathfinder = tameableIn.m_21573_();
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (!this.entity.isCalm() || this.entity.shouldWander || this.entity.shouldFollowOwner) {
            return false;
        }
        if (this.entity.m_21534_() == null || this.entity.m_21534_().equals((Object)BlockPos.f_121853_)) {
            return false;
        }
        if (!this.world.m_46749_(this.entity.m_21534_())) {
            return false;
        }
        return !this.isCloseEnough();
    }

    public boolean isCloseEnough() {
        return this.entity.m_142538_().m_123331_((Vec3i)this.entity.m_21534_()) <= 0.5;
    }

    public boolean isFarEnoughToTeleport() {
        return this.entity.m_142538_().m_123331_((Vec3i)this.entity.m_21534_()) > TP_RANGE_SQ;
    }

    public static boolean needsToTeleportToOwner(ZombiePlayer entity) {
        if (!entity.isCalm() || !entity.shouldFollowOwner) {
            return false;
        }
        LivingEntity entitylivingbase = (LivingEntity)entity.m_142480_();
        if (entitylivingbase == null) {
            return false;
        }
        if (entitylivingbase instanceof Player && ((Player)entitylivingbase).m_5833_()) {
            return false;
        }
        return !(entity.m_20280_((Entity)entitylivingbase) < TP_RANGE_SQ);
    }

    public boolean m_8045_() {
        return this.m_8036_();
    }

    public void m_8056_() {
        this.timeToRecalcPath = 0;
        this.oldWaterCost = this.entity.m_21439_(BlockPathTypes.WATER);
        this.entity.m_21441_(BlockPathTypes.WATER, 0.0f);
    }

    public void m_8041_() {
        this.petPathfinder.m_26573_();
        this.entity.m_21441_(BlockPathTypes.WATER, this.oldWaterCost);
    }

    public void m_8037_() {
        if (!this.entity.m_21523_() && !this.entity.m_20159_() && this.isFarEnoughToTeleport() && this.teleportToHome()) {
            return;
        }
        if (--this.timeToRecalcPath <= 0) {
            this.timeToRecalcPath = 10;
            if (!this.petPathfinder.m_26519_((double)((float)this.entity.m_21534_().m_123341_() + 0.5f), (double)this.entity.m_21534_().m_123342_(), (double)((float)this.entity.m_21534_().m_123343_() + 0.5f), this.followSpeed) && !this.entity.m_21523_() && !this.entity.m_20159_() && this.isFarEnoughToTeleport()) {
                int i = Mth.m_14143_((float)this.entity.m_21534_().m_123341_()) - 2;
                int j = Mth.m_14143_((float)this.entity.m_21534_().m_123343_()) - 2;
                int k = Mth.m_14143_((float)this.entity.m_21534_().m_123342_());
                for (int l = 0; l <= 4; ++l) {
                    for (int i1 = 0; i1 <= 4; ++i1) {
                        if (l >= 1 && i1 >= 1 && l <= 3 && i1 <= 3 || !this.canTeleportTo(new BlockPos(i, j, k))) continue;
                        this.entity.m_7678_((float)(i + l) + 0.5f, k, (float)(j + i1) + 0.5f, this.entity.m_146908_(), this.entity.m_146909_());
                        this.petPathfinder.m_26573_();
                        return;
                    }
                }
            }
        }
    }

    private boolean canTeleportTo(BlockPos p_25308_) {
        BlockPathTypes blockpathtypes = WalkNodeEvaluator.m_77604_((BlockGetter)this.world, (BlockPos.MutableBlockPos)p_25308_.m_122032_());
        if (blockpathtypes != BlockPathTypes.WALKABLE) {
            return false;
        }
        BlockState blockstate = this.world.m_8055_(p_25308_.m_7495_());
        if (blockstate.m_60734_() instanceof LeavesBlock) {
            return false;
        }
        BlockPos blockpos = p_25308_.m_141950_((Vec3i)this.entity.m_142538_());
        return this.world.m_45756_((Entity)this.entity, this.entity.m_142469_().m_82338_(blockpos));
    }

    private boolean teleportToHome() {
        BlockPos blockpos = this.entity.m_21534_();
        for (int i = 0; i < 10; ++i) {
            int j = this.randomIntInclusive(-3, 3);
            int k = this.randomIntInclusive(-1, 1);
            int l = this.randomIntInclusive(-3, 3);
            boolean flag = this.maybeTeleportTo(blockpos.m_123341_() + j, blockpos.m_123342_() + k, blockpos.m_123343_() + l);
            if (!flag) continue;
            return true;
        }
        return false;
    }

    private int randomIntInclusive(int p_25301_, int p_25302_) {
        return this.entity.m_21187_().nextInt(p_25302_ - p_25301_ + 1) + p_25301_;
    }

    private boolean maybeTeleportTo(int p_25304_, int p_25305_, int p_25306_) {
        if (!this.canTeleportTo(new BlockPos(p_25304_, p_25305_, p_25306_))) {
            return false;
        }
        this.entity.m_7678_((double)p_25304_ + 0.5, p_25305_, (double)p_25306_ + 0.5, this.entity.m_146908_(), this.entity.m_146909_());
        this.entity.m_21573_().m_26573_();
        return true;
    }
}

