/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players.entity.ai;

import com.corosus.zombie_players.entity.ZombiePlayer;
import java.util.EnumSet;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.NotNull;

public class EntityAIWorkDepositPickupsInChest
extends Goal {
    private final ZombiePlayer entityObj;
    private int walkingTimeoutMax = 200;
    private int walkingTimeout;
    private int repathPentalty = 0;
    private int lookUpdateTimer = 0;
    @NotNull
    public BlockPos posCachedBestChest = BlockPos.f_121853_;

    public EntityAIWorkDepositPickupsInChest(ZombiePlayer entityObjIn) {
        this.entityObj = entityObjIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.entityObj.hasAnyItemsInExtra() && this.entityObj.hasChestToUse()) {
            this.posCachedBestChest = this.entityObj.getClosestChestPosWithSpace();
            return this.posCachedBestChest != BlockPos.f_121853_;
        }
        return false;
    }

    public boolean m_8045_() {
        return this.entityObj.hasAnyItemsInExtra() && this.verifyOrGetNewChest();
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.posCachedBestChest != BlockPos.f_121853_) {
            boolean isClose = false;
            BlockPos blockposGoal = this.posCachedBestChest;
            if (blockposGoal == BlockPos.f_121853_) {
                this.m_8041_();
                return;
            }
            double dist = this.entityObj.m_20182_().m_82554_(new Vec3((double)blockposGoal.m_123341_(), (double)blockposGoal.m_123342_(), (double)blockposGoal.m_123343_()));
            if (dist <= 3.0) {
                this.entityObj.setDepositingInChest(true);
                this.entityObj.openChest(this.posCachedBestChest);
                if (!this.entityObj.ejectItems(this.posCachedBestChest)) {
                    this.posCachedBestChest = BlockPos.f_121853_;
                    ((ServerLevel)this.entityObj.f_19853_).m_8767_((ParticleOptions)ParticleTypes.f_123771_, this.entityObj.m_20185_(), this.entityObj.m_20186_() + (double)this.entityObj.m_20192_() + 0.5, this.entityObj.m_20189_(), 1, 0.3, 0.0, 0.3, 1.0);
                }
                this.entityObj.m_6674_(InteractionHand.MAIN_HAND);
                this.entityObj.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3((double)this.posCachedBestChest.m_123341_() + 0.5, (double)this.posCachedBestChest.m_123342_() + 0.5, (double)this.posCachedBestChest.m_123343_() + 0.5));
                this.entityObj.m_21573_().m_26573_();
                return;
            }
            if (!isClose) {
                if ((this.entityObj.m_21573_().m_26571_() || this.walkingTimeout <= 0) && this.repathPentalty <= 0) {
                    int i = blockposGoal.m_123341_();
                    int j = blockposGoal.m_123342_();
                    int k = blockposGoal.m_123343_();
                    boolean success = false;
                    if (this.entityObj.m_20238_(Vec3.m_82512_((Vec3i)blockposGoal)) > 256.0) {
                        Vec3 vec3d = DefaultRandomPos.m_148412_((PathfinderMob)this.entityObj, (int)14, (int)3, (Vec3)new Vec3((double)i + 0.5, (double)j, (double)k + 0.5), (double)1.5707963705062866);
                        if (vec3d != null) {
                            success = this.entityObj.m_21573_().m_26519_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.3);
                        }
                    } else {
                        success = this.entityObj.m_21573_().m_26519_((double)i + 0.5, (double)j, (double)k + 0.5, 1.3);
                    }
                    if (!success) {
                        this.repathPentalty = 40;
                    } else {
                        this.walkingTimeout = this.walkingTimeoutMax;
                    }
                } else if (this.walkingTimeout > 0) {
                    --this.walkingTimeout;
                }
            }
            if (this.repathPentalty > 0) {
                --this.repathPentalty;
            }
            if (this.lookUpdateTimer > 0) {
                --this.lookUpdateTimer;
            }
        }
    }

    public void m_8056_() {
        super.m_8056_();
        this.entityObj.m_21573_().m_26573_();
    }

    public void m_8041_() {
        super.m_8041_();
        this.walkingTimeout = 0;
        this.entityObj.setDepositingInChest(false);
        ((ServerLevel)this.entityObj.f_19853_).m_8767_((ParticleOptions)DustParticleOptions.f_123656_, this.entityObj.m_20185_(), this.entityObj.m_20186_() + 1.5, this.entityObj.m_20189_(), 1, 0.3, 0.0, 0.3, 1.0);
    }

    public boolean verifyOrGetNewChest() {
        if (this.posCachedBestChest == BlockPos.f_121853_) {
            return false;
        }
        if (!this.entityObj.isValidChestForWork(this.posCachedBestChest, false)) {
            this.posCachedBestChest = this.entityObj.getClosestChestPosWithSpace();
        }
        return this.posCachedBestChest != BlockPos.f_121853_;
    }
}

