/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players.entity.ai;

import com.corosus.coroutil.util.CU;
import com.corosus.coroutil.util.CULog;
import com.corosus.coroutil.util.CoroUtilEntity;
import com.corosus.zombie_players.entity.EnumBlockBreakBehaviorType;
import com.corosus.zombie_players.entity.EnumTrainType;
import com.corosus.zombie_players.entity.ZombiePlayer;
import com.corosus.zombie_players.util.TreeCutter;
import com.corosus.zombie_players.util.UtilCrops;
import com.mojang.math.Vector3f;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.commands.arguments.EntityAnchorArgument;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.Vec3i;
import net.minecraft.core.particles.DustParticleOptions;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.BlockTags;
import net.minecraft.tags.TagKey;
import net.minecraft.util.Mth;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.goal.Goal;
import net.minecraft.world.entity.ai.util.DefaultRandomPos;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BambooBlock;
import net.minecraft.world.level.block.BeetrootBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.CactusBlock;
import net.minecraft.world.level.block.CaveVinesBlock;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.GrowingPlantBlock;
import net.minecraft.world.level.block.SugarCaneBlock;
import net.minecraft.world.level.block.SweetBerryBushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.util.FakePlayer;

public class EntityAIWorkInArea
extends Goal {
    private final ZombiePlayer entityObj;
    private int walkingTimeoutMax = 200;
    private int walkingTimeout;
    private int repathPentalty = 0;
    private int lookUpdateTimer = 0;
    private BlockPos posCurrentWorkTarget = BlockPos.f_121853_;
    private BlockPos posNextWorkTarget = BlockPos.f_121853_;
    private BlockPos posLastBadPath = BlockPos.f_121853_;
    private long lastBadPathTime = 0L;
    private long lastBadPathCooldown = 200L;
    private long scanCooldownAmount = 5L;
    private long scanNextTickWork = 0L;
    private long jobCompleteCooldown = 0L;
    private long jobCompleteCooldownValue = 100L;
    private int curScanRange = 3;
    private int curAngle = 0;
    public static HashMap<Class, BlockInfo> lookupBlockClassToBlockInfo = new HashMap();
    public static HashMap<String, BlockInfo> lookupBlockTagToBlockInfo = new HashMap();

    public static void add(String tag, Property property, EnumBlockBreakBehaviorType behaviorType) {
        lookupBlockTagToBlockInfo.put(tag, new BlockInfo(property, behaviorType));
    }

    public static void add(Class clazz, Property property, EnumBlockBreakBehaviorType behaviorType) {
        lookupBlockClassToBlockInfo.put(clazz, new BlockInfo(property, behaviorType));
    }

    public EntityAIWorkInArea(ZombiePlayer entityObjIn) {
        this.entityObj = entityObjIn;
        this.m_7021_(EnumSet.of(Goal.Flag.MOVE, Goal.Flag.LOOK));
    }

    public boolean m_8036_() {
        if (this.entityObj.isDepositingInChest()) {
            return false;
        }
        if (this.entityObj.needsMoreWorkItem()) {
            return false;
        }
        if (!this.entityObj.isCalm() || this.entityObj.getWorkInfo().isInTrainingMode() || this.entityObj.getWorkInfo().isInAreaSetMode() || this.jobCompleteCooldown >= this.entityObj.m_183503_().m_46467_() || this.entityObj.getWorkInfo().getStateWorkLastObserved().m_60734_() == Blocks.f_50016_) {
            return false;
        }
        if (this.posNextWorkTarget != BlockPos.f_121853_) {
            this.posCurrentWorkTarget = this.posNextWorkTarget;
            return true;
        }
        return this.canWorkOrFindWork();
    }

    public boolean m_8045_() {
        if (!this.entityObj.isCalm() || this.entityObj.getWorkInfo().isInTrainingMode() || this.jobCompleteCooldown >= this.entityObj.m_183503_().m_46467_() || this.entityObj.getWorkInfo().getStateWorkLastObserved().m_60734_() == Blocks.f_50016_) {
            return false;
        }
        if (this.entityObj.needsMoreWorkItem()) {
            return false;
        }
        return !this.posCurrentWorkTarget.equals((Object)BlockPos.f_121853_);
    }

    public boolean canWorkOrFindWork() {
        if (this.scanNextTickWork < this.entityObj.m_183503_().m_46467_()) {
            this.scanNextTickWork = this.entityObj.m_183503_().m_46467_() + this.scanCooldownAmount;
            if (this.entityObj.getWorkInfo().isWorkAreaSet() && this.posCurrentWorkTarget.equals((Object)BlockPos.f_121853_)) {
                return !this.findWorkBlockPosRadial().equals((Object)BlockPos.f_121853_);
            }
            return false;
        }
        return false;
    }

    public int getWorkDistance() {
        return this.entityObj.getWorkDistance();
    }

    public BlockPos findWorkBlockPosRadial() {
        int lastX = 0;
        int lastZ = 0;
        if (this.curAngle >= 360) {
            this.curAngle = 0;
            ++this.curScanRange;
            if (this.curScanRange > this.getWorkDistance()) {
                this.curScanRange = 1;
            }
        }
        int range = this.curScanRange;
        boolean looked = false;
        for (int angleTicks = 0; angleTicks < 90; ++angleTicks) {
            ++this.curAngle;
            int x = Mth.m_14143_((float)(-Mth.m_14031_((float)((float)this.curAngle * ((float)Math.PI / 180))) * (float)range));
            int z = Mth.m_14143_((float)(Mth.m_14089_((float)((float)this.curAngle * ((float)Math.PI / 180))) * (float)range));
            if (lastX == x && lastZ == z) continue;
            lastX = x;
            lastZ = z;
            boolean dbgScan = this.entityObj.isShowWorkInfo();
            if (dbgScan) {
                BlockPos pos = this.entityObj.m_142538_().m_142082_(x, 0, z);
                ((ServerLevel)this.entityObj.f_19853_).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.0f), 1.0f), (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() - 4), (double)pos.m_123343_() + 0.5, 1, 0.3, 0.0, 0.3, 1.0);
                ((ServerLevel)this.entityObj.f_19853_).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.0f), 1.0f), (double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 1, 0.3, 0.0, 0.3, 1.0);
                ((ServerLevel)this.entityObj.f_19853_).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 1.0f, 0.0f), 1.0f), (double)pos.m_123341_() + 0.5, (double)(pos.m_123342_() + this.getWorkDistance() / 2), (double)pos.m_123343_() + 0.5, 1, 0.3, 0.0, 0.3, 1.0);
            }
            for (int y = -4; y <= this.getWorkDistance() / 2; ++y) {
                BlockPos pos = this.entityObj.m_142538_().m_142082_(x, y, z);
                if (!looked) {
                    looked = true;
                    if (CU.random.nextInt(5) == 0) {
                        this.entityObj.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3((double)pos.m_123341_() + 0.5, (double)this.entityObj.m_142538_().m_123342_(), (double)pos.m_123343_() + 0.5));
                    }
                }
                if (!this.isValidWorkBlock(pos)) continue;
                if (this.entityObj.f_19853_.m_8055_(pos).m_204336_(BlockTags.f_13106_)) {
                    if (this.entityObj.f_19853_.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13106_) || this.entityObj.f_19853_.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13035_) || this.entityObj.f_19853_.m_8055_(pos.m_7495_()).m_60795_()) continue;
                    this.posCurrentWorkTarget = pos;
                    return this.posCurrentWorkTarget;
                }
                this.posCurrentWorkTarget = pos;
                return this.posCurrentWorkTarget;
            }
        }
        return BlockPos.f_121853_;
    }

    public boolean isValidWorkBlock(BlockPos pos) {
        if (this.shouldSkipPos(pos)) {
            return false;
        }
        if (!this.entityObj.getWorkInfo().getPosWorkArea().m_82393_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_())) {
            return false;
        }
        BlockState state = this.entityObj.f_19853_.m_8055_(pos);
        BlockInfo infoDesired = this.getBlockInfo(this.entityObj.getWorkInfo().getStateWorkLastObserved());
        BlockInfo info = this.getBlockInfo(state);
        if (state.m_60734_() == this.entityObj.getWorkInfo().getStateWorkLastObserved().m_60734_() || infoDesired != null && info == infoDesired) {
            boolean foundRuleForBlock = false;
            boolean successfullMatchPhase1 = false;
            if (info != null && this.entityObj.getWorkInfo().getItemNeededForWork().m_41619_()) {
                foundRuleForBlock = true;
            }
            if (this.entityObj.getWorkInfo().isExactMatchMode()) {
                if (!this.entityObj.getWorkInfo().getStateWorkLastObserved().m_60734_().equals(state.m_60734_())) {
                    return false;
                }
                for (Map.Entry entry : state.m_61148_().entrySet()) {
                    if (this.entityObj.getWorkInfo().getStateWorkLastObserved().m_61138_((Property)entry.getKey())) {
                        if (state.m_61143_((Property)entry.getKey()) == this.entityObj.getWorkInfo().getStateWorkLastObserved().m_61143_((Property)entry.getKey())) continue;
                        return false;
                    }
                    return false;
                }
                successfullMatchPhase1 = true;
            } else if (foundRuleForBlock) {
                if (info.property == null) {
                    successfullMatchPhase1 = true;
                }
                if (state.m_61138_(info.property) && this.entityObj.getWorkInfo().getStateWorkLastObserved().m_61138_(info.property) && this.entityObj.getWorkInfo().getStateWorkLastObserved().m_61143_(info.property) == state.m_61143_(info.property)) {
                    successfullMatchPhase1 = true;
                }
            } else {
                successfullMatchPhase1 = true;
            }
            if (successfullMatchPhase1) {
                // empty if block
            }
            if (successfullMatchPhase1 && this.isWithinRestrictions(pos)) {
                BlockPos posCheckForAir;
                if (this.entityObj.f_19853_.m_8055_(pos).m_204336_(BlockTags.f_13106_) && (this.entityObj.f_19853_.m_8055_(pos.m_7495_()).m_204336_(BlockTags.f_13106_) || this.entityObj.f_19853_.m_8055_(pos.m_7495_()).m_60795_())) {
                    return false;
                }
                if (info != null && info.blockBreakBehaviorType == EnumBlockBreakBehaviorType.BREAK_ALL_BUT_BOTTOM && this.entityObj.f_19853_.m_8055_(pos.m_7495_()).m_60734_() != this.entityObj.getWorkInfo().getStateWorkLastObserved().m_60734_()) {
                    return false;
                }
                if (!foundRuleForBlock && this.entityObj.getWorkInfo().getWorkClickLastObserved() == EnumTrainType.BLOCK_RIGHT_CLICK && !this.entityObj.f_19853_.m_8055_(posCheckForAir = pos.m_142300_(this.entityObj.getWorkInfo().getWorkClickDirectionLastObserved())).m_60795_()) {
                    return false;
                }
                CULog.dbg((String)("found valid work block!: " + this.entityObj.f_19853_.m_8055_(pos)));
                return true;
            }
        }
        return false;
    }

    public boolean isWithinRestrictions(BlockPos pos) {
        return this.entityObj.getWorkInfo().getPosWorkArea().m_82393_((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_());
    }

    public boolean hasLineOfSight(LivingEntity source, BlockPos p_147185_) {
        Vec3 vec3 = new Vec3(source.m_20185_(), source.m_20188_(), source.m_20189_());
        Vec3 vec31 = new Vec3((double)p_147185_.m_123341_() + 0.5, (double)p_147185_.m_123342_() + 0.5, (double)p_147185_.m_123343_() + 0.5);
        if (vec31.m_82554_(vec3) > 128.0) {
            return false;
        }
        return CoroUtilEntity.canSee((Entity)this.entityObj, (BlockPos)p_147185_);
    }

    public void m_8037_() {
        super.m_8037_();
        if (this.entityObj.isShowWorkInfo()) {
            ((ServerLevel)this.entityObj.f_19853_).m_8767_((ParticleOptions)DustParticleOptions.f_123656_, (double)this.posCurrentWorkTarget.m_123341_() + 0.5, (double)this.posCurrentWorkTarget.m_123342_() + 0.5, (double)this.posCurrentWorkTarget.m_123343_() + 0.5, 2, 0.5, 0.5, 0.5, 1.0);
        }
        if (!this.posCurrentWorkTarget.equals((Object)BlockPos.f_121853_)) {
            boolean isClose = false;
            BlockPos blockposGoal = this.posCurrentWorkTarget;
            if (blockposGoal.equals((Object)BlockPos.f_121853_)) {
                this.m_8041_();
                return;
            }
            double dist = this.entityObj.m_20182_().m_82554_(new Vec3((double)blockposGoal.m_123341_(), (double)blockposGoal.m_123342_(), (double)blockposGoal.m_123343_()));
            if (dist <= 3.8) {
                if (this.operateOnTargetPosition(blockposGoal)) {
                    this.posNextWorkTarget = this.quickFindNeighborWorkBlock(this.posCurrentWorkTarget);
                    if (this.posCurrentWorkTarget.equals((Object)this.posNextWorkTarget)) {
                        this.jobCompleteCooldown = this.entityObj.f_19853_.m_46467_() + 5L;
                    }
                    this.posCurrentWorkTarget = BlockPos.f_121853_;
                } else {
                    CULog.dbg((String)"target block no longer valid, aborting");
                    this.posCurrentWorkTarget = BlockPos.f_121853_;
                    this.posNextWorkTarget = BlockPos.f_121853_;
                }
                this.entityObj.m_21573_().m_26573_();
                return;
            }
            if (!isClose) {
                if ((this.entityObj.m_21573_().m_26571_() || this.walkingTimeout <= 0) && this.repathPentalty <= 0) {
                    int i = blockposGoal.m_123341_();
                    int j = blockposGoal.m_123342_();
                    int k = blockposGoal.m_123343_();
                    boolean success = false;
                    if (this.entityObj.m_20238_(Vec3.m_82512_((Vec3i)blockposGoal)) > 256.0) {
                        Vec3 vec3d = DefaultRandomPos.m_148412_((PathfinderMob)this.entityObj, (int)14, (int)3, (Vec3)new Vec3((double)i + 0.5, (double)j, (double)k + 0.5), (double)1.5707963705062866);
                        if (vec3d != null) {
                            success = this.entityObj.m_21573_().m_26519_(vec3d.f_82479_, vec3d.f_82480_, vec3d.f_82481_, 1.3);
                        }
                    } else {
                        success = this.tryMoveToOpenSpotNextTo(new BlockPos(i, j, k));
                    }
                    if (!success) {
                        this.repathPentalty = 40;
                    } else {
                        this.walkingTimeout = this.walkingTimeoutMax;
                    }
                } else if (this.walkingTimeout > 0) {
                    --this.walkingTimeout;
                    this.entityObj.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3((double)this.entityObj.m_21573_().m_26567_().m_123341_() + 0.5, (double)this.entityObj.m_21573_().m_26567_().m_123342_() + 0.5, (double)this.entityObj.m_21573_().m_26567_().m_123343_() + 0.5));
                    if (this.walkingTimeout < this.walkingTimeoutMax / 4 * 3 && this.walkingTimeout % 4 == 0) {
                        for (int y = 0; y <= 2; ++y) {
                            for (int x = -1; x < 2; ++x) {
                                this.trimLeaves(this.entityObj.m_142538_().m_142082_(x, y, 0));
                                this.trimLeaves(this.entityObj.m_142538_().m_142082_(x, y, 0));
                                this.trimLeaves(this.entityObj.m_142538_().m_142082_(x, y, 0));
                                this.trimLeaves(this.entityObj.m_142538_().m_142082_(x, y, 0));
                                this.trimLeaves(this.entityObj.m_142538_().m_142082_(0, y, x));
                                this.trimLeaves(this.entityObj.m_142538_().m_142082_(0, y, x));
                                this.trimLeaves(this.entityObj.m_142538_().m_142082_(0, y, x));
                                this.trimLeaves(this.entityObj.m_142538_().m_142082_(0, y, x));
                            }
                        }
                    }
                } else {
                    this.lastBadPathTime = this.entityObj.f_19853_.m_46467_() + this.lastBadPathCooldown;
                    this.posLastBadPath = this.entityObj.m_21573_().m_26567_();
                    this.m_8041_();
                }
            }
            if (this.repathPentalty > 0) {
                --this.repathPentalty;
            }
            if (this.lookUpdateTimer > 0) {
                --this.lookUpdateTimer;
            }
        }
    }

    public boolean tryMoveToOpenSpotNextTo(BlockPos pos) {
        if (this.entityObj.f_19853_.m_8055_(pos.m_142082_(1, 0, 0)).m_60795_()) {
            return this.entityObj.m_21573_().m_26519_((double)pos.m_123341_() + 1.0 + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 1.0);
        }
        if (this.entityObj.f_19853_.m_8055_(pos.m_142082_(-1, 0, 0)).m_60795_()) {
            return this.entityObj.m_21573_().m_26519_((double)pos.m_123341_() - 1.0 + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 1.0);
        }
        if (this.entityObj.f_19853_.m_8055_(pos.m_142082_(0, 0, 1)).m_60795_()) {
            return this.entityObj.m_21573_().m_26519_((double)pos.m_123341_() + 0.0 + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 1.0 + 0.5, 1.0);
        }
        if (this.entityObj.f_19853_.m_8055_(pos.m_142082_(0, 0, -1)).m_60795_()) {
            return this.entityObj.m_21573_().m_26519_((double)pos.m_123341_() + 0.0 + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() - 1.0 + 0.5, 1.0);
        }
        return this.entityObj.m_21573_().m_26519_((double)pos.m_123341_() + 0.5, (double)pos.m_123342_(), (double)pos.m_123343_() + 0.5, 1.0);
    }

    public void trimLeaves(BlockPos pos) {
        if (this.entityObj.f_19853_.m_8055_(pos).m_204336_(BlockTags.f_13035_) || this.entityObj.f_19853_.m_8055_(pos).m_204336_(BlockTags.f_13106_)) {
            this.entityObj.f_19853_.m_46961_(pos, true);
        }
    }

    public void m_8056_() {
        super.m_8056_();
        this.entityObj.m_21573_().m_26573_();
    }

    public void m_8041_() {
        super.m_8041_();
        ((ServerLevel)this.entityObj.f_19853_).m_8767_((ParticleOptions)new DustParticleOptions(new Vector3f(0.0f, 0.0f, 1.0f), 1.0f), this.entityObj.m_20185_(), this.entityObj.m_20186_() + 1.5, this.entityObj.m_20189_(), 1, 0.3, 0.0, 0.3, 1.0);
        this.walkingTimeout = this.walkingTimeoutMax;
        this.posCurrentWorkTarget = BlockPos.f_121853_;
        this.curScanRange = 1;
    }

    public boolean operateOnTargetPosition(BlockPos pos) {
        if (!this.isValidWorkBlock(pos)) {
            return false;
        }
        boolean performedAction = false;
        BlockState state = this.entityObj.f_19853_.m_8055_(pos);
        if (this.entityObj.getWorkInfo().getWorkClickLastObserved() == EnumTrainType.BLOCK_RIGHT_CLICK) {
            FakePlayer fakePlayer = this.entityObj.getFakePlayer();
            if (!this.entityObj.m_21205_().m_41619_()) {
                InteractionResultHolder resultHolder;
                InteractionResult result = InteractionResult.PASS;
                if (this.entityObj.getWorkInfo().getBlockHitResult() != null) {
                    result = state.m_60664_(this.entityObj.f_19853_, (Player)fakePlayer, InteractionHand.MAIN_HAND, this.entityObj.getWorkInfo().getBlockHitResult());
                    performedAction = true;
                }
                if (!result.m_19077_()) {
                    result = this.entityObj.m_21205_().m_41661_(new UseOnContext(this.entityObj.f_19853_, (Player)fakePlayer, InteractionHand.MAIN_HAND, this.entityObj.m_21205_(), BlockHitResult.m_82426_((Vec3)new Vec3((double)pos.m_123341_(), (double)pos.m_123342_(), (double)pos.m_123343_()), (Direction)this.entityObj.getWorkInfo().getWorkClickDirectionLastObserved(), (BlockPos)pos)));
                    performedAction = true;
                }
                if (!result.m_19077_() && (resultHolder = this.entityObj.m_21205_().m_41682_(this.entityObj.f_19853_, (Player)fakePlayer, InteractionHand.MAIN_HAND)).m_19089_().m_19077_()) {
                    performedAction = true;
                }
            } else if (this.entityObj.getWorkInfo().getBlockHitResult() != null) {
                state.m_60664_(this.entityObj.f_19853_, (Player)fakePlayer, InteractionHand.MAIN_HAND, this.entityObj.getWorkInfo().getBlockHitResult());
                performedAction = true;
            }
        } else if (this.entityObj.getWorkInfo().getWorkClickLastObserved() == EnumTrainType.BLOCK_LEFT_CLICK) {
            BlockInfo info = this.getBlockInfo(state);
            if (info != null) {
                if (info.blockBreakBehaviorType == EnumBlockBreakBehaviorType.BREAK_NORMAL) {
                    if (this.entityObj.f_19853_.m_8055_(pos).m_60800_((BlockGetter)this.entityObj.f_19853_, pos) >= 0.0f) {
                        this.entityObj.f_19853_.m_46961_(pos, true);
                        performedAction = true;
                    }
                } else if (info.blockBreakBehaviorType == EnumBlockBreakBehaviorType.HARVEST) {
                    FakePlayer fakePlayer = this.entityObj.getFakePlayer();
                    if (!UtilCrops.harvestAndReplant(this.entityObj.f_19853_, pos, state, (Player)fakePlayer, (LivingEntity)this.entityObj)) {
                        this.entityObj.f_19853_.m_46961_(pos, true);
                        performedAction = true;
                    }
                } else if (info.blockBreakBehaviorType == EnumBlockBreakBehaviorType.BREAK_VEINMINE_TREE) {
                    TreeCutter.Tree tree = TreeCutter.findTree((BlockGetter)this.entityObj.f_19853_, pos);
                    if (tree.equals(TreeCutter.NO_TREE)) {
                        CULog.dbg((String)"tree veinminer failed");
                    } else {
                        for (BlockPos posEntry : tree.getLogs()) {
                            this.destroyBlockSilently(this.entityObj.f_19853_, posEntry, true, null, 512);
                            performedAction = true;
                        }
                        for (BlockPos posEntry : tree.getLeaves()) {
                            this.destroyBlockSilently(this.entityObj.f_19853_, posEntry, true, null, 512);
                            performedAction = true;
                        }
                        this.entityObj.f_19853_.m_46961_(pos, true);
                    }
                } else if (info.blockBreakBehaviorType == EnumBlockBreakBehaviorType.BREAK_ALL_BUT_BOTTOM) {
                    this.entityObj.f_19853_.m_46961_(pos, true);
                    performedAction = true;
                }
            } else if (this.entityObj.f_19853_.m_8055_(pos).m_60800_((BlockGetter)this.entityObj.f_19853_, pos) >= 0.0f) {
                this.entityObj.f_19853_.m_46961_(pos, true);
                performedAction = true;
            }
        }
        if (performedAction) {
            this.entityObj.m_6674_(InteractionHand.MAIN_HAND);
            this.entityObj.m_7618_(EntityAnchorArgument.Anchor.EYES, new Vec3((double)pos.m_123341_() + 0.5, (double)pos.m_123342_() + 0.5, (double)pos.m_123343_() + 0.5));
        }
        this.jobCompleteCooldown = this.entityObj.f_19853_.m_46467_() + this.jobCompleteCooldownValue;
        this.jobCompleteCooldown = this.entityObj.f_19853_.m_46467_() + 30L;
        this.posLastBadPath = BlockPos.f_121853_;
        this.curScanRange = 1;
        return true;
    }

    public boolean destroyBlockSilently(Level level, BlockPos p_46626_, boolean p_46627_, @Nullable Entity p_46628_, int p_46629_) {
        boolean flag;
        BlockState blockstate = level.m_8055_(p_46626_);
        if (blockstate.m_60795_()) {
            return false;
        }
        FluidState fluidstate = level.m_6425_(p_46626_);
        if (p_46627_) {
            BlockEntity blockentity = blockstate.m_155947_() ? level.m_7702_(p_46626_) : null;
            Block.m_49881_((BlockState)blockstate, (Level)level, (BlockPos)p_46626_, (BlockEntity)blockentity, (Entity)p_46628_, (ItemStack)ItemStack.f_41583_);
        }
        if (flag = level.m_6933_(p_46626_, fluidstate.m_76188_(), 3, p_46629_)) {
            level.m_142346_(p_46628_, GameEvent.f_157794_, p_46626_);
        }
        return flag;
    }

    public BlockInfo getBlockInfo(BlockState state) {
        BlockInfo info;
        block3: {
            String str;
            TagKey tagKey;
            info = lookupBlockClassToBlockInfo.get(state.m_60734_().getClass());
            if (info == null) {
                for (Map.Entry<Class<Object>, BlockInfo> entry : lookupBlockClassToBlockInfo.entrySet()) {
                    if (!entry.getKey().isAssignableFrom(state.m_60734_().getClass())) continue;
                    info = entry.getValue();
                    break;
                }
            }
            if (info != null) break block3;
            Iterator<Map.Entry<Class<Object>, BlockInfo>> iterator = state.m_204343_().toList().iterator();
            while (iterator.hasNext() && (!state.m_204336_(tagKey = (TagKey)iterator.next()) || (info = lookupBlockTagToBlockInfo.get(str = tagKey.f_203868_().toString().replace("minecraft:", ""))) == null)) {
            }
        }
        return info;
    }

    public BlockPos quickFindNeighborWorkBlock(BlockPos completedJobPos) {
        ArrayList list = new ArrayList();
        Arrays.stream(Direction.values()).forEach(p -> list.add(p));
        Collections.shuffle(list);
        for (Direction dir : list) {
            BlockPos pos = completedJobPos.m_142300_(dir);
            if (!this.isValidWorkBlock(pos)) continue;
            return pos;
        }
        if (this.isValidWorkBlock(completedJobPos)) {
            return completedJobPos;
        }
        return BlockPos.f_121853_;
    }

    public boolean shouldSkipPos(BlockPos pos) {
        return this.entityObj.f_19853_.m_46467_() < this.lastBadPathTime && pos == this.posLastBadPath;
    }

    public BlockPos getPosNextWorkTarget() {
        return this.posNextWorkTarget;
    }

    public void setPosNextWorkTarget(BlockPos posNextWorkTarget) {
        this.posNextWorkTarget = posNextWorkTarget;
    }

    static {
        EntityAIWorkInArea.add(CropBlock.class, (Property)CropBlock.f_52244_, EnumBlockBreakBehaviorType.HARVEST);
        EntityAIWorkInArea.add(BeetrootBlock.class, (Property)BeetrootBlock.f_49657_, EnumBlockBreakBehaviorType.HARVEST);
        EntityAIWorkInArea.add(SugarCaneBlock.class, null, EnumBlockBreakBehaviorType.BREAK_ALL_BUT_BOTTOM);
        EntityAIWorkInArea.add(CactusBlock.class, null, EnumBlockBreakBehaviorType.BREAK_ALL_BUT_BOTTOM);
        EntityAIWorkInArea.add(GrowingPlantBlock.class, null, EnumBlockBreakBehaviorType.BREAK_ALL_BUT_BOTTOM);
        EntityAIWorkInArea.add(BambooBlock.class, null, EnumBlockBreakBehaviorType.BREAK_ALL_BUT_BOTTOM);
        EntityAIWorkInArea.add(SweetBerryBushBlock.class, (Property)SweetBerryBushBlock.f_57244_, EnumBlockBreakBehaviorType.BREAK_NORMAL);
        EntityAIWorkInArea.add("logs", null, EnumBlockBreakBehaviorType.BREAK_VEINMINE_TREE);
        EntityAIWorkInArea.add("cave_vines", (Property)CaveVinesBlock.f_152949_, EnumBlockBreakBehaviorType.BREAK_NORMAL);
    }

    static class BlockInfo {
        public Property property;
        public EnumBlockBreakBehaviorType blockBreakBehaviorType;

        public BlockInfo(Property property, EnumBlockBreakBehaviorType blockBreakBehaviorType) {
            this.property = property;
            this.blockBreakBehaviorType = blockBreakBehaviorType;
        }
    }
}

