/*
 * Decompiled with CFR 0.152.
 */
package com.corosus.zombie_players.util;

import com.google.common.collect.Maps;
import java.util.Collection;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.item.enchantment.EnchantmentHelper;
import net.minecraft.world.item.enchantment.Enchantments;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.CropBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.registries.ForgeRegistries;

public class UtilCrops {
    public static final Map<BlockState, BlockState> crops = Maps.newHashMap();

    public static void initDataIfNeeded() {
        if (crops.size() == 0) {
            ForgeRegistries.BLOCKS.getValues().stream().filter(b -> b instanceof CropBlock).map(b -> (CropBlock)b).forEach(b -> crops.put((BlockState)b.m_49966_().m_61124_((Property)b.m_7959_(), (Comparable)Integer.valueOf(UtilCrops.last(b.m_7959_().m_6908_()))), b.m_49966_()));
        }
    }

    private static int last(Collection<Integer> vals) {
        return vals.stream().max(Integer::compare).orElse(0);
    }

    public static boolean harvestAndReplant(Level world, BlockPos pos, BlockState inWorld, Player player, LivingEntity entityWithInventory) {
        UtilCrops.initDataIfNeeded();
        if (!(world instanceof ServerLevel)) {
            return false;
        }
        ItemStack mainHand = entityWithInventory.m_21205_();
        int fortune = 0;
        ItemStack copy = mainHand.m_41777_();
        if (copy.m_41619_()) {
            copy = new ItemStack((ItemLike)Items.f_42398_);
        }
        Map enchMap = EnchantmentHelper.m_44831_((ItemStack)copy);
        enchMap.put(Enchantments.f_44987_, fortune);
        EnchantmentHelper.m_44865_((Map)enchMap, (ItemStack)copy);
        Item blockItem = inWorld.m_60734_().m_5456_();
        Block.m_49874_((BlockState)inWorld, (ServerLevel)((ServerLevel)world), (BlockPos)pos, (BlockEntity)world.m_7702_(pos), (Entity)player, (ItemStack)copy).forEach(stack -> {
            if (stack.m_41720_() == blockItem) {
                stack.m_41774_(1);
            }
            if (!stack.m_41619_()) {
                Block.m_49840_((Level)world, (BlockPos)pos, (ItemStack)stack);
            }
        });
        inWorld.m_60612_((ServerLevel)world, pos, copy);
        BlockState newBlock = crops.get(inWorld);
        if (newBlock != null) {
            world.m_46796_(2001, pos, Block.m_49956_((BlockState)newBlock));
            world.m_46597_(pos, newBlock);
            return true;
        }
        return false;
    }
}

