/*
 * Decompiled with CFR 0.152.
 */
package com.animania.client.render.layer;

import com.animania.api.interfaces.IBlinking;
import com.animania.api.interfaces.ISleeping;
import com.animania.client.models.IColoredModel;
import com.animania.common.handler.AddonInjectionHandler;
import java.awt.Color;
import net.minecraft.client.renderer.GlStateManager;
import net.minecraft.client.renderer.entity.RenderLiving;
import net.minecraft.client.renderer.entity.layers.LayerRenderer;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLivingBase;
import net.minecraft.util.ResourceLocation;

public class LayerBlinking<E extends EntityLivingBase>
implements LayerRenderer {
    private RenderLiving render;
    private ResourceLocation texture_base;
    private int colLeft;
    private int colRight;
    private ResourceLocation left;
    private ResourceLocation right;

    public LayerBlinking(RenderLiving render, ResourceLocation blinkingTexture, int colLeft, int colRight) {
        this.render = render;
        this.texture_base = blinkingTexture;
        this.colLeft = colLeft;
        this.colRight = colRight;
        this.left = new ResourceLocation(this.texture_base.toString().replace(".png", "") + "_left.png");
        this.right = new ResourceLocation(this.texture_base.toString().replace(".png", "") + "_right.png");
    }

    public LayerBlinking(RenderLiving render, ResourceLocation blinkingTexture, int col) {
        this(render, blinkingTexture, col, col);
    }

    public LayerBlinking(RenderLiving render, ResourceLocation blinkingTexture, int col, boolean oneTexture) {
        this.render = render;
        this.texture_base = blinkingTexture;
        this.colLeft = col;
        this.colRight = col;
        this.left = this.texture_base;
        this.right = this.texture_base;
    }

    public void setColors(int left, int right) {
        this.colLeft = left;
        this.colRight = right;
    }

    public void func_177141_a(EntityLivingBase entity, float limbSwing, float limbSwingAmount, float partialTicks, float ageInTicks, float netHeadYaw, float headPitch, float scale) {
        IBlinking iblinking;
        boolean drawBlink = false;
        if (entity instanceof IBlinking && (iblinking = (IBlinking)entity).getBlinkTimer() < 7 && iblinking.getBlinkTimer() >= 0) {
            drawBlink = true;
        }
        if (entity instanceof ISleeping) {
            long currentTime = entity.field_70170_p.func_72820_D() % 23999L;
            ISleeping isleeping = (ISleeping)entity;
            boolean isSleeping = isleeping.getSleeping();
            float sleepTimer = isleeping.getSleepTimer().floatValue();
            if (sleepTimer == -100.0f || (double)sleepTimer == 0.0 ? isSleeping && currentTime < 23250L : isSleeping && sleepTimer <= -0.55f && currentTime < 23250L) {
                drawBlink = true;
            }
        }
        if (drawBlink) {
            float[] rgb = new float[3];
            Color c = new Color(this.colLeft);
            rgb = c.getRGBColorComponents(rgb);
            AddonInjectionHandler.runInjection("farm", "blink1", Void.class, this.render, entity);
            this.render.func_110776_a(this.left);
            GlStateManager.func_179091_B();
            GlStateManager.func_179089_o();
            GlStateManager.func_179131_c((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)1.0f);
            if (this.render.func_177087_b() instanceof IColoredModel) {
                ((IColoredModel)this.render.func_177087_b()).setColor(-1.0f, -1.0f, -1.0f);
            }
            this.render.func_177087_b().func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179121_F();
            GlStateManager.func_179094_E();
            AddonInjectionHandler.runInjection("farm", "blink2", Void.class, this.render, entity);
            c = new Color(this.colRight);
            rgb = c.getRGBColorComponents(new float[3]);
            this.render.func_110776_a(this.right);
            GlStateManager.func_179131_c((float)rgb[0], (float)rgb[1], (float)rgb[2], (float)1.0f);
            if (this.render.func_177087_b() instanceof IColoredModel) {
                ((IColoredModel)this.render.func_177087_b()).setColor(-1.0f, -1.0f, -1.0f);
            }
            this.render.func_177087_b().func_78088_a((Entity)entity, limbSwing, limbSwingAmount, ageInTicks, netHeadYaw, headPitch, scale);
            GlStateManager.func_179124_c((float)1.0f, (float)1.0f, (float)1.0f);
            GlStateManager.func_179129_p();
            GlStateManager.func_179121_F();
        }
    }

    public boolean func_177142_b() {
        return false;
    }
}

