/*
 * Decompiled with CFR 0.152.
 */
package com.animania.common.helper;

import com.animania.Animania;
import com.animania.api.data.AnimalContainer;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.AnimaniaType;
import com.animania.common.entities.RandomAnimalType;
import com.animania.common.handler.AnimalTypeHandler;
import com.animania.common.handler.EntityEggHandler;
import com.animania.common.handler.ItemHandler;
import com.animania.common.items.ItemEntityEgg;
import com.animania.common.items.ItemEntityEggAnimated;
import com.animania.config.AnimaniaConfig;
import net.minecraft.client.renderer.block.model.ModelResourceLocation;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.EnumCreatureType;
import net.minecraft.util.ResourceLocation;
import net.minecraft.world.biome.Biome;
import net.minecraftforge.client.model.ModelLoader;
import net.minecraftforge.common.BiomeDictionary;
import net.minecraftforge.fml.common.registry.EntityEntry;
import net.minecraftforge.fml.common.registry.EntityRegistry;
import net.minecraftforge.fml.common.registry.ForgeRegistries;

public class RegistryHelper {

    public static class Entities {
        public static void registerAnimal(Class<? extends Entity> entityClass, String entityName, int entityID, AnimaniaType type, EntityGender gender, boolean registerEgg, boolean fancyEgg) {
            ResourceLocation registryName = new ResourceLocation("animania", entityName);
            EntityEntry entry = (EntityEntry)new EntityEntry(entityClass, entityName).setRegistryName(registryName);
            EntityRegistry.registerModEntity((ResourceLocation)registryName, entityClass, (String)registryName.toString(), (int)entityID, (Object)Animania.instance, (int)64, (int)2, (boolean)true);
            EntityEggHandler.ENTITY_MAP.put(new AnimalContainer(type, gender), entry);
            if (registerEgg) {
                if (fancyEgg) {
                    ItemHandler.entityEggList.add(new ItemEntityEggAnimated(entityName, type, gender));
                } else {
                    ItemHandler.entityEggList.add(new ItemEntityEgg(entityName, type, gender));
                }
            }
            RandomAnimalType.addType(type.getClass());
            AnimalTypeHandler.register(type.getTypeName(), type.getClass());
        }

        public static void registerAnimal(Class<? extends Entity> entityClass, String entityName, int entityID, AnimaniaType type, EntityGender gender, boolean registerEgg) {
            Entities.registerAnimal(entityClass, entityName, entityID, type, gender, registerEgg, false);
        }

        public static void registerAnimal(Class<? extends Entity> entityClass, String entityName, int entityID, AnimaniaType type, EntityGender gender) {
            Entities.registerAnimal(entityClass, entityName, entityID, type, gender, true, AnimaniaConfig.gameRules.fancyEggs);
        }

        public static void registerEntity(Class<? extends Entity> entityClass, String entityName, int entityID, int trackingRange, int updateFrequency, boolean sendsVelocityUpdates) {
            ResourceLocation registryName = new ResourceLocation("animania", entityName);
            EntityRegistry.registerModEntity((ResourceLocation)registryName, entityClass, (String)registryName.toString(), (int)entityID, (Object)Animania.instance, (int)trackingRange, (int)updateFrequency, (boolean)sendsVelocityUpdates);
        }

        public static void addSpawn(Class<? extends EntityLiving> entityClass, int weightedProb, int min, int max, EnumCreatureType typeOfCreature, Biome ... biomes) {
            if (max <= 0 || weightedProb <= 0) {
                return;
            }
            EntityRegistry.addSpawn(entityClass, (int)weightedProb, (int)Math.min(min, max), (int)Math.max(min, max), (EnumCreatureType)typeOfCreature, (Biome[])biomes);
        }

        public static void copySpawns(Class<? extends EntityLiving> classToAdd, EnumCreatureType creatureTypeToAdd, Class<? extends EntityLiving> classToCopy, EnumCreatureType creatureTypeToCopy) {
            for (Biome biome : ForgeRegistries.BIOMES) {
                biome.func_76747_a(creatureTypeToCopy).stream().filter(entry -> entry.field_76300_b == classToCopy).findFirst().ifPresent(spawnListEntry -> biome.func_76747_a(creatureTypeToAdd).add(new Biome.SpawnListEntry(classToAdd, spawnListEntry.field_76292_a, spawnListEntry.field_76301_c, spawnListEntry.field_76299_d)));
            }
        }

        public static Biome[] getBiomes(BiomeDictionary.Type type) {
            return (Biome[])BiomeDictionary.getBiomes((BiomeDictionary.Type)type).stream().toArray(Biome[]::new);
        }
    }

    public static class Item {
        public static void register(net.minecraft.item.Item item) {
            ModelLoader.setCustomModelResourceLocation((net.minecraft.item.Item)item, (int)0, (ModelResourceLocation)new ModelResourceLocation("animania:" + item.func_77658_a(), "inventory"));
        }
    }
}

