/*
 * Decompiled with CFR 0.152.
 */
package com.animania.addons.farm.common.entity.sheep;

import com.animania.addons.farm.common.entity.sheep.EntityLambBase;
import com.animania.addons.farm.common.entity.sheep.SheepDorset;
import com.animania.addons.farm.common.entity.sheep.SheepFriesian;
import com.animania.addons.farm.common.entity.sheep.SheepMerino;
import com.animania.addons.farm.common.entity.sheep.SheepSuffolk;
import com.animania.addons.farm.common.entity.sheep.SheepType;
import com.animania.addons.farm.config.FarmConfig;
import com.animania.api.data.AnimalContainer;
import com.animania.api.data.EntityGender;
import com.animania.api.interfaces.AnimaniaType;
import com.animania.api.interfaces.IAnimaniaAnimalBase;
import com.animania.api.interfaces.IConvertable;
import com.animania.common.entities.generic.GenericBehavior;
import com.animania.common.entities.generic.ai.GenericAIAvoidEntity;
import com.animania.common.entities.generic.ai.GenericAIEatGrass;
import com.animania.common.entities.generic.ai.GenericAIFindFood;
import com.animania.common.entities.generic.ai.GenericAIFindSaltLick;
import com.animania.common.entities.generic.ai.GenericAIFindWater;
import com.animania.common.entities.generic.ai.GenericAILookIdle;
import com.animania.common.entities.generic.ai.GenericAIPanic;
import com.animania.common.entities.generic.ai.GenericAISleep;
import com.animania.common.entities.generic.ai.GenericAITempt;
import com.animania.common.entities.generic.ai.GenericAIWanderAvoidWater;
import com.animania.common.entities.generic.ai.GenericAIWatchClosest;
import com.animania.common.helper.AnimaniaHelper;
import com.animania.common.items.ItemEntityEgg;
import com.animania.config.AnimaniaConfig;
import com.google.common.base.Optional;
import com.google.common.collect.Sets;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.UUID;
import javax.annotation.Nullable;
import net.minecraft.block.Block;
import net.minecraft.entity.Entity;
import net.minecraft.entity.EntityAgeable;
import net.minecraft.entity.EntityCreature;
import net.minecraft.entity.EntityLiving;
import net.minecraft.entity.ai.EntityAIBase;
import net.minecraft.entity.ai.EntityAIHurtByTarget;
import net.minecraft.entity.ai.EntityAISwimming;
import net.minecraft.entity.ai.EntityAITasks;
import net.minecraft.entity.passive.EntityAnimal;
import net.minecraft.entity.passive.EntitySheep;
import net.minecraft.entity.passive.EntityWolf;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.init.Blocks;
import net.minecraft.init.Items;
import net.minecraft.init.SoundEvents;
import net.minecraft.item.EnumDyeColor;
import net.minecraft.item.Item;
import net.minecraft.item.ItemDye;
import net.minecraft.item.ItemShears;
import net.minecraft.item.ItemStack;
import net.minecraft.nbt.NBTTagCompound;
import net.minecraft.network.datasync.DataParameter;
import net.minecraft.network.datasync.DataSerializer;
import net.minecraft.network.datasync.DataSerializers;
import net.minecraft.network.datasync.EntityDataManager;
import net.minecraft.util.EnumHand;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.world.IBlockAccess;
import net.minecraft.world.World;
import net.minecraftforge.common.IShearable;
import net.minecraftforge.fml.common.Loader;
import net.minecraftforge.fml.relauncher.Side;
import net.minecraftforge.fml.relauncher.SideOnly;

public class EntityAnimaniaSheep
extends EntitySheep
implements IShearable,
IAnimaniaAnimalBase,
IConvertable {
    public static final Set<ItemStack> TEMPTATION_ITEMS = Sets.newHashSet((Object[])AnimaniaHelper.getItemStackArray((String[])FarmConfig.settings.sheepFood));
    protected static final DataParameter<Boolean> WATERED = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> FED = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Optional<UUID>> RIVAL_UNIQUE_ID = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187203_m);
    protected static final DataParameter<Boolean> SHEARED = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Integer> SHEARED_TIMER = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187192_b);
    private static final DataParameter<Integer> COLOR_NUM = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Integer> AGE = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> HANDFED = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Boolean> SLEEPING = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    protected static final DataParameter<Float> SLEEPTIMER = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187193_c);
    protected static final DataParameter<Integer> DYE_COLOR = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187192_b);
    protected static final DataParameter<Boolean> INTERACTED = EntityDataManager.func_187226_a(EntityAnimaniaSheep.class, (DataSerializer)DataSerializers.field_187198_h);
    private static final String[] SHEEP_TEXTURES = new String[]{"black", "white", "brown"};
    protected int happyTimer;
    public int blinkTimer;
    public int eatTimer;
    protected int fedTimer;
    protected int wateredTimer;
    protected int damageTimer;
    public SheepType sheepType;
    public GenericAIEatGrass<EntityAnimaniaSheep> field_146087_bs;
    protected boolean mateable = false;
    protected boolean headbutting = false;
    protected EntityGender gender;
    protected EnumDyeColor color;
    protected boolean hasRemovedBOP = false;

    public EntityAnimaniaSheep(World worldIn) {
        super(worldIn);
        this.field_70714_bg.field_75782_a.clear();
        this.field_146087_bs = new GenericAIEatGrass((EntityCreature)this);
        if (!AnimaniaConfig.gameRules.ambianceMode) {
            this.field_70714_bg.func_75776_a(2, (EntityAIBase)new GenericAIFindWater((EntityCreature)this, 1.0, this.field_146087_bs, EntityAnimaniaSheep.class));
            this.field_70714_bg.func_75776_a(3, (EntityAIBase)new GenericAIFindFood((EntityCreature)this, 1.0, this.field_146087_bs, true));
        }
        this.field_70714_bg.func_75776_a(4, (EntityAIBase)new GenericAIWanderAvoidWater((EntityCreature)this, 1.0));
        this.field_70714_bg.func_75776_a(5, (EntityAIBase)new EntityAISwimming((EntityLiving)this));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new GenericAIPanic((EntityCreature)this, 2.2));
        this.field_70714_bg.func_75776_a(7, (EntityAIBase)new GenericAITempt((EntityCreature)this, 1.25, false, TEMPTATION_ITEMS));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new GenericAITempt((EntityCreature)this, 1.25, new ItemStack((Block)Blocks.field_150327_N), false));
        this.field_70714_bg.func_75776_a(6, (EntityAIBase)new GenericAITempt((EntityCreature)this, 1.25, new ItemStack((Block)Blocks.field_150328_O), false));
        this.field_70714_bg.func_75776_a(8, this.field_146087_bs);
        this.field_70714_bg.func_75776_a(9, (EntityAIBase)new GenericAIAvoidEntity((EntityCreature)this, EntityWolf.class, 24.0f, 2.0, 2.2));
        this.field_70714_bg.func_75776_a(10, (EntityAIBase)new GenericAIWatchClosest((EntityLiving)this, EntityPlayer.class, 6.0f));
        this.field_70714_bg.func_75776_a(11, (EntityAIBase)new GenericAILookIdle((EntityLiving)this));
        this.field_70714_bg.func_75776_a(12, (EntityAIBase)new GenericAIFindSaltLick((EntityCreature)this, 1.0, this.field_146087_bs));
        if (AnimaniaConfig.gameRules.animalsSleep) {
            this.field_70714_bg.func_75776_a(11, (EntityAIBase)new GenericAISleep((EntityCreature)this, 0.8, AnimaniaHelper.getBlock((String)FarmConfig.settings.sheepBed), AnimaniaHelper.getBlock((String)FarmConfig.settings.sheepBed2), EntityAnimaniaSheep.class));
        }
        this.field_70715_bh.func_75776_a(0, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, false, new Class[0]));
        this.field_70715_bh.func_75776_a(1, (EntityAIBase)new EntityAIHurtByTarget((EntityCreature)this, true, new Class[]{EntityPlayer.class}));
        this.fedTimer = AnimaniaConfig.careAndFeeding.feedTimer + this.field_70146_Z.nextInt(100);
        this.wateredTimer = AnimaniaConfig.careAndFeeding.waterTimer + this.field_70146_Z.nextInt(100);
        this.happyTimer = 60;
        this.blinkTimer = 100 + this.field_70146_Z.nextInt(100);
        this.func_110163_bv();
    }

    protected void func_184651_r() {
    }

    protected boolean func_70692_ba() {
        return false;
    }

    public void func_70107_b(double x, double y, double z) {
        super.func_70107_b(x, y, z);
    }

    protected void func_70088_a() {
        super.func_70088_a();
        this.field_70180_af.func_187214_a(FED, (Object)true);
        this.field_70180_af.func_187214_a(HANDFED, (Object)false);
        this.field_70180_af.func_187214_a(WATERED, (Object)true);
        this.field_70180_af.func_187214_a(RIVAL_UNIQUE_ID, (Object)Optional.absent());
        this.field_70180_af.func_187214_a(SHEARED, (Object)false);
        this.field_70180_af.func_187214_a(SHEARED_TIMER, (Object)(AnimaniaConfig.careAndFeeding.woolRegrowthTimer + this.field_70146_Z.nextInt(500)));
        this.field_70180_af.func_187214_a(SLEEPING, (Object)false);
        this.field_70180_af.func_187214_a(SLEEPTIMER, (Object)Float.valueOf(0.0f));
        this.field_70180_af.func_187214_a(DYE_COLOR, (Object)EnumDyeColor.WHITE.func_176765_a());
        this.field_70180_af.func_187214_a(INTERACTED, (Object)false);
        if (this instanceof SheepFriesian.EntityRamFriesian || this instanceof SheepFriesian.EntityEweFriesian || this instanceof SheepFriesian.EntityLambFriesian) {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.field_70146_Z.nextInt(3));
        } else if (this instanceof SheepDorset.EntityRamDorset || this instanceof SheepDorset.EntityEweDorset || this instanceof SheepDorset.EntityLambDorset) {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.field_70146_Z.nextInt(2));
        } else if (this instanceof SheepMerino.EntityRamMerino || this instanceof SheepMerino.EntityEweMerino || this instanceof SheepMerino.EntityLambMerino) {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.field_70146_Z.nextInt(2));
        } else if (this instanceof SheepSuffolk.EntityRamSuffolk || this instanceof SheepSuffolk.EntityEweSuffolk || this instanceof SheepSuffolk.EntityLambSuffolk) {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)this.field_70146_Z.nextInt(2));
        } else {
            this.field_70180_af.func_187214_a(COLOR_NUM, (Object)0);
        }
        this.field_70180_af.func_187214_a(AGE, (Object)0);
    }

    public EntityAnimaniaSheep createChild(EntityAgeable ageable) {
        return null;
    }

    protected ResourceLocation func_184647_J() {
        return this instanceof EntityLambBase ? null : (this.sheepType.isPrime ? new ResourceLocation("farm/animania", "sheep_prime") : new ResourceLocation("farm/animania", "sheep_regular"));
    }

    public boolean func_70892_o() {
        return this.getBoolFromDataManager(SHEARED);
    }

    public void func_70893_e(boolean sheared) {
        if (sheared) {
            this.field_70180_af.func_187227_b(SHEARED, (Object)true);
            this.setWoolRegrowthTimer(AnimaniaConfig.careAndFeeding.woolRegrowthTimer + this.field_70146_Z.nextInt(500));
        } else {
            this.field_70180_af.func_187227_b(SHEARED, (Object)false);
        }
    }

    @Override
    public DataParameter<Boolean> getSleepingParam() {
        return SLEEPING;
    }

    @Override
    public DataParameter<Float> getSleepTimerParam() {
        return SLEEPTIMER;
    }

    @Override
    public DataParameter<Boolean> getFedParam() {
        return FED;
    }

    @Override
    public DataParameter<Boolean> getHandFedParam() {
        return HANDFED;
    }

    @Override
    public DataParameter<Boolean> getWateredParam() {
        return WATERED;
    }

    public int getWoolRegrowthTimer() {
        return this.getIntFromDataManager(SHEARED_TIMER);
    }

    public void setWoolRegrowthTimer(int time) {
        this.field_70180_af.func_187227_b(SHEARED_TIMER, (Object)time);
    }

    public int getDyeColorNum() {
        return this.getIntFromDataManager(DYE_COLOR);
    }

    public void setDyeColorNum(int col) {
        this.field_70180_af.func_187227_b(DYE_COLOR, (Object)new Integer(col));
    }

    protected void func_70619_bc() {
        this.eatTimer = this.field_146087_bs.getEatingGrassTimer();
    }

    protected float func_70599_aP() {
        return 0.4f;
    }

    protected Item func_146068_u() {
        return Items.field_151116_aA;
    }

    public void func_70615_aA() {
    }

    public boolean isDyeable() {
        return false;
    }

    public EnumDyeColor getDyeColor() {
        if (this.color == null) {
            this.color = EnumDyeColor.func_176764_b((int)this.getDyeColorNum());
        }
        return this.color;
    }

    public void func_70636_d() {
        if (!this.hasRemovedBOP && Loader.isModLoaded((String)"biomesoplenty")) {
            Iterator it = this.field_70714_bg.field_75782_a.iterator();
            while (it.hasNext()) {
                EntityAITasks.EntityAITaskEntry entry = (EntityAITasks.EntityAITaskEntry)it.next();
                EntityAIBase ai = entry.field_75733_a;
                try {
                    if (!Class.forName("biomesoplenty.common.entities.ai.EntityAIEatBOPGrass").isInstance(ai)) continue;
                    entry.field_188524_c = false;
                    ai.func_75251_c();
                    it.remove();
                }
                catch (Exception exception) {}
            }
            this.hasRemovedBOP = true;
        }
        GenericBehavior.livingUpdateCommon((EntityAnimal)this);
        boolean sheared = this.func_70892_o();
        if (sheared) {
            int shearedTimer = this.getWoolRegrowthTimer();
            this.setWoolRegrowthTimer(--shearedTimer);
            if (shearedTimer < 0) {
                this.func_70893_e(false);
            }
        }
        super.func_70636_d();
    }

    public boolean func_184645_a(EntityPlayer player, EnumHand hand) {
        ItemStack stack = player.func_184586_b(hand);
        EntityPlayer entityplayer = player;
        if (stack.func_77973_b() instanceof ItemShears && !this.func_70892_o() && !this.func_70631_g_()) {
            if (!this.field_70170_p.field_72995_K) {
                this.func_184185_a(SoundEvents.field_187763_eJ, 1.0f, 1.0f);
            }
            player.func_184609_a(hand);
            if (this.getSleeping()) {
                this.setSleeping(false);
            }
        }
        if (stack.func_77973_b() instanceof ItemDye && !this.func_70631_g_() && !this.func_70892_o()) {
            if (this.isDyeable()) {
                EnumDyeColor col = EnumDyeColor.func_176766_a((int)stack.func_77952_i());
                if (this.getDyeColor() != col) {
                    if (!player.func_184812_l_()) {
                        stack.func_190918_g(1);
                    }
                    this.color = col;
                    this.setDyeColorNum(col.func_176765_a());
                    return true;
                }
                return true;
            }
            return false;
        }
        return GenericBehavior.interactCommon((EntityAnimal)this, (EntityPlayer)player, (EnumHand)hand, this.field_146087_bs) ? true : super.func_184645_a(player, hand);
    }

    @SideOnly(value=Side.CLIENT)
    public void func_70103_a(byte id) {
        if (id == 10) {
            this.eatTimer = 80;
        } else {
            super.func_70103_a(id);
        }
    }

    public void func_146082_f(EntityPlayer player) {
        if (!this.getSleeping()) {
            this.field_70170_p.func_72960_a((Entity)this, (byte)18);
        }
    }

    public boolean func_70877_b(@Nullable ItemStack stack) {
        return this.mateable && stack != ItemStack.field_190927_a && this.isSheepBreedingItem(stack);
    }

    private boolean isSheepBreedingItem(ItemStack itemIn) {
        return AnimaniaHelper.containsItemStack(TEMPTATION_ITEMS, (ItemStack)itemIn) || itemIn.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150327_N) || itemIn.func_77973_b() == Item.func_150898_a((Block)Blocks.field_150328_O);
    }

    public void func_70014_b(NBTTagCompound compound) {
        super.func_70014_b(compound);
        compound.func_74757_a("Sheared", this.func_70892_o());
        compound.func_74768_a("ColorNumber", this.getColorNumber());
        compound.func_74768_a("DyeColor", this.getDyeColorNum());
        GenericBehavior.writeCommonNBT((NBTTagCompound)compound, (EntityAnimal)this);
    }

    public void func_70037_a(NBTTagCompound compound) {
        super.func_70037_a(compound);
        this.setColorNumber(compound.func_74762_e("ColorNumber"));
        this.func_70893_e(compound.func_74767_n("Sheared"));
        this.setDyeColorNum(compound.func_74762_e("DyeColor"));
        GenericBehavior.readCommonNBT((NBTTagCompound)compound, (EntityAnimal)this);
    }

    @Override
    public DataParameter<Integer> getAgeParam() {
        return AGE;
    }

    public int getColorNumber() {
        return this.getIntFromDataManager(COLOR_NUM);
    }

    public void setColorNumber(int color) {
        this.field_70180_af.func_187227_b(COLOR_NUM, (Object)color);
    }

    @Override
    public Item getSpawnEgg() {
        return (Item)ItemEntityEgg.ANIMAL_EGGS.get(new AnimalContainer(this.sheepType, this.gender));
    }

    public ItemStack getPickedResult(RayTraceResult target) {
        return new ItemStack(this.getSpawnEgg());
    }

    @Override
    public int getPrimaryEggColor() {
        return 0;
    }

    @Override
    public int getSecondaryEggColor() {
        return 0;
    }

    public boolean isShearable(ItemStack item, IBlockAccess world, BlockPos pos) {
        return !this.func_70892_o() && !this.func_70631_g_();
    }

    public List<ItemStack> onSheared(ItemStack item, IBlockAccess world, BlockPos pos, int fortune) {
        return null;
    }

    @Override
    public EntityGender getEntityGender() {
        return this.gender;
    }

    @Override
    public Set<ItemStack> getFoodItems() {
        return TEMPTATION_ITEMS;
    }

    @Override
    public void setSleepingPos(BlockPos pos) {
    }

    @Override
    public BlockPos getSleepingPos() {
        return null;
    }

    @Override
    public int getBlinkTimer() {
        return this.blinkTimer;
    }

    @Override
    public void setBlinkTimer(int i) {
        this.blinkTimer = i;
    }

    @Override
    public int getEatTimer() {
        return this.eatTimer;
    }

    @Override
    public void setEatTimer(int i) {
        this.eatTimer = i;
    }

    @Override
    public int getFedTimer() {
        return this.fedTimer;
    }

    @Override
    public void setFedTimer(int i) {
        this.fedTimer = i;
    }

    @Override
    public DataParameter<Boolean> getInteractedParam() {
        return INTERACTED;
    }

    @Override
    public int getWaterTimer() {
        return this.wateredTimer;
    }

    @Override
    public void setWaterTimer(int i) {
        this.wateredTimer = i;
    }

    @Override
    public int getDamageTimer() {
        return this.damageTimer;
    }

    @Override
    public void setDamageTimer(int i) {
        this.damageTimer = i;
    }

    @Override
    public int getHappyTimer() {
        return this.happyTimer;
    }

    @Override
    public void setHappyTimer(int i) {
        this.happyTimer = i;
    }

    @Override
    public AnimaniaType getAnimalType() {
        return this.sheepType;
    }

    @Override
    public Entity convertToVanilla() {
        EntitySheep entity = new EntitySheep(this.field_70170_p);
        entity.func_70107_b(this.field_70165_t, this.field_70163_u, this.field_70161_v);
        if (entity.func_145818_k_()) {
            entity.func_96094_a(this.func_95999_t());
        }
        return entity;
    }
}

