/*
 * Decompiled with CFR 0.152.
 */
package com.pugz.bambooblocks.common.block;

import com.pugz.bambooblocks.core.BambooBlocksRegistry;
import com.teamabnormals.abnormals_core.core.utils.ItemStackUtils;
import java.util.Random;
import javax.annotation.Nullable;
import net.minecraft.block.BambooBlock;
import net.minecraft.block.BambooSaplingBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.LeavesBlock;
import net.minecraft.block.TorchBlock;
import net.minecraft.item.BlockItemUseContext;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.particles.IParticleData;
import net.minecraft.particles.ParticleTypes;
import net.minecraft.state.IProperty;
import net.minecraft.state.IntegerProperty;
import net.minecraft.state.StateContainer;
import net.minecraft.state.properties.BambooLeaves;
import net.minecraft.util.Direction;
import net.minecraft.util.IItemProvider;
import net.minecraft.util.NonNullList;
import net.minecraft.util.math.BlockPos;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.math.shapes.ISelectionContext;
import net.minecraft.util.math.shapes.VoxelShape;
import net.minecraft.util.math.shapes.VoxelShapes;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.IWorldReader;
import net.minecraft.world.World;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class BambooTorchBlock
extends TorchBlock {
    protected static final VoxelShape TORCH = Block.func_208617_a((double)5.5, (double)0.0, (double)5.5, (double)10.5, (double)14.0, (double)10.5);
    protected static final VoxelShape TORCH_LARGE = Block.func_208617_a((double)4.0, (double)0.0, (double)4.0, (double)12.0, (double)14.0, (double)12.0);
    protected static final IntegerProperty SIZE = IntegerProperty.func_177719_a((String)"size", (int)0, (int)2);

    public BambooTorchBlock() {
        super(BambooBlocksRegistry.Properties.BAMBOO_TORCH);
        this.func_180632_j((BlockState)((BlockState)this.field_176227_L.func_177621_b()).func_206870_a((IProperty)SIZE, (Comparable)Integer.valueOf(0)));
    }

    public void func_149666_a(ItemGroup group, NonNullList<ItemStack> items) {
        if (ItemStackUtils.isInGroup((Item)this.func_199767_j(), (ItemGroup)group)) {
            int targetIndex = ItemStackUtils.findIndexOfItem((Item)Items.field_221657_bQ, items);
            if (targetIndex != -1) {
                items.add(targetIndex + 1, (Object)new ItemStack((IItemProvider)this));
            } else {
                super.func_149666_a(group, items);
            }
        }
    }

    protected void func_206840_a(StateContainer.Builder<Block, BlockState> builder) {
        builder.func_206894_a(new IProperty[]{SIZE});
    }

    public boolean func_196260_a(BlockState state, IWorldReader worldIn, BlockPos pos) {
        BlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        return BambooTorchBlock.func_220055_a((IWorldReader)worldIn, (BlockPos)pos.func_177977_b(), (Direction)Direction.UP) || downState.func_177230_c() instanceof LeavesBlock || downState.func_177230_c() instanceof BambooBlock;
    }

    public Vec3d func_190949_e(BlockState state, IBlockReader world, BlockPos pos) {
        BlockState downState = world.func_180495_p(pos.func_177977_b());
        Block.OffsetType block$offsettype = this.func_176218_Q();
        if (downState.func_177230_c() instanceof BambooBlock) {
            long i = MathHelper.func_180187_c((int)pos.func_177958_n(), (int)0, (int)pos.func_177952_p());
            return new Vec3d(((double)((float)(i & 0xFL) / 15.0f) - 0.5) * 0.5, block$offsettype == Block.OffsetType.XYZ ? ((double)((float)(i >> 4 & 0xFL) / 15.0f) - 1.0) * 0.2 : 0.0, ((double)((float)(i >> 8 & 0xFL) / 15.0f) - 0.5) * 0.5);
        }
        return Vec3d.field_186680_a;
    }

    public Block.OffsetType func_176218_Q() {
        return Block.OffsetType.XZ;
    }

    public VoxelShape func_220053_a(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        BlockState downState = worldIn.func_180495_p(pos.func_177977_b());
        if (downState.func_177230_c() instanceof BambooBlock) {
            Vec3d vec3d = downState.func_191059_e(worldIn, pos);
            return (Integer)state.func_177229_b((IProperty)SIZE) < 2 ? TORCH.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c) : TORCH_LARGE.func_197751_a(vec3d.field_72450_a, vec3d.field_72448_b, vec3d.field_72449_c);
        }
        return (Integer)state.func_177229_b((IProperty)SIZE) < 2 ? TORCH : TORCH_LARGE;
    }

    public VoxelShape func_220071_b(BlockState state, IBlockReader worldIn, BlockPos pos, ISelectionContext context) {
        if (worldIn.func_180495_p(pos.func_177977_b()).func_177230_c() instanceof BambooBlock) {
            return (Integer)state.func_177229_b((IProperty)SIZE) < 2 ? TORCH : TORCH_LARGE;
        }
        return VoxelShapes.func_197880_a();
    }

    @Nullable
    public BlockState func_196258_a(BlockItemUseContext context) {
        BlockPos pos;
        World world = context.func_195991_k();
        BlockState downState = world.func_180495_p((pos = context.func_195995_a()).func_177977_b());
        if (downState.func_177230_c() instanceof BambooBlock) {
            return (BlockState)this.func_176223_P().func_206870_a((IProperty)SIZE, (Comparable)Integer.valueOf(this.getSizeByBambooLeavesSize((BambooLeaves)downState.func_177229_b((IProperty)BambooBlock.field_220265_e))));
        }
        if (downState.func_177230_c() instanceof BambooSaplingBlock && context.func_196000_l() == Direction.UP) {
            world.func_180501_a(pos.func_177977_b(), Blocks.field_222405_kQ.func_176223_P(), 3);
            return this.func_176223_P();
        }
        return this.func_176223_P();
    }

    private int getSizeByBambooLeavesSize(BambooLeaves leaves) {
        switch (leaves) {
            case NONE: {
                return 0;
            }
            case SMALL: {
                return 1;
            }
            case LARGE: {
                return 2;
            }
        }
        return 0;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void func_180655_c(BlockState state, World worldIn, BlockPos pos, Random rand) {
        double d0 = (double)pos.func_177958_n() + 0.5;
        double d1 = (double)pos.func_177956_o() + 0.9;
        double d2 = (double)pos.func_177952_p() + 0.5;
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197601_L, d0 + this.func_190949_e((BlockState)state, (IBlockReader)worldIn, (BlockPos)pos).field_72450_a, d1, d2 + this.func_190949_e((BlockState)state, (IBlockReader)worldIn, (BlockPos)pos).field_72449_c, 0.0, 0.0, 0.0);
        worldIn.func_195594_a((IParticleData)ParticleTypes.field_197631_x, d0 + this.func_190949_e((BlockState)state, (IBlockReader)worldIn, (BlockPos)pos).field_72450_a, d1, d2 + this.func_190949_e((BlockState)state, (IBlockReader)worldIn, (BlockPos)pos).field_72449_c, 0.0, 0.0, 0.0);
    }
}

