/*
 * Decompiled with CFR 0.152.
 */
package com.pugz.bambooblocks.core.registry;

import com.pugz.bambooblocks.common.block.BambooTorchBlock;
import com.pugz.bambooblocks.common.block.BambooWallTorchBlock;
import com.pugz.bambooblocks.common.block.DirectionalSlabBlock;
import com.pugz.bambooblocks.core.util.BlockProperties;
import net.minecraft.block.Block;
import net.minecraft.block.Blocks;
import net.minecraft.block.ComposterBlock;
import net.minecraft.block.DoorBlock;
import net.minecraft.block.FenceBlock;
import net.minecraft.block.FenceGateBlock;
import net.minecraft.block.FireBlock;
import net.minecraft.block.RotatedPillarBlock;
import net.minecraft.block.SlabBlock;
import net.minecraft.block.StairsBlock;
import net.minecraft.block.TrapDoorBlock;
import net.minecraft.item.BlockItem;
import net.minecraft.item.Item;
import net.minecraft.item.ItemGroup;
import net.minecraft.item.WallOrFloorItem;
import net.minecraftforge.event.RegistryEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.registries.IForgeRegistryEntry;

@Mod.EventBusSubscriber(modid="bambooblocks", bus=Mod.EventBusSubscriber.Bus.MOD)
public class BlockRegistry {
    public static Block BAMBOO_TORCH = (Block)new BambooTorchBlock().setRegistryName("bamboo_torch");
    public static Block BAMBOO_WALL_TORCH = (Block)new BambooWallTorchBlock().setRegistryName("bamboo_wall_torch");
    public static Block BAMBOO_PLANKS = (Block)new Block(BlockProperties.BAMBOO_PLANKS).setRegistryName("bamboo_planks");
    public static Block BAMBOO_STAIRS = (Block)new StairsBlock(BAMBOO_PLANKS.func_176223_P(), BlockProperties.BAMBOO_PLANKS).setRegistryName("bamboo_stairs");
    public static Block BAMBOO_SLAB = (Block)new SlabBlock(BlockProperties.BAMBOO_PLANKS).setRegistryName("bamboo_slab");
    public static Block BAMBOO_FENCE = (Block)new FenceBlock(BlockProperties.BAMBOO_PLANKS).setRegistryName("bamboo_fence");
    public static Block BAMBOO_FENCE_GATE = (Block)new FenceGateBlock(BlockProperties.BAMBOO_PLANKS).setRegistryName("bamboo_fence_gate");
    public static Block BAMBOO_DOOR = (Block)new DoorBlock(BlockProperties.BAMBOO_DOORS).setRegistryName("bamboo_door");
    public static Block BAMBOO_TRAPDOOR = (Block)new TrapDoorBlock(BlockProperties.BAMBOO_DOORS).setRegistryName("bamboo_trapdoor");
    public static Block THATCH = (Block)new RotatedPillarBlock(BlockProperties.THATCH).setRegistryName("thatch");
    public static Block THATCH_STAIRS = (Block)new StairsBlock(THATCH.func_176223_P(), BlockProperties.THATCH).setRegistryName("thatch_stairs");
    public static Block THATCH_SLAB = (Block)new DirectionalSlabBlock(BlockProperties.THATCH).setRegistryName("thatch_slab");

    @SubscribeEvent
    public static void registerBlocks(RegistryEvent.Register<Block> event) {
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Block[]{BAMBOO_TORCH, BAMBOO_WALL_TORCH, BAMBOO_PLANKS, BAMBOO_STAIRS, BAMBOO_SLAB, BAMBOO_FENCE, BAMBOO_FENCE_GATE, BAMBOO_DOOR, BAMBOO_TRAPDOOR, THATCH, THATCH_STAIRS, THATCH_SLAB});
    }

    @SubscribeEvent
    public static void registerItems(RegistryEvent.Register<Item> event) {
        Item.Properties buildingBlocks = new Item.Properties().func_200916_a(ItemGroup.field_78030_b);
        Item.Properties decorations = new Item.Properties().func_200916_a(ItemGroup.field_78031_c);
        Item.Properties redstone = new Item.Properties().func_200916_a(ItemGroup.field_78028_d);
        event.getRegistry().registerAll((IForgeRegistryEntry[])new Item[]{(Item)new WallOrFloorItem(BAMBOO_TORCH, BAMBOO_WALL_TORCH, decorations).setRegistryName(BAMBOO_TORCH.getRegistryName()), (Item)new BlockItem(BAMBOO_PLANKS, buildingBlocks).setRegistryName(BAMBOO_PLANKS.getRegistryName()), (Item)new BlockItem(BAMBOO_STAIRS, buildingBlocks).setRegistryName(BAMBOO_STAIRS.getRegistryName()), (Item)new BlockItem(BAMBOO_SLAB, buildingBlocks).setRegistryName(BAMBOO_SLAB.getRegistryName()), (Item)new BlockItem(BAMBOO_FENCE, decorations).setRegistryName(BAMBOO_FENCE.getRegistryName()), (Item)new BlockItem(BAMBOO_FENCE_GATE, redstone).setRegistryName(BAMBOO_FENCE_GATE.getRegistryName()), (Item)new BlockItem(BAMBOO_DOOR, redstone).setRegistryName(BAMBOO_DOOR.getRegistryName()), (Item)new BlockItem(BAMBOO_TRAPDOOR, redstone).setRegistryName(BAMBOO_TRAPDOOR.getRegistryName()), (Item)new BlockItem(THATCH, buildingBlocks).setRegistryName(THATCH.getRegistryName()), (Item)new BlockItem(THATCH_STAIRS, buildingBlocks).setRegistryName(THATCH_STAIRS.getRegistryName()), (Item)new BlockItem(THATCH_SLAB, buildingBlocks).setRegistryName(THATCH_SLAB.getRegistryName())});
    }

    public static void registerFlammables() {
        FireBlock fire = (FireBlock)Blocks.field_150480_ab;
        fire.func_180686_a(BAMBOO_PLANKS, 5, 20);
        fire.func_180686_a(BAMBOO_STAIRS, 5, 20);
        fire.func_180686_a(BAMBOO_SLAB, 5, 20);
        fire.func_180686_a(BAMBOO_FENCE, 5, 20);
        fire.func_180686_a(BAMBOO_FENCE_GATE, 5, 20);
        fire.func_180686_a(THATCH, 10, 32);
        fire.func_180686_a(THATCH_STAIRS, 10, 32);
        fire.func_180686_a(THATCH_SLAB, 10, 32);
    }

    public static void registerCompostables() {
        ComposterBlock.field_220299_b.put((Object)THATCH.func_199767_j(), 0.75f);
        ComposterBlock.field_220299_b.put((Object)THATCH_STAIRS.func_199767_j(), 0.6f);
        ComposterBlock.field_220299_b.put((Object)THATCH_SLAB.func_199767_j(), 0.45f);
    }
}

