/*
 * Decompiled with CFR 0.152.
 */
package pvp.settings;

import cpw.mods.fml.client.registry.KeyBindingRegistry;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import pvp.BetterPvP;
import pvp.ControlsHandler;
import pvp.interfaces.Interface;
import pvp.interfaces.InterfaceHandler;
import pvp.settings.ModOptions;

public class ModSettings {
    public final String[] ENCHANT_COLORS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    public final String[] ENCHANT_COLOR_NAMES = new String[]{"Black", "Dark Blue", "Dark Green", "Dark Aqua", "Dark Red", "Dark Purple", "Gold", "Gray", "Dark Gray", "Blue", "Green", "Aqua", "Red", "Purple", "Yellow", "White"};
    public final String[] DURABILITY = new String[]{"Percent (%)", "Numeral (c/m)", "Both"};
    public final String[] NOTIFICATION = new String[]{"OFF", "White", "Red", "Yellow", "Gold", "Blue", "Green"};
    public final String[] NOTIFICATION_COLORS = new String[]{"r", "f", "c", "e", "6", "9", "2"};
    public final String format = "\u00a7";
    public ats keyBindSprint = new ats("Sprint", 29);
    public ats keyBindEat = new ats("Quick Eat", 33);
    public ats keyBindSneak = new ats("Toggle Sneak", 46);
    public ats keyBindPvP1 = new ats("Quick Use 1 (PvP Key Mode)", 79);
    public ats keyBindPvP2 = new ats("Quick Use 2 (PvP Key Mode)", 80);
    public ats keyBindPvP3 = new ats("Quick Use 3 (PvP Key Mode)", 81);
    public ats keyBindPvP4 = new ats("Quick Use 4 (PvP Key Mode)", 75);
    public ats keyBindPvP5 = new ats("Quick Use 5 (PvP Key Mode)", 76);
    public ats keyBindPvP6 = new ats("Quick Use 6 (PvP Key Mode)", 77);
    public ats keyBindPvP7 = new ats("Quick Use 7 (PvP Key Mode)", 71);
    public ats keyBindPvP8 = new ats("Quick Use 8 (PvP Key Mode)", 72);
    public ats keyBindPvP9 = new ats("Quick Use 9 (PvP Key Mode)", 73);
    public ats keyBindSettings = new ats("Better PvP Settings", 21);
    public boolean betterSprint = true;
    public boolean betterNumbers = true;
    public boolean showEffects = true;
    public boolean showArmor = true;
    public boolean betterEat = true;
    public boolean keepSneak = true;
    public boolean notifications = true;
    public int notifications_hunger = 3;
    public int notifications_hp = 4;
    public int notifications_tnt = 2;
    public boolean showEnchants = true;
    public boolean xp = true;
    public boolean archery = true;
    public int xpSpeed = 1;
    public int enchantColor = 7;
    public int durability = 2;

    public ModSettings() {
        ats[] toLoad = new ats[]{this.keyBindPvP1, this.keyBindPvP2, this.keyBindPvP3, this.keyBindPvP4, this.keyBindPvP5, this.keyBindPvP6, this.keyBindPvP7, this.keyBindPvP8, this.keyBindPvP9, this.keyBindSprint, this.keyBindEat, this.keyBindSneak, this.keyBindSettings};
        boolean[] repeats = new boolean[toLoad.length];
        for (int i = 0; i < repeats.length; ++i) {
            repeats[i] = true;
        }
        BetterPvP.ch = new ControlsHandler(toLoad, repeats);
        KeyBindingRegistry.registerKeyBinding((KeyBindingRegistry.KeyHandler)BetterPvP.ch);
    }

    public void saveSettings() throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(BetterPvP.optionsFile));
        writer.println("betterSprint:" + this.betterSprint);
        writer.println("betterEat:" + this.betterEat);
        writer.println("showArmor:" + this.showArmor);
        writer.println("showEffects:" + this.showEffects);
        writer.println("keepSneak:" + this.keepSneak);
        writer.println("enchantColor:" + this.enchantColor);
        writer.println("durability:" + this.durability);
        writer.println("notifications:" + this.notifications);
        writer.println("notifications_hunger:" + this.notifications_hunger);
        writer.println("notifications_hp:" + this.notifications_hp);
        writer.println("notifications_tnt:" + this.notifications_tnt);
        writer.println("xp:" + this.xp);
        writer.println("xpSpeed:" + this.xpSpeed);
        writer.println("showEnchants:" + this.showEnchants);
        writer.println("betterNumbers:" + this.betterNumbers);
        writer.println("archery:" + this.archery);
        for (Interface l : InterfaceHandler.list) {
            writer.println("interface:" + l.name + ":" + l.x + ":" + l.y + ":" + l.centered);
        }
        writer.close();
    }

    public void loadSettings() throws IOException {
        String s;
        if (!BetterPvP.optionsFile.exists()) {
            this.saveSettings();
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(BetterPvP.optionsFile));
        while ((s = reader.readLine()) != null) {
            String[] args = s.split(":");
            try {
                if (args[0].equalsIgnoreCase("betterSprint")) {
                    this.betterSprint = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("betterEat")) {
                    this.betterEat = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("showArmor")) {
                    this.showArmor = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("showEffects")) {
                    this.showEffects = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("keepSneak")) {
                    this.keepSneak = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("notifications")) {
                    this.notifications = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("xp")) {
                    this.xp = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("xpSpeed")) {
                    this.xpSpeed = Integer.parseInt(args[1]);
                }
                if (args[0].equalsIgnoreCase("showEnchants")) {
                    this.showEnchants = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("betterNumbers")) {
                    this.betterNumbers = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("archery")) {
                    this.archery = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("notifications_hunger")) {
                    this.notifications_hunger = Integer.parseInt(args[1]);
                }
                if (args[0].equalsIgnoreCase("notifications_hp")) {
                    this.notifications_hp = Integer.parseInt(args[1]);
                }
                if (args[0].equalsIgnoreCase("notifications_tnt")) {
                    this.notifications_tnt = Integer.parseInt(args[1]);
                }
                if (args[0].equalsIgnoreCase("enchantColor")) {
                    this.enchantColor = Integer.parseInt(args[1]);
                }
                if (args[0].equalsIgnoreCase("durability")) {
                    this.durability = Integer.parseInt(args[1]);
                }
                if (!args[0].equalsIgnoreCase("interface")) continue;
                for (Interface l : InterfaceHandler.list) {
                    if (!args[1].equals(l.name)) continue;
                    l.bx = l.x = Integer.parseInt(args[2]);
                    l.by = l.y = Integer.parseInt(args[3]);
                    l.centered = args[4].equals("true");
                }
            }
            catch (Exception e) {
                System.out.println("Skipping setting:" + args[0]);
            }
        }
    }

    public String getKeyBinding(ModOptions par1EnumOptions) {
        String s = bkb.a((String)par1EnumOptions.getEnumString()) + ": ";
        s = par1EnumOptions == ModOptions.ENCHANT_COLOR ? s + "\u00a7" + this.ENCHANT_COLORS[this.enchantColor] + this.ENCHANT_COLOR_NAMES[this.enchantColor] : (par1EnumOptions == ModOptions.DURABILITY ? s + this.DURABILITY[this.durability] : (par1EnumOptions == ModOptions.CUSTOMIZATION ? bkb.a((String)par1EnumOptions.getEnumString()) : (par1EnumOptions == ModOptions.EDIT ? bkb.a((String)par1EnumOptions.getEnumString()) : (par1EnumOptions == ModOptions.XP_SPEED ? s + this.xpSpeed : (par1EnumOptions == ModOptions.NOTIFICATIONS_HUNGER ? s + "\u00a7" + this.NOTIFICATION_COLORS[this.notifications_hunger] + this.NOTIFICATION[this.notifications_hunger] : (par1EnumOptions == ModOptions.NOTIFICATIONS_HP ? s + "\u00a7" + this.NOTIFICATION_COLORS[this.notifications_hp] + this.NOTIFICATION[this.notifications_hp] : (par1EnumOptions == ModOptions.NOTIFICATIONS_TNT ? s + "\u00a7" + this.NOTIFICATION_COLORS[this.notifications_tnt] + this.NOTIFICATION[this.notifications_tnt] : s + ModSettings.getTranslation(this.getBooleanValue(par1EnumOptions)))))))));
        return s;
    }

    public boolean getBooleanValue(ModOptions o) {
        if (o == ModOptions.BETTER_SPRINT) {
            return this.betterSprint;
        }
        if (o == ModOptions.BETTER_EAT) {
            return this.betterEat;
        }
        if (o == ModOptions.SHOW_ARMOR) {
            return this.showArmor;
        }
        if (o == ModOptions.SHOW_EFFECTS) {
            return this.showEffects;
        }
        if (o == ModOptions.KEEP_SNEAK) {
            return this.keepSneak;
        }
        if (o == ModOptions.NOTIFICATIONS) {
            return this.notifications;
        }
        if (o == ModOptions.XP) {
            return this.xp;
        }
        if (o == ModOptions.SHOW_ENCHANTS) {
            return this.showEnchants;
        }
        if (o == ModOptions.ARCHERY) {
            return this.archery;
        }
        if (o == ModOptions.NUMBERS) {
            return this.betterNumbers;
        }
        return false;
    }

    private static String getTranslation(boolean o) {
        return o ? "ON" : "OFF";
    }

    public void setOptionValue(ModOptions par1EnumOptions, int par2) throws IOException {
        if (par1EnumOptions == ModOptions.ENCHANT_COLOR) {
            this.enchantColor = (this.enchantColor + 1) % 16;
        }
        if (par1EnumOptions == ModOptions.DURABILITY) {
            this.durability = (this.durability + 1) % 3;
        }
        if (par1EnumOptions == ModOptions.XP_SPEED) {
            this.xpSpeed = (this.xpSpeed + 1) % 6;
        }
        if (par1EnumOptions == ModOptions.NOTIFICATIONS_HUNGER) {
            this.notifications_hunger = (this.notifications_hunger + 1) % 7;
        }
        if (par1EnumOptions == ModOptions.NOTIFICATIONS_HP) {
            this.notifications_hp = (this.notifications_hp + 1) % 7;
        }
        if (par1EnumOptions == ModOptions.NOTIFICATIONS_TNT) {
            this.notifications_tnt = (this.notifications_tnt + 1) % 7;
        }
        if (par1EnumOptions == ModOptions.NUMBERS) {
            boolean bl = this.betterNumbers = !this.betterNumbers;
        }
        if (par1EnumOptions == ModOptions.SHOW_EFFECTS) {
            boolean bl = this.showEffects = !this.showEffects;
        }
        if (par1EnumOptions == ModOptions.BETTER_SPRINT) {
            boolean bl = this.betterSprint = !this.betterSprint;
        }
        if (par1EnumOptions == ModOptions.SHOW_ARMOR) {
            boolean bl = this.showArmor = !this.showArmor;
        }
        if (par1EnumOptions == ModOptions.BETTER_EAT) {
            boolean bl = this.betterEat = !this.betterEat;
        }
        if (par1EnumOptions == ModOptions.KEEP_SNEAK) {
            boolean bl = this.keepSneak = !this.keepSneak;
        }
        if (par1EnumOptions == ModOptions.NOTIFICATIONS) {
            boolean bl = this.notifications = !this.notifications;
        }
        if (par1EnumOptions == ModOptions.ARCHERY) {
            boolean bl = this.archery = !this.archery;
        }
        if (par1EnumOptions == ModOptions.XP) {
            boolean bl = this.xp = !this.xp;
        }
        if (par1EnumOptions == ModOptions.SHOW_ENCHANTS) {
            this.showEnchants = !this.showEnchants;
        }
        this.saveSettings();
    }
}

