/*
 * Decompiled with CFR 0.152.
 */
package com.pvp.settings;

import com.pvp.BetterPvP;
import com.pvp.ControlsHandler;
import com.pvp.interfaces.Interface;
import com.pvp.interfaces.InterfaceHandler;
import com.pvp.settings.ModOptions;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.PrintWriter;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.settings.KeyBinding;

public class ModSettings {
    public static final String[] ENCHANT_COLORS = new String[]{"0", "1", "2", "3", "4", "5", "6", "7", "8", "9", "a", "b", "c", "d", "e", "f"};
    public static final String[] ENCHANT_COLOR_NAMES = new String[]{"Black", "Dark Blue", "Dark Green", "Dark Aqua", "Dark Red", "Dark Purple", "Gold", "Gray", "Dark Gray", "Blue", "Green", "Aqua", "Red", "Purple", "Yellow", "White"};
    public static final String[] DURABILITY = new String[]{"Percent (%)", "Numeral (c/m)", "Both"};
    public static final String[] NOTIFICATION = new String[]{"OFF", "White", "Red", "Yellow", "Gold", "Blue", "Green"};
    public static final String[] NOTIFICATION_COLORS = new String[]{"r", "f", "c", "e", "6", "9", "2"};
    public static final String format = "\u00a7";
    public static KeyBinding keyBindSprint = new KeyBinding("PVP Sprint", 19, "Better PVP Mod");
    public static KeyBinding keyBindEat = new KeyBinding("Quick Eat", 33, "Better PVP Mod");
    public static KeyBinding keyBindToggleSneak = new KeyBinding("Toggle Sneak", 46, "Better PVP Mod");
    public static KeyBinding keyBindPvP1 = new KeyBinding("Quick Use 1", 79, "Better PVP Mod");
    public static KeyBinding keyBindPvP2 = new KeyBinding("Quick Use 2", 80, "Better PVP Mod");
    public static KeyBinding keyBindPvP3 = new KeyBinding("Quick Use 3", 81, "Better PVP Mod");
    public static KeyBinding keyBindPvP4 = new KeyBinding("Quick Use 4", 75, "Better PVP Mod");
    public static KeyBinding keyBindPvP5 = new KeyBinding("Quick Use 5", 76, "Better PVP Mod");
    public static KeyBinding keyBindPvP6 = new KeyBinding("Quick Use 6", 77, "Better PVP Mod");
    public static KeyBinding keyBindPvP7 = new KeyBinding("Quick Use 7", 71, "Better PVP Mod");
    public static KeyBinding keyBindPvP8 = new KeyBinding("Quick Use 8", 72, "Better PVP Mod");
    public static KeyBinding keyBindPvP9 = new KeyBinding("Quick Use 9", 73, "Better PVP Mod");
    public static KeyBinding keyBindSettings = new KeyBinding("Better PVP Settings", 21, "Better PVP Mod");
    public boolean betterSprint = true;
    public boolean betterNumbers = true;
    public boolean showEffects = true;
    public boolean showArmor = true;
    public boolean keepSneak = true;
    public boolean notifications = true;
    public int notifications_hunger = 3;
    public int notifications_hp = 4;
    public int notifications_tnt = 2;
    public int notifications_arrow = 5;
    public boolean showEnchants = true;
    public boolean xp = true;
    public boolean archery = true;
    public int xpSpeed = 0;
    public int enchantColor = 7;
    public int durability = 2;
    public static boolean keysLoaded = false;

    public ModSettings() {
        if (!keysLoaded) {
            BetterPvP.ch = new ControlsHandler();
            keysLoaded = true;
        }
    }

    public void saveSettings() throws IOException {
        PrintWriter writer = new PrintWriter(new FileWriter(BetterPvP.optionsFile));
        writer.println("betterSprint:" + this.betterSprint);
        writer.println("showArmor:" + this.showArmor);
        writer.println("showEffects:" + this.showEffects);
        writer.println("keepSneak:" + this.keepSneak);
        writer.println("enchantColor:" + this.enchantColor);
        writer.println("durability:" + this.durability);
        writer.println("notifications:" + this.notifications);
        writer.println("notifications_hunger:" + this.notifications_hunger);
        writer.println("notifications_hp:" + this.notifications_hp);
        writer.println("notifications_tnt:" + this.notifications_tnt);
        writer.println("notifications_arrow:" + this.notifications_arrow);
        writer.println("xp:" + this.xp);
        writer.println("xpSpeed:" + this.xpSpeed);
        writer.println("showEnchants:" + this.showEnchants);
        writer.println("betterNumbers:" + this.betterNumbers);
        writer.println("archery:" + this.archery);
        for (Interface l : InterfaceHandler.list) {
            writer.println("interface:" + l.name + ":" + l.x + ":" + l.y + ":" + l.centered + ":" + l.flipped + ":" + l.fromRight);
        }
        for (int i = 0; i < ControlsHandler.toAdd.length; ++i) {
            KeyBinding kb = ControlsHandler.toAdd[i];
            writer.println("key_" + kb.func_151464_g() + ":" + kb.func_151463_i());
        }
        writer.close();
    }

    public void loadSettings() throws IOException {
        String s;
        if (!BetterPvP.optionsFile.exists()) {
            this.saveSettings();
            return;
        }
        BufferedReader reader = new BufferedReader(new FileReader(BetterPvP.optionsFile));
        block2: while ((s = reader.readLine()) != null) {
            String[] args = s.split(":");
            try {
                if (args[0].equalsIgnoreCase("betterSprint")) {
                    this.betterSprint = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("showArmor")) {
                    this.showArmor = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("showEffects")) {
                    this.showEffects = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("keepSneak")) {
                    this.keepSneak = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("notifications")) {
                    this.notifications = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("xp")) {
                    this.xp = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("xpSpeed")) {
                    this.xpSpeed = Integer.parseInt(args[1]);
                }
                if (args[0].equalsIgnoreCase("showEnchants")) {
                    this.showEnchants = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("betterNumbers")) {
                    this.betterNumbers = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("archery")) {
                    this.archery = args[1].equals("true");
                }
                if (args[0].equalsIgnoreCase("notifications_hunger")) {
                    this.notifications_hunger = Integer.parseInt(args[1]);
                }
                if (args[0].equalsIgnoreCase("notifications_hp")) {
                    this.notifications_hp = Integer.parseInt(args[1]);
                }
                if (args[0].equalsIgnoreCase("notifications_tnt")) {
                    this.notifications_tnt = Integer.parseInt(args[1]);
                }
                if (args[0].equalsIgnoreCase("notifications_arrow")) {
                    this.notifications_arrow = Integer.parseInt(args[1]);
                }
                if (args[0].equalsIgnoreCase("enchantColor")) {
                    this.enchantColor = Integer.parseInt(args[1]);
                }
                if (args[0].equalsIgnoreCase("durability")) {
                    this.durability = Integer.parseInt(args[1]);
                }
                if (args[0].equalsIgnoreCase("interface")) {
                    for (Interface l : InterfaceHandler.list) {
                        if (!args[1].equals(l.name)) continue;
                        l.bx = l.x = Integer.parseInt(args[2]);
                        l.by = l.y = Integer.parseInt(args[3]);
                        l.bcentered = l.centered = args[4].equals("true");
                        l.bflipped = l.flipped = args[5].equals("true");
                        l.bfromRight = l.fromRight = args[6].equals("true");
                    }
                }
                if (!args[0].startsWith("key_")) continue;
                for (int i = 0; i < ControlsHandler.toAdd.length; ++i) {
                    KeyBinding kb = ControlsHandler.toAdd[i];
                    if (!kb.func_151464_g().equals(args[0].substring(4))) continue;
                    kb.func_151462_b(Integer.parseInt(args[1]));
                    continue block2;
                }
            }
            catch (Exception e) {
                System.out.println("Skipping setting:" + args[0]);
            }
        }
        KeyBinding.func_74508_b();
    }

    public String getKeyBinding(ModOptions par1EnumOptions) {
        String s = I18n.func_135052_a((String)par1EnumOptions.getEnumString(), (Object[])new Object[0]) + ": ";
        s = par1EnumOptions == ModOptions.ENCHANT_COLOR ? s + format + ENCHANT_COLORS[this.enchantColor] + ENCHANT_COLOR_NAMES[this.enchantColor] : (par1EnumOptions == ModOptions.DURABILITY ? s + DURABILITY[this.durability] : (par1EnumOptions == ModOptions.CUSTOMIZATION ? I18n.func_135052_a((String)par1EnumOptions.getEnumString(), (Object[])new Object[0]) : (par1EnumOptions == ModOptions.EDIT ? I18n.func_135052_a((String)par1EnumOptions.getEnumString(), (Object[])new Object[0]) : (par1EnumOptions == ModOptions.RESET ? I18n.func_135052_a((String)par1EnumOptions.getEnumString(), (Object[])new Object[0]) : (par1EnumOptions == ModOptions.XP_SPEED ? s + this.xpSpeed : (par1EnumOptions == ModOptions.NOTIFICATIONS_HUNGER ? s + format + NOTIFICATION_COLORS[this.notifications_hunger] + NOTIFICATION[this.notifications_hunger] : (par1EnumOptions == ModOptions.NOTIFICATIONS_HP ? s + format + NOTIFICATION_COLORS[this.notifications_hp] + NOTIFICATION[this.notifications_hp] : (par1EnumOptions == ModOptions.NOTIFICATIONS_TNT ? s + format + NOTIFICATION_COLORS[this.notifications_tnt] + NOTIFICATION[this.notifications_tnt] : (par1EnumOptions == ModOptions.NOTIFICATIONS_ARROW ? s + format + NOTIFICATION_COLORS[this.notifications_arrow] + NOTIFICATION[this.notifications_arrow] : s + ModSettings.getTranslation(this.getBooleanValue(par1EnumOptions)))))))))));
        return s;
    }

    public boolean getBooleanValue(ModOptions o) {
        if (o == ModOptions.BETTER_SPRINT) {
            return this.betterSprint;
        }
        if (o == ModOptions.SHOW_ARMOR) {
            return this.showArmor;
        }
        if (o == ModOptions.SHOW_EFFECTS) {
            return this.showEffects;
        }
        if (o == ModOptions.KEEP_SNEAK) {
            return this.keepSneak;
        }
        if (o == ModOptions.NOTIFICATIONS) {
            return this.notifications;
        }
        if (o == ModOptions.XP) {
            return this.xp;
        }
        if (o == ModOptions.SHOW_ENCHANTS) {
            return this.showEnchants;
        }
        if (o == ModOptions.ARCHERY) {
            return this.archery;
        }
        if (o == ModOptions.NUMBERS) {
            return this.betterNumbers;
        }
        return false;
    }

    private static String getTranslation(boolean o) {
        return o ? "ON" : "OFF";
    }

    public void setOptionValue(ModOptions par1EnumOptions, int par2) throws IOException {
        if (par1EnumOptions == ModOptions.ENCHANT_COLOR) {
            this.enchantColor = (this.enchantColor + 1) % 16;
        }
        if (par1EnumOptions == ModOptions.DURABILITY) {
            this.durability = (this.durability + 1) % 3;
        }
        if (par1EnumOptions == ModOptions.XP_SPEED) {
            this.xpSpeed = (this.xpSpeed + 1) % 6;
        }
        if (par1EnumOptions == ModOptions.NOTIFICATIONS_HUNGER) {
            this.notifications_hunger = (this.notifications_hunger + 1) % 7;
        }
        if (par1EnumOptions == ModOptions.NOTIFICATIONS_HP) {
            this.notifications_hp = (this.notifications_hp + 1) % 7;
        }
        if (par1EnumOptions == ModOptions.NOTIFICATIONS_TNT) {
            this.notifications_tnt = (this.notifications_tnt + 1) % 7;
        }
        if (par1EnumOptions == ModOptions.NOTIFICATIONS_ARROW) {
            this.notifications_arrow = (this.notifications_arrow + 1) % 7;
        }
        if (par1EnumOptions == ModOptions.NUMBERS) {
            boolean bl = this.betterNumbers = !this.betterNumbers;
        }
        if (par1EnumOptions == ModOptions.SHOW_EFFECTS) {
            boolean bl = this.showEffects = !this.showEffects;
        }
        if (par1EnumOptions == ModOptions.BETTER_SPRINT) {
            boolean bl = this.betterSprint = !this.betterSprint;
        }
        if (par1EnumOptions == ModOptions.SHOW_ARMOR) {
            boolean bl = this.showArmor = !this.showArmor;
        }
        if (par1EnumOptions == ModOptions.KEEP_SNEAK) {
            boolean bl = this.keepSneak = !this.keepSneak;
        }
        if (par1EnumOptions == ModOptions.NOTIFICATIONS) {
            boolean bl = this.notifications = !this.notifications;
        }
        if (par1EnumOptions == ModOptions.ARCHERY) {
            boolean bl = this.archery = !this.archery;
        }
        if (par1EnumOptions == ModOptions.XP) {
            boolean bl = this.xp = !this.xp;
        }
        if (par1EnumOptions == ModOptions.SHOW_ENCHANTS) {
            this.showEnchants = !this.showEnchants;
        }
        this.saveSettings();
    }
}

