/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.util.ArrayList;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.ScaledResolution;
import net.minecraft.client.resources.I18n;
import org.lwjgl.input.Mouse;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.MySmallButton;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;

public class GuiTransfer
extends GuiScreen {
    private GuiScreen parentScreen;
    private MySmallButton transferButton;
    private ArrayList<GuiDropDown> dropDowns = new ArrayList();
    private GuiWaypointContainers containers1;
    private GuiWaypointWorlds worlds1;
    private GuiWaypointContainers containers2;
    private GuiWaypointWorlds worlds2;
    private IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;
    private boolean dropped = false;

    public GuiTransfer(IXaeroMinimap modMain, GuiScreen par1) {
        this.modMain = modMain;
        this.waypointsManager = modMain.getWaypointsManager();
        this.parentScreen = par1;
        this.containers1 = new GuiWaypointContainers(modMain, this.waypointsManager);
        this.containers2 = new GuiWaypointContainers(modMain, this.waypointsManager);
        this.worlds1 = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers1.getCurrentKey()), this.waypointsManager);
        this.worlds2 = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers2.getCurrentKey()), this.waypointsManager);
    }

    public void func_73866_w_() {
        this.field_146292_n.clear();
        this.transferButton = new MySmallButton(5, this.field_146294_l / 2 - 155, this.field_146295_m / 7 + 120, I18n.func_135052_a((String)"gui.xaero_transfer", (Object[])new Object[0]));
        this.field_146292_n.add(this.transferButton);
        this.transferButton.field_146124_l = false;
        this.field_146292_n.add(new MySmallButton(6, this.field_146294_l / 2 + 5, this.field_146295_m / 7 + 120, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0])));
        this.dropDowns.clear();
        this.dropDowns.add(new GuiDropDown(this.worlds1.options, this.field_146294_l / 2 + 2, this.field_146295_m / 7 + 20, 200, this.worlds1.current));
        this.dropDowns.add(new GuiDropDown(this.worlds2.options, this.field_146294_l / 2 + 2, this.field_146295_m / 7 + 50, 200, this.worlds2.current));
        this.dropDowns.add(new GuiDropDown(this.containers1.options, this.field_146294_l / 2 - 202, this.field_146295_m / 7 + 20, 200, this.containers1.current));
        this.dropDowns.add(new GuiDropDown(this.containers2.options, this.field_146294_l / 2 - 202, this.field_146295_m / 7 + 50, 200, this.containers2.current));
    }

    protected void func_73864_a(int par1, int par2, int par3) throws IOException {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown(par1, par2, this.field_146295_m)) {
                d.mouseClicked(par1, par2, par3, this.field_146295_m);
                return;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown(par1, par2, this.field_146295_m)) {
                d.mouseClicked(par1, par2, par3, this.field_146295_m);
                return;
            }
            d.setClosed(true);
        }
        if (this.dropped) {
            return;
        }
        super.func_73864_a(par1, par2, par3);
    }

    protected void func_146286_b(int par1, int par2, int par3) {
        super.func_146286_b(par1, par2, par3);
        for (GuiDropDown d : this.dropDowns) {
            d.mouseReleased(par1, par2, par3, this.field_146295_m);
        }
    }

    protected void func_146284_a(GuiButton p_146284_1_) {
        if (p_146284_1_.field_146124_l) {
            switch (p_146284_1_.field_146127_k) {
                case 5: {
                    this.transfer();
                    break;
                }
                case 6: {
                    this.field_146297_k.func_147108_a(this.parentScreen);
                }
            }
        }
    }

    public void transfer() {
        try {
            String[] keys1 = this.worlds1.getCurrentKeys();
            String[] keys2 = this.worlds2.getCurrentKeys();
            WaypointWorld from = this.waypointsManager.getWorld(keys1[0], keys1[1]);
            WaypointWorld to = this.waypointsManager.getWorld(keys2[0], keys2[1]);
            Object[] keys = from.getSets().keySet().toArray();
            Object[] values = from.getSets().values().toArray();
            for (int i = 0; i < keys.length; ++i) {
                String setName = (String)keys[i];
                WaypointSet fromSet = (WaypointSet)values[i];
                WaypointSet toSet = to.getSets().get(setName);
                if (toSet == null) {
                    toSet = new WaypointSet(setName);
                }
                ArrayList<Waypoint> list = fromSet.getList();
                for (int j = 0; j < list.size(); ++j) {
                    Waypoint w = list.get(j);
                    Waypoint copy = new Waypoint(w.getX(), w.getY(), w.getZ(), w.getLocalizedName(), w.getSymbol(), w.getColor(), w.getType());
                    copy.setRotation(w.isRotation());
                    copy.setDisabled(w.isDisabled());
                    copy.setYaw(w.getYaw());
                    toSet.getList().add(copy);
                }
                to.getSets().put(setName, toSet);
            }
            if (keys2[0] != null && !keys2[0].equals(this.waypointsManager.getCustomContainerID())) {
                this.waypointsManager.setCustomContainerID(keys2[0]);
            }
            if (keys2[1] != null && !keys2[1].equals(this.waypointsManager.getCustomWorldID())) {
                this.waypointsManager.setCustomWorldID(keys2[1]);
            }
            this.waypointsManager.updateWaypoints();
            if (this.parentScreen instanceof GuiWaypoints) {
                this.field_146297_k.func_147108_a((GuiScreen)new GuiWaypoints(this.modMain, ((GuiWaypoints)this.parentScreen).getParentScreen()));
            }
            this.modMain.getSettings().saveWaypoints(to);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int k;
        super.func_146276_q_();
        this.updateSelections();
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_transfer_all", (Object[])new Object[0]), this.field_146294_l / 2, 5, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_from", (Object[])new Object[0]).replace("\u00a7\u00a7", ":") + ":", this.field_146294_l / 2, this.field_146295_m / 7 + 10, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_to", (Object[])new Object[0]).replace("\u00a7\u00a7", ":") + ":", this.field_146294_l / 2, this.field_146295_m / 7 + 40, 0xFFFFFF);
        if (this.dropped) {
            super.func_73863_a(0, 0, par3);
        } else {
            super.func_73863_a(par1, par2, par3);
        }
        this.dropped = false;
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) {
                this.dropDowns.get(k).drawButton(par1, par2, this.field_146295_m);
                continue;
            }
            this.dropped = true;
        }
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) continue;
            this.dropDowns.get(k).drawButton(par1, par2, this.field_146295_m);
        }
    }

    private void updateSelections() {
        if (this.containers1.current != this.dropDowns.get(2).getSelected()) {
            this.containers1.current = this.dropDowns.get(2).getSelected();
            this.worlds1 = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers1.getCurrentKey()), this.waypointsManager);
            this.dropDowns.set(0, new GuiDropDown(this.worlds1.options, this.field_146294_l / 2 + 2, this.field_146295_m / 7 + 20, 200, this.worlds1.current));
        }
        if (this.containers2.current != this.dropDowns.get(3).getSelected()) {
            this.containers2.current = this.dropDowns.get(3).getSelected();
            this.worlds2 = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers2.getCurrentKey()), this.waypointsManager);
            this.dropDowns.set(1, new GuiDropDown(this.worlds2.options, this.field_146294_l / 2 + 2, this.field_146295_m / 7 + 50, 200, this.worlds2.current));
        }
        this.worlds1.current = this.dropDowns.get(0).getSelected();
        this.worlds2.current = this.dropDowns.get(1).getSelected();
        this.transferButton.field_146124_l = this.containers1.current != this.containers2.current || this.worlds1.current != this.worlds2.current;
    }

    public void func_146274_d() throws IOException {
        super.func_146274_d();
        int wheel = Mouse.getEventDWheel() / 120;
        if (wheel != 0) {
            ScaledResolution var3 = new ScaledResolution(this.field_146297_k);
            int mouseXScaled = Mouse.getX() / var3.func_78325_e();
            int mouseYScaled = var3.func_78328_b() - 1 - Mouse.getY() / var3.func_78325_e();
            for (GuiDropDown d : this.dropDowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.field_146295_m)) continue;
                d.mouseScrolled(wheel, mouseXScaled, mouseYScaled, this.field_146295_m);
                return;
            }
        }
    }
}

