/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TextComponentString;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.minimap.waypoints.Waypoint;

public class WaypointSharingHandler
implements GuiYesNoCallback {
    public static final String WAYPOINT_SHARE_PREFIX = "xaero_waypoint:";
    public static final String WAYPOINT_ADD_PREFIX = "xaero_waypoint_add:";
    private IXaeroMinimap modMain;
    private GuiScreen parent;
    private Waypoint w;

    public WaypointSharingHandler(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    public void shareWaypoint(GuiScreen parent, Waypoint w) {
        this.parent = parent;
        this.w = w;
        Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_share_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_share_msg2", (Object[])new Object[0]), 0));
    }

    public void onWaypointReceived(String text, ClientChatReceivedEvent e) {
        String[] args = text.substring(text.indexOf(WAYPOINT_SHARE_PREFIX)).split(":");
        TextComponentString component = null;
        if (args.length < 9) {
            System.out.println("Incorrect format of the shared waypoint! Error: 0");
        } else {
            String playerName = text.substring(0, text.indexOf(WAYPOINT_SHARE_PREFIX));
            int lastGreater = playerName.lastIndexOf(">");
            if (lastGreater != -1) {
                playerName = playerName.substring(0, lastGreater).replaceFirst("<", "");
            }
            String newText = playerName + " shared a waypoint called \"" + I18n.func_135052_a((String)Waypoint.getStringFromStringSafe(args[1], "^col^"), (Object[])new Object[0]) + "\"! \u00a72\u00a7n[Add]";
            newText = newText.replaceAll("\u00a7r", "\u00a7r\u00a77").replaceAll("\u00a7f", "\u00a77");
            component = new TextComponentString(newText);
            TextComponentString hoverComponent = new TextComponentString(args[3] + ", " + args[4] + ", " + args[5]);
            component.func_150256_b().func_150238_a(TextFormatting.GRAY).func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, "/xaero xaero_waypoint_add:" + text.substring(text.indexOf(WAYPOINT_SHARE_PREFIX) + WAYPOINT_SHARE_PREFIX.length()))).func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)hoverComponent));
        }
        e.setMessage(component);
    }

    public void onWaypointAdd(String[] args) {
        String waypointName = Waypoint.getStringFromStringSafe(args[1], "^col^");
        if (waypointName.length() < 1 || waypointName.length() > 32) {
            System.out.println("Incorrect format of the shared waypoint! Error: 1");
            return;
        }
        String waypointSymbol = Waypoint.getStringFromStringSafe(args[2], "^col^");
        if (waypointSymbol.length() < 1 || waypointSymbol.length() > 2) {
            System.out.println("Incorrect format of the shared waypoint! Error: 2");
            return;
        }
        try {
            int x = Integer.parseInt(args[3]);
            int y = Integer.parseInt(args[4]);
            int z = Integer.parseInt(args[5]);
            int color = Integer.parseInt(args[6]);
            String yawString = args[8].replaceAll("[^0-9-]+", "");
            if (yawString.length() > 4) {
                System.out.println("Incorrect format of the shared waypoint! Error: 4");
                return;
            }
            int yaw = Integer.parseInt(yawString);
            boolean rotation = args[7].equals("true");
            Waypoint w = new Waypoint(x, y, z, waypointName, waypointSymbol, color, 0);
            w.setRotation(rotation);
            w.setYaw(yaw);
            Minecraft.func_71410_x().func_147108_a((GuiScreen)new GuiAddWaypoint(this.modMain, null, w));
        }
        catch (NumberFormatException nfe) {
            System.out.println("Incorrect format of the shared waypoint! Error: 3");
            return;
        }
    }

    public void func_73878_a(boolean p_confirmResult_1_, int p_confirmResult_2_) {
        switch (p_confirmResult_2_) {
            case 0: {
                if (!p_confirmResult_1_) break;
                Minecraft.func_71410_x().field_71462_r.func_175281_b(WAYPOINT_SHARE_PREFIX + this.w.getNameSafe("^col^") + ":" + this.w.getSymbolSafe("^col^") + ":" + this.w.getX() + ":" + this.w.getY() + ":" + this.w.getZ() + ":" + this.w.getColor() + ":" + this.w.isRotation() + ":" + this.w.getYaw(), true);
                Minecraft.func_71410_x().func_147108_a(null);
                return;
            }
        }
        Minecraft.func_71410_x().func_147108_a(this.parent);
    }
}

