/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiTextField;
import net.minecraft.client.resources.I18n;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MySuperTinyButton;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;
import xaero.common.validator.NumericFieldValidator;

public class GuiAddWaypoint
extends GuiScreen
implements IDropDownCallback {
    private IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;
    private GuiScreen parentGuiScreen;
    protected String screenTitle;
    private GuiButton multiplyButton;
    private GuiButton divideButton;
    private GuiTextField nameTextField;
    private GuiTextField xTextField;
    private GuiTextField yTextField;
    private GuiTextField zTextField;
    private GuiTextField yawTextField;
    private GuiTextField initialTextField;
    private String nameText;
    private String xText;
    private String yText;
    private String zText;
    private String yaw;
    private String initial;
    private GuiTextField focusedField;
    private ArrayList<GuiDropDown> dropDowns;
    private int defaultContainer;
    private WaypointWorld defaultWorld;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private GuiDropDown containersDD;
    private GuiDropDown worldsDD;
    private GuiDropDown setsDD;
    private GuiDropDown colorDD;
    private String fromSet;
    private int color;
    private ArrayList<Waypoint> waypointsEdited;
    private boolean dropped;
    private boolean waypointDisabled;
    private MySuperTinyButton disableButton;
    private NumericFieldValidator fieldValidator;
    private boolean keepNameText;
    private boolean keepXTextField;
    private boolean keepYTextField;
    private boolean keepZTextField;
    private boolean keepYawTextField;
    private boolean keepInitialTextField;
    private boolean keepDisabledValue;
    private boolean adding;
    private String namePlaceholder;
    private String xPlaceholder;
    private String yPlaceholder;
    private String zPlaceholder;
    private String yawPlaceholder;
    private String initialPlaceholder;
    private String colorPlaceholder;
    private boolean defaultKeepYawTextField;
    private boolean defaultKeepDisabledValue;
    private GuiButton defaultYawButton;
    private GuiButton defaultDisabledButton;
    private int multiplyDefaultValueBy8Counter;

    public GuiAddWaypoint(IXaeroMinimap modMain, GuiScreen par1GuiScreen, Waypoint point, String defaultParentContainer, WaypointWorld defaultWorld) {
        this(modMain, par1GuiScreen, point == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new Waypoint[]{point}), defaultParentContainer, defaultWorld, point == null || point.getColor() == -1);
    }

    public GuiAddWaypoint(IXaeroMinimap modMain, GuiScreen par1GuiScreen, ArrayList<Waypoint> waypointsEdited, String defaultParentContainer, WaypointWorld defaultWorld, boolean adding) {
        this.parentGuiScreen = par1GuiScreen;
        this.waypointsEdited = waypointsEdited;
        this.modMain = modMain;
        this.waypointsManager = modMain.getWaypointsManager();
        this.fromSet = defaultWorld.getCurrent();
        this.defaultWorld = defaultWorld;
        this.containers = new GuiWaypointContainers(modMain, this.waypointsManager, defaultParentContainer);
        this.defaultContainer = this.containers.current;
        this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(defaultParentContainer), this.waypointsManager, defaultWorld.getFullId());
        this.sets = new GuiWaypointSets(false, defaultWorld);
        this.nameText = "";
        this.dropDowns = new ArrayList();
        this.initial = "";
        this.yaw = "";
        this.fieldValidator = modMain.getFieldValidators().getNumericFieldValidator();
        this.adding = adding;
        if (waypointsEdited.isEmpty()) {
            this.color = (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1));
        } else if (this.differentValues(Waypoint::getColor)) {
            this.color = 0;
        } else {
            this.color = waypointsEdited.get(0).getColor();
            if (this.color == -1) {
                this.color = (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1));
            }
        }
        String string = this.screenTitle = adding ? I18n.func_135052_a((String)"gui.xaero_new_waypoint", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_edit_waypoint", (Object[])new Object[0]);
        if (waypointsEdited.isEmpty()) {
            boolean divideBy8 = this.waypointsManager.divideBy8(this.worlds.getCurrentKeys()[0]);
            Minecraft minecraft = Minecraft.func_71410_x();
            this.xText = "" + OptimizedMath.myFloor(minecraft.field_71439_g.field_70165_t) * (divideBy8 ? 8 : 1);
            this.yText = "" + OptimizedMath.myFloor(minecraft.field_71439_g.field_70163_u);
            this.zText = "" + OptimizedMath.myFloor(minecraft.field_71439_g.field_70161_v) * (divideBy8 ? 8 : 1);
        } else {
            this.xText = "";
            this.yText = "";
            this.zText = "";
            this.keepNameText = this.differentValues(Waypoint::getName);
            this.keepXTextField = this.differentValues(Waypoint::getX);
            this.keepYTextField = this.differentValues(Waypoint::getY);
            this.keepZTextField = this.differentValues(Waypoint::getZ);
            this.keepYawTextField = this.differentValues(Waypoint::isRotation) || GuiWaypoints.allWaypointsAre(waypointsEdited, Waypoint::isRotation) && this.differentValues(Waypoint::getYaw);
            this.defaultKeepYawTextField = this.keepYawTextField;
            this.keepInitialTextField = this.differentValues(Waypoint::getSymbol);
            this.defaultKeepDisabledValue = this.keepDisabledValue = this.differentValues(Waypoint::isDisabled);
            Waypoint firstWaypoint = waypointsEdited.get(0);
            if (!this.keepNameText) {
                this.nameText = firstWaypoint.getLocalizedName();
            }
            if (!this.keepXTextField) {
                this.xText = firstWaypoint.getX() + "";
            }
            if (!this.keepYTextField) {
                this.yText = firstWaypoint.getY() + "";
            }
            if (!this.keepZTextField) {
                this.zText = firstWaypoint.getZ() + "";
            }
            if (!this.keepYawTextField && firstWaypoint.isRotation()) {
                this.yaw = firstWaypoint.getYaw() + "";
            }
            if (!this.keepInitialTextField) {
                this.initial = firstWaypoint.getSymbol() + "";
            }
            if (!this.keepDisabledValue) {
                this.waypointDisabled = firstWaypoint.isDisabled();
            }
        }
        this.namePlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_waypoint_name", (Object[])new Object[0]);
        this.xPlaceholder = "\u00a78- x";
        this.yPlaceholder = "\u00a78- y";
        this.zPlaceholder = "\u00a78- z";
        this.yawPlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]);
        this.initialPlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]);
        this.colorPlaceholder = "\u00a78-";
    }

    private boolean differentValues(Function<Waypoint, Object> s) {
        if (this.waypointsEdited.isEmpty()) {
            return false;
        }
        Waypoint testWaypoint = this.waypointsEdited.get(0);
        for (Waypoint w : this.waypointsEdited) {
            if (s.apply(w).equals(s.apply(testWaypoint))) continue;
            return true;
        }
        return false;
    }

    public String[] createColorOptions() {
        boolean unchangedOption = this.differentValues(Waypoint::getColor);
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length + (unchangedOption ? 1 : 0)];
        if (unchangedOption) {
            options[0] = this.colorPlaceholder;
        }
        for (int i = 0; i < ModSettings.ENCHANT_COLOR_NAMES.length; ++i) {
            options[i + (unchangedOption ? 1 : 0)] = i == 0 ? I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[i] + I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]);
        }
        return options;
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.modMain.getInterfaces().setSelectedId(-1);
        this.modMain.getInterfaces().setDraggingId(-1);
        this.func_189646_b(new MySmallButton(200, this.field_146294_l / 2 - 155, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                boolean creatingAWaypoint;
                int x = GuiAddWaypoint.this.keepXTextField || GuiAddWaypoint.this.xTextField.func_146179_b().equals("-") ? 0 : Integer.parseInt(GuiAddWaypoint.this.xTextField.func_146179_b());
                int y = GuiAddWaypoint.this.keepYTextField || GuiAddWaypoint.this.yTextField.func_146179_b().equals("-") ? 0 : Integer.parseInt(GuiAddWaypoint.this.yTextField.func_146179_b());
                int z = GuiAddWaypoint.this.keepZTextField || GuiAddWaypoint.this.zTextField.func_146179_b().equals("-") ? 0 : Integer.parseInt(GuiAddWaypoint.this.zTextField.func_146179_b());
                String name = GuiAddWaypoint.this.nameTextField.func_146179_b();
                boolean bl = creatingAWaypoint = GuiAddWaypoint.this.adding && GuiAddWaypoint.this.waypointsEdited.isEmpty();
                if (creatingAWaypoint) {
                    Waypoint created = new Waypoint(x, y, z, name, GuiAddWaypoint.this.initial, GuiAddWaypoint.this.color);
                    GuiAddWaypoint.this.waypointsEdited.add(created);
                } else {
                    for (Waypoint w : GuiAddWaypoint.this.waypointsEdited) {
                        if (!GuiAddWaypoint.this.keepNameText) {
                            w.setName(name);
                        }
                        if (!GuiAddWaypoint.this.keepXTextField) {
                            w.setX(x);
                        }
                        if (!GuiAddWaypoint.this.keepYTextField) {
                            w.setY(y);
                        }
                        if (!GuiAddWaypoint.this.keepZTextField) {
                            w.setZ(z);
                        }
                        if (!GuiAddWaypoint.this.keepInitialTextField) {
                            w.setSymbol(GuiAddWaypoint.this.initial);
                        }
                        if (GuiAddWaypoint.this.colorDD.size() > ModSettings.ENCHANT_COLOR_NAMES.length) {
                            if (GuiAddWaypoint.this.color == 0) continue;
                            w.setColor(GuiAddWaypoint.this.color - 1);
                            continue;
                        }
                        w.setColor(GuiAddWaypoint.this.color);
                    }
                }
                boolean yawIsUsable = GuiAddWaypoint.this.yaw.length() > 0 && !GuiAddWaypoint.this.yaw.equals("-");
                int yawInt = yawIsUsable ? Integer.parseInt(GuiAddWaypoint.this.yaw) : 0;
                for (Waypoint w : GuiAddWaypoint.this.waypointsEdited) {
                    w.setX(GuiAddWaypoint.this.applyDefaultMultiplier(w.getX()));
                    w.setZ(GuiAddWaypoint.this.applyDefaultMultiplier(w.getZ()));
                    if (!GuiAddWaypoint.this.keepDisabledValue) {
                        w.setDisabled(GuiAddWaypoint.this.waypointDisabled);
                    }
                    if (GuiAddWaypoint.this.keepYawTextField) continue;
                    w.setRotation(yawIsUsable);
                    if (!yawIsUsable) continue;
                    w.setYaw(yawInt);
                }
                WaypointWorld sourceWorld = GuiAddWaypoint.this.defaultWorld;
                WaypointSet sourceSet = sourceWorld.getSets().get(GuiAddWaypoint.this.fromSet);
                String[] destinationWorldKeys = GuiAddWaypoint.this.worlds.getCurrentKeys();
                String destinationSetKey = GuiAddWaypoint.this.sets.getCurrentSetKey();
                WaypointWorld destinationWorld = GuiAddWaypoint.this.waypointsManager.getWorld(destinationWorldKeys[0], destinationWorldKeys[1]);
                WaypointSet destinationSet = destinationWorld.getSets().get(destinationSetKey);
                if (GuiAddWaypoint.this.adding || sourceSet != destinationSet) {
                    destinationSet.getList().addAll(0, GuiAddWaypoint.this.waypointsEdited);
                }
                if (sourceSet != destinationSet) {
                    sourceSet.getList().removeAll(GuiAddWaypoint.this.waypointsEdited);
                }
                try {
                    GuiAddWaypoint.this.modMain.getSettings().saveWaypoints(sourceWorld);
                    if (destinationWorld != sourceWorld) {
                        GuiAddWaypoint.this.modMain.getSettings().saveWaypoints(destinationWorld);
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                GuiAddWaypoint.this.field_146297_k.func_147108_a(GuiAddWaypoint.this.parentGuiScreen);
            }
        });
        this.func_189646_b(new MySmallButton(201, this.field_146294_l / 2 + 5, this.field_146295_m / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiAddWaypoint.this.field_146297_k.func_147108_a(GuiAddWaypoint.this.parentGuiScreen);
            }
        });
        this.multiplyButton = new MySuperTinyButton(203, this.field_146294_l / 2 - 165, 121, I18n.func_135052_a((String)"* 8", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiAddWaypoint.this.multiplyDefaultValueBy8Counter++;
                GuiAddWaypoint.this.updateMultiplyButtons();
            }
        };
        this.func_189646_b(this.multiplyButton);
        this.divideButton = new MySuperTinyButton(204, this.field_146294_l / 2 - 165, 147, I18n.func_135052_a((String)"/ 8", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiAddWaypoint.this.multiplyDefaultValueBy8Counter--;
                GuiAddWaypoint.this.updateMultiplyButtons();
            }
        };
        this.func_189646_b(this.divideButton);
        this.nameTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 100, 104, 200, 20){

            public void func_146195_b(boolean focused) {
                super.func_146195_b(focused);
                if (focused) {
                    GuiAddWaypoint.this.changeFocus(this);
                }
            }
        };
        this.xTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 109, 134, 50, 20){

            public void func_146195_b(boolean focused) {
                super.func_146195_b(focused);
                if (focused) {
                    GuiAddWaypoint.this.changeFocus(this);
                }
            }
        };
        this.yTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 53, 134, 50, 20){

            public void func_146195_b(boolean focused) {
                super.func_146195_b(focused);
                if (focused) {
                    GuiAddWaypoint.this.changeFocus(this);
                }
            }
        };
        this.zTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 + 3, 134, 50, 20){

            public void func_146195_b(boolean focused) {
                super.func_146195_b(focused);
                if (focused) {
                    GuiAddWaypoint.this.changeFocus(this);
                }
            }
        };
        this.yawTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 + 59, 134, 50, 20){

            public void func_146195_b(boolean focused) {
                super.func_146195_b(focused);
                if (focused) {
                    GuiAddWaypoint.this.changeFocus(this);
                }
            }
        };
        this.initialTextField = new GuiTextField(0, this.field_146289_q, this.field_146294_l / 2 - 25, 164, 50, 20){

            public void func_146195_b(boolean focused) {
                super.func_146195_b(focused);
                if (focused) {
                    GuiAddWaypoint.this.changeFocus(this);
                }
            }
        };
        this.nameTextField.func_146180_a(this.nameText);
        this.xTextField.func_146180_a(this.xText);
        this.yTextField.func_146180_a(this.yText);
        this.zTextField.func_146180_a(this.zText);
        this.yawTextField.func_146180_a(this.yaw);
        this.initialTextField.func_146180_a(this.initial);
        final String[] enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
        this.disableButton = new MySuperTinyButton(205, this.field_146294_l / 2 + 31, 164, enabledisable[this.waypointDisabled ? 1 : 0]){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiAddWaypoint.this.waypointDisabled = !GuiAddWaypoint.this.waypointDisabled;
                String[] enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
                ((GuiAddWaypoint)GuiAddWaypoint.this).disableButton.field_146126_j = GuiAddWaypoint.this.waypointDisabled ? enabledisable[1] : enabledisable[0];
                GuiAddWaypoint.this.keepDisabledValue = false;
                if (GuiAddWaypoint.this.defaultDisabledButton != null) {
                    ((GuiAddWaypoint)GuiAddWaypoint.this).defaultDisabledButton.field_146124_l = true;
                }
            }
        };
        this.func_189646_b(this.disableButton);
        if (this.defaultKeepYawTextField) {
            this.defaultYawButton = new GuiButton(206, this.field_146294_l / 2 + 111, 134, 20, 20, "-"){

                public void func_194829_a(double mouseX, double mouseY) {
                    GuiAddWaypoint.this.keepYawTextField = GuiAddWaypoint.this.defaultKeepYawTextField;
                    GuiAddWaypoint.this.yaw = "";
                    GuiAddWaypoint.this.yawTextField.func_146180_a(GuiAddWaypoint.this.yaw);
                    this.field_146124_l = false;
                }
            };
            this.func_189646_b(this.defaultYawButton);
            boolean bl = this.defaultYawButton.field_146124_l = !this.keepYawTextField;
        }
        if (this.defaultKeepDisabledValue) {
            this.defaultDisabledButton = new GuiButton(207, this.field_146294_l / 2 + 81, 164, 20, 20, "-"){

                public void func_194829_a(double mouseX, double mouseY) {
                    GuiAddWaypoint.this.keepDisabledValue = GuiAddWaypoint.this.defaultKeepDisabledValue;
                    GuiAddWaypoint.this.waypointDisabled = false;
                    ((GuiAddWaypoint)GuiAddWaypoint.this).disableButton.field_146126_j = GuiAddWaypoint.this.waypointDisabled ? enabledisable[1] : enabledisable[0];
                    this.field_146124_l = false;
                }
            };
            this.func_189646_b(this.defaultDisabledButton);
            this.defaultDisabledButton.field_146124_l = !this.keepDisabledValue;
        }
        this.dropDowns.clear();
        this.colorDD = new GuiDropDown(this.createColorOptions(), this.field_146294_l / 2 - 60, 82, 120, this.color, this);
        this.dropDowns.add(this.colorDD);
        this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
        this.dropDowns.add(this.setsDD);
        this.containersDD = new GuiDropDown(this.containers.options, this.field_146294_l / 2 - 203, 38, 200, this.containers.current, this);
        this.dropDowns.add(this.containersDD);
        this.worldsDD = new GuiDropDown(this.worlds.options, this.field_146294_l / 2 + 2, 38, 200, this.worlds.current, this);
        this.dropDowns.add(this.worldsDD);
        this.nameTextField.func_146195_b(true);
        this.field_146297_k.field_195559_v.func_197967_a(true);
        this.updateConfirmButton();
    }

    private void updateMultiplyButtons() {
        this.multiplyButton.field_146124_l = this.multiplyDefaultValueBy8Counter < 1;
        this.divideButton.field_146124_l = this.multiplyDefaultValueBy8Counter > -1;
    }

    private int applyDefaultMultiplier(int x) {
        block3: {
            block2: {
                if (this.multiplyDefaultValueBy8Counter <= 0) break block2;
                for (int i = 0; i < this.multiplyDefaultValueBy8Counter; ++i) {
                    x *= 8;
                }
                break block3;
            }
            if (this.multiplyDefaultValueBy8Counter >= 0) break block3;
            for (int i = 0; i < -this.multiplyDefaultValueBy8Counter; ++i) {
                x = (int)Math.floor((double)x * 0.125);
            }
        }
        return x;
    }

    private void changeFocus(GuiTextField field) {
        if (this.focusedField != null && this.focusedField != field) {
            this.focusedField.func_146195_b(false);
        }
        this.focusedField = field;
    }

    public void func_146281_b() {
        this.field_146297_k.field_195559_v.func_197967_a(false);
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        this.preType(par1, par2);
        if (this.focusedField != null) {
            this.focusedField.keyPressed(par1, par2, par3);
        }
        if (par2 == 15) {
            if (this.nameTextField.func_146206_l()) {
                this.xTextField.func_146195_b(true);
            } else if (this.xTextField.func_146206_l()) {
                this.yTextField.func_146195_b(true);
            } else if (this.yTextField.func_146206_l()) {
                this.zTextField.func_146195_b(true);
            } else if (this.zTextField.func_146206_l()) {
                this.yawTextField.func_146195_b(true);
            } else if (this.yawTextField.func_146206_l()) {
                this.initialTextField.func_146195_b(true);
            } else if (this.initialTextField.func_146206_l()) {
                this.nameTextField.func_146195_b(true);
            }
        }
        this.postType(par1, par2);
        if (this.canConfirm() && (par1 == 257 || par1 == 335)) {
            ((GuiButton)this.field_146292_n.get(0)).func_194829_a(0.0, 0.0);
        }
        return super.keyPressed(par1, par2, par3);
    }

    public boolean charTyped(char par1, int par2) {
        if (this.preType(par1, par2) && this.focusedField != null) {
            this.focusedField.charTyped(par1, par2);
        }
        this.postType(par1, par2);
        return super.charTyped(par1, par2);
    }

    private boolean preType(int par1, int par2) {
        return true;
    }

    private void postType(int par1, int par2) {
        if (this.nameTextField.func_146206_l()) {
            if (this.initial.length() == 0 && this.nameTextField.func_146179_b().length() > 0 && !this.keepInitialTextField) {
                this.initialTextField.func_146180_a(this.nameTextField.func_146179_b().substring(0, 1));
            }
        } else if (this.yawTextField.func_146206_l()) {
            this.fieldValidator.validate(this.yawTextField);
            this.keepYawTextField = false;
            if (this.defaultYawButton != null) {
                this.defaultYawButton.field_146124_l = true;
            }
        }
        this.checkFields();
        this.updateConfirmButton();
    }

    private boolean canConfirm() {
        return !(!this.keepNameText && this.nameTextField.func_146179_b().length() <= 0 || !this.keepInitialTextField && this.initial.length() <= 0 || !this.keepXTextField && this.xTextField.func_146179_b().length() <= 0 || !this.keepYTextField && this.yTextField.func_146179_b().length() <= 0 || !this.keepZTextField && this.zTextField.func_146179_b().length() <= 0);
    }

    private void updateConfirmButton() {
        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = this.canConfirm();
    }

    protected void checkFields() {
        this.fieldValidator.validate(this.xTextField);
        this.fieldValidator.validate(this.yTextField);
        this.fieldValidator.validate(this.zTextField);
        this.nameText = this.nameTextField.func_146179_b();
        this.xText = this.xTextField.func_146179_b();
        this.yText = this.yTextField.func_146179_b();
        this.zText = this.zTextField.func_146179_b();
        this.yaw = this.yawTextField.func_146179_b();
        this.initial = this.initialTextField.func_146179_b();
        this.initial = this.initial.toUpperCase();
        if (this.initial.length() > 1) {
            this.initial = this.initial.substring(0, 1);
            this.initialTextField.func_146180_a(this.initial);
        }
        if (this.yaw.length() > 4) {
            this.yaw = this.yaw.substring(0, 4);
            this.yawTextField.func_146180_a(this.yaw);
        }
        if (this.waypointsEdited.size() > 1) {
            this.keepNameText = this.nameText.isEmpty();
            this.keepXTextField = this.xText.isEmpty();
            this.keepYTextField = this.yText.isEmpty();
            this.keepZTextField = this.zText.isEmpty();
            this.keepInitialTextField = this.initial.isEmpty();
        }
    }

    public boolean mouseClicked(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown((int)par1, (int)par2, this.field_146295_m)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.field_146295_m);
                return true;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown((int)par1, (int)par2, this.field_146295_m)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.field_146295_m);
                return true;
            }
            d.setClosed(true);
        }
        boolean otherResult = super.mouseClicked(par1, par2, par3);
        this.nameTextField.mouseClicked(par1, par2, par3);
        this.xTextField.mouseClicked(par1, par2, par3);
        this.yTextField.mouseClicked(par1, par2, par3);
        this.zTextField.mouseClicked(par1, par2, par3);
        this.yawTextField.mouseClicked(par1, par2, par3);
        this.initialTextField.mouseClicked(par1, par2, par3);
        return otherResult;
    }

    public boolean mouseReleased(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            d.mouseReleased((int)par1, (int)par2, par3, this.field_146295_m);
        }
        return super.mouseReleased(par1, par2, par3);
    }

    private void setFieldText(GuiTextField field, String text) {
        if (field.func_146179_b().equals(text)) {
            return;
        }
        field.func_146180_a(text);
    }

    public void func_73876_c() {
        if (this.field_146297_k.field_71439_g == null) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        this.nameTextField.func_146178_a();
        this.xTextField.func_146178_a();
        this.yTextField.func_146178_a();
        this.zTextField.func_146178_a();
        this.yawTextField.func_146178_a();
        this.initialTextField.func_146178_a();
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.func_146276_q_();
        this.func_73732_a(this.field_146289_q, this.screenTitle, this.field_146294_l / 2, 20, 0xFFFFFF);
        if (!this.nameTextField.func_146206_l() && this.keepNameText) {
            this.setFieldText(this.nameTextField, this.namePlaceholder);
        }
        if (!this.xTextField.func_146206_l()) {
            if (this.keepXTextField) {
                this.setFieldText(this.xTextField, this.xPlaceholder);
            }
            if (this.multiplyDefaultValueBy8Counter > 0) {
                this.setFieldText(this.xTextField, this.xTextField.func_146179_b() + "\u00a7" + "8 * 8");
            } else if (this.multiplyDefaultValueBy8Counter < 0) {
                this.setFieldText(this.xTextField, this.xTextField.func_146179_b() + "\u00a7" + "8 / 8");
            }
        }
        if (!this.yTextField.func_146206_l() && this.keepYTextField) {
            this.setFieldText(this.yTextField, this.yPlaceholder);
        }
        if (!this.zTextField.func_146206_l()) {
            if (this.keepZTextField) {
                this.setFieldText(this.zTextField, this.zPlaceholder);
            }
            if (this.multiplyDefaultValueBy8Counter > 0) {
                this.setFieldText(this.zTextField, this.zTextField.func_146179_b() + "\u00a7" + "8 * 8");
            } else if (this.multiplyDefaultValueBy8Counter < 0) {
                this.setFieldText(this.zTextField, this.zTextField.func_146179_b() + "\u00a7" + "8 / 8");
            }
        }
        if (!this.yawTextField.func_146206_l() && this.yaw.isEmpty()) {
            if (this.keepYawTextField) {
                this.setFieldText(this.yawTextField, this.yawPlaceholder);
            } else {
                this.setFieldText(this.yawTextField, "\u00a78" + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]));
            }
        }
        if (!this.initialTextField.func_146206_l() && this.initial.isEmpty()) {
            if (this.keepInitialTextField) {
                this.setFieldText(this.initialTextField, this.initialPlaceholder);
            } else {
                this.setFieldText(this.initialTextField, "\u00a78" + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]));
            }
        }
        this.nameTextField.func_195608_a(par1, par2, par3);
        this.xTextField.func_195608_a(par1, par2, par3);
        this.yTextField.func_195608_a(par1, par2, par3);
        this.zTextField.func_195608_a(par1, par2, par3);
        this.yawTextField.func_195608_a(par1, par2, par3);
        this.initialTextField.func_195608_a(par1, par2, par3);
        this.setFieldText(this.nameTextField, this.nameText);
        this.setFieldText(this.xTextField, this.xText);
        this.setFieldText(this.yTextField, this.yText);
        this.setFieldText(this.zTextField, this.zText);
        this.setFieldText(this.yawTextField, this.yaw);
        this.setFieldText(this.initialTextField, this.initial);
        if (this.dropped) {
            super.func_73863_a(0, 0, par3);
        } else {
            super.func_73863_a(par1, par2, par3);
        }
        this.dropped = false;
        GuiDropDown openDropdown = null;
        for (int k = 0; k < this.dropDowns.size(); ++k) {
            GuiDropDown dropdown = this.dropDowns.get(k);
            if (!dropdown.isClosed()) {
                this.dropped = true;
                openDropdown = dropdown;
                continue;
            }
            dropdown.drawButton(par1, par2, this.field_146295_m);
        }
        if (openDropdown != null) {
            openDropdown.drawButton(par1, par2, this.field_146295_m);
        }
    }

    public boolean mouseScrolled(double wheel) {
        if ((int)wheel != 0) {
            int mouseXScaled = (int)(Misc.getMouseX(Minecraft.func_71410_x()) / Minecraft.func_71410_x().field_195558_d.func_198100_s());
            int mouseYScaled = (int)(Misc.getMouseY(Minecraft.func_71410_x()) / Minecraft.func_71410_x().field_195558_d.func_198100_s());
            for (GuiDropDown d : this.dropDowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.field_146295_m)) continue;
                d.mouseScrolled((int)wheel, mouseXScaled, mouseYScaled, this.field_146295_m);
                return true;
            }
        }
        return super.mouseScrolled(wheel);
    }

    @Override
    public void onSelected(GuiDropDown menu, int selected) {
        if (menu == this.setsDD) {
            this.sets.setCurrentSet(selected);
            if (this.waypointsManager.getCurrentContainerAndWorldID().equals(this.worlds.getCurrentKey())) {
                this.waypointsManager.getCurrentWorld().setCurrent(this.sets.getCurrentSetKey());
                this.waypointsManager.updateWaypoints();
                try {
                    this.modMain.getSettings().saveWaypoints(this.waypointsManager.getCurrentWorld());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (menu == this.colorDD) {
            this.color = selected;
        } else if (menu == this.containersDD) {
            this.containers.current = selected;
            WaypointWorld currentWorld = this.containers.current != this.defaultContainer ? this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()).getFirstWorld() : this.defaultWorld;
            this.sets = new GuiWaypointSets(false, currentWorld);
            this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, currentWorld.getFullId());
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
            this.dropDowns.set(1, this.setsDD);
            this.worldsDD = new GuiDropDown(this.worlds.options, this.field_146294_l / 2 + 2, 38, 200, this.worlds.current, this);
            this.dropDowns.set(3, this.worldsDD);
        } else if (menu == this.worldsDD) {
            this.worlds.current = selected;
            String[] worldKeys = this.worlds.getCurrentKeys();
            this.sets = new GuiWaypointSets(false, this.waypointsManager.getWorld(worldKeys[0], worldKeys[1]));
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
            this.dropDowns.set(1, this.setsDD);
        }
    }
}

