/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.function.Predicate;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiSlot;
import net.minecraft.client.resources.I18n;
import xaero.common.IXaeroMinimap;
import xaero.common.api.spigot.ServerWaypoint;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.gui.GuiClearSet;
import xaero.common.gui.GuiDeleteSet;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.GuiNewSet;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.GuiWaypointsOptions;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.MyTinyButton;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;

public class GuiWaypoints
extends GuiScreen
implements IDropDownCallback {
    private static final int FRAME_TOP_SIZE = 58;
    private static final int FRAME_BOTTOM_SIZE = 61;
    private GuiScreen parentScreen;
    private List list;
    private WaypointWorld displayedWorld;
    private ConcurrentSkipListSet<Integer> selectedListSet;
    private ArrayList<GuiDropDown> dropDowns;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private GuiDropDown containersDD;
    private GuiDropDown worldsDD;
    private GuiDropDown setsDD;
    private IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;
    private int draggingFromX;
    private int draggingFromY;
    private int draggingFromSlot;
    private Waypoint draggingWaypoint;
    private boolean dropped = false;
    private boolean displayingTeleportableWorld;
    private int shiftSelectFirst;

    public GuiWaypoints(IXaeroMinimap modMain, GuiScreen par1GuiScreen) {
        this.modMain = modMain;
        this.waypointsManager = modMain.getWaypointsManager();
        this.parentScreen = par1GuiScreen;
        this.selectedListSet = new ConcurrentSkipListSet();
        this.dropDowns = new ArrayList();
        this.draggingFromX = -1;
        this.draggingFromY = -1;
        this.draggingFromSlot = -1;
        this.displayedWorld = this.waypointsManager.getCurrentWorld();
        String currentContainer = this.displayedWorld.getContainer().getRootContainer().getKey();
        this.containers = new GuiWaypointContainers(modMain, this.waypointsManager, currentContainer);
        this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, this.displayedWorld.getFullId());
        this.displayingTeleportableWorld = this.waypointsManager.isWorldTeleportable(this.displayedWorld);
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.sets = new GuiWaypointSets(true, this.displayedWorld);
        this.func_189646_b(new MyTinyButton(5, this.field_146294_l / 2 + 129, this.field_146295_m - 53, I18n.func_135052_a((String)"gui.xaero_delete", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                if (!GuiWaypoints.this.selectedListSet.isEmpty()) {
                    Waypoint w;
                    int i;
                    GuiWaypoints.this.undrag();
                    boolean shouldRestore = true;
                    Iterator iterator = GuiWaypoints.this.selectedListSet.iterator();
                    while (iterator.hasNext()) {
                        i = (Integer)iterator.next();
                        w = GuiWaypoints.this.list.getWaypoint(i);
                        if (w instanceof ServerWaypoint) continue;
                        if (!w.isTemporary()) {
                            shouldRestore = false;
                        }
                        w.setTemporary(true);
                    }
                    if (shouldRestore) {
                        iterator = GuiWaypoints.this.selectedListSet.iterator();
                        while (iterator.hasNext()) {
                            i = (Integer)iterator.next();
                            w = GuiWaypoints.this.list.getWaypoint(i);
                            if (w instanceof ServerWaypoint) continue;
                            w.setTemporary(false);
                        }
                    }
                    try {
                        GuiWaypoints.this.modMain.getSettings().saveWaypoints(GuiWaypoints.this.displayedWorld);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                }
            }
        });
        this.func_189646_b(new GuiButton(6, this.field_146294_l / 2 - 100, this.field_146295_m - 29, I18n.func_135052_a((String)"gui.done", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiWaypoints.this.field_146297_k.func_147108_a(GuiWaypoints.this.parentScreen);
            }
        });
        this.func_189646_b(new MyTinyButton(7, this.field_146294_l / 2 - 203, this.field_146295_m - 53, I18n.func_135052_a((String)"gui.xaero_add_edit", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                ArrayList selectedWaypoints = GuiWaypoints.this.getSelectedWaypointsList().stream().filter(w -> !w.isServerWaypoint()).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
                GuiWaypoints.this.field_146297_k.func_147108_a((GuiScreen)new GuiAddWaypoint(GuiWaypoints.this.modMain, GuiWaypoints.this, selectedWaypoints, GuiWaypoints.this.displayedWorld.getContainer().getRootContainer().getKey(), GuiWaypoints.this.displayedWorld, selectedWaypoints.isEmpty()));
                GuiWaypoints.this.list.setSelected(-1);
            }
        });
        this.func_189646_b(new MyTinyButton(8, this.field_146294_l / 2 - 120, this.field_146295_m - 53, I18n.func_135052_a((String)"gui.xaero_waypoint_teleport", (Object[])new Object[0]) + " (T)"){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiWaypoints.this.displayingTeleportableWorld = GuiWaypoints.this.waypointsManager.isWorldTeleportable(GuiWaypoints.this.displayedWorld);
                GuiWaypoints.this.waypointsManager.teleportToWaypoint(GuiWaypoints.this.list.getWaypoint((Integer)GuiWaypoints.this.selectedListSet.first()), GuiWaypoints.this.displayedWorld, GuiWaypoints.this);
            }
        });
        this.func_189646_b(new MyTinyButton(9, this.field_146294_l / 2 + 46, this.field_146295_m - 53, I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                ArrayList selectedWaypoints = GuiWaypoints.this.getSelectedWaypointsList();
                if (GuiWaypoints.allWaypointsAre(selectedWaypoints, Waypoint::isTemporary)) {
                    for (Waypoint selected : selectedWaypoints) {
                        GuiWaypoints.this.displayedWorld.getCurrentSet().getList().remove(selected);
                    }
                    GuiWaypoints.this.selectedListSet.clear();
                } else if (GuiWaypoints.allWaypointsAre(selectedWaypoints, Waypoint::isDisabled)) {
                    for (Waypoint selected : selectedWaypoints) {
                        selected.setDisabled(false);
                    }
                } else {
                    for (Waypoint selected : selectedWaypoints) {
                        selected.setDisabled(true);
                    }
                }
                try {
                    GuiWaypoints.this.modMain.getSettings().saveWaypoints(GuiWaypoints.this.displayedWorld);
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        });
        this.func_189646_b(new MyTinyButton(10, this.field_146294_l / 2 + 130, 32, I18n.func_135052_a((String)"gui.xaero_clear", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                String[] worldKeys = GuiWaypoints.this.worlds.getCurrentKeys();
                if (GuiWaypoints.this.shouldDeleteSet()) {
                    GuiWaypoints.this.field_146297_k.func_147108_a((GuiScreen)new GuiDeleteSet(GuiWaypoints.this.modMain, I18n.func_135052_a((String)GuiWaypoints.this.sets.getOptions()[GuiWaypoints.this.sets.getCurrentSet()], (Object[])new Object[0]), worldKeys[0], worldKeys[1], GuiWaypoints.this.sets.getOptions()[GuiWaypoints.this.sets.getCurrentSet()], GuiWaypoints.this));
                } else {
                    GuiWaypoints.this.field_146297_k.func_147108_a((GuiScreen)new GuiClearSet(GuiWaypoints.this.modMain, I18n.func_135052_a((String)GuiWaypoints.this.sets.getOptions()[GuiWaypoints.this.sets.getCurrentSet()], (Object[])new Object[0]), worldKeys[0], worldKeys[1], GuiWaypoints.this.sets.getOptions()[GuiWaypoints.this.sets.getCurrentSet()], GuiWaypoints.this));
                }
            }
        });
        this.func_189646_b(new MyTinyButton(11, this.field_146294_l / 2 - 203, 32, I18n.func_135052_a((String)"gui.xaero_options", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiWaypoints.this.field_146297_k.func_147108_a((GuiScreen)new GuiWaypointsOptions(GuiWaypoints.this.modMain, GuiWaypoints.this, GuiWaypoints.this.displayedWorld));
            }
        });
        this.func_189646_b(new MyTinyButton(12, this.field_146294_l / 2 - 37, this.field_146295_m - 53, I18n.func_135052_a((String)"gui.xaero_share", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                Waypoint selected;
                Waypoint waypoint = selected = GuiWaypoints.this.selectedListSet.isEmpty() ? null : GuiWaypoints.this.list.getWaypoint((Integer)GuiWaypoints.this.selectedListSet.first());
                if (selected != null) {
                    GuiWaypoints.this.modMain.getWaypointSharing().shareWaypoint(GuiWaypoints.this, selected, GuiWaypoints.this.displayedWorld);
                }
            }
        });
        this.list = new List();
        this.dropDowns.clear();
        this.containersDD = new GuiDropDown(this.containers.options, this.field_146294_l / 2 - 202, 17, 200, this.containers.current, this);
        this.dropDowns.add(this.containersDD);
        this.worldsDD = new GuiDropDown(this.worlds.options, this.field_146294_l / 2 + 2, 17, 200, this.worlds.current, this);
        this.dropDowns.add(this.worldsDD);
        this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 100, 33, 200, this.sets.getCurrentSet(), this);
        this.dropDowns.add(this.setsDD);
    }

    private ArrayList<Waypoint> getSelectedWaypointsList() {
        return this.selectedListSet.stream().map(i -> this.list.getWaypoint(i)).collect(ArrayList::new, ArrayList::add, ArrayList::addAll);
    }

    public static boolean allWaypointsAre(ArrayList<Waypoint> waypoints, Predicate<Waypoint> predicate) {
        boolean allTrue = true;
        for (Waypoint w : waypoints) {
            if (predicate.test(w)) continue;
            allTrue = false;
            break;
        }
        return allTrue;
    }

    public boolean shouldDeleteSet() {
        return !this.sets.getOptions()[this.sets.getCurrentSet()].equals("gui.xaero_default") && this.displayedWorld.getCurrentSet().getList().isEmpty();
    }

    private void undrag() {
        this.draggingFromX = -1;
        this.draggingFromY = -1;
        this.draggingFromSlot = -1;
        this.draggingWaypoint = null;
    }

    public boolean mouseClicked(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown((int)par1, (int)par2, this.field_146295_m)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.field_146295_m);
                return true;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown((int)par1, (int)par2, this.field_146295_m)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.field_146295_m);
                return true;
            }
            d.setClosed(true);
        }
        if (this.dropped) {
            return true;
        }
        if (par3 == 0) {
            if (par2 >= 58.0 && par2 < (double)(this.field_146295_m - 61)) {
                this.draggingFromX = (int)par1;
                this.draggingFromY = (int)par2;
                this.draggingFromSlot = this.list.func_195083_a(par1, par2);
                if (this.draggingFromSlot >= this.displayedWorld.getCurrentSet().getList().size()) {
                    this.draggingFromSlot = -1;
                }
            }
        } else {
            this.list.setSelected(-1);
        }
        if (this.list.mouseClicked(par1, par2, par3)) {
            return true;
        }
        return super.mouseClicked(par1, par2, par3);
    }

    public boolean mouseReleased(double par1, double par2, int par3) {
        try {
            if (this.draggingWaypoint != null) {
                this.modMain.getSettings().saveWaypoints(this.displayedWorld);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        this.undrag();
        for (GuiDropDown d : this.dropDowns) {
            d.mouseReleased((int)par1, (int)par2, par3, this.field_146295_m);
        }
        if (this.list.mouseReleased(par1, par2, par3)) {
            return true;
        }
        return super.mouseReleased(par1, par2, par3);
    }

    public boolean mouseDragged(double par1, double par2, int par3, double par4, double par5) {
        return this.list.mouseDragged(par1, par2, par3, par4, par5);
    }

    public boolean mouseScrolled(double wheel) {
        if ((int)wheel != 0) {
            int mouseXScaled = (int)(Misc.getMouseX(Minecraft.func_71410_x()) / Minecraft.func_71410_x().field_195558_d.func_198100_s());
            int mouseYScaled = (int)(Misc.getMouseY(Minecraft.func_71410_x()) / Minecraft.func_71410_x().field_195558_d.func_198100_s());
            for (GuiDropDown d : this.dropDowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.field_146295_m)) continue;
                d.mouseScrolled((int)wheel, mouseXScaled, mouseYScaled, this.field_146295_m);
                return true;
            }
        }
        return this.list.mouseScrolled(wheel);
    }

    public boolean keyReleased(int par1, int par2, int par3) {
        switch (par1) {
            case 261: {
                if (!((GuiButton)this.field_146292_n.get((int)4)).field_146124_l) break;
                for (int i : this.selectedListSet) {
                    this.list.getWaypoint(i).setTemporary(true);
                }
                ((GuiButton)this.field_146292_n.get(4)).func_194829_a(0.0, 0.0);
                break;
            }
            case 84: {
                if (!((GuiButton)this.field_146292_n.get((int)3)).field_146124_l) break;
                ((GuiButton)this.field_146292_n.get(3)).func_194829_a(0.0, 0.0);
            }
        }
        return super.keyReleased(par1, par2, par3);
    }

    public void func_73863_a(int par1, int par2, float par3) {
        int k;
        if (this.field_146297_k.field_71439_g == null) {
            this.field_146297_k.func_147108_a(null);
            return;
        }
        this.updateButtons();
        this.list.func_148128_a(par1, par2, par3);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_world_server", (Object[])new Object[0]), this.field_146294_l / 2 - 102, 5, 0xFFFFFF);
        this.func_73732_a(this.field_146289_q, I18n.func_135052_a((String)"gui.xaero_subworld_dimension", (Object[])new Object[0]), this.field_146294_l / 2 + 102, 5, 0xFFFFFF);
        if (this.draggingFromSlot != -1) {
            int distance = (int)Math.sqrt(Math.pow(par1 - this.draggingFromX, 2.0) + Math.pow(par2 - this.draggingFromY, 2.0));
            int toSlot = Math.min(this.displayedWorld.getCurrentSet().getList().size() - 1, this.list.func_195083_a(par1, par2));
            if (distance > 4 && this.draggingWaypoint == null) {
                this.draggingWaypoint = this.displayedWorld.getCurrentSet().getList().get(this.draggingFromSlot);
                this.list.setSelected(-1);
            }
            if (this.draggingWaypoint != null && this.draggingFromSlot != toSlot && toSlot != -1) {
                int direction = toSlot > this.draggingFromSlot ? 1 : -1;
                for (int i = this.draggingFromSlot; i != toSlot; i += direction) {
                    this.displayedWorld.getCurrentSet().getList().set(i, this.displayedWorld.getCurrentSet().getList().get(i + direction));
                }
                this.displayedWorld.getCurrentSet().getList().set(toSlot, this.draggingWaypoint);
                this.draggingFromSlot = toSlot;
            }
            int fromCenter = this.draggingFromX - this.list.field_148155_a / 2;
            this.list.drawWaypointSlot(this.draggingWaypoint, par1 - 108 - fromCenter, par2 - this.list.field_148149_f / 4);
        }
        if (this.dropped) {
            super.func_73863_a(0, 0, par3);
        } else {
            super.func_73863_a(par1, par2, par3);
        }
        this.dropped = false;
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) {
                this.dropDowns.get(k).drawButton(par1, par2, this.field_146295_m);
                continue;
            }
            this.dropped = true;
        }
        for (k = 0; k < this.dropDowns.size(); ++k) {
            if (this.dropDowns.get(k).isClosed()) continue;
            this.dropDowns.get(k).drawButton(par1, par2, this.field_146295_m);
        }
    }

    private void updateButtons() {
        ((GuiButton)this.field_146292_n.get((int)4)).field_146124_l = !this.selectedListSet.isEmpty();
        ((GuiButton)this.field_146292_n.get((int)0)).field_146124_l = ((GuiButton)this.field_146292_n.get((int)4)).field_146124_l;
        ((GuiButton)this.field_146292_n.get((int)7)).field_146124_l = this.selectedListSet.size() == 1;
        ((GuiButton)this.field_146292_n.get((int)3)).field_146124_l = this.selectedListSet.size() == 1 && (this.modMain.getSettings().allowWrongWorldTeleportation || this.displayingTeleportableWorld) && this.displayedWorld.getContainer().getRootContainer().isTeleportationEnabled();
        ArrayList<Waypoint> selectedWaypointsList = this.getSelectedWaypointsList();
        ((GuiButton)this.field_146292_n.get((int)2)).field_146124_l = this.selectedListSet.isEmpty() && this.field_146297_k.field_71439_g != null || !GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isServerWaypoint);
        ((GuiButton)this.field_146292_n.get((int)5)).field_146126_j = I18n.func_135052_a((String)(this.shouldDeleteSet() ? "gui.xaero_delete_set" : "gui.xaero_clear"), (Object[])new Object[0]);
        if (!this.selectedListSet.isEmpty() && GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isTemporary)) {
            ((GuiButton)this.field_146292_n.get((int)4)).field_146126_j = I18n.func_135052_a((String)"gui.xaero_delete", (Object[])new Object[0]);
            ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = I18n.func_135052_a((String)"gui.xaero_restore", (Object[])new Object[0]);
        } else {
            ((GuiButton)this.field_146292_n.get((int)0)).field_146126_j = I18n.func_135052_a((String)"gui.xaero_delete", (Object[])new Object[0]);
            String[] enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
            ((GuiButton)this.field_146292_n.get((int)4)).field_146126_j = enabledisable[!GuiWaypoints.allWaypointsAre(selectedWaypointsList, Waypoint::isDisabled) ? 0 : 1];
        }
    }

    public GuiScreen getParentScreen() {
        return this.parentScreen;
    }

    @Override
    public void onSelected(GuiDropDown menu, int selectedIndex) {
        if (menu == this.containersDD || menu == this.worldsDD) {
            if (menu == this.containersDD) {
                this.containers.current = selectedIndex;
                if (this.containers.current != this.containers.auto) {
                    WaypointWorld firstWorld = this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()).getFirstWorld();
                    this.waypointsManager.setCustomContainerID(firstWorld.getContainer().getKey());
                    this.waypointsManager.setCustomWorldID(firstWorld.getId());
                } else {
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.setCustomWorldID(null);
                }
                this.displayedWorld = this.waypointsManager.getCurrentWorld();
                this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, this.displayedWorld.getFullId());
                this.worldsDD = new GuiDropDown(this.worlds.options, this.field_146294_l / 2 + 2, 17, 200, this.worlds.current, this);
                this.dropDowns.set(1, this.worldsDD);
            } else if (menu == this.worldsDD) {
                this.worlds.current = selectedIndex;
                if (this.worlds.current != this.worlds.auto) {
                    String[] keys = this.worlds.getCurrentKeys();
                    this.waypointsManager.setCustomContainerID(keys[0]);
                    this.waypointsManager.setCustomWorldID(keys[1]);
                } else {
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.setCustomWorldID(null);
                }
                this.displayedWorld = this.waypointsManager.getCurrentWorld();
            }
            this.displayingTeleportableWorld = this.waypointsManager.isWorldTeleportable(this.displayedWorld);
            this.waypointsManager.updateWaypoints();
            this.list.setSelected(-1);
            this.sets = new GuiWaypointSets(true, this.displayedWorld);
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.field_146294_l / 2 - 100, 33, 200, this.sets.getCurrentSet(), this);
            this.dropDowns.set(2, this.setsDD);
        } else if (menu == this.setsDD) {
            if (selectedIndex == menu.size() - 1) {
                System.out.println("New waypoint set gui");
                menu.selectId(this.sets.getCurrentSet());
                this.field_146297_k.func_147108_a((GuiScreen)new GuiNewSet(this.modMain, this, this.displayedWorld));
                return;
            }
            this.sets.setCurrentSet(selectedIndex);
            this.displayedWorld.setCurrent(this.sets.getCurrentSetKey());
            this.waypointsManager.updateWaypoints();
            this.list.setSelected(-1);
            try {
                this.modMain.getSettings().saveWaypoints(this.displayedWorld);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    class List
    extends GuiSlot {
        public List() {
            super(GuiWaypoints.this.field_146297_k, GuiWaypoints.this.field_146294_l, GuiWaypoints.this.field_146295_m, 58, Math.max(62, GuiWaypoints.this.field_146295_m - 61), 18);
        }

        protected int func_148127_b() {
            int size = GuiWaypoints.this.displayedWorld.getCurrentSet().getList().size();
            if (GuiWaypoints.this.waypointsManager.getServerWaypoints() != null) {
                size += GuiWaypoints.this.waypointsManager.getServerWaypoints().size();
            }
            return size;
        }

        private Waypoint getWaypoint(int slotIndex) {
            int serverWPIndex;
            Waypoint waypoint = null;
            if (slotIndex < GuiWaypoints.this.displayedWorld.getCurrentSet().getList().size()) {
                waypoint = GuiWaypoints.this.displayedWorld.getCurrentSet().getList().get(slotIndex);
            } else if (GuiWaypoints.this.waypointsManager.getServerWaypoints() != null && (serverWPIndex = slotIndex - GuiWaypoints.this.displayedWorld.getCurrentSet().getList().size()) < GuiWaypoints.this.waypointsManager.getServerWaypoints().size()) {
                waypoint = GuiWaypoints.this.waypointsManager.getServerWaypoints().get(serverWPIndex);
            }
            return waypoint;
        }

        protected boolean func_195078_a(int index, int button, double mouseX, double mouseY) {
            this.setSelected(index);
            return true;
        }

        public void setSelected(int index) {
            if (index == -1) {
                GuiWaypoints.this.selectedListSet.clear();
                GuiWaypoints.this.shiftSelectFirst = -1;
                return;
            }
            int currentSize = GuiWaypoints.this.selectedListSet.size();
            boolean shiftPressed = GuiScreen.func_146272_n();
            if ((currentSize > 1 || currentSize == 1 && (Integer)GuiWaypoints.this.selectedListSet.first() != index) && !GuiScreen.func_146271_m() && !shiftPressed) {
                GuiWaypoints.this.selectedListSet.clear();
            }
            if (currentSize > 0 && shiftPressed) {
                int direction = index > GuiWaypoints.this.shiftSelectFirst ? 1 : -1;
                GuiWaypoints.this.selectedListSet.clear();
                for (int i = GuiWaypoints.this.shiftSelectFirst; i != index + direction; i += direction) {
                    GuiWaypoints.this.selectedListSet.add(i);
                }
            } else if (GuiWaypoints.this.selectedListSet.contains(index)) {
                GuiWaypoints.this.selectedListSet.remove(index);
            } else {
                GuiWaypoints.this.shiftSelectFirst = index;
                GuiWaypoints.this.selectedListSet.add(index);
            }
        }

        protected boolean func_148131_a(int p_148131_1_) {
            return !GuiWaypoints.this.selectedListSet.isEmpty() && GuiWaypoints.this.selectedListSet.contains(p_148131_1_);
        }

        protected int func_148138_e() {
            return this.func_148127_b() * 18;
        }

        protected void func_148123_a() {
            GuiWaypoints.this.func_146276_q_();
        }

        public void func_192637_a(int p_192637_1_, int p_192637_2_, int p_192637_3_, int p_192637_4_, int p_192637_5_, int p_192637_6_, float p_192637_7_) {
            Waypoint w = this.getWaypoint(p_192637_1_);
            if (w == GuiWaypoints.this.draggingWaypoint) {
                return;
            }
            this.drawWaypointSlot(w, p_192637_2_, p_192637_3_);
        }

        public void drawWaypointSlot(Waypoint w, int p_180791_2_, int p_180791_3_) {
            if (w == null) {
                return;
            }
            GuiWaypoints.this.func_73732_a(GuiWaypoints.this.field_146289_q, w.getLocalizedName() + (w.isDisabled() ? " \u00a74" + I18n.func_135052_a((String)"gui.xaero_disabled", (Object[])new Object[0]) : (w.isTemporary() ? " \u00a74" + I18n.func_135052_a((String)"gui.xaero_temporary", (Object[])new Object[0]) : "")), p_180791_2_ + 110, p_180791_3_ + 1, 0xFFFFFF);
            int rectX = p_180791_2_ + 8;
            int rectY = p_180791_3_;
            GuiWaypoints.this.modMain.getInterfaces().getMinimapInterface().getWaypointsGuiRenderer().drawIconOnGUI(w, GuiWaypoints.this.modMain.getSettings(), rectX, rectY);
        }

        public boolean func_195082_l() {
            if (GuiWaypoints.this.dropped) {
                return false;
            }
            return super.func_195082_l();
        }
    }
}

