/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.gui.GuiButton;
import net.minecraft.client.gui.GuiScreen;
import net.minecraft.client.gui.GuiYesNo;
import net.minecraft.client.gui.GuiYesNoCallback;
import net.minecraft.client.resources.I18n;
import org.apache.commons.io.FileUtils;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiTransfer;
import xaero.common.gui.GuiWorldTpCommand;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModSettings;

public class GuiWaypointsOptions
extends GuiScreen {
    GuiScreen parent;
    private IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;
    private MySmallButton automaticButton;
    private MySmallButton subAutomaticButton;
    private MySmallButton deleteButton;
    private MySmallButton subDeleteButton;
    private boolean buttonTest;
    private WaypointWorld waypointWorld;
    private boolean teleportationOptionShown;
    public CursorBox mwTooltip = new CursorBox("gui.xaero_use_multiworld_tooltip");
    public CursorBox teleportationTooltip = new CursorBox("gui.xaero_teleportation_tooltip", "\u00a7c");

    public GuiWaypointsOptions(IXaeroMinimap modMain, GuiScreen parent, WaypointWorld waypointWorld) {
        this.parent = parent;
        this.modMain = modMain;
        this.waypointsManager = modMain.getWaypointsManager();
        this.waypointWorld = waypointWorld;
        this.teleportationOptionShown = waypointWorld.getContainer().getRootContainer().isTeleportationEnabled();
    }

    public void func_73866_w_() {
        super.func_73866_w_();
        this.parent.func_146280_a(this.field_146297_k, this.field_146294_l, this.field_146295_m);
        this.func_189646_b(new MyTinyButton(5, this.field_146294_l / 2 - 203, 32, I18n.func_135052_a((String)"gui.xaero_close", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiWaypointsOptions.this.actionPerformed(this);
            }
        });
        this.func_189646_b(new MySmallButton(6, this.field_146294_l / 2 - 203, 57, I18n.func_135052_a((String)"gui.xaero_transfer", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiWaypointsOptions.this.actionPerformed(this);
            }
        });
        this.automaticButton = new MySmallButton(7, this.field_146294_l / 2 - 203, 82, I18n.func_135052_a((String)"gui.xaero_make_automatic", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiWaypointsOptions.this.actionPerformed(this);
            }
        };
        this.func_189646_b(this.automaticButton);
        this.subAutomaticButton = new MySmallButton(8, this.field_146294_l / 2 - 203, 107, I18n.func_135052_a((String)"gui.xaero_make_multi_automatic", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiWaypointsOptions.this.actionPerformed(this);
            }
        };
        this.func_189646_b(this.subAutomaticButton);
        this.deleteButton = new MySmallButton(9, this.field_146294_l / 2 - 203, 132, I18n.func_135052_a((String)"gui.xaero_delete_world", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiWaypointsOptions.this.actionPerformed(this);
            }
        };
        this.func_189646_b(this.deleteButton);
        this.subDeleteButton = new MySmallButton(10, this.field_146294_l / 2 - 203, 157, I18n.func_135052_a((String)"gui.xaero_delete_multi_world", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiWaypointsOptions.this.actionPerformed(this);
            }
        };
        this.func_189646_b(this.subDeleteButton);
        this.func_189646_b(new MySmallButton(11, this.field_146294_l / 2 - 203, 182, I18n.func_135052_a((String)"gui.xaero_multiply_all_by_8", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiWaypointsOptions.this.actionPerformed(this);
            }
        });
        this.func_189646_b(new MySmallButton(12, this.field_146294_l / 2 - 203, 207, I18n.func_135052_a((String)"gui.xaero_divide_all_by_8", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiWaypointsOptions.this.actionPerformed(this);
            }
        });
        this.func_189646_b(new MySmallButton(200, this.field_146294_l / 2 + 53, 57, this.getConfigButtonName(0)){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiWaypointsOptions.this.onConfigButtonClick(this);
            }
        });
        MySmallButton teleportationEnabledButton = (MySmallButton)this.func_189646_b(new MySmallButton(201, this.field_146294_l / 2 + 53, 82, this.getConfigButtonName(1)){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiWaypointsOptions.this.onConfigButtonClick(this);
            }
        });
        teleportationEnabledButton.field_146124_l = this.teleportationOptionShown;
        this.func_189646_b(new MySmallButton(13, this.field_146294_l / 2 + 53, 107, I18n.func_135052_a((String)"gui.xaero_world_teleport_command", (Object[])new Object[0])){

            public void func_194829_a(double mouseX, double mouseY) {
                GuiWaypointsOptions.this.actionPerformed(this);
            }
        });
    }

    private String getConfigButtonName(int buttonId) {
        switch (buttonId) {
            case 0: {
                return I18n.func_135052_a((String)"gui.xaero_use_multiworld", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.waypointWorld.getContainer().getRootContainer().isUsingMultiworldDetection());
            }
            case 1: {
                return I18n.func_135052_a((String)"gui.xaero_teleportation", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.waypointWorld.getContainer().getRootContainer().isTeleportationEnabled());
            }
        }
        return "";
    }

    private void onConfigButtonClick(MySmallButton button) {
        this.buttonTest = true;
        WaypointWorldRootContainer wc = this.waypointWorld.getContainer().getRootContainer();
        switch (button.getId() - 200) {
            case 0: {
                wc.setUsingMultiworldDetection(!this.waypointWorld.getContainer().getRootContainer().isUsingMultiworldDetection());
                wc.setDefaultMultiworldId(null);
                break;
            }
            case 1: {
                wc.setTeleportationEnabled(!wc.isTeleportationEnabled());
            }
        }
        wc.saveConfig();
        button.field_146126_j = this.getConfigButtonName(button.getId() - 200);
    }

    public boolean mouseClicked(double par1, double par2, int par3) {
        this.buttonTest = false;
        boolean toReturn = super.mouseClicked(par1, par2, par3);
        if (!this.buttonTest) {
            this.field_146297_k.func_147108_a(this.parent);
        }
        return toReturn;
    }

    protected void actionPerformed(GuiButton p_146284_1_) {
        this.buttonTest = true;
        if (p_146284_1_.field_146124_l) {
            switch (p_146284_1_.field_146127_k) {
                case 5: {
                    this.field_146297_k.func_147108_a(this.parent);
                    break;
                }
                case 6: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiTransfer(this.modMain, this.parent));
                    break;
                }
                case 7: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_make_automatic_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_make_automatic_msg2", (Object[])new Object[0]), p_146284_1_.field_146127_k));
                    break;
                }
                case 8: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_make_multi_automatic_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_make_multi_automatic_msg2", (Object[])new Object[0]), p_146284_1_.field_146127_k));
                    break;
                }
                case 9: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_delete_world_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_delete_world_msg2", (Object[])new Object[0]), p_146284_1_.field_146127_k));
                    break;
                }
                case 10: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_delete_multi_world_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_delete_multi_world_msg2", (Object[])new Object[0]), p_146284_1_.field_146127_k));
                    break;
                }
                case 11: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_multiply_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_multiply_msg2", (Object[])new Object[0]), p_146284_1_.field_146127_k));
                    break;
                }
                case 12: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiYesNo((GuiYesNoCallback)this, I18n.func_135052_a((String)"gui.xaero_multiply_msg1", (Object[])new Object[0]), I18n.func_135052_a((String)"gui.xaero_divide_msg2", (Object[])new Object[0]), p_146284_1_.field_146127_k));
                    break;
                }
                case 13: {
                    this.field_146297_k.func_147108_a((GuiScreen)new GuiWorldTpCommand(this.modMain, this, this.waypointWorld));
                }
            }
        }
    }

    public void confirmResult(boolean result, int id) {
        block25: {
            if (!result) break block25;
            switch (id) {
                case 7: {
                    WaypointWorldRootContainer selected = this.waypointWorld.getContainer().getRootContainer();
                    WaypointWorldContainer auto = this.waypointsManager.getWaypointMap().get(this.waypointsManager.getAutoRootContainerID());
                    if (selected == null || auto == null) break;
                    String buKey = selected.getKey();
                    this.waypointsManager.getWaypointMap().put(auto.getKey(), selected);
                    this.waypointsManager.getWaypointMap().put(buKey, auto);
                    selected.setKey(auto.getKey());
                    auto.setKey(buKey);
                    Path selectedPath = selected.getDirectory().toPath();
                    Path autoPath = auto.getDirectory().toPath();
                    Path tempFolder = this.modMain.getWaypointsFolder().toPath().resolve("temp_to_add");
                    try {
                        Files.createDirectories(tempFolder, new FileAttribute[0]);
                        Path selectedTemp = tempFolder.resolve(selectedPath.getFileName());
                        Path autoTemp = tempFolder.resolve(autoPath.getFileName());
                        if (Files.exists(selectedPath, new LinkOption[0])) {
                            Files.move(selectedPath, selectedTemp, new CopyOption[0]);
                        }
                        if (Files.exists(autoPath, new LinkOption[0])) {
                            Files.move(autoPath, autoTemp, new CopyOption[0]);
                        }
                        if (Files.exists(selectedTemp, new LinkOption[0])) {
                            Files.move(selectedTemp, autoPath, new CopyOption[0]);
                        }
                        if (Files.exists(autoTemp, new LinkOption[0])) {
                            Files.move(autoTemp, selectedPath, new CopyOption[0]);
                        }
                        Files.deleteIfExists(tempFolder);
                    }
                    catch (Throwable e) {
                        this.modMain.getInterfaces().getMinimap().setCrashedWith(e);
                    }
                    this.waypointsManager.setCustomWorldID(null);
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.updateWaypoints();
                    break;
                }
                case 8: {
                    WaypointWorld autoWorld = this.waypointsManager.getAutoWorld();
                    WaypointWorld selectedWorld = this.waypointWorld;
                    try {
                        Path autoFile = this.modMain.getSettings().getWaypointsFile(autoWorld).toPath();
                        Path selectedFile = this.modMain.getSettings().getWaypointsFile(selectedWorld).toPath();
                        Path autoTempFile = autoFile.getParent().resolve("temp_to_add").resolve(autoFile.getFileName());
                        Path selectedTempFile = selectedFile.getParent().resolve("temp_to_add").resolve(selectedFile.getFileName());
                        Files.createDirectories(autoTempFile.getParent(), new FileAttribute[0]);
                        Files.createDirectories(selectedTempFile.getParent(), new FileAttribute[0]);
                        if (!Files.exists(autoFile, new LinkOption[0])) {
                            Files.createFile(autoFile, new FileAttribute[0]);
                        }
                        Files.move(autoFile, autoTempFile, new CopyOption[0]);
                        if (!Files.exists(selectedFile, new LinkOption[0])) {
                            Files.createFile(selectedFile, new FileAttribute[0]);
                        }
                        Files.move(selectedFile, selectedTempFile, new CopyOption[0]);
                        if (Files.exists(autoTempFile, new LinkOption[0])) {
                            Files.move(autoTempFile, selectedFile, new CopyOption[0]);
                        }
                        if (Files.exists(selectedTempFile, new LinkOption[0])) {
                            Files.move(selectedTempFile, autoFile, new CopyOption[0]);
                        }
                        Files.deleteIfExists(autoTempFile.getParent());
                        Files.deleteIfExists(selectedTempFile.getParent());
                    }
                    catch (Throwable e) {
                        this.modMain.getInterfaces().getMinimap().setCrashedWith(e);
                        break;
                    }
                    WaypointWorldContainer autoWc = autoWorld.getContainer();
                    WaypointWorldContainer selectedWc = selectedWorld.getContainer();
                    autoWorld.setContainer(selectedWc);
                    selectedWorld.setContainer(autoWc);
                    selectedWc.worlds.put(selectedWorld.getId(), autoWorld);
                    autoWc.worlds.put(autoWorld.getId(), selectedWorld);
                    String buSelected = selectedWorld.getId();
                    selectedWorld.setId(autoWorld.getId());
                    autoWorld.setId(buSelected);
                    this.waypointsManager.setCustomWorldID(null);
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.updateWaypoints();
                    break;
                }
                case 9: {
                    String selectedRootContainerId = this.waypointWorld.getContainer().getRootContainer().getKey();
                    try {
                        File directory = this.modMain.getWaypointsFolder().toPath().resolve(selectedRootContainerId).toFile();
                        if (directory.exists()) {
                            FileUtils.deleteDirectory((File)directory);
                        }
                    }
                    catch (Throwable e) {
                        this.modMain.getInterfaces().getMinimap().setCrashedWith(e);
                        break;
                    }
                    this.waypointsManager.getWaypointMap().remove(selectedRootContainerId);
                    this.waypointsManager.setCustomWorldID(null);
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.updateWaypoints();
                    break;
                }
                case 10: {
                    WaypointWorld selectedWorld = this.waypointWorld;
                    try {
                        Files.deleteIfExists(this.modMain.getSettings().getWaypointsFile(selectedWorld).toPath());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    selectedWorld.getContainer().worlds.remove(selectedWorld.getId());
                    selectedWorld.getContainer().removeName(selectedWorld.getId());
                    this.waypointsManager.setCustomWorldID(null);
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.updateWaypoints();
                    break;
                }
                case 11: {
                    this.multiplyWaypoints(this.waypointWorld, 8.0);
                    break;
                }
                case 12: {
                    this.multiplyWaypoints(this.waypointWorld, 0.125);
                }
            }
        }
        this.field_146297_k.func_147108_a(this.parent);
    }

    private void multiplyWaypoints(WaypointWorld world, double factor) {
        HashMap<String, WaypointSet> sets = world.getSets();
        Iterator<WaypointSet> iter = sets.values().iterator();
        while (iter.hasNext()) {
            ArrayList<Waypoint> wpList = iter.next().getList();
            for (int i = 0; i < wpList.size(); ++i) {
                Waypoint wp = wpList.get(i);
                wp.setX((int)Math.floor((double)wp.getX() * factor));
                wp.setZ((int)Math.floor((double)wp.getZ() * factor));
            }
        }
        try {
            this.modMain.getSettings().saveWaypoints(world);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void func_73863_a(int par1, int par2, float par3) {
        this.deleteButton.field_146124_l = this.waypointsManager.getAutoRootContainerID() != null && !this.waypointsManager.getAutoRootContainerID().equals(this.waypointWorld.getContainer().getRootContainer().getKey());
        this.automaticButton.field_146124_l = this.deleteButton.field_146124_l;
        this.subDeleteButton.field_146124_l = !this.automaticButton.field_146124_l && this.waypointWorld != this.waypointsManager.getAutoWorld();
        this.subAutomaticButton.field_146124_l = this.subDeleteButton.field_146124_l;
        this.parent.func_73863_a(0, 0, par3);
        this.func_146276_q_();
        super.func_73863_a(par1, par2, par3);
        block4: for (int k = 0; k < this.field_146292_n.size(); ++k) {
            MySmallButton b;
            GuiButton w = (GuiButton)this.field_146292_n.get(k);
            if (!(w instanceof MySmallButton) || (b = (MySmallButton)w).getId() < 200 || par1 < b.field_146128_h || par2 < b.field_146129_i || par1 >= b.field_146128_h + 150 || par2 >= b.field_146129_i + 20) continue;
            switch (b.getId() - 200) {
                case 0: {
                    this.mwTooltip.drawBox(par1, par2, this.field_146294_l, this.field_146295_m);
                    continue block4;
                }
                case 1: {
                    this.teleportationTooltip.drawBox(par1, par2, this.field_146294_l, this.field_146295_m);
                }
            }
        }
    }
}

