/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.EntityPlayerSP;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.EntityPlayer;
import net.minecraft.item.ItemStack;
import net.minecraft.world.World;
import org.lwjgl.opengl.GL;
import xaero.common.IXaeroMinimap;
import xaero.common.anim.OldAnimation;
import xaero.common.minimap.MinimapRadar;
import xaero.common.minimap.render.MinimapFBORenderer;
import xaero.common.minimap.render.MinimapSafeModeRenderer;
import xaero.common.minimap.write.MinimapWriter;
import xaero.common.settings.ModSettings;

public class MinimapProcessor {
    public static final boolean DEBUG = false;
    public static final int FRAME = 9;
    private IXaeroMinimap modMain;
    private Throwable crashedWith;
    public static MinimapProcessor instance;
    private MinimapWriter minimapWriter;
    private MinimapFBORenderer minimapFBORenderer;
    private MinimapSafeModeRenderer minimapSafeModeRenderer;
    private MinimapRadar entityRadar;
    private ArrayList<Integer> texturesToDelete;
    private double minimapZoom;
    private boolean enlargedMap = false;
    protected final int[] minimapSizes;
    protected final int[] bufferSizes;
    private boolean toResetImage;
    public final Object mainStuffSync;
    public World mainWorld;
    public double mainPlayerX;
    public double mainPlayerY;
    public double mainPlayerZ;

    public MinimapProcessor(IXaeroMinimap modMain, MinimapWriter minimapWriter, MinimapFBORenderer minimapFBORenderer, MinimapSafeModeRenderer minimapSafeModeRenderer, MinimapRadar entityRadar) {
        this.modMain = modMain;
        this.minimapWriter = minimapWriter;
        this.minimapFBORenderer = minimapFBORenderer;
        this.minimapSafeModeRenderer = minimapSafeModeRenderer;
        this.entityRadar = entityRadar;
        this.texturesToDelete = new ArrayList();
        this.minimapZoom = 1.0;
        this.minimapSizes = new int[]{112, 168, 224, 336};
        this.bufferSizes = new int[]{128, 256, 256, 512};
        instance = this;
        this.toResetImage = true;
        this.mainStuffSync = new Object();
    }

    public boolean usingFBO() {
        return this.minimapFBORenderer.isLoadedFBO() && !this.modMain.getSettings().mapSafeMode;
    }

    public Throwable getCrashedWith() {
        return this.crashedWith;
    }

    public void setCrashedWith(Throwable crashedWith) {
        if (this.crashedWith == null) {
            this.crashedWith = crashedWith;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void requestTextureDelete(int texture) {
        ArrayList<Integer> arrayList = this.texturesToDelete;
        synchronized (arrayList) {
            this.texturesToDelete.add(texture);
        }
    }

    public double getMinimapZoom() {
        return this.minimapZoom;
    }

    public void updateZoom() {
        double off;
        double target = this.modMain.getSettings().zooms[this.modMain.getSettings().zoom] * (this.modMain.getSettings().caveZoom > 0 && this.minimapWriter.getLoadedCaving() != -1 ? (float)(1 + this.modMain.getSettings().caveZoom) : 1.0f);
        if (target > (double)this.modMain.getSettings().zooms[this.modMain.getSettings().zooms.length - 1]) {
            target = this.modMain.getSettings().zooms[this.modMain.getSettings().zooms.length - 1];
        }
        off = (off = target - this.minimapZoom) > 0.01 || off < -0.01 ? (double)((float)OldAnimation.animate(off, 0.8)) : 0.0;
        this.minimapZoom = target - off;
    }

    public MinimapWriter getMinimapWriter() {
        return this.minimapWriter;
    }

    public MinimapFBORenderer getMinimapFBORenderer() {
        return this.minimapFBORenderer;
    }

    public MinimapSafeModeRenderer getMinimapSafeModeRenderer() {
        return this.minimapSafeModeRenderer;
    }

    public boolean canUseFrameBuffer() {
        return GL.getCapabilities().OpenGL14 && (GL.getCapabilities().GL_ARB_framebuffer_object || GL.getCapabilities().GL_EXT_framebuffer_object || GL.getCapabilities().OpenGL30);
    }

    public int getFBOBufferSize() {
        return 512;
    }

    public int getMinimapSize() {
        return this.enlargedMap ? 448 : this.minimapSizes[this.modMain.getSettings().getMinimapSize()];
    }

    public int getMinimapBufferSize() {
        return this.enlargedMap ? 512 : this.bufferSizes[this.modMain.getSettings().getMinimapSize()];
    }

    public void onClientTick() {
        World world = null;
        EntityPlayerSP player = Minecraft.func_71410_x().field_71439_g;
        if (player != null) {
            world = player.field_70170_p;
        }
        if (world != null && player != null && this.modMain.getSettings().getMinimap()) {
            this.entityRadar.updateRadar(world, (EntityPlayer)player, Minecraft.func_71410_x().func_175606_aa());
        }
    }

    public void onPlayerTick() {
        if (this.modMain.getWaypointsManager().getCurrentContainerID() != null && this.modMain.getWaypointsManager().getCurrentWorldID() != null) {
            this.minimapWriter.setSeedForLoading(this.modMain.getSettings().getSlimeChunksSeed());
        }
    }

    public void onRender(int x, int y, int width, int height, double scale, int size, float partial) {
        if (this.crashedWith != null) {
            throw new RuntimeException("Xaero's Minimap has crashed! Please contact the author at planetminecraft.com/member/xaero96 or minecraftforum.net/members/xaero96", this.crashedWith);
        }
        try {
            if (this.minimapFBORenderer.isLoadedFBO() && !this.canUseFrameBuffer()) {
                this.minimapFBORenderer.setLoadedFBO(false);
                this.minimapFBORenderer.deleteFramebuffers();
                this.toResetImage = true;
            }
            if (!this.getMinimapFBORenderer().isLoadedFBO() && !this.modMain.getSettings().mapSafeMode && this.canUseFrameBuffer()) {
                this.minimapFBORenderer.loadFrameBuffer();
            }
            if (this.usingFBO()) {
                this.minimapFBORenderer.renderMinimap(this, x, y, width, height, scale, size, partial);
            } else {
                this.minimapSafeModeRenderer.renderMinimap(this, x, y, width, height, scale, size, partial);
            }
        }
        catch (Throwable e) {
            this.setCrashedWith(e);
        }
    }

    public static boolean hasMinimapItem(EntityPlayer player) {
        for (int i = 0; i < 9; ++i) {
            if (player.field_71071_by.field_70462_a.get(i) == null || ((ItemStack)player.field_71071_by.field_70462_a.get(i)).func_77973_b() != ModSettings.minimapItem) continue;
            return true;
        }
        return false;
    }

    public boolean isToResetImage() {
        return this.toResetImage;
    }

    public void setToResetImage(boolean toResetImage) {
        this.toResetImage = toResetImage;
    }

    public MinimapRadar getEntityRadar() {
        return this.entityRadar;
    }

    public boolean isEnlargedMap() {
        return this.enlargedMap;
    }

    public void setEnlargedMap(boolean enlargedMap) {
        this.enlargedMap = enlargedMap;
    }

    public ArrayList<Integer> getTexturesToDelete() {
        return this.texturesToDelete;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setMainValues() {
        Object object = this.mainStuffSync;
        synchronized (object) {
            Entity player = Minecraft.func_71410_x().func_175606_aa();
            if (player != null) {
                this.mainWorld = player.field_70170_p;
                this.mainPlayerX = player.field_70165_t;
                this.mainPlayerY = player.field_70163_u;
                this.mainPlayerZ = player.field_70161_v;
            } else {
                this.mainWorld = null;
            }
        }
    }
}

