/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraftforge.event.TickEvent;
import net.minecraftforge.eventbus.api.SubscribeEvent;
import net.minecraftforge.fml.LogicalSide;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.api.spigot.ServerWaypointStorage;
import xaero.common.controls.event.KeyEventHandler;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.waypoints.WaypointsManager;

public class FMLEventHandler {
    private IXaeroMinimap modMain;
    private MinimapProcessor minimap;
    protected WaypointsManager waypointsManager;
    private KeyEventHandler keyEventHandler;

    public FMLEventHandler(IXaeroMinimap modMain, KeyEventHandler keyEventHandler) {
        this.modMain = modMain;
        this.minimap = modMain.getInterfaces().getMinimap();
        this.waypointsManager = modMain.getWaypointsManager();
        this.keyEventHandler = keyEventHandler;
    }

    @SubscribeEvent
    public void handleClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ServerWaypointStorage.update(this.modMain, this.waypointsManager);
            this.minimap.onClientTick();
            if (Minecraft.func_71410_x().field_71439_g != null && Minecraft.func_71410_x().field_71462_r == null) {
                this.keyEventHandler.onKeyInput(Minecraft.func_71410_x(), this.modMain);
            }
        }
    }

    @SubscribeEvent
    public void handlePlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.side == LogicalSide.CLIENT && event.player == Minecraft.func_71410_x().field_71439_g && event.phase == TickEvent.Phase.START) {
            this.waypointsManager.updateWorldIds();
            this.minimap.onPlayerTick();
            if (this.modMain.getSettings() != null && (this.modMain.getSettings().getDeathpoints() || this.modMain.getSettings().getShowWaypoints() || this.modMain.getSettings().getShowIngameWaypoints())) {
                this.waypointsManager.updateWaypoints();
            } else if (this.waypointsManager.getWaypoints() != null) {
                this.waypointsManager.setWaypoints(null);
            }
            Minecraft mc = Minecraft.func_71410_x();
            this.keyEventHandler.handleEvents(mc, this.modMain);
            this.playerTickPostOverridable();
        }
    }

    protected void playerTickPostOverridable() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void handleRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ArrayList<Integer> arrayList = this.minimap.getTexturesToDelete();
            synchronized (arrayList) {
                if (!this.minimap.getTexturesToDelete().isEmpty()) {
                    int toDelete = this.minimap.getTexturesToDelete().get(0);
                    GL11.glDeleteTextures((int)toDelete);
                    this.minimap.getTexturesToDelete().remove(0);
                }
            }
            this.minimap.setMainValues();
        }
    }
}

