/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.IOException;
import java.util.Iterator;
import java.util.List;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiChoosePreset;
import xaero.common.gui.GuiInstructions;
import xaero.common.gui.MySmallButton;
import xaero.common.interfaces.Interface;
import xaero.common.interfaces.InterfaceManager;

public class GuiEditMode
extends Screen {
    private Screen parentGuiScreen;
    private IXaeroMinimap modMain;
    private String message;
    private boolean instructions;
    public boolean mouseDown;

    public GuiEditMode(IXaeroMinimap modMain, Screen par1GuiScreen, String message, boolean instructions) {
        super((ITextComponent)new TranslationTextComponent("gui.xaero_edit_mode", new Object[0]));
        this.modMain = modMain;
        this.parentGuiScreen = par1GuiScreen;
        this.message = message;
        this.instructions = instructions;
    }

    public void init() {
        super.init();
        this.modMain.getInterfaces().setSelectedId(-1);
        this.modMain.getInterfaces().setDraggingId(-1);
        this.addButton((Widget)new MySmallButton(200, this.width / 2 - 155, this.height / 6 + 143, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0]), b -> {
            try {
                this.confirm();
                this.modMain.getSettings().saveSettings();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.minecraft.func_147108_a(this.parentGuiScreen);
        }));
        this.addButton((Widget)new MySmallButton(202, this.width / 2 + 5, this.height / 6 + 143, I18n.func_135052_a((String)"gui.xaero_choose_a_preset", (Object[])new Object[0]), b -> this.minecraft.func_147108_a((Screen)new GuiChoosePreset(this.modMain, this))));
        if (this.instructions) {
            this.addButton((Widget)new MySmallButton(201, this.width / 2 + 5, this.height / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> {
                GuiEditMode.cancel(this.modMain.getInterfaces());
                this.minecraft.func_147108_a(this.parentGuiScreen);
            }));
            this.addButton((Widget)new MySmallButton(203, this.width / 2 - 155, this.height / 6 + 168, I18n.func_135052_a((String)"gui.xaero_instructions", (Object[])new Object[0]), b -> this.minecraft.func_147108_a((Screen)new GuiInstructions(this))));
        } else {
            this.addButton((Widget)new Button(this.width / 2 - 100, this.height / 6 + 168, 200, 20, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> {
                GuiEditMode.cancel(this.modMain.getInterfaces());
                this.minecraft.func_147108_a(this.parentGuiScreen);
            }));
        }
    }

    public boolean mouseClicked(double par1, double par2, int par3) {
        if (par3 == 0) {
            this.mouseDown = true;
        }
        return super.mouseClicked(par1, par2, par3);
    }

    public boolean mouseReleased(double par1, double par2, int par3) {
        if (par3 == 0) {
            this.mouseDown = false;
        }
        return super.mouseReleased(par1, par2, par3);
    }

    public void removed() {
        super.removed();
        this.mouseDown = false;
    }

    public void render(int par1, int par2, float par3) {
        if (this.modMain.getInterfaces().getDraggingId() == -1) {
            if (this.minecraft.field_71439_g == null) {
                this.renderBackground();
                this.drawCenteredString(this.font, I18n.func_135052_a((String)"gui.xaero_not_ingame", (Object[])new Object[0]), this.width / 2, this.height / 6 + 128, 0xFFFFFF);
            } else {
                this.drawCenteredString(this.font, I18n.func_135052_a((String)this.message, (Object[])new Object[0]), this.width / 2, this.height / 6 + 128, 0xFFFFFF);
            }
            super.render(par1, par2, par3);
        }
        if (this.minecraft.field_71439_g != null) {
            this.modMain.getInterfaceRenderer().renderBoxes(par1, par2, this.minecraft.field_195558_d.func_198107_o(), this.minecraft.field_195558_d.func_198087_p(), this.minecraft.field_195558_d.func_198100_s());
        }
    }

    public void confirm() {
        Iterator<Interface> iter = this.modMain.getInterfaces().getInterfaceIterator();
        while (iter.hasNext()) {
            iter.next().backup();
        }
    }

    public static void cancel(InterfaceManager interfaces) {
        Iterator<Interface> iter = interfaces.getInterfaceIterator();
        while (iter.hasNext()) {
            iter.next().restore();
        }
    }

    public void applyPreset(int id) {
        Iterator<Interface> iter = this.modMain.getInterfaces().getInterfaceIterator();
        this.modMain.getInterfaces().setActionTimer(10);
        while (iter.hasNext()) {
            iter.next().applyPreset(this.modMain.getInterfaces().getPreset(id));
        }
    }

    public List<Widget> getButtons() {
        return this.buttons;
    }
}

