/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints.render;

import com.mojang.blaze3d.platform.GlStateManager;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.entity.Entity;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.Vec3d;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.api.spigot.ServerWaypointStorage;
import xaero.common.gui.GuiMisc;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.settings.ModSettings;

public class WaypointsIngameRenderer {
    private IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;

    public WaypointsIngameRenderer(IXaeroMinimap modMain, Minecraft mc) {
        this.modMain = modMain;
        this.waypointsManager = modMain.getWaypointsManager();
    }

    public void render(float partial) {
        if (this.modMain.getSettings().getShowIngameWaypoints() && this.waypointsManager.getWaypoints() != null) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71474_y.field_74320_O > 0) {
                return;
            }
            Entity entity = mc.func_175606_aa();
            Vec3d eyePos = entity.func_174824_e(partial);
            double d3 = eyePos.func_82615_a();
            double d4 = eyePos.func_82617_b();
            double d5 = eyePos.func_82616_c();
            double actualEntityY = entity.field_70163_u;
            Tessellator tessellator = Tessellator.func_178181_a();
            BufferBuilder bufferbuilder = tessellator.func_178180_c();
            boolean divideBy8 = this.waypointsManager.divideBy8(this.waypointsManager.getCurrentContainerID());
            if (this.waypointsManager.renderAllSets) {
                HashMap<String, WaypointSet> sets = this.waypointsManager.getCurrentWorld().getSets();
                for (Map.Entry<String, WaypointSet> setEntry : sets.entrySet()) {
                    this.renderWaypointsList(setEntry.getValue().getList(), d3, d4, d5, entity, bufferbuilder, tessellator, divideBy8, actualEntityY);
                }
            } else {
                this.renderWaypointsList(this.waypointsManager.getWaypoints().getList(), d3, d4, d5, entity, bufferbuilder, tessellator, divideBy8, actualEntityY);
            }
            if (ServerWaypointStorage.working() && this.waypointsManager.getServerWaypoints() != null) {
                this.renderWaypointsList(this.waypointsManager.getServerWaypoints(), d3, d4, d5, entity, bufferbuilder, tessellator, divideBy8, actualEntityY);
            }
            RenderHelper.func_74518_a();
            GlStateManager.enableDepthTest();
            GlStateManager.depthMask((boolean)true);
        }
    }

    private void renderWaypointsList(List<Waypoint> list, double d3, double d4, double d5, Entity entity, BufferBuilder bufferbuilder, Tessellator tessellator, boolean divideBy8, double actualEntityY) {
        float cameraAngleYaw = MathHelper.func_76142_g((float)entity.field_70177_z);
        Vec3d lookVector = entity.func_70040_Z();
        for (int i = 0; i < list.size(); ++i) {
            this.renderWaypointIngame(cameraAngleYaw, lookVector, list.get(i), this.modMain, 12.0, d3, d4, d5, entity, bufferbuilder, tessellator, divideBy8, actualEntityY);
        }
    }

    private void renderWaypointIngame(float cameraAngleYaw, Vec3d lookVector, Waypoint w, IXaeroMinimap modMain, double radius, double d3, double d4, double d5, Entity entity, BufferBuilder bufferBuilder, Tessellator tessellator, boolean divideBy8, double actualEntityY) {
        float offZ;
        float offY;
        if (w.isDisabled() || w.getType() == 1 && !modMain.getSettings().getDeathpoints()) {
            return;
        }
        float offX = (float)((double)w.getX(divideBy8) - d3) + 0.5f;
        if ((double)offX * lookVector.field_72450_a + (double)(offY = (float)((double)w.getY() - d4) + 1.0f) * lookVector.field_72448_b + (double)(offZ = (float)((double)w.getZ(divideBy8) - d5) + 0.5f) * lookVector.field_72449_c < 0.0) {
            return;
        }
        double distance = Math.sqrt(offX * offX + offY * offY + offZ * offZ);
        double correctDistance = Math.sqrt((double)(offX * offX) + (actualEntityY - (double)w.getY()) * (actualEntityY - (double)w.getY()) + (double)(offZ * offZ));
        w.setLastDistance(distance);
        if (modMain.getSettings().waypointsDistance != 0.0 && distance > modMain.getSettings().waypointsDistance || modMain.getSettings().waypointsDistanceMin != 0.0 && distance < modMain.getSettings().waypointsDistanceMin) {
            return;
        }
        EntityRendererManager renderManager = Minecraft.func_71410_x().func_175598_ae();
        FontRenderer fontrenderer = renderManager.func_78716_a();
        if (fontrenderer == null) {
            return;
        }
        float f = 1.6f;
        float f1 = 0.016666668f * f;
        GlStateManager.pushMatrix();
        float textSize = 1.0f;
        String name = w.getLocalizedName();
        String distanceText = "";
        boolean showDistance = false;
        float zoomer2 = 1.0f;
        if (modMain.getSettings().keepWaypointNames) {
            textSize = 1.6f;
        }
        if (distance > radius) {
            double maxDistance = (double)Minecraft.func_71410_x().field_71474_y.field_151451_c * 16.0;
            if (distance > maxDistance) {
                zoomer2 = (float)(maxDistance / radius);
                float zoomer = (float)(maxDistance / distance);
                offX *= zoomer;
                offY *= zoomer;
                offZ *= zoomer;
            } else {
                zoomer2 = (float)(distance / radius);
            }
        }
        if (correctDistance > 20.0 || modMain.getSettings().alwaysShowDistance) {
            textSize = 1.6f;
            if (modMain.getSettings().distance == 1) {
                float offset;
                float Z = (float)(offZ == 0.0f ? 0.001 : (double)offZ);
                float angle = (float)Math.toDegrees(Math.atan(-offX / Z));
                if (offZ < 0.0f) {
                    angle = offX < 0.0f ? (angle += 180.0f) : (angle -= 180.0f);
                }
                boolean bl = showDistance = Math.abs(offset = MathHelper.func_76142_g((float)(angle - cameraAngleYaw))) < (float)modMain.getSettings().lookingAtAngle;
                if (modMain.getSettings().lookingAtAngleVertical != 180) {
                    float cameraAnglePitch = entity.field_70125_A;
                    float verticalAngle = (float)Math.toDegrees(Math.asin((double)(-offY) / (distance == 0.0 ? 1.0E-5 : distance)));
                    showDistance = showDistance && Math.abs(verticalAngle - cameraAnglePitch) < (float)modMain.getSettings().lookingAtAngleVertical;
                }
            } else if (modMain.getSettings().distance == 2) {
                showDistance = true;
            }
            if (showDistance) {
                distanceText = GuiMisc.simpleFormat.format(correctDistance) + "m";
                if (!modMain.getSettings().keepWaypointNames) {
                    name = "";
                }
            } else {
                name = "";
            }
        }
        GlStateManager.translatef((float)offX, (float)offY, (float)offZ);
        GL11.glNormal3f((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)(-renderManager.field_78735_i), (float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.rotatef((float)renderManager.field_78732_j, (float)1.0f, (float)0.0f, (float)0.0f);
        GlStateManager.scalef((float)(-f1), (float)(-f1), (float)f1);
        GlStateManager.scalef((float)zoomer2, (float)zoomer2, (float)1.0f);
        GlStateManager.disableLighting();
        GlStateManager.depthMask((boolean)false);
        GlStateManager.disableDepthTest();
        GlStateManager.enableBlend();
        GlStateManager.blendFuncSeparate((int)770, (int)771, (int)1, (int)0);
        GlStateManager.scalef((float)2.0f, (float)2.0f, (float)2.0f);
        this.drawIconInWorld(w, modMain.getSettings(), bufferBuilder, tessellator, fontrenderer, name, distanceText, textSize, showDistance);
        GlStateManager.enableLighting();
        GlStateManager.disableBlend();
        GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        GlStateManager.popMatrix();
    }

    public void drawIconInWorld(Waypoint w, ModSettings settings, BufferBuilder vertexBuffer, Tessellator tessellator, FontRenderer fontrenderer, String name, String distance, float textSize, boolean showDistance) {
        GlStateManager.scaled((double)settings.waypointsScale, (double)settings.waypointsScale, (double)1.0);
        if (w.getType() == 0) {
            int c = ModSettings.COLORS[w.getColor()];
            float l = (float)(c >> 16 & 0xFF) / 255.0f;
            float i1 = (float)(c >> 8 & 0xFF) / 255.0f;
            float j1 = (float)(c & 0xFF) / 255.0f;
            int s = fontrenderer.func_78256_a(w.getSymbol()) / 2;
            GlStateManager.disableTexture();
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            GlStateManager.color4f((float)l, (float)i1, (float)j1, (float)(133.3f * ((float)settings.waypointOpacityIngame / 100.0f) / 255.0f));
            vertexBuffer.func_181662_b(-5.0, -9.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b(-5.0, 0.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b(4.0, 0.0, 0.0).func_181675_d();
            vertexBuffer.func_181662_b(4.0, -9.0, 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.enableTexture();
            fontrenderer.func_211126_b(w.getSymbol(), (float)(-s), -8.0f, 0x20FFFFFF);
            fontrenderer.func_211126_b(w.getSymbol(), (float)(-s), -8.0f, -1);
        } else if (w.getType() == 1) {
            Minecraft.func_71410_x().func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
            float f = 0.00390625f;
            float f1 = 0.00390625f;
            GlStateManager.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)(250.0f * ((float)settings.waypointOpacityIngame / 100.0f) / 255.0f));
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
            vertexBuffer.func_181662_b(-5.0, -9.0, 0.0).func_187315_a(0.0, (double)(78.0f * f1)).func_181675_d();
            vertexBuffer.func_181662_b(-5.0, 0.0, 0.0).func_187315_a(0.0, (double)(87.0f * f1)).func_181675_d();
            vertexBuffer.func_181662_b(4.0, 0.0, 0.0).func_187315_a((double)(9.0f * f), (double)(87.0f * f1)).func_181675_d();
            vertexBuffer.func_181662_b(4.0, -9.0, 0.0).func_187315_a((double)(9.0f * f), (double)(78.0f * f1)).func_181675_d();
            tessellator.func_78381_a();
            if (!showDistance) {
                name = w.getLocalizedName();
                if (!settings.keepWaypointNames) {
                    textSize = 1.0f;
                }
            }
        }
        if (Minecraft.func_71410_x().func_211821_e()) {
            textSize *= 1.5f;
        }
        boolean showingName = name.length() > 0;
        GlStateManager.translatef((float)0.0f, (float)1.0f, (float)0.0f);
        GlStateManager.scalef((float)(textSize / 2.0f), (float)(textSize / 2.0f), (float)1.0f);
        if (distance.length() > 0) {
            int t = fontrenderer.func_78256_a(distance) / 2;
            GlStateManager.disableTexture();
            GlStateManager.color4f((float)0.0f, (float)0.0f, (float)0.0f, (float)0.27450982f);
            vertexBuffer.func_181668_a(7, DefaultVertexFormats.field_181705_e);
            vertexBuffer.func_181662_b((double)(-t) - 1.0, (double)(showingName ? 10 : 0), 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)(-t) - 1.0, 9.0 + (double)(showingName ? 10 : 0), 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)t, 9.0 + (double)(showingName ? 10 : 0), 0.0).func_181675_d();
            vertexBuffer.func_181662_b((double)t, (double)(showingName ? 10 : 0), 0.0).func_181675_d();
            tessellator.func_78381_a();
            GlStateManager.enableTexture();
            fontrenderer.func_211126_b(distance, (float)(-t), (float)(1 + (showingName ? 10 : 0)), 0x20FFFFFF);
            fontrenderer.func_211126_b(distance, (float)(-t), (float)(1 + (showingName ? 10 : 0)), -1);
        }
        if (showingName) {
            int t = fontrenderer.func_78256_a(name) / 2;
            fontrenderer.func_211126_b(name, (float)(-t), 1.0f, 0x20FFFFFF);
            fontrenderer.func_211126_b(name, (float)(-t), 1.0f, -1);
        }
    }
}

