/*
 * Decompiled with CFR 0.152.
 */
package xaero.pvp;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.function.BiConsumer;
import java.util.function.Function;
import net.minecraft.util.ResourceLocation;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.fml.DeferredWorkQueue;
import net.minecraftforge.fml.common.Mod;
import net.minecraftforge.fml.event.lifecycle.FMLClientSetupEvent;
import net.minecraftforge.fml.javafmlmod.FMLJavaModLoadingContext;
import net.minecraftforge.fml.loading.FMLLoader;
import net.minecraftforge.fml.loading.FMLPaths;
import net.minecraftforge.fml.loading.moddiscovery.ModFile;
import net.minecraftforge.fml.network.NetworkRegistry;
import net.minecraftforge.fml.network.simple.SimpleChannel;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import xaero.common.IXaeroMinimap;
import xaero.common.api.spigot.message.MessageWaypoint;
import xaero.common.api.spigot.message.in.InMessageWaypointConsumer;
import xaero.common.api.spigot.message.in.InMessageWaypointDecoder;
import xaero.common.api.spigot.message.in.InMessageWaypointEncoder;
import xaero.common.api.spigot.message.out.OutMessageHandshake;
import xaero.common.api.spigot.message.out.OutMessageWaypoint;
import xaero.common.api.spigot.message.out.OutMessageWaypointDecoder;
import xaero.common.api.spigot.message.out.OutMessageWaypointEncoder;
import xaero.common.controls.ControlsHandler;
import xaero.common.controls.event.KeyEventHandler;
import xaero.common.events.FMLEventHandler;
import xaero.common.events.ForgeEventHandler;
import xaero.common.events.ModEvents;
import xaero.common.gui.GuiHelper;
import xaero.common.gui.widget.WidgetLoadingHandler;
import xaero.common.gui.widget.WidgetScreenHandler;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.waypoints.WaypointSharingHandler;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Internet;
import xaero.common.mods.SupportMods;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.common.validator.FieldValidatorHolder;
import xaero.common.validator.NumericFieldValidator;
import xaero.patreon.Patreon4;
import xaero.patreon.PatreonMod2;
import xaero.pvp.controls.BPVPControlsHandler;
import xaero.pvp.events.BPVPEvents;
import xaero.pvp.events.BPVPFMLEvents;
import xaero.pvp.gui.BPVPGuiHelper;
import xaero.pvp.interfaces.BPVPInterfaceHandler;
import xaero.pvp.interfaces.BPVPInterfaceLoader;
import xaero.pvp.notifications.NotificationHandler;
import xaero.pvp.settings.BPVPModSettings;

@Mod(value="xaerobetterpvp")
public class BetterPVP
implements IXaeroMinimap {
    private static final boolean ENABLED = true;
    public static BetterPVP instance;
    private final Logger LOGGER = LogManager.getLogger();
    private static final String versionID = "1.14.4_20.1.0";
    private int newestUpdateID;
    private boolean isOutdated = true;
    public static String fileLayoutID;
    private String latestVersion;
    public static final File old_optionsFile;
    public static final File oldConfigFile;
    private ModSettings settings;
    private String message = "";
    private ControlsHandler controls;
    private ForgeEventHandler events;
    private FMLEventHandler fmlEvents;
    private InterfaceManager interfaces;
    private InterfaceRenderer interfaceRenderer;
    private GuiHelper guiHelper;
    private SupportMods supportMods;
    public NotificationHandler notifications;
    private WaypointsManager waypointsManager;
    private WaypointSharingHandler waypointSharing;
    private FieldValidatorHolder fieldValidators;
    private WidgetScreenHandler widgetScreenHandler;
    private WidgetLoadingHandler widgetLoader;
    private File modJAR = null;
    private File configFile;
    public File waypointsFile;
    public File waypointsFolder;
    private SimpleChannel network;

    public BetterPVP() {
        instance = this;
        FMLJavaModLoadingContext.get().getModEventBus().addListener(this::loadClient);
        MinecraftForge.EVENT_BUS.register((Object)this);
    }

    private void loadClient(FMLClientSetupEvent event) {
        this.LOGGER.info("Loading Better PVP Mod - Stage 1/2");
        try {
            Path waypointTempToAddFolder;
            ModOptions.init(this);
            ModFile modFile = FMLLoader.getLoadingModList().getModFileById("xaerobetterpvp").getFile();
            String fileName = modFile.getFileName();
            if (fileName.endsWith(".jar")) {
                this.modJAR = modFile.getFilePath().toFile();
            }
            Path config = FMLPaths.CONFIGDIR.get();
            this.waypointsFile = config.resolve("xaerowaypoints.txt").toFile();
            Path wrongWaypointsFolder3 = config.resolve("XaeroWaypoints");
            Path wrongWaypointsFolder2 = this.modJAR != null ? this.modJAR.toPath().getParent().resolve("XaeroWaypoints") : config.getParent().resolve("mods").resolve("XaeroWaypoints");
            this.waypointsFolder = config.getParent().resolve("XaeroWaypoints").toFile();
            if (wrongWaypointsFile.exists() && !this.waypointsFile.exists()) {
                Files.move(wrongWaypointsFile.toPath(), this.waypointsFile.toPath(), new CopyOption[0]);
            }
            if (wrongWaypointsFolder.exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder.toPath(), this.waypointsFolder.toPath(), new CopyOption[0]);
            } else if (wrongWaypointsFolder2.toFile().exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder2, this.waypointsFolder.toPath(), new CopyOption[0]);
            } else if (wrongWaypointsFolder3.toFile().exists() && !this.waypointsFolder.exists()) {
                Files.move(wrongWaypointsFolder3, this.waypointsFolder.toPath(), new CopyOption[0]);
            }
            this.configFile = config.resolve("pvpsettings.txt").toFile();
            if (oldConfigFile.exists() && !this.configFile.getAbsolutePath().equals(oldConfigFile.getAbsolutePath())) {
                Files.move(oldConfigFile.toPath(), this.configFile.toPath(), new CopyOption[0]);
            }
            if (Files.exists(waypointTempToAddFolder = this.waypointsFolder.toPath().resolve("temp_to_add"), new LinkOption[0])) {
                ModSettings.copyTempFilesBack(waypointTempToAddFolder);
            }
            Patreon4.checkPatreon();
            Patreon4.rendersCapes = fileLayoutID;
            this.waypointsManager = new WaypointsManager(this);
            this.waypointSharing = new WaypointSharingHandler(this);
            this.fieldValidators = new FieldValidatorHolder(new NumericFieldValidator());
            this.interfaceRenderer = new InterfaceRenderer(this);
            this.widgetScreenHandler = new WidgetScreenHandler();
            this.widgetLoader = new WidgetLoadingHandler(this.widgetScreenHandler);
            BPVPInterfaceLoader interfaceLoader = new BPVPInterfaceLoader(this);
            this.notifications = new NotificationHandler();
            this.interfaces = new BPVPInterfaceHandler(this, interfaceLoader);
            this.settings = new BPVPModSettings(this);
            this.controls = new BPVPControlsHandler(this);
            if (old_optionsFile.exists() && !this.configFile.exists()) {
                this.configFile.getParentFile().mkdirs();
                Files.move(old_optionsFile.toPath(), this.configFile.toPath(), new CopyOption[0]);
            }
            if (old_waypointsFile.exists() && !this.waypointsFile.exists()) {
                this.waypointsFile.getParentFile().mkdirs();
                Files.move(old_waypointsFile.toPath(), this.waypointsFile.toPath(), new CopyOption[0]);
            }
            ModEvents modEvents = new ModEvents(this);
            modEvents.addListeners(FMLJavaModLoadingContext.get().getModEventBus());
            DeferredWorkQueue.runLater(this::loadLater);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private void loadLater() {
        this.LOGGER.info("Loading Better PVP Mod - Stage 2/2");
        try {
            this.settings.loadSettings();
            this.events = new BPVPEvents(this);
            KeyEventHandler keyEventHandler = new KeyEventHandler();
            this.fmlEvents = new BPVPFMLEvents(this, keyEventHandler);
            Internet.checkModVersion(this);
            if (Patreon4.patronPledge >= 5 && this.isOutdated) {
                this.getPatreon().modJar = this.modJAR;
                this.getPatreon().currentVersion = versionID;
                this.getPatreon().latestVersion = this.latestVersion;
                Patreon4.addOutdatedMod(this.getPatreon());
            }
            MinecraftForge.EVENT_BUS.register((Object)this.events);
            MinecraftForge.EVENT_BUS.register((Object)this.fmlEvents);
            this.guiHelper = new BPVPGuiHelper(this);
            this.supportMods = new SupportMods(this);
            this.network = NetworkRegistry.newSimpleChannel((ResourceLocation)new ResourceLocation("xaerominimap", "spigot_api"), () -> "1.0", s -> true, s -> true);
            this.network.registerMessage(0, MessageWaypoint.class, (BiConsumer)new InMessageWaypointEncoder(), (Function)new InMessageWaypointDecoder(), (BiConsumer)new InMessageWaypointConsumer());
            this.network.registerMessage(1, OutMessageWaypoint.class, new OutMessageWaypointEncoder(), new OutMessageWaypointDecoder(), (a, b) -> {});
            this.network.registerMessage(2, OutMessageHandshake.class, new OutMessageWaypointEncoder(), new OutMessageWaypointDecoder(), (a, b) -> {});
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getVersionsURL() {
        return "http://data.chocolateminecraft.com/Versions/BetterPvPMod.txt";
    }

    @Override
    public String getUpdateLink() {
        return !versionID.endsWith("fair") ? "http://goo.gl/hFLD1u" : "http://goo.gl/r3h9RX";
    }

    @Override
    public File getOldOptionsFile() {
        return old_optionsFile;
    }

    @Override
    public File getOldConfigFile() {
        return oldConfigFile;
    }

    @Override
    public String getFileLayoutID() {
        return fileLayoutID;
    }

    @Override
    public File getConfigFile() {
        return this.configFile;
    }

    @Override
    public File getModJAR() {
        return this.modJAR;
    }

    public BPVPModSettings getBPVPSettings() {
        return (BPVPModSettings)this.settings;
    }

    @Override
    public ModSettings getSettings() {
        return this.settings;
    }

    @Override
    public void setSettings(ModSettings minimapSettings) {
        this.settings = minimapSettings;
    }

    @Override
    public void resetSettings() {
        this.settings = new BPVPModSettings(this);
    }

    @Override
    public ControlsHandler getControls() {
        return this.controls;
    }

    @Override
    public SupportMods getSupportMods() {
        return this.supportMods;
    }

    @Override
    public InterfaceManager getInterfaces() {
        return this.interfaces;
    }

    @Override
    public ForgeEventHandler getEvents() {
        return this.events;
    }

    @Override
    public boolean isOutdated() {
        return this.isOutdated;
    }

    @Override
    public void setOutdated(boolean value) {
        this.isOutdated = value;
    }

    @Override
    public String getMessage() {
        return this.message;
    }

    @Override
    public void setMessage(String string) {
        this.message = string;
    }

    @Override
    public String getLatestVersion() {
        return this.latestVersion;
    }

    @Override
    public void setLatestVersion(String string) {
        this.latestVersion = string;
    }

    @Override
    public int getNewestUpdateID() {
        return this.newestUpdateID;
    }

    @Override
    public void setNewestUpdateID(int parseInt) {
        this.newestUpdateID = parseInt;
    }

    @Override
    public PatreonMod2 getPatreon() {
        return Patreon4.mods.get(fileLayoutID);
    }

    @Override
    public GuiHelper getGuiHelper() {
        return this.guiHelper;
    }

    @Override
    public String getVersionID() {
        return versionID;
    }

    @Override
    public Object getSettingsKey() {
        return BPVPControlsHandler.keyBindSettings;
    }

    @Override
    public File getWaypointsFile() {
        return this.waypointsFile;
    }

    @Override
    public File getWaypointsFolder() {
        return this.waypointsFolder;
    }

    @Override
    public WaypointsManager getWaypointsManager() {
        return this.waypointsManager;
    }

    @Override
    public FieldValidatorHolder getFieldValidators() {
        return this.fieldValidators;
    }

    @Override
    public InterfaceRenderer getInterfaceRenderer() {
        return this.interfaceRenderer;
    }

    @Override
    public SimpleChannel getNetwork() {
        return this.network;
    }

    @Override
    public Logger getLogger() {
        return this.LOGGER;
    }

    @Override
    public WaypointSharingHandler getWaypointSharing() {
        return this.waypointSharing;
    }

    @Override
    public WidgetScreenHandler getWidgetScreenHandler() {
        return this.widgetScreenHandler;
    }

    @Override
    public WidgetLoadingHandler getWidgetLoader() {
        return this.widgetLoader;
    }

    static {
        fileLayoutID = versionID.endsWith("fair") ? "bpvpfair" : "bpvp";
        old_optionsFile = new File("pvpsettings.txt");
        oldConfigFile = new File("config/pvpsettings.txt");
    }
}

