/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import com.google.common.collect.Lists;
import java.io.IOException;
import java.util.ArrayList;
import java.util.function.Function;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.IGuiEventListener;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.TextFieldWidget;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiDropDown;
import xaero.common.gui.GuiWaypointContainers;
import xaero.common.gui.GuiWaypointSets;
import xaero.common.gui.GuiWaypointWorlds;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.IDropDownCallback;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MySuperTinyButton;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.misc.Misc;
import xaero.common.misc.OptimizedMath;
import xaero.common.settings.ModSettings;
import xaero.common.validator.NumericFieldValidator;

public class GuiAddWaypoint
extends Screen
implements IDropDownCallback {
    private IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;
    private Screen parentGuiScreen;
    protected String screenTitle;
    private Button multiplyButton;
    private Button divideButton;
    private TextFieldWidget nameTextField;
    private TextFieldWidget xTextField;
    private TextFieldWidget yTextField;
    private TextFieldWidget zTextField;
    private TextFieldWidget yawTextField;
    private TextFieldWidget initialTextField;
    private String nameText;
    private String xText;
    private String yText;
    private String zText;
    private String yaw;
    private String initial;
    private ArrayList<GuiDropDown> dropDowns;
    private int defaultContainer;
    private WaypointWorld defaultWorld;
    private GuiWaypointContainers containers;
    private GuiWaypointWorlds worlds;
    private GuiWaypointSets sets;
    private GuiDropDown containersDD;
    private GuiDropDown worldsDD;
    private GuiDropDown setsDD;
    private GuiDropDown colorDD;
    private String fromSet;
    private int color;
    private ArrayList<Waypoint> waypointsEdited;
    private boolean dropped;
    private boolean waypointDisabled;
    private MySuperTinyButton disableButton;
    private NumericFieldValidator fieldValidator;
    private boolean keepNameText;
    private boolean keepXTextField;
    private boolean keepYTextField;
    private boolean keepZTextField;
    private boolean keepYawTextField;
    private boolean keepInitialTextField;
    private boolean keepDisabledValue;
    private boolean adding;
    private String namePlaceholder;
    private String xPlaceholder;
    private String yPlaceholder;
    private String zPlaceholder;
    private String yawPlaceholder;
    private String initialPlaceholder;
    private String colorPlaceholder;
    private boolean defaultKeepYawTextField;
    private boolean defaultKeepDisabledValue;
    private Button defaultYawButton;
    private Button defaultDisabledButton;
    private int multiplyDefaultValueBy8Counter;

    public GuiAddWaypoint(IXaeroMinimap modMain, Screen par1GuiScreen, Waypoint point, String defaultParentContainer, WaypointWorld defaultWorld) {
        this(modMain, par1GuiScreen, point == null ? Lists.newArrayList() : Lists.newArrayList((Object[])new Waypoint[]{point}), defaultParentContainer, defaultWorld, point == null || point.getColor() == -1);
    }

    public GuiAddWaypoint(IXaeroMinimap modMain, Screen par1GuiScreen, ArrayList<Waypoint> waypointsEdited, String defaultParentContainer, WaypointWorld defaultWorld, boolean adding) {
        super((ITextComponent)new StringTextComponent(""));
        this.parentGuiScreen = par1GuiScreen;
        this.waypointsEdited = waypointsEdited;
        this.modMain = modMain;
        this.waypointsManager = modMain.getWaypointsManager();
        this.fromSet = defaultWorld.getCurrent();
        this.defaultWorld = defaultWorld;
        this.containers = new GuiWaypointContainers(modMain, this.waypointsManager, defaultParentContainer);
        this.defaultContainer = this.containers.current;
        this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(defaultParentContainer), this.waypointsManager, defaultWorld.getFullId());
        this.sets = new GuiWaypointSets(false, defaultWorld);
        this.nameText = "";
        this.dropDowns = new ArrayList();
        this.initial = "";
        this.yaw = "";
        this.fieldValidator = modMain.getFieldValidators().getNumericFieldValidator();
        this.adding = adding;
        if (waypointsEdited.isEmpty()) {
            this.color = (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1));
        } else if (this.differentValues(Waypoint::getColor)) {
            this.color = 0;
        } else {
            this.color = waypointsEdited.get(0).getColor();
            if (this.color == -1) {
                this.color = (int)(Math.random() * (double)(ModSettings.ENCHANT_COLORS.length - 1));
            }
        }
        String string = this.screenTitle = adding ? I18n.func_135052_a((String)"gui.xaero_new_waypoint", (Object[])new Object[0]) : I18n.func_135052_a((String)"gui.xaero_edit_waypoint", (Object[])new Object[0]);
        if (waypointsEdited.isEmpty()) {
            boolean divideBy8 = this.waypointsManager.divideBy8(this.worlds.getCurrentKeys()[0]);
            Minecraft minecraft = Minecraft.func_71410_x();
            this.xText = "" + OptimizedMath.myFloor(minecraft.field_71439_g.func_226277_ct_()) * (divideBy8 ? 8 : 1);
            this.yText = "" + OptimizedMath.myFloor(minecraft.field_71439_g.func_226278_cu_());
            this.zText = "" + OptimizedMath.myFloor(minecraft.field_71439_g.func_226281_cx_()) * (divideBy8 ? 8 : 1);
        } else {
            this.xText = "";
            this.yText = "";
            this.zText = "";
            this.keepNameText = this.differentValues(Waypoint::getName);
            this.keepXTextField = this.differentValues(Waypoint::getX);
            this.keepYTextField = this.differentValues(Waypoint::getY);
            this.keepZTextField = this.differentValues(Waypoint::getZ);
            this.keepYawTextField = this.differentValues(Waypoint::isRotation) || GuiWaypoints.allWaypointsAre(waypointsEdited, Waypoint::isRotation) && this.differentValues(Waypoint::getYaw);
            this.defaultKeepYawTextField = this.keepYawTextField;
            this.keepInitialTextField = this.differentValues(Waypoint::getSymbol);
            this.defaultKeepDisabledValue = this.keepDisabledValue = this.differentValues(Waypoint::isDisabled);
            Waypoint firstWaypoint = waypointsEdited.get(0);
            if (!this.keepNameText) {
                this.nameText = firstWaypoint.getLocalizedName();
            }
            if (!this.keepXTextField) {
                this.xText = firstWaypoint.getX() + "";
            }
            if (!this.keepYTextField) {
                this.yText = firstWaypoint.getY() + "";
            }
            if (!this.keepZTextField) {
                this.zText = firstWaypoint.getZ() + "";
            }
            if (!this.keepYawTextField && firstWaypoint.isRotation()) {
                this.yaw = firstWaypoint.getYaw() + "";
            }
            if (!this.keepInitialTextField) {
                this.initial = firstWaypoint.getSymbol() + "";
            }
            if (!this.keepDisabledValue) {
                this.waypointDisabled = firstWaypoint.isDisabled();
            }
        }
        this.namePlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_waypoint_name", (Object[])new Object[0]);
        this.xPlaceholder = "\u00a78- x";
        this.yPlaceholder = "\u00a78- y";
        this.zPlaceholder = "\u00a78- z";
        this.yawPlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]);
        this.initialPlaceholder = "\u00a78- " + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]);
        this.colorPlaceholder = "\u00a78-";
    }

    private boolean differentValues(Function<Waypoint, Object> s) {
        if (this.waypointsEdited.isEmpty()) {
            return false;
        }
        Waypoint testWaypoint = this.waypointsEdited.get(0);
        for (Waypoint w : this.waypointsEdited) {
            if (s.apply(w).equals(s.apply(testWaypoint))) continue;
            return true;
        }
        return false;
    }

    public String[] createColorOptions() {
        boolean unchangedOption = this.differentValues(Waypoint::getColor);
        String[] options = new String[ModSettings.ENCHANT_COLOR_NAMES.length + (unchangedOption ? 1 : 0)];
        if (unchangedOption) {
            options[0] = this.colorPlaceholder;
        }
        for (int i = 0; i < ModSettings.ENCHANT_COLOR_NAMES.length; ++i) {
            options[i + (unchangedOption ? 1 : 0)] = i == 0 ? I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]) : "\u00a7" + ModSettings.ENCHANT_COLORS[i] + I18n.func_135052_a((String)ModSettings.ENCHANT_COLOR_NAMES[i], (Object[])new Object[0]);
        }
        return options;
    }

    public void init() {
        super.init();
        this.modMain.getInterfaces().setSelectedId(-1);
        this.modMain.getInterfaces().setDraggingId(-1);
        this.nameTextField = new TextFieldWidget(this.font, this.width / 2 - 100, 104, 200, 20, I18n.func_135052_a((String)"gui.xaero_waypoint_name", (Object[])new Object[0]));
        this.xTextField = new TextFieldWidget(this.font, this.width / 2 - 109, 134, 50, 20, "x");
        this.yTextField = new TextFieldWidget(this.font, this.width / 2 - 53, 134, 50, 20, "y");
        this.zTextField = new TextFieldWidget(this.font, this.width / 2 + 3, 134, 50, 20, "z");
        this.yawTextField = new TextFieldWidget(this.font, this.width / 2 + 59, 134, 50, 20, I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]));
        this.initialTextField = new TextFieldWidget(this.font, this.width / 2 - 25, 164, 50, 20, I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]));
        this.children.add(this.nameTextField);
        this.children.add(this.xTextField);
        this.children.add(this.yTextField);
        this.children.add(this.zTextField);
        this.children.add(this.yawTextField);
        this.children.add(this.initialTextField);
        this.addButton((Widget)new MySmallButton(0, this.width / 2 - 155, this.height / 6 + 168, I18n.func_135052_a((String)"gui.xaero_confirm", (Object[])new Object[0]), b -> {
            boolean creatingAWaypoint;
            int x = this.keepXTextField || this.xTextField.func_146179_b().equals("-") ? 0 : Integer.parseInt(this.xTextField.func_146179_b());
            int y = this.keepYTextField || this.yTextField.func_146179_b().equals("-") ? 0 : Integer.parseInt(this.yTextField.func_146179_b());
            int z = this.keepZTextField || this.zTextField.func_146179_b().equals("-") ? 0 : Integer.parseInt(this.zTextField.func_146179_b());
            String name = this.nameTextField.func_146179_b();
            boolean bl = creatingAWaypoint = this.adding && this.waypointsEdited.isEmpty();
            if (creatingAWaypoint) {
                Waypoint created = new Waypoint(x, y, z, name, this.initial, this.color);
                this.waypointsEdited.add(created);
            } else {
                for (Waypoint w : this.waypointsEdited) {
                    if (!this.keepNameText) {
                        w.setName(name);
                    }
                    if (!this.keepXTextField) {
                        w.setX(x);
                    }
                    if (!this.keepYTextField) {
                        w.setY(y);
                    }
                    if (!this.keepZTextField) {
                        w.setZ(z);
                    }
                    if (!this.keepInitialTextField) {
                        w.setSymbol(this.initial);
                    }
                    if (this.colorDD.size() > ModSettings.ENCHANT_COLOR_NAMES.length) {
                        if (this.color == 0) continue;
                        w.setColor(this.color - 1);
                        continue;
                    }
                    w.setColor(this.color);
                }
            }
            boolean yawIsUsable = this.yaw.length() > 0 && !this.yaw.equals("-");
            int yawInt = yawIsUsable ? Integer.parseInt(this.yaw) : 0;
            for (Waypoint w : this.waypointsEdited) {
                w.setX(this.applyDefaultMultiplier(w.getX()));
                w.setZ(this.applyDefaultMultiplier(w.getZ()));
                if (!this.keepDisabledValue) {
                    w.setDisabled(this.waypointDisabled);
                }
                if (this.keepYawTextField) continue;
                w.setRotation(yawIsUsable);
                if (!yawIsUsable) continue;
                w.setYaw(yawInt);
            }
            WaypointWorld sourceWorld = this.defaultWorld;
            WaypointSet sourceSet = sourceWorld.getSets().get(this.fromSet);
            String[] destinationWorldKeys = this.worlds.getCurrentKeys();
            String destinationSetKey = this.sets.getCurrentSetKey();
            WaypointWorld destinationWorld = this.waypointsManager.getWorld(destinationWorldKeys[0], destinationWorldKeys[1]);
            WaypointSet destinationSet = destinationWorld.getSets().get(destinationSetKey);
            if (this.adding || sourceSet != destinationSet) {
                destinationSet.getList().addAll(0, this.waypointsEdited);
            }
            if (sourceSet != destinationSet) {
                sourceSet.getList().removeAll(this.waypointsEdited);
            }
            try {
                this.modMain.getSettings().saveWaypoints(sourceWorld);
                if (destinationWorld != sourceWorld) {
                    this.modMain.getSettings().saveWaypoints(destinationWorld);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.minecraft.func_147108_a(this.parentGuiScreen);
        }));
        this.addButton((Widget)new MySmallButton(0, this.width / 2 + 5, this.height / 6 + 168, I18n.func_135052_a((String)"gui.xaero_cancel", (Object[])new Object[0]), b -> this.minecraft.func_147108_a(this.parentGuiScreen)));
        this.multiplyButton = new MySuperTinyButton(this.width / 2 - 165, 121, I18n.func_135052_a((String)"* 8", (Object[])new Object[0]), b -> {
            ++this.multiplyDefaultValueBy8Counter;
            this.updateMultiplyButtons();
        });
        this.addButton((Widget)this.multiplyButton);
        this.divideButton = new MySuperTinyButton(this.width / 2 - 165, 147, I18n.func_135052_a((String)"/ 8", (Object[])new Object[0]), b -> {
            --this.multiplyDefaultValueBy8Counter;
            this.updateMultiplyButtons();
        });
        this.addButton((Widget)this.divideButton);
        this.nameTextField.func_146180_a(this.nameText);
        this.xTextField.func_146180_a(this.xText);
        this.yTextField.func_146180_a(this.yText);
        this.zTextField.func_146180_a(this.zText);
        this.yawTextField.func_146180_a(this.yaw);
        this.initialTextField.func_146180_a(this.initial);
        String[] enabledisable = I18n.func_135052_a((String)"gui.xaero_disable_enable", (Object[])new Object[0]).split("/");
        this.disableButton = new MySuperTinyButton(this.width / 2 + 31, 164, enabledisable[this.waypointDisabled ? 1 : 0], b -> {
            this.waypointDisabled = !this.waypointDisabled;
            this.disableButton.setMessage(this.waypointDisabled ? enabledisable[1] : enabledisable[0]);
            this.keepDisabledValue = false;
            if (this.defaultDisabledButton != null) {
                this.defaultDisabledButton.active = true;
            }
        });
        this.addButton((Widget)this.disableButton);
        if (this.defaultKeepYawTextField) {
            this.defaultYawButton = new Button(this.width / 2 + 111, 134, 20, 20, "-", b -> {
                this.keepYawTextField = this.defaultKeepYawTextField;
                this.yaw = "";
                this.yawTextField.func_146180_a(this.yaw);
                b.active = false;
            });
            this.addButton((Widget)this.defaultYawButton);
            boolean bl = this.defaultYawButton.active = !this.keepYawTextField;
        }
        if (this.defaultKeepDisabledValue) {
            this.defaultDisabledButton = new Button(this.width / 2 + 81, 164, 20, 20, "-", b -> {
                this.keepDisabledValue = this.defaultKeepDisabledValue;
                this.waypointDisabled = false;
                this.disableButton.setMessage(this.waypointDisabled ? enabledisable[1] : enabledisable[0]);
                b.active = false;
            });
            this.addButton((Widget)this.defaultDisabledButton);
            this.defaultDisabledButton.active = !this.keepDisabledValue;
        }
        this.dropDowns.clear();
        this.colorDD = new GuiDropDown(this.createColorOptions(), this.width / 2 - 60, 82, 120, this.color, this);
        this.dropDowns.add(this.colorDD);
        this.setsDD = new GuiDropDown(this.sets.getOptions(), this.width / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
        this.dropDowns.add(this.setsDD);
        this.containersDD = new GuiDropDown(this.containers.options, this.width / 2 - 203, 38, 200, this.containers.current, this);
        this.dropDowns.add(this.containersDD);
        this.worldsDD = new GuiDropDown(this.worlds.options, this.width / 2 + 2, 38, 200, this.worlds.current, this);
        this.dropDowns.add(this.worldsDD);
        this.setFocused((IGuiEventListener)this.nameTextField);
        this.nameTextField.func_146195_b(true);
        this.minecraft.field_195559_v.func_197967_a(true);
        this.updateConfirmButton();
    }

    private void updateMultiplyButtons() {
        this.multiplyButton.active = this.multiplyDefaultValueBy8Counter < 1;
        this.divideButton.active = this.multiplyDefaultValueBy8Counter > -1;
    }

    private int applyDefaultMultiplier(int x) {
        block3: {
            block2: {
                if (this.multiplyDefaultValueBy8Counter <= 0) break block2;
                for (int i = 0; i < this.multiplyDefaultValueBy8Counter; ++i) {
                    x *= 8;
                }
                break block3;
            }
            if (this.multiplyDefaultValueBy8Counter >= 0) break block3;
            for (int i = 0; i < -this.multiplyDefaultValueBy8Counter; ++i) {
                x = (int)Math.floor((double)x * 0.125);
            }
        }
        return x;
    }

    public void removed() {
        this.minecraft.field_195559_v.func_197967_a(false);
    }

    public boolean keyPressed(int par1, int par2, int par3) {
        IGuiEventListener focused = this.getFocused();
        this.preType(focused);
        boolean result = super.keyPressed(par1, par2, par3);
        this.postType(focused);
        if (focused instanceof TextFieldWidget && this.canConfirm() && (par1 == 257 || par1 == 335)) {
            ((Widget)this.buttons.get(0)).onClick(0.0, 0.0);
        }
        return result;
    }

    public boolean charTyped(char par1, int par2) {
        IGuiEventListener focused = this.getFocused();
        this.preType(focused);
        boolean result = super.charTyped(par1, par2);
        this.postType(focused);
        return result;
    }

    private void preType(IGuiEventListener focused) {
        if (focused == null) {
            return;
        }
    }

    private void postType(IGuiEventListener focused) {
        if (focused == null) {
            return;
        }
        if (this.nameTextField == focused) {
            if (this.initial.length() == 0 && this.nameTextField.func_146179_b().length() > 0 && !this.keepInitialTextField) {
                this.initialTextField.func_146180_a(this.nameTextField.func_146179_b().substring(0, 1));
            }
        } else if (this.yawTextField == focused) {
            this.fieldValidator.validate(this.yawTextField);
            this.keepYawTextField = false;
            if (this.defaultYawButton != null) {
                this.defaultYawButton.active = true;
            }
        }
        this.checkFields();
        this.updateConfirmButton();
    }

    public void setFocused(IGuiEventListener l) {
        this.preType(l);
        IGuiEventListener currentFocused = this.getFocused();
        if (currentFocused != null && currentFocused != l && currentFocused instanceof TextFieldWidget) {
            ((TextFieldWidget)currentFocused).func_146195_b(false);
        }
        super.setFocused(l);
    }

    private boolean canConfirm() {
        return !(!this.keepNameText && this.nameTextField.func_146179_b().length() <= 0 || !this.keepInitialTextField && this.initial.length() <= 0 || !this.keepXTextField && this.xTextField.func_146179_b().length() <= 0 || !this.keepYTextField && this.yTextField.func_146179_b().length() <= 0 || !this.keepZTextField && this.zTextField.func_146179_b().length() <= 0);
    }

    private void updateConfirmButton() {
        ((Button)this.buttons.get((int)0)).active = this.canConfirm();
    }

    protected void checkFields() {
        this.fieldValidator.validate(this.xTextField);
        this.fieldValidator.validate(this.yTextField);
        this.fieldValidator.validate(this.zTextField);
        this.nameText = this.nameTextField.func_146179_b();
        this.xText = this.xTextField.func_146179_b();
        this.yText = this.yTextField.func_146179_b();
        this.zText = this.zTextField.func_146179_b();
        this.yaw = this.yawTextField.func_146179_b();
        this.initial = this.initialTextField.func_146179_b();
        this.initial = this.initial.toUpperCase();
        if (this.initial.length() > 1) {
            this.initial = this.initial.substring(0, 1);
            this.initialTextField.func_146180_a(this.initial);
        }
        if (this.yaw.length() > 4) {
            this.yaw = this.yaw.substring(0, 4);
            this.yawTextField.func_146180_a(this.yaw);
        }
        if (this.waypointsEdited.size() > 1) {
            this.keepNameText = this.nameText.isEmpty();
            this.keepXTextField = this.xText.isEmpty();
            this.keepYTextField = this.yText.isEmpty();
            this.keepZTextField = this.zText.isEmpty();
            this.keepInitialTextField = this.initial.isEmpty();
        }
    }

    public boolean mouseClicked(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            if (!d.isClosed() && d.onDropDown((int)par1, (int)par2, this.height)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.height);
                return true;
            }
            d.setClosed(true);
        }
        for (GuiDropDown d : this.dropDowns) {
            if (d.onDropDown((int)par1, (int)par2, this.height)) {
                d.mouseClicked((int)par1, (int)par2, par3, this.height);
                return true;
            }
            d.setClosed(true);
        }
        return super.mouseClicked(par1, par2, par3);
    }

    public boolean mouseReleased(double par1, double par2, int par3) {
        for (GuiDropDown d : this.dropDowns) {
            d.mouseReleased((int)par1, (int)par2, par3, this.height);
        }
        return super.mouseReleased(par1, par2, par3);
    }

    private void setFieldText(TextFieldWidget field, String text) {
        if (field.func_146179_b().equals(text)) {
            return;
        }
        field.func_146180_a(text);
    }

    public void tick() {
        if (this.minecraft.field_71439_g == null) {
            this.minecraft.func_147108_a(null);
            return;
        }
        this.nameTextField.func_146178_a();
        this.xTextField.func_146178_a();
        this.yTextField.func_146178_a();
        this.zTextField.func_146178_a();
        this.yawTextField.func_146178_a();
        this.initialTextField.func_146178_a();
    }

    public void render(int par1, int par2, float par3) {
        this.renderBackground();
        this.drawCenteredString(this.font, this.screenTitle, this.width / 2, 20, 0xFFFFFF);
        if (!this.nameTextField.isFocused() && this.keepNameText) {
            this.setFieldText(this.nameTextField, this.namePlaceholder);
        }
        if (!this.xTextField.isFocused()) {
            if (this.keepXTextField) {
                this.setFieldText(this.xTextField, this.xPlaceholder);
            }
            if (this.multiplyDefaultValueBy8Counter > 0) {
                this.setFieldText(this.xTextField, this.xTextField.func_146179_b() + "\u00a7" + "8 * 8");
            } else if (this.multiplyDefaultValueBy8Counter < 0) {
                this.setFieldText(this.xTextField, this.xTextField.func_146179_b() + "\u00a7" + "8 / 8");
            }
        }
        if (!this.yTextField.isFocused() && this.keepYTextField) {
            this.setFieldText(this.yTextField, this.yPlaceholder);
        }
        if (!this.zTextField.isFocused()) {
            if (this.keepZTextField) {
                this.setFieldText(this.zTextField, this.zPlaceholder);
            }
            if (this.multiplyDefaultValueBy8Counter > 0) {
                this.setFieldText(this.zTextField, this.zTextField.func_146179_b() + "\u00a7" + "8 * 8");
            } else if (this.multiplyDefaultValueBy8Counter < 0) {
                this.setFieldText(this.zTextField, this.zTextField.func_146179_b() + "\u00a7" + "8 / 8");
            }
        }
        if (!this.yawTextField.isFocused() && this.yaw.isEmpty()) {
            if (this.keepYawTextField) {
                this.setFieldText(this.yawTextField, this.yawPlaceholder);
            } else {
                this.setFieldText(this.yawTextField, "\u00a78" + I18n.func_135052_a((String)"gui.xaero_yaw", (Object[])new Object[0]));
            }
        }
        if (!this.initialTextField.isFocused() && this.initial.isEmpty()) {
            if (this.keepInitialTextField) {
                this.setFieldText(this.initialTextField, this.initialPlaceholder);
            } else {
                this.setFieldText(this.initialTextField, "\u00a78" + I18n.func_135052_a((String)"gui.xaero_initial", (Object[])new Object[0]));
            }
        }
        this.nameTextField.render(par1, par2, par3);
        this.xTextField.render(par1, par2, par3);
        this.yTextField.render(par1, par2, par3);
        this.zTextField.render(par1, par2, par3);
        this.yawTextField.render(par1, par2, par3);
        this.initialTextField.render(par1, par2, par3);
        this.setFieldText(this.nameTextField, this.nameText);
        this.setFieldText(this.xTextField, this.xText);
        this.setFieldText(this.yTextField, this.yText);
        this.setFieldText(this.zTextField, this.zText);
        this.setFieldText(this.yawTextField, this.yaw);
        this.setFieldText(this.initialTextField, this.initial);
        if (this.dropped) {
            super.render(0, 0, par3);
        } else {
            super.render(par1, par2, par3);
        }
        this.dropped = false;
        GuiDropDown openDropdown = null;
        for (int k = 0; k < this.dropDowns.size(); ++k) {
            GuiDropDown dropdown = this.dropDowns.get(k);
            if (!dropdown.isClosed()) {
                this.dropped = true;
                openDropdown = dropdown;
                continue;
            }
            dropdown.drawButton(par1, par2, this.height);
        }
        if (openDropdown != null) {
            openDropdown.drawButton(par1, par2, this.height);
        }
    }

    public boolean mouseScrolled(double p_mouseScrolled_1_, double p_mouseScrolled_3_, double wheel) {
        if ((int)wheel != 0) {
            int mouseXScaled = (int)(Misc.getMouseX(Minecraft.func_71410_x()) / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
            int mouseYScaled = (int)(Misc.getMouseY(Minecraft.func_71410_x()) / Minecraft.func_71410_x().func_228018_at_().func_198100_s());
            for (GuiDropDown d : this.dropDowns) {
                if (d.isClosed() || !d.onDropDown(mouseXScaled, mouseYScaled, this.height)) continue;
                d.mouseScrolled((int)wheel, mouseXScaled, mouseYScaled, this.height);
                return true;
            }
        }
        return super.mouseScrolled(p_mouseScrolled_1_, p_mouseScrolled_3_, wheel);
    }

    @Override
    public void onSelected(GuiDropDown menu, int selected) {
        if (menu == this.setsDD) {
            this.sets.setCurrentSet(selected);
            if (this.waypointsManager.getCurrentContainerAndWorldID().equals(this.worlds.getCurrentKey())) {
                this.waypointsManager.getCurrentWorld().setCurrent(this.sets.getCurrentSetKey());
                this.waypointsManager.updateWaypoints();
                try {
                    this.modMain.getSettings().saveWaypoints(this.waypointsManager.getCurrentWorld());
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        } else if (menu == this.colorDD) {
            this.color = selected;
        } else if (menu == this.containersDD) {
            this.containers.current = selected;
            WaypointWorld currentWorld = this.containers.current != this.defaultContainer ? this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()).getFirstWorld() : this.defaultWorld;
            this.sets = new GuiWaypointSets(false, currentWorld);
            this.worlds = new GuiWaypointWorlds(this.waypointsManager.getWorldContainer(this.containers.getCurrentKey()), this.waypointsManager, currentWorld.getFullId());
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.width / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
            this.dropDowns.set(1, this.setsDD);
            this.worldsDD = new GuiDropDown(this.worlds.options, this.width / 2 + 2, 38, 200, this.worlds.current, this);
            this.dropDowns.set(3, this.worldsDD);
        } else if (menu == this.worldsDD) {
            this.worlds.current = selected;
            String[] worldKeys = this.worlds.getCurrentKeys();
            this.sets = new GuiWaypointSets(false, this.waypointsManager.getWorld(worldKeys[0], worldKeys[1]));
            this.setsDD = new GuiDropDown(this.sets.getOptions(), this.width / 2 - 101, 60, 201, this.sets.getCurrentSet(), this);
            this.dropDowns.set(1, this.setsDD);
        }
    }
}

