/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.gui;

import java.io.File;
import java.io.IOException;
import java.nio.file.CopyOption;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.gui.widget.Widget;
import net.minecraft.client.gui.widget.button.Button;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.TranslationTextComponent;
import org.apache.commons.io.FileUtils;
import xaero.common.IXaeroMinimap;
import xaero.common.graphics.CursorBox;
import xaero.common.gui.GuiTransfer;
import xaero.common.gui.GuiWaypoints;
import xaero.common.gui.GuiWorldTpCommand;
import xaero.common.gui.MySmallButton;
import xaero.common.gui.MyTinyButton;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointSet;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.waypoints.WaypointsSort;
import xaero.common.settings.ModSettings;

public class GuiWaypointsOptions
extends Screen {
    Screen parent;
    private IXaeroMinimap modMain;
    private WaypointsManager waypointsManager;
    private MySmallButton automaticButton;
    private MySmallButton subAutomaticButton;
    private MySmallButton deleteButton;
    private MySmallButton subDeleteButton;
    private boolean buttonTest;
    private WaypointWorld waypointWorld;
    private boolean teleportationOptionShown;
    public CursorBox mwTooltip = new CursorBox("gui.xaero_use_multiworld_tooltip");
    public CursorBox teleportationTooltip = new CursorBox("gui.xaero_teleportation_tooltip", "\u00a7c");

    public GuiWaypointsOptions(IXaeroMinimap modMain, Screen parent, WaypointWorld waypointWorld) {
        super((ITextComponent)new TranslationTextComponent("gui.xaero_options", new Object[0]));
        this.parent = parent;
        this.modMain = modMain;
        this.waypointsManager = modMain.getWaypointsManager();
        this.waypointWorld = waypointWorld;
        this.teleportationOptionShown = waypointWorld.getContainer().getRootContainer().isTeleportationEnabled();
    }

    public void init() {
        super.init();
        this.parent.resize(this.minecraft, this.width, this.height);
        this.addButton((Widget)new MyTinyButton(this.width / 2 - 203, 32, I18n.func_135052_a((String)"gui.xaero_close", (Object[])new Object[0]), b -> this.actionPerformed(b, 5)));
        this.addButton((Widget)new MySmallButton(6, this.width / 2 - 203, 57, I18n.func_135052_a((String)"gui.xaero_transfer", (Object[])new Object[0]), b -> this.actionPerformed(b, 6)));
        this.automaticButton = new MySmallButton(7, this.width / 2 - 203, 82, I18n.func_135052_a((String)"gui.xaero_make_automatic", (Object[])new Object[0]), b -> this.actionPerformed(b, 7));
        this.addButton((Widget)this.automaticButton);
        this.subAutomaticButton = new MySmallButton(8, this.width / 2 - 203, 107, I18n.func_135052_a((String)"gui.xaero_make_multi_automatic", (Object[])new Object[0]), b -> this.actionPerformed(b, 8));
        this.addButton((Widget)this.subAutomaticButton);
        this.deleteButton = new MySmallButton(9, this.width / 2 - 203, 132, I18n.func_135052_a((String)"gui.xaero_delete_world", (Object[])new Object[0]), b -> this.actionPerformed(b, 9));
        this.addButton((Widget)this.deleteButton);
        this.subDeleteButton = new MySmallButton(10, this.width / 2 - 203, 157, I18n.func_135052_a((String)"gui.xaero_delete_multi_world", (Object[])new Object[0]), b -> this.actionPerformed(b, 10));
        this.addButton((Widget)this.subDeleteButton);
        this.addButton((Widget)new MySmallButton(11, this.width / 2 - 203, 182, I18n.func_135052_a((String)"gui.xaero_multiply_all_by_8", (Object[])new Object[0]), b -> this.actionPerformed(b, 11)));
        this.addButton((Widget)new MySmallButton(12, this.width / 2 - 203, 207, I18n.func_135052_a((String)"gui.xaero_divide_all_by_8", (Object[])new Object[0]), b -> this.actionPerformed(b, 12)));
        this.addButton((Widget)new MySmallButton(200, this.width / 2 + 53, 57, this.getConfigButtonName(0), b -> this.onConfigButtonClick((MySmallButton)b)));
        MySmallButton teleportationEnabledButton = (MySmallButton)this.addButton((Widget)new MySmallButton(201, this.width / 2 + 53, 82, this.getConfigButtonName(1), b -> this.onConfigButtonClick((MySmallButton)b)));
        teleportationEnabledButton.active = this.teleportationOptionShown;
        this.addButton((Widget)new MySmallButton(13, this.width / 2 + 53, 107, I18n.func_135052_a((String)"gui.xaero_world_teleport_command", (Object[])new Object[0]), b -> this.actionPerformed(b, 13)));
        this.addButton((Widget)new MySmallButton(14, this.width / 2 + 53, 157, I18n.func_135052_a((String)"gui.xaero_sort", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)GuiWaypoints.sortType.optionName, (Object[])new Object[0]), b -> this.actionPerformed(b, 14)));
        this.addButton((Widget)new MySmallButton(15, this.width / 2 + 53, 182, I18n.func_135052_a((String)"gui.xaero_sort_reversed", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(GuiWaypoints.reversedOrder), b -> this.actionPerformed(b, 15)));
    }

    private String getConfigButtonName(int buttonId) {
        switch (buttonId) {
            case 0: {
                return I18n.func_135052_a((String)"gui.xaero_use_multiworld", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.waypointWorld.getContainer().getRootContainer().isUsingMultiworldDetection());
            }
            case 1: {
                return I18n.func_135052_a((String)"gui.xaero_teleportation", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(this.waypointWorld.getContainer().getRootContainer().isTeleportationEnabled());
            }
        }
        return "";
    }

    private void onConfigButtonClick(MySmallButton button) {
        this.buttonTest = true;
        WaypointWorldRootContainer wc = this.waypointWorld.getContainer().getRootContainer();
        switch (button.getId() - 200) {
            case 0: {
                wc.setUsingMultiworldDetection(!this.waypointWorld.getContainer().getRootContainer().isUsingMultiworldDetection());
                wc.setDefaultMultiworldId(null);
                break;
            }
            case 1: {
                wc.setTeleportationEnabled(!wc.isTeleportationEnabled());
            }
        }
        wc.saveConfig();
        button.setMessage(this.getConfigButtonName(button.getId() - 200));
    }

    public boolean mouseClicked(double par1, double par2, int par3) {
        this.buttonTest = false;
        boolean toReturn = super.mouseClicked(par1, par2, par3);
        if (!this.buttonTest) {
            this.minecraft.func_147108_a(this.parent);
        }
        return toReturn;
    }

    protected void actionPerformed(Button p_146284_1_, int id) {
        this.buttonTest = true;
        if (p_146284_1_.active) {
            switch (id) {
                case 5: {
                    this.minecraft.func_147108_a(this.parent);
                    break;
                }
                case 6: {
                    this.minecraft.func_147108_a((Screen)new GuiTransfer(this.modMain, this.parent));
                    break;
                }
                case 7: {
                    this.minecraft.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_make_automatic_msg1", new Object[0]), (ITextComponent)new TranslationTextComponent("gui.xaero_make_automatic_msg2", new Object[0])));
                    break;
                }
                case 8: {
                    this.minecraft.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_make_multi_automatic_msg1", new Object[0]), (ITextComponent)new TranslationTextComponent("gui.xaero_make_multi_automatic_msg2", new Object[0])));
                    break;
                }
                case 9: {
                    this.minecraft.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_delete_world_msg1", new Object[0]), (ITextComponent)new TranslationTextComponent("gui.xaero_delete_world_msg2", new Object[0])));
                    break;
                }
                case 10: {
                    this.minecraft.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_delete_multi_world_msg1", new Object[0]), (ITextComponent)new TranslationTextComponent("gui.xaero_delete_multi_world_msg2", new Object[0])));
                    break;
                }
                case 11: {
                    this.minecraft.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_multiply_msg1", new Object[0]), (ITextComponent)new TranslationTextComponent("gui.xaero_multiply_msg2", new Object[0])));
                    break;
                }
                case 12: {
                    this.minecraft.func_147108_a((Screen)new ConfirmScreen(result -> this.confirmResult(result, id), (ITextComponent)new TranslationTextComponent("gui.xaero_multiply_msg1", new Object[0]), (ITextComponent)new TranslationTextComponent("gui.xaero_divide_msg2", new Object[0])));
                    break;
                }
                case 13: {
                    this.minecraft.func_147108_a((Screen)new GuiWorldTpCommand(this.modMain, this, this.waypointWorld));
                    break;
                }
                case 14: {
                    GuiWaypoints.sortType = WaypointsSort.values()[(GuiWaypoints.sortType.ordinal() + 1) % WaypointsSort.values().length];
                    p_146284_1_.setMessage(I18n.func_135052_a((String)"gui.xaero_sort", (Object[])new Object[0]) + ": " + I18n.func_135052_a((String)GuiWaypoints.sortType.optionName, (Object[])new Object[0]));
                    this.parent.init(this.minecraft, this.width, this.height);
                    break;
                }
                case 15: {
                    GuiWaypoints.reversedOrder = !GuiWaypoints.reversedOrder;
                    p_146284_1_.setMessage(I18n.func_135052_a((String)"gui.xaero_sort_reversed", (Object[])new Object[0]) + ": " + ModSettings.getTranslation(GuiWaypoints.reversedOrder));
                    this.parent.init(this.minecraft, this.width, this.height);
                }
            }
        }
    }

    public void confirmResult(boolean result, int id) {
        block27: {
            if (!result) break block27;
            switch (id) {
                case 7: {
                    WaypointWorldRootContainer selected = this.waypointWorld.getContainer().getRootContainer();
                    WaypointWorldContainer auto = this.waypointsManager.getWaypointMap().get(this.waypointsManager.getAutoRootContainerID());
                    if (selected == null || auto == null) break;
                    String buKey = selected.getKey();
                    this.waypointsManager.getWaypointMap().put(auto.getKey(), selected);
                    this.waypointsManager.getWaypointMap().put(buKey, auto);
                    selected.setKey(auto.getKey());
                    auto.setKey(buKey);
                    Path selectedPath = selected.getDirectory().toPath();
                    Path autoPath = auto.getDirectory().toPath();
                    Path tempFolder = this.modMain.getWaypointsFolder().toPath().resolve("temp_to_add");
                    try {
                        Files.createDirectories(tempFolder, new FileAttribute[0]);
                        Path selectedTemp = tempFolder.resolve(selectedPath.getFileName());
                        Path autoTemp = tempFolder.resolve(autoPath.getFileName());
                        if (Files.exists(selectedPath, new LinkOption[0])) {
                            Files.move(selectedPath, selectedTemp, new CopyOption[0]);
                        }
                        if (Files.exists(autoPath, new LinkOption[0])) {
                            Files.move(autoPath, autoTemp, new CopyOption[0]);
                        }
                        if (Files.exists(selectedTemp, new LinkOption[0])) {
                            Files.move(selectedTemp, autoPath, new CopyOption[0]);
                        }
                        if (Files.exists(autoTemp, new LinkOption[0])) {
                            Files.move(autoTemp, selectedPath, new CopyOption[0]);
                        }
                        Files.deleteIfExists(tempFolder);
                    }
                    catch (Throwable e) {
                        this.modMain.getInterfaces().getMinimap().setCrashedWith(e);
                    }
                    this.waypointsManager.setCustomWorldID(null);
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.updateWaypoints();
                    break;
                }
                case 8: {
                    WaypointWorld autoWorld = this.waypointsManager.getAutoWorld();
                    WaypointWorld selectedWorld = this.waypointWorld;
                    try {
                        Path autoFile = this.modMain.getSettings().getWaypointsFile(autoWorld).toPath();
                        Path selectedFile = this.modMain.getSettings().getWaypointsFile(selectedWorld).toPath();
                        Path autoTempFile = autoFile.getParent().resolve("temp_to_add").resolve(autoFile.getFileName());
                        Path selectedTempFile = selectedFile.getParent().resolve("temp_to_add").resolve(selectedFile.getFileName());
                        Files.createDirectories(autoTempFile.getParent(), new FileAttribute[0]);
                        Files.createDirectories(selectedTempFile.getParent(), new FileAttribute[0]);
                        if (!Files.exists(autoFile, new LinkOption[0])) {
                            Files.createFile(autoFile, new FileAttribute[0]);
                        }
                        Files.move(autoFile, autoTempFile, new CopyOption[0]);
                        if (!Files.exists(selectedFile, new LinkOption[0])) {
                            Files.createFile(selectedFile, new FileAttribute[0]);
                        }
                        Files.move(selectedFile, selectedTempFile, new CopyOption[0]);
                        if (Files.exists(autoTempFile, new LinkOption[0])) {
                            Files.move(autoTempFile, selectedFile, new CopyOption[0]);
                        }
                        if (Files.exists(selectedTempFile, new LinkOption[0])) {
                            Files.move(selectedTempFile, autoFile, new CopyOption[0]);
                        }
                        Files.deleteIfExists(autoTempFile.getParent());
                        Files.deleteIfExists(selectedTempFile.getParent());
                    }
                    catch (Throwable e) {
                        this.modMain.getInterfaces().getMinimap().setCrashedWith(e);
                        break;
                    }
                    WaypointWorldContainer autoWc = autoWorld.getContainer();
                    WaypointWorldContainer selectedWc = selectedWorld.getContainer();
                    autoWorld.setContainer(selectedWc);
                    selectedWorld.setContainer(autoWc);
                    selectedWc.worlds.put(selectedWorld.getId(), autoWorld);
                    autoWc.worlds.put(autoWorld.getId(), selectedWorld);
                    String buSelected = selectedWorld.getId();
                    selectedWorld.setId(autoWorld.getId());
                    autoWorld.setId(buSelected);
                    this.waypointsManager.setCustomWorldID(null);
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.updateWaypoints();
                    break;
                }
                case 9: {
                    String selectedRootContainerId = this.waypointWorld.getContainer().getRootContainer().getKey();
                    try {
                        File directory = this.modMain.getWaypointsFolder().toPath().resolve(selectedRootContainerId).toFile();
                        if (directory.exists()) {
                            FileUtils.deleteDirectory((File)directory);
                        }
                    }
                    catch (Throwable e) {
                        this.modMain.getInterfaces().getMinimap().setCrashedWith(e);
                        break;
                    }
                    this.waypointsManager.getWaypointMap().remove(selectedRootContainerId);
                    this.waypointsManager.setCustomWorldID(null);
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.updateWaypoints();
                    break;
                }
                case 10: {
                    WaypointWorld selectedWorld = this.waypointWorld;
                    try {
                        Files.deleteIfExists(this.modMain.getSettings().getWaypointsFile(selectedWorld).toPath());
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    selectedWorld.getContainer().worlds.remove(selectedWorld.getId());
                    selectedWorld.getContainer().removeName(selectedWorld.getId());
                    this.waypointsManager.setCustomWorldID(null);
                    this.waypointsManager.setCustomContainerID(null);
                    this.waypointsManager.updateWaypoints();
                    break;
                }
                case 11: {
                    this.multiplyWaypoints(this.waypointWorld, 8.0);
                    break;
                }
                case 12: {
                    this.multiplyWaypoints(this.waypointWorld, 0.125);
                }
            }
        }
        if (this.parent instanceof GuiWaypoints) {
            this.minecraft.func_147108_a((Screen)new GuiWaypoints(this.modMain, ((GuiWaypoints)this.parent).getParentScreen()));
        } else {
            this.minecraft.func_147108_a(this.parent);
        }
    }

    private void multiplyWaypoints(WaypointWorld world, double factor) {
        HashMap<String, WaypointSet> sets = world.getSets();
        Iterator<WaypointSet> iter = sets.values().iterator();
        while (iter.hasNext()) {
            ArrayList<Waypoint> wpList = iter.next().getList();
            for (int i = 0; i < wpList.size(); ++i) {
                Waypoint wp = wpList.get(i);
                wp.setX((int)Math.floor((double)wp.getX() * factor));
                wp.setZ((int)Math.floor((double)wp.getZ() * factor));
            }
        }
        try {
            this.modMain.getSettings().saveWaypoints(world);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void render(int par1, int par2, float par3) {
        this.deleteButton.active = this.waypointsManager.getAutoRootContainerID() != null && !this.waypointsManager.getAutoRootContainerID().equals(this.waypointWorld.getContainer().getRootContainer().getKey());
        this.automaticButton.active = this.deleteButton.active;
        this.subDeleteButton.active = !this.automaticButton.active && this.waypointWorld != this.waypointsManager.getAutoWorld();
        this.subAutomaticButton.active = this.subDeleteButton.active;
        this.parent.render(0, 0, par3);
        this.renderBackground();
        super.render(par1, par2, par3);
        block4: for (int k = 0; k < this.buttons.size(); ++k) {
            MySmallButton b;
            Widget w = (Widget)this.buttons.get(k);
            if (!(w instanceof MySmallButton) || (b = (MySmallButton)w).getId() < 200 || par1 < b.x || par2 < b.y || par1 >= b.x + 150 || par2 >= b.y + 20) continue;
            switch (b.getId() - 200) {
                case 0: {
                    this.mwTooltip.drawBox(par1, par2, this.width, this.height);
                    continue block4;
                }
                case 1: {
                    this.teleportationTooltip.drawBox(par1, par2, this.width, this.height);
                }
            }
        }
    }
}

