/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.render;

import com.mojang.blaze3d.systems.RenderSystem;
import java.awt.Color;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.entity.Entity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.LightType;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.MinimapRadar;
import xaero.common.minimap.render.MinimapRendererHelper;
import xaero.common.minimap.waypoints.render.WaypointsGuiRenderer;
import xaero.common.misc.OptimizedMath;

public abstract class MinimapRenderer {
    public static final Color black = new Color(0, 0, 0, 255);
    public static final Color slime = new Color(82, 241, 64, 128);
    protected IXaeroMinimap modMain;
    protected Minecraft mc;
    protected MinimapRendererHelper helper;
    private WaypointsGuiRenderer waypointsGuiRenderer;
    private int lastMinimapSize;
    private ArrayList<String> underText;
    protected double zoom = 1.0;
    private BlockPos.Mutable mutableBlockPos;

    public MinimapRenderer(IXaeroMinimap modMain, Minecraft mc, WaypointsGuiRenderer waypointsGuiRenderer) {
        this.modMain = modMain;
        this.mc = mc;
        this.waypointsGuiRenderer = waypointsGuiRenderer;
        this.underText = new ArrayList();
        this.helper = new MinimapRendererHelper();
        this.mutableBlockPos = new BlockPos.Mutable();
    }

    public double getRenderAngle(Entity player, float partial) {
        if (this.modMain.getSettings().getLockNorth()) {
            return 90.0;
        }
        return this.getActualAngle(player, partial);
    }

    public double getActualAngle(Entity player, float partial) {
        double angle;
        double rotation = player.func_195046_g(partial);
        if (rotation < 0.0 || rotation > 360.0) {
            rotation %= 360.0;
        }
        if ((angle = 270.0 - rotation) < 0.0 || angle > 360.0) {
            angle %= 360.0;
        }
        return angle;
    }

    protected abstract void renderChunks(MinimapProcessor var1, int var2, int var3, float var4, float var5, int var6, boolean var7);

    public void renderMinimap(MinimapProcessor minimap, int x, int y, int width, int height, double scale, int size, float partial) {
        int specW;
        if (this.modMain.getSettings().getMinimapSize() != this.lastMinimapSize) {
            this.lastMinimapSize = this.modMain.getSettings().getMinimapSize();
            minimap.setToResetImage(true);
        }
        long before = System.currentTimeMillis();
        int mapSize = minimap.getMinimapSize();
        int bufferSize = minimap.getMinimapBufferSize();
        if (minimap.usingFBO()) {
            bufferSize = minimap.getFBOBufferSize();
        }
        float mapScale = (float)(scale / 2.0 / (double)this.modMain.getSettings().getMinimapScale());
        minimap.updateZoom();
        this.zoom = minimap.getMinimapZoom();
        RenderHelper.func_74518_a();
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.pixelStore((int)3317, (int)4);
        RenderSystem.pixelStore((int)3316, (int)0);
        RenderSystem.pixelStore((int)3315, (int)0);
        RenderSystem.pixelStore((int)3314, (int)0);
        float sizeFix = (float)bufferSize / 512.0f;
        boolean useWorldMap = this.modMain.getSupportMods().shouldUseWorldMapChunks() && MinimapProcessor.instance.getMinimapWriter().getLoadedCaving() == -1;
        int lightLevel = (int)((1.0f - Math.min(1.0f, this.mc.field_71441_e.func_228326_g_(1.0f))) * (float)(minimap.getMinimapWriter().getLoadedLevels() - 1));
        if (useWorldMap || lightLevel >= 0) {
            this.renderChunks(minimap, mapSize, bufferSize, sizeFix, partial, lightLevel, useWorldMap);
        }
        if (minimap.usingFBO()) {
            sizeFix = 1.0f;
        }
        GL11.glEnable((int)3008);
        RenderSystem.enableAlphaTest();
        RenderSystem.enableBlend();
        RenderSystem.blendFunc((int)770, (int)771);
        GL11.glScalef((float)(1.0f / mapScale), (float)(1.0f / mapScale), (float)1.0f);
        int scaledX = (int)((float)x * mapScale);
        int scaledY = (int)((float)y * mapScale);
        this.mc.field_71456_v.blit((int)((float)(scaledX + 9) / sizeFix), (int)((float)(scaledY + 9) / sizeFix), 0, 0, (int)((float)(mapSize / 2 + 1) / sizeFix), (int)((float)(mapSize / 2 + 1) / sizeFix));
        if (!minimap.usingFBO()) {
            GL11.glScalef((float)(1.0f / sizeFix), (float)(1.0f / sizeFix), (float)1.0f);
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        int specH = specW = mapSize / 2 + 6;
        double angle = Math.toRadians(this.getRenderAngle(this.mc.func_175606_aa(), partial));
        double ps = Math.sin(Math.PI - angle);
        double pc = Math.cos(Math.PI - angle);
        this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
        if (this.modMain.getSettings().getLockNorth() || this.modMain.getSettings().alwaysArrow) {
            float a;
            float b;
            float g;
            float r;
            GL11.glTexParameteri((int)3553, (int)10240, (int)9729);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9729);
            double arrowX = (double)(2 * scaledX + 18 + (mapSize + 1) / 2) + 0.5;
            double arrowY = (double)(2 * scaledY + 18 + (mapSize + 1) / 2) + 0.5;
            RenderSystem.pushMatrix();
            GL11.glScalef((float)0.5f, (float)0.5f, (float)1.0f);
            float arrowAngle = this.modMain.getSettings().getLockNorth() ? this.mc.func_175606_aa().func_195046_g(partial) : 180.0f;
            this.drawArrow(arrowAngle, arrowX, arrowY + 1.0, 0.0f, 0.0f, 0.0f, 0.5f);
            if (this.modMain.getSettings().arrowColour != -1) {
                float[] c = this.modMain.getSettings().arrowColours[this.modMain.getSettings().arrowColour];
                r = c[0];
                g = c[1];
                b = c[2];
                a = c[3];
            } else {
                int rgb = minimap.getEntityRadar().getPlayerTeamColour((PlayerEntity)this.mc.field_71439_g);
                if (rgb != -1) {
                    r = (float)(rgb >> 16 & 0xFF) / 255.0f;
                    g = (float)(rgb >> 8 & 0xFF) / 255.0f;
                    b = (float)(rgb & 0xFF) / 255.0f;
                    a = 1.0f;
                } else {
                    float[] c = this.modMain.getSettings().arrowColours[0];
                    r = c[0];
                    g = c[1];
                    b = c[2];
                    a = c[3];
                }
            }
            this.drawArrow(arrowAngle, arrowX, arrowY, r, g, b, a);
            RenderSystem.popMatrix();
            GL11.glTexParameteri((int)3553, (int)10240, (int)9728);
            GL11.glTexParameteri((int)3553, (int)10241, (int)9728);
        }
        this.mc.field_71456_v.blit(scaledX + 9 - 4, scaledY + 9 - 4, 0, 0, 17, 15);
        this.mc.field_71456_v.blit(scaledX + 9 - 4 + mapSize / 2 - 8, scaledY + 9 - 4, 0, 15, 17, 15);
        this.mc.field_71456_v.blit(scaledX + 9 - 4, scaledY + 9 - 4 + mapSize / 2 - 6, 0, 30, 17, 15);
        this.mc.field_71456_v.blit(scaledX + 9 - 4 + mapSize / 2 - 8, scaledY + 9 - 4 + mapSize / 2 - 6, 0, 45, 17, 15);
        int horLineLength = (mapSize / 2 - 16) / 16;
        for (int i = 0; i < horLineLength; ++i) {
            this.mc.field_71456_v.blit(scaledX + 9 - 4 + 17 + i * 16, scaledY + 9 - 4, 0, 60, 16, 4);
            this.mc.field_71456_v.blit(scaledX + 9 - 4 + 17 + i * 16, scaledY + 9 - 4 + mapSize / 2 + 9 - 4, 0, 64, 16, 4);
        }
        int vertLineLength = (mapSize / 2 - 14) / 5;
        for (int i = 0; i < vertLineLength; ++i) {
            this.mc.field_71456_v.blit(scaledX + 9 - 4, scaledY + 9 - 4 + 15 + i * 5, 0, 68, 4, 5);
            this.mc.field_71456_v.blit(scaledX + 9 - 4 + mapSize / 2 + 9 - 4, scaledY + 9 - 4 + 15 + i * 5, 0, 73, 4, 5);
        }
        RenderSystem.pushMatrix();
        RenderSystem.scalef((float)0.5f, (float)0.5f, (float)1.0f);
        RenderSystem.translatef((float)(2 * scaledX + specW - 6 + 18), (float)(2 * scaledY + specH - 6 + 18), (float)0.0f);
        double playerX = minimap.getEntityRadar().getEntityX(this.mc.func_175606_aa(), partial);
        double playerZ = minimap.getEntityRadar().getEntityZ(this.mc.func_175606_aa(), partial);
        this.waypointsGuiRenderer.render(playerX, playerZ, specW, specH, ps, pc, partial, this.zoom);
        RenderSystem.popMatrix();
        if (this.modMain.getSettings().getShowCoords()) {
            int interfaceSize = size / 2;
            String coords = OptimizedMath.myFloor(this.mc.func_175606_aa().func_226277_ct_()) + ", " + OptimizedMath.myFloor(this.mc.func_175606_aa().func_226278_cu_()) + ", " + OptimizedMath.myFloor(this.mc.func_175606_aa().func_226281_cx_());
            if (this.mc.field_71466_p.func_78256_a(coords) >= interfaceSize) {
                String stringLevel = "" + OptimizedMath.myFloor(this.mc.func_175606_aa().func_226278_cu_());
                coords = OptimizedMath.myFloor(this.mc.func_175606_aa().func_226277_ct_()) + ", " + OptimizedMath.myFloor(this.mc.func_175606_aa().func_226281_cx_());
                this.underText.add(coords);
                this.underText.add(stringLevel);
            } else {
                this.underText.add(coords);
            }
        }
        int playerBlockX = OptimizedMath.myFloor(this.mc.func_175606_aa().func_226277_ct_());
        int playerBlockY = OptimizedMath.myFloor(this.mc.func_175606_aa().func_174813_aQ().field_72338_b);
        int playerBlockZ = OptimizedMath.myFloor(this.mc.func_175606_aa().func_226281_cx_());
        BlockPos.Mutable pos = this.mutableBlockPos.func_181079_c(playerBlockX, playerBlockY, playerBlockZ);
        if (this.modMain.getSettings().showBiome) {
            this.underText.add(this.mc.field_71441_e.func_226691_t_((BlockPos)pos).func_205403_k().func_150254_d());
        }
        if (this.modMain.getSettings().showLightLevel) {
            int playerBlockLightLevel = 15;
            if (playerBlockY >= 0 && playerBlockY < 256) {
                playerBlockLightLevel = this.mc.field_71441_e.func_226658_a_(LightType.BLOCK, (BlockPos)pos);
            }
            this.underText.add(String.format("Light: %d", playerBlockLightLevel));
        }
        if (this.modMain.getSettings().showTime != 0) {
            long totalTime = 6000L + this.mc.field_71441_e.func_72820_D();
            int dayNumber = (int)(totalTime / 24000L) + 1;
            int dayTimeSinceMidnight = (int)(totalTime % 24000L);
            int timeHours = dayTimeSinceMidnight / 1000;
            int minutes = (int)((double)(dayTimeSinceMidnight % 1000) / 1000.0 * 60.0);
            if (this.modMain.getSettings().showTime == 1) {
                this.underText.add(String.format("Day %d, %02d:%02d", dayNumber, timeHours, minutes));
            } else {
                String half = "AM";
                if (timeHours >= 12) {
                    timeHours -= 12;
                    half = "PM";
                }
                if (timeHours == 0) {
                    timeHours = 12;
                }
                this.underText.add(String.format("Day %d, %02d:%02d %s", dayNumber, timeHours, minutes, half));
            }
        }
        this.drawTextUnderMinimap(scaledX, scaledY, height, size, mapScale);
        GL11.glScalef((float)mapScale, (float)mapScale, (float)1.0f);
    }

    private void drawArrow(float angle, double arrowX, double arrowY, float r, float g, float b, float a) {
        RenderSystem.pushMatrix();
        GL11.glTranslated((double)arrowX, (double)arrowY, (double)0.0);
        RenderSystem.rotatef((float)angle, (float)0.0f, (float)0.0f, (float)1.0f);
        GL11.glScaled((double)(0.5 * this.modMain.getSettings().arrowScale), (double)(0.5 * this.modMain.getSettings().arrowScale), (double)1.0);
        GL11.glTranslated((double)-13.0, (double)-6.0, (double)0.0);
        RenderSystem.color4f((float)r, (float)g, (float)b, (float)a);
        this.mc.field_71456_v.blit(0, 0, 49, 0, 26, 27);
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.popMatrix();
    }

    public void drawTextUnderMinimap(int scaledX, int scaledY, int height, int size, float mapScale) {
        int interfaceSize = size / 2;
        int scaledHeight = (int)((float)height * mapScale);
        for (int i = 0; i < this.underText.size(); ++i) {
            String s = this.underText.get(i);
            int stringWidth = this.mc.field_71466_p.func_78256_a(s);
            boolean under = scaledY + interfaceSize / 2 < scaledHeight / 2;
            int stringY = scaledY + (under ? interfaceSize : -9) + i * 10 * (under ? 1 : -1);
            RenderSystem.enableDepthTest();
            GL11.glDisable((int)2929);
            Minecraft.func_71410_x().field_71466_p.func_175063_a(s, (float)(scaledX + interfaceSize / 2 - stringWidth / 2), (float)stringY, MinimapRadar.radarPlayers.hashCode());
            RenderSystem.disableDepthTest();
        }
        this.underText.clear();
    }

    public double getZoom() {
        return this.zoom;
    }

    public void setZoom(double zoom) {
        this.zoom = zoom;
    }
}

