/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import net.minecraft.client.Minecraft;
import net.minecraft.client.resources.I18n;
import net.minecraft.entity.Entity;
import xaero.common.gui.GuiWaypoints;

public class Waypoint
implements Comparable<Waypoint> {
    private int x;
    private int y;
    private int z;
    private String name;
    private String symbol;
    private int color;
    private boolean disabled = false;
    private int type = 0;
    private boolean rotation = false;
    private int yaw = 0;
    private double lastDistance = 0.0;
    private boolean temporary;

    public Waypoint(int x, int y, int z, String name, String symbol, int color) {
        this(x, y, z, name, symbol, color, 0, false);
    }

    public Waypoint(int x, int y, int z, String name, String symbol, int color, int type) {
        this(x, y, z, name, symbol, color, type, false);
    }

    public Waypoint(int x, int y, int z, String name, String symbol, int color, int type, boolean temp) {
        this.x = x;
        this.y = y;
        this.z = z;
        this.symbol = symbol;
        this.color = color;
        this.type = type;
        this.name = name;
        this.temporary = temp;
    }

    public double getDistanceSq(double x, double y, double z) {
        double d3 = (double)this.x - x;
        double d4 = (double)this.y - y;
        double d5 = (double)this.z - z;
        return d3 * d3 + d4 * d4 + d5 * d5;
    }

    public String getLocalizedName() {
        return I18n.func_135052_a((String)this.name, (Object[])new Object[0]);
    }

    public boolean isDisabled() {
        return this.disabled;
    }

    public void setDisabled(boolean b) {
        this.temporary = false;
        this.disabled = b;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    public double getLastDistance() {
        return this.lastDistance;
    }

    public int getX() {
        return this.x;
    }

    public int getX(boolean divideBy8) {
        if (!divideBy8) {
            return this.x;
        }
        return Math.floorDiv(this.x, 8);
    }

    public int getY() {
        return this.y;
    }

    public int getZ() {
        return this.z;
    }

    public int getZ(boolean divideBy8) {
        if (!divideBy8) {
            return this.z;
        }
        return Math.floorDiv(this.z, 8);
    }

    public void setX(int x) {
        this.x = x;
    }

    public void setY(int y) {
        this.y = y;
    }

    public void setZ(int z) {
        this.z = z;
    }

    public String getName() {
        return this.name;
    }

    public String getNameSafe(String replacement) {
        return this.getName().replace(":", replacement);
    }

    public void setName(String name) {
        this.name = name;
    }

    public boolean isTemporary() {
        return this.temporary;
    }

    public void setTemporary(boolean temporary) {
        this.temporary = temporary;
        this.disabled = false;
    }

    public String getSymbol() {
        return this.symbol;
    }

    public void setSymbol(String symbol) {
        this.symbol = symbol;
    }

    public String getSymbolSafe(String replacement) {
        return this.getSymbol().replace(":", replacement);
    }

    public boolean isRotation() {
        return this.rotation;
    }

    public void setRotation(boolean rotation) {
        this.rotation = rotation;
    }

    public int getYaw() {
        return this.yaw;
    }

    public void setYaw(int yaw) {
        this.yaw = yaw;
    }

    public int getColor() {
        return this.color;
    }

    public void setColor(int c) {
        this.color = c;
    }

    public void setLastDistance(double lastDistance) {
        this.lastDistance = lastDistance;
    }

    public static String getStringFromStringSafe(String stringSafe, String replacement) {
        return stringSafe.replace(replacement, ":");
    }

    public boolean isServerWaypoint() {
        return false;
    }

    public String getComparisonName() {
        String comparisonName = this.getLocalizedName().toLowerCase().trim();
        if (comparisonName.startsWith("the ")) {
            comparisonName = comparisonName.substring(4);
        }
        if (comparisonName.startsWith("a ")) {
            comparisonName = comparisonName.substring(2);
        }
        return comparisonName;
    }

    public double getComparisonDistance(Entity entity, boolean divided) {
        double offX = (double)this.getX(divided) - entity.func_226277_ct_();
        double offY = (double)this.getY() - entity.func_226278_cu_();
        double offZ = (double)this.getZ(divided) - entity.func_226281_cx_();
        return offX * offX + offY * offY + offZ * offZ;
    }

    @Override
    public int compareTo(Waypoint arg0) {
        switch (GuiWaypoints.sortType) {
            case NAME: {
                return this.getComparisonName().compareTo(arg0.getComparisonName());
            }
            case SYMBOL: {
                return this.getSymbol().compareTo(arg0.getSymbol());
            }
            case DISTANCE: {
                Entity renderEntity = Minecraft.func_71410_x().func_175606_aa();
                double compDist = this.getComparisonDistance(renderEntity, GuiWaypoints.distanceDivided);
                double otherCompDist = arg0.getComparisonDistance(renderEntity, GuiWaypoints.distanceDivided);
                return compDist > otherCompDist ? 1 : (compDist == otherCompDist ? 0 : -1);
            }
        }
        return 0;
    }
}

