/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.waypoints;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.screen.ConfirmScreen;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.resources.I18n;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.util.text.TextFormatting;
import net.minecraft.util.text.TranslationTextComponent;
import net.minecraft.util.text.event.ClickEvent;
import net.minecraft.util.text.event.HoverEvent;
import net.minecraft.world.dimension.DimensionType;
import net.minecraftforge.client.event.ClientChatReceivedEvent;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiAddWaypoint;
import xaero.common.minimap.waypoints.Waypoint;
import xaero.common.minimap.waypoints.WaypointWorld;
import xaero.common.minimap.waypoints.WaypointWorldContainer;
import xaero.common.minimap.waypoints.WaypointWorldRootContainer;
import xaero.common.minimap.waypoints.WaypointsManager;

public class WaypointSharingHandler {
    public static final String WAYPOINT_SHARE_PREFIX = "xaero_waypoint:";
    public static final String WAYPOINT_ADD_PREFIX = "xaero_waypoint_add:";
    private IXaeroMinimap modMain;
    private Screen parent;
    private Waypoint w;
    private WaypointWorld wWorld;

    public WaypointSharingHandler(IXaeroMinimap modMain) {
        this.modMain = modMain;
    }

    public void shareWaypoint(Screen parent, Waypoint w, WaypointWorld wWorld) {
        this.parent = parent;
        this.w = w;
        this.wWorld = wWorld;
        Minecraft.func_71410_x().func_147108_a((Screen)new ConfirmScreen(this::confirmResult, (ITextComponent)new TranslationTextComponent("gui.xaero_share_msg1", new Object[0]), (ITextComponent)new TranslationTextComponent("gui.xaero_share_msg2", new Object[0])));
    }

    public void onWaypointReceived(String text, ClientChatReceivedEvent e) {
        String[] args = text.substring(text.indexOf(WAYPOINT_SHARE_PREFIX)).split(":");
        StringTextComponent component = null;
        if (args.length < 9) {
            System.out.println("Incorrect format of the shared waypoint! Error: 0");
        } else {
            String playerName = text.substring(0, text.indexOf(WAYPOINT_SHARE_PREFIX));
            int lastGreater = playerName.lastIndexOf(">");
            if (lastGreater != -1) {
                playerName = playerName.substring(0, lastGreater).replaceFirst("<", "");
            }
            String newText = playerName + " shared a waypoint called \"" + I18n.func_135052_a((String)Waypoint.getStringFromStringSafe(args[1], "^col^"), (Object[])new Object[0]) + "\"";
            if (args.length > 9 && args[9].startsWith("Internal_")) {
                try {
                    DimensionType dt;
                    Integer dimId;
                    String details = args[9].substring(9, args[9].lastIndexOf("_")).replace("^col^", ":");
                    newText = newText + " from ";
                    newText = details.startsWith("dim%") ? (details.length() == 4 ? newText + "an unknown dimension" : ((dimId = this.modMain.getWaypointsManager().getDimensionForDirectoryName(details)) == null ? newText + "an unknown dimension" : ((dt = DimensionType.func_186069_a((int)dimId)) == null ? newText + "an unknown dimension" : newText + WaypointsManager.getDimensionKey(dt).func_110623_a()))) : newText + details;
                }
                catch (IndexOutOfBoundsException details) {
                    // empty catch block
                }
            }
            newText = newText + "! \u00a72\u00a7n[Add]";
            newText = newText.replaceAll("\u00a7r", "\u00a7r\u00a77").replaceAll("\u00a7f", "\u00a77");
            component = new StringTextComponent(newText);
            StringTextComponent hoverComponent = new StringTextComponent(args[3] + ", " + args[4] + ", " + args[5]);
            component.func_211708_a(TextFormatting.GRAY).func_211710_a(style -> style.func_150241_a(new ClickEvent(ClickEvent.Action.RUN_COMMAND, WAYPOINT_ADD_PREFIX + text.substring(text.indexOf(WAYPOINT_SHARE_PREFIX) + WAYPOINT_SHARE_PREFIX.length())))).func_211710_a(style -> style.func_150209_a(new HoverEvent(HoverEvent.Action.SHOW_TEXT, (ITextComponent)hoverComponent)));
        }
        e.setMessage(component);
    }

    public void onWaypointAdd(String[] args) {
        String waypointName = Waypoint.getStringFromStringSafe(args[1], "^col^");
        if (waypointName.length() < 1 || waypointName.length() > 32) {
            System.out.println("Incorrect format of the shared waypoint! Error: 1");
            return;
        }
        String waypointSymbol = Waypoint.getStringFromStringSafe(args[2], "^col^");
        if (waypointSymbol.length() < 1 || waypointSymbol.length() > 2) {
            System.out.println("Incorrect format of the shared waypoint! Error: 2");
            return;
        }
        try {
            int x = Integer.parseInt(args[3]);
            int y = Integer.parseInt(args[4]);
            int z = Integer.parseInt(args[5]);
            int color = Integer.parseInt(args[6]);
            String yawString = args[8];
            if (yawString.length() > 4) {
                System.out.println("Incorrect format of the shared waypoint! Error: 4");
                return;
            }
            int yaw = Integer.parseInt(yawString);
            boolean rotation = args[7].equals("true");
            Waypoint w = new Waypoint(x, y, z, waypointName, waypointSymbol, color, 0);
            w.setRotation(rotation);
            w.setYaw(yaw);
            String externalContainerId = this.modMain.getWaypointsManager().getCurrentContainerID().split("/")[0];
            WaypointWorld externalWorld = this.modMain.getWaypointsManager().getCurrentWorld();
            String parentContainerId = externalContainerId;
            WaypointWorld currentWorld = externalWorld;
            if (args.length > 9) {
                String worldDetails = args[9];
                if (worldDetails.length() > 9 && worldDetails.startsWith("Internal_")) {
                    String subContainers;
                    int divider = worldDetails.lastIndexOf(95);
                    if (divider < 1 || divider == worldDetails.length() - 1) {
                        System.out.println("Incorrect format of the shared waypoint! Error: 5");
                        return;
                    }
                    String worldId = worldDetails.substring(divider + 1);
                    if (!worldId.replaceAll("[^a-zA-Z0-9,-]+", "").equals(worldId)) {
                        System.out.println("Incorrect format of the shared waypoint! Error: 7");
                        return;
                    }
                    boolean destinationDimensionExists = true;
                    try {
                        subContainers = worldDetails.substring(9, divider);
                    }
                    catch (IndexOutOfBoundsException eoobe) {
                        subContainers = null;
                    }
                    parentContainerId = this.modMain.getWaypointsManager().getAutoRootContainerID();
                    String containerId = null;
                    if (subContainers != null) {
                        CharSequence[] subContainersArgs = (subContainers = subContainers.replace("^col^", ":")).split("/");
                        if (subContainersArgs.length > 1) {
                            System.out.println("Incorrect format of the shared waypoint! Error: 8");
                            return;
                        }
                        for (int i = 0; i < subContainersArgs.length; ++i) {
                            String s = subContainersArgs[i];
                            if (!s.isEmpty()) continue;
                            System.out.println("Incorrect format of the shared waypoint! Error: 11");
                            return;
                        }
                        String dimContainer = subContainersArgs[0];
                        Integer dimId = null;
                        if (!dimContainer.startsWith("dim%")) {
                            if (!dimContainer.replaceAll("[^a-zA-Z0-9_]+", "").equals(dimContainer)) {
                                System.out.println("Incorrect format of the shared waypoint! Error: 18");
                                return;
                            }
                            DimensionType dt = this.modMain.getWaypointsManager().findDimensionType(dimContainer);
                            if (dt != null) {
                                dimId = dt.func_186068_a();
                            }
                        } else {
                            dimId = this.modMain.getWaypointsManager().getDimensionForDirectoryName(dimContainer);
                        }
                        if (dimId == null) {
                            System.out.println("Destination dimension doesn't exists! Handling waypoint as external.");
                            parentContainerId = externalContainerId;
                            currentWorld = externalWorld;
                            destinationDimensionExists = false;
                        } else {
                            subContainersArgs[0] = this.modMain.getWaypointsManager().getDimensionDirectoryName(dimId);
                            subContainers = String.join((CharSequence)"/", subContainersArgs);
                            containerId = parentContainerId + "/" + subContainers;
                            WaypointWorldContainer rootContainer = this.modMain.getWaypointsManager().getWorldContainer(parentContainerId);
                            rootContainer.renameOldContainer(containerId);
                        }
                    } else {
                        containerId = parentContainerId;
                    }
                    if (destinationDimensionExists) {
                        String autoWorldId = this.modMain.getWaypointsManager().getAutoWorldID();
                        if (worldId.equals("waypoints")) {
                            worldId = autoWorldId;
                        } else if (autoWorldId.equals("waypoints")) {
                            worldId = "waypoints";
                        }
                        File securityTest = new File(this.modMain.getWaypointsFolder(), containerId + "/" + worldId + (worldId.equals("waypoints") ? "" : "_1") + ".txt");
                        try {
                            if (!securityTest.getPath().equals(securityTest.getCanonicalPath())) {
                                System.out.println("Dangerously incorrect format of the shared waypoint! Error: 10");
                                return;
                            }
                        }
                        catch (IOException e) {
                            System.out.println("IO error adding a shared waypoint!");
                            e.printStackTrace();
                            return;
                        }
                        currentWorld = this.modMain.getWaypointsManager().getWorld(containerId, worldId);
                    }
                } else if (!worldDetails.equals("External")) {
                    System.out.println("Incorrect format of the shared waypoint! Error: 12");
                    return;
                }
            }
            Minecraft.func_71410_x().func_147108_a((Screen)new GuiAddWaypoint(this.modMain, null, Lists.newArrayList((Object[])new Waypoint[]{w}), parentContainerId, currentWorld, true));
        }
        catch (NumberFormatException nfe) {
            System.out.println("Incorrect format of the shared waypoint! Error: 3");
            return;
        }
    }

    public void confirmResult(boolean p_confirmResult_1_) {
        if (p_confirmResult_1_) {
            String worldDetails;
            WaypointWorldRootContainer autoRootContainer;
            WaypointWorldRootContainer rootContainer = this.wWorld.getContainer().getRootContainer();
            if (rootContainer == (autoRootContainer = this.modMain.getWaypointsManager().getAutoWorld().getContainer().getRootContainer())) {
                String details;
                String containerId = this.wWorld.getContainer().getKey();
                int firstSlashIndex = containerId.indexOf("/");
                if (firstSlashIndex != -1) {
                    String subContainers = containerId.substring(firstSlashIndex + 1);
                    CharSequence[] subContainersSplit = subContainers.split("/");
                    if (subContainersSplit[0].equals("dim%0")) {
                        subContainersSplit[0] = "overworld";
                    } else if (subContainersSplit[0].equals("dim%-1")) {
                        subContainersSplit[0] = "the_nether";
                    } else if (((String)subContainersSplit[0]).equals("dim%1")) {
                        subContainersSplit[0] = "the_end";
                    }
                    subContainers = String.join((CharSequence)"/", subContainersSplit);
                    details = subContainers.replace(":", "^col^") + "_" + this.wWorld.getId();
                } else {
                    details = this.wWorld.getId();
                }
                worldDetails = "Internal_" + details;
            } else {
                worldDetails = "External";
            }
            Minecraft.func_71410_x().field_71462_r.sendMessage(WAYPOINT_SHARE_PREFIX + this.w.getNameSafe("^col^") + ":" + this.w.getSymbolSafe("^col^") + ":" + this.w.getX() + ":" + this.w.getY() + ":" + this.w.getZ() + ":" + this.w.getColor() + ":" + this.w.isRotation() + ":" + this.w.getYaw() + ":" + worldDetails, true);
            Minecraft.func_71410_x().func_147108_a(null);
            return;
        }
        Minecraft.func_71410_x().func_147108_a(this.parent);
    }
}

