/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.minimap.write;

import java.awt.image.BufferedImage;
import java.io.FileNotFoundException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import javax.imageio.ImageIO;
import net.minecraft.block.AirBlock;
import net.minecraft.block.Block;
import net.minecraft.block.BlockRenderType;
import net.minecraft.block.BlockState;
import net.minecraft.block.Blocks;
import net.minecraft.block.BushBlock;
import net.minecraft.block.ComparatorBlock;
import net.minecraft.block.DoublePlantBlock;
import net.minecraft.block.FlowingFluidBlock;
import net.minecraft.block.GlassBlock;
import net.minecraft.block.IceBlock;
import net.minecraft.block.OreBlock;
import net.minecraft.block.RepeaterBlock;
import net.minecraft.block.material.MaterialColor;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.BlockModelShapes;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.RenderTypeLookup;
import net.minecraft.client.renderer.model.BakedQuad;
import net.minecraft.client.renderer.model.IBakedModel;
import net.minecraft.client.renderer.texture.AtlasTexture;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.crash.ReportedException;
import net.minecraft.fluid.IFluidState;
import net.minecraft.resources.IResource;
import net.minecraft.util.Direction;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.math.BlockPos;
import net.minecraft.world.IBlockReader;
import net.minecraft.world.ILightReader;
import net.minecraft.world.LightType;
import net.minecraft.world.World;
import net.minecraft.world.chunk.Chunk;
import net.minecraft.world.chunk.ChunkStatus;
import net.minecraft.world.chunk.EmptyChunk;
import net.minecraft.world.gen.Heightmap;
import xaero.common.IXaeroMinimap;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.region.MinimapChunk;
import xaero.common.minimap.region.MinimapTile;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.common.minimap.write.MinimapWriterHelper;
import xaero.common.misc.OptimizedMath;

public class MinimapWriter
implements Runnable {
    private static final String[] dimensionsToIgnore = new String[]{"FZHammer"};
    private static final int UPDATE_EVERY_RUNS = 5;
    private static final int MAXIMUM_OVERLAYS = 5;
    private IXaeroMinimap modMain;
    private MinimapWriterHelper helper;
    private Random usedRandom = new Random(0L);
    private int loadingSideInChunks;
    private int updateRadius;
    private MinimapChunk[][] loadingBlocks;
    private int loadingMapChunkX;
    private int loadingMapChunkZ;
    private int loadingCaving;
    private int loadingLevels;
    private boolean loadingTerrainSlopes;
    private boolean loadingTerrainSlopesExperiment;
    private boolean loadingTerrainDepth;
    private boolean loadingRedstone;
    private int loadingColours;
    private boolean loadingTransparency;
    private boolean loadingBiomesVanillaMode;
    private MinimapChunk[][] loadedBlocks;
    private int loadedMapChunkX;
    private int loadedMapChunkZ;
    private int loadedCaving;
    private int loadedLevels;
    private boolean loadedTerrainSlopes;
    private boolean loadedTerrainSlopesExperiment;
    private boolean loadedTerrainDepth;
    private boolean loadedRedstone;
    private int loadedColours;
    private boolean loadedTransparency;
    private boolean loadedBiomesVanillaMode;
    private boolean settingsChanged;
    private int updateChunkX;
    private int updateChunkZ;
    private int tileInsideX;
    private int tileInsideZ;
    private int runNumber;
    private boolean previousShouldLoad;
    private int lastCaving;
    private boolean clearBlockColours;
    private HashMap<String, Integer> textureColours;
    private HashMap<Integer, Integer> blockColours;
    private boolean forcedRefresh;
    private MinimapChunk oldChunk;
    private int[][] lastBlockY = new int[4][16];
    private int updates;
    private int loads;
    private long before;
    private int processingTime;
    private long currentComparisonCode;
    private List<Integer> pixelTransparentSizes;
    private List<BlockState> pixelBlockStates;
    private List<Integer> pixelBlockLights;
    private int firstBlockY;
    boolean isglowing;
    private int[] underRed;
    private int[] underGreen;
    private int[] underBlue;
    private int sun;
    private float currentTransparencyMultiplier;
    private int blockY;
    private int blockColor;
    private final int[] red;
    private final int[] green;
    private final int[] blue;
    private final float[] brightness;
    private final float[] postBrightness;
    private final int[] tempColor;
    private double secondaryB;
    private boolean underair;
    private BlockState previousTransparentState;
    private int[][] lastSlopeShades;
    private BlockPos.Mutable mutableBlockPos;
    private BlockPos.Mutable mutableBlockPos2;
    private byte[][] bufferUpdateArrayBuffers;
    private Long seedForLoading;

    public MinimapWriter(IXaeroMinimap modMain) {
        this.modMain = modMain;
        this.loadingSideInChunks = 16;
        this.updateRadius = 16;
        this.loadingCaving = -1;
        this.lastCaving = -1;
        this.textureColours = new HashMap();
        this.blockColours = new HashMap();
        this.loadedCaving = -1;
        this.red = new int[5];
        this.green = new int[5];
        this.blue = new int[5];
        this.underRed = new int[5];
        this.underGreen = new int[5];
        this.underBlue = new int[5];
        this.brightness = new float[5];
        this.postBrightness = new float[5];
        this.tempColor = new int[3];
        this.lastSlopeShades = new int[4][16];
        this.helper = new MinimapWriterHelper();
        this.mutableBlockPos = new BlockPos.Mutable();
        this.mutableBlockPos2 = new BlockPos.Mutable();
        this.bufferUpdateArrayBuffers = new byte[5][16384];
        this.pixelBlockStates = new ArrayList<BlockState>();
        this.pixelTransparentSizes = new ArrayList<Integer>();
        this.pixelBlockLights = new ArrayList<Integer>();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        block12: while (true) {
            try {
                while (true) {
                    long startTime = System.currentTimeMillis();
                    int totalTime = 3000000;
                    int sleepTime = 10;
                    while (totalTime > 0) {
                        try {
                            World world = null;
                            double playerX = 0.0;
                            double playerY = 0.0;
                            double playerZ = 0.0;
                            if (this.modMain.getInterfaces() != null) {
                                MinimapProcessor minimapProcessor = this.modMain.getInterfaces().getMinimap();
                                Object object = minimapProcessor.mainStuffSync;
                                synchronized (object) {
                                    world = minimapProcessor.mainWorld;
                                    playerX = minimapProcessor.mainPlayerX;
                                    playerY = minimapProcessor.mainPlayerY;
                                    playerZ = minimapProcessor.mainPlayerZ;
                                }
                            }
                            if (this.modMain.getSettings() == null || !this.modMain.getSettings().getMinimap() || world == null) {
                                sleepTime = 100;
                                break;
                            }
                            World world2 = world;
                            synchronized (world2) {
                                int time = this.writeChunk(playerX, playerY, playerZ, world);
                                totalTime -= time;
                            }
                            if (this.tileInsideX != 0 || this.tileInsideZ != 0 || this.updateChunkX != 0 || this.updateChunkZ != 0) continue;
                            sleepTime = 300;
                            break;
                        }
                        catch (ConcurrentModificationException world) {
                        }
                    }
                    int passed = (int)(System.currentTimeMillis() - startTime);
                    try {
                        if (passed >= sleepTime) continue block12;
                        Thread.sleep(sleepTime - passed);
                        continue block12;
                    }
                    catch (InterruptedException interruptedException) {
                        continue;
                    }
                    break;
                }
            }
            catch (Throwable e) {
                MinimapProcessor.instance.setCrashedWith(e);
                return;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private int writeChunk(double playerX, double playerY, double playerZ, World world) {
        MinimapChunk mchunk;
        boolean shouldLoad;
        long processStart = System.nanoTime();
        boolean bl = shouldLoad = !this.ignoreWorld(world) && (!this.modMain.getSupportMods().shouldUseWorldMapChunks() || this.loadingCaving != -1 || this.getCaving(playerX, playerY, playerZ, world) != -1);
        if (shouldLoad != this.previousShouldLoad) {
            this.updateChunkZ = 0;
            this.updateChunkX = 0;
            this.tileInsideZ = 0;
            this.tileInsideX = 0;
            this.previousShouldLoad = shouldLoad;
        }
        if (shouldLoad) {
            if (this.tileInsideX == 0 && this.tileInsideZ == 0) {
                if (this.updateChunkX == 0 && this.updateChunkZ == 0) {
                    this.settingsChanged = false;
                    if (this.clearBlockColours) {
                        this.settingsChanged = true;
                        this.clearBlockColours = false;
                        if (!this.blockColours.isEmpty()) {
                            this.blockColours.clear();
                            this.textureColours.clear();
                            System.out.println("Minimap block colour cache cleaned.");
                        }
                    }
                    this.loadingSideInChunks = this.getLoadSide();
                    this.updateRadius = this.getUpdateRadiusInChunks();
                    this.loadingMapChunkX = this.getMapCoord(this.loadingSideInChunks, playerX);
                    this.loadingMapChunkZ = this.getMapCoord(this.loadingSideInChunks, playerZ);
                    this.loadingCaving = this.getCaving(playerX, playerY, playerZ, world);
                    if (this.loadingCaving != this.loadedCaving) {
                        this.runNumber = 0;
                    }
                    this.loadingLevels = this.modMain.getSettings().getLighting() ? 5 : 1;
                    this.loadingTerrainSlopes = this.modMain.getSettings().getTerrainSlopes();
                    this.loadingTerrainSlopesExperiment = this.modMain.getSettings().getTerrainSlopesExperiment();
                    this.loadingTerrainDepth = this.modMain.getSettings().getTerrainDepth();
                    this.loadingRedstone = this.modMain.getSettings().getDisplayRedstone();
                    this.loadingColours = this.modMain.getSettings().getBlockColours();
                    this.loadingTransparency = this.modMain.getSettings().blockTransparency;
                    this.loadingBiomesVanillaMode = this.modMain.getSettings().getBiomeColorsVanillaMode();
                    this.settingsChanged = this.settingsChanged || this.loadedTerrainSlopes != this.loadingTerrainSlopes;
                    this.settingsChanged = this.settingsChanged || this.loadedTerrainSlopesExperiment != this.loadingTerrainSlopesExperiment;
                    this.settingsChanged = this.settingsChanged || this.loadedTerrainDepth != this.loadingTerrainDepth;
                    this.settingsChanged = this.settingsChanged || this.loadedRedstone != this.loadingRedstone;
                    this.settingsChanged = this.settingsChanged || this.loadedColours != this.loadingColours;
                    this.settingsChanged = this.settingsChanged || this.loadedTransparency != this.loadingTransparency;
                    boolean bl2 = this.settingsChanged = this.settingsChanged || this.loadingBiomesVanillaMode != this.loadedBiomesVanillaMode;
                    if (this.loadingBlocks == null || this.loadingBlocks.length != this.loadingSideInChunks) {
                        this.loadingBlocks = new MinimapChunk[this.loadingSideInChunks][this.loadingSideInChunks];
                    }
                    if (MinimapProcessor.instance.usingFBO() && MinimapProcessor.instance.isToResetImage()) {
                        this.forcedRefresh = true;
                        MinimapProcessor.instance.setToResetImage(false);
                    }
                }
                this.oldChunk = null;
                if (this.loadedBlocks != null) {
                    int updateChunkXOld = this.loadingMapChunkX + this.updateChunkX - this.loadedMapChunkX;
                    int updateChunkZOld = this.loadingMapChunkZ + this.updateChunkZ - this.loadedMapChunkZ;
                    if (updateChunkXOld > -1 && updateChunkXOld < this.loadedBlocks.length && updateChunkZOld > -1 && updateChunkZOld < this.loadedBlocks.length) {
                        this.oldChunk = this.loadedBlocks[updateChunkXOld][updateChunkZOld];
                    }
                }
            }
            if ((mchunk = this.loadingBlocks[this.updateChunkX][this.updateChunkZ]) == null) {
                MinimapChunk minimapChunk = new MinimapChunk(this.loadingMapChunkX + this.updateChunkX, this.loadingMapChunkZ + this.updateChunkZ);
                this.loadingBlocks[this.updateChunkX][this.updateChunkZ] = minimapChunk;
                mchunk = minimapChunk;
            } else if (this.tileInsideX == 0 && this.tileInsideZ == 0) {
                mchunk.reset(this.loadingMapChunkX + this.updateChunkX, this.loadingMapChunkZ + this.updateChunkZ);
            }
            this.writeTile(playerX, playerY, playerZ, world, mchunk, this.oldChunk, this.updateChunkX, this.updateChunkZ, this.tileInsideX, this.tileInsideZ, this.runNumber % 5 != 0);
        }
        ++this.tileInsideZ;
        if (this.tileInsideZ >= 4) {
            this.tileInsideZ = 0;
            ++this.tileInsideX;
            if (this.tileInsideX >= 4) {
                this.tileInsideX = 0;
                if (shouldLoad) {
                    mchunk = this.loadingBlocks[this.updateChunkX][this.updateChunkZ];
                    if (MinimapProcessor.instance.usingFBO() && mchunk.isHasSomething() && mchunk.isChanged()) {
                        mchunk.updateBuffers(this.loadingLevels, this.bufferUpdateArrayBuffers);
                        mchunk.setChanged(false);
                    }
                    mchunk.setLevelsBuffered(this.loadingLevels);
                }
                if (this.updateChunkX == this.loadingSideInChunks - 1 && this.updateChunkZ == this.loadingSideInChunks - 1) {
                    if (shouldLoad) {
                        if (this.runNumber % 5 == 0 && !MinimapTile.recycled.isEmpty()) {
                            MinimapTile.recycled.subList(0, MinimapTile.recycled.size() / 2).clear();
                        }
                        if (this.loadedBlocks != null) {
                            for (int i = 0; i < this.loadedBlocks.length; ++i) {
                                for (int j = 0; j < this.loadedBlocks.length; ++j) {
                                    boolean shouldTransfer;
                                    MinimapChunk m = this.loadedBlocks[i][j];
                                    MinimapChunk lm = null;
                                    if (m == null) continue;
                                    m.recycleTiles();
                                    int loadingX = this.loadedMapChunkX + i - this.loadingMapChunkX;
                                    int loadingZ = this.loadedMapChunkZ + j - this.loadingMapChunkZ;
                                    if (loadingX > -1 && loadingZ > -1 && loadingX < this.loadingSideInChunks && loadingZ < this.loadingSideInChunks) {
                                        lm = this.loadingBlocks[loadingX][loadingZ];
                                    }
                                    boolean bl3 = shouldTransfer = m.getLevelsBuffered() == this.loadingLevels && lm != null;
                                    if (shouldTransfer) {
                                        MinimapChunk minimapChunk = m;
                                        synchronized (minimapChunk) {
                                            m.setBlockTextureUpload(true);
                                        }
                                    }
                                    for (int l = 0; l < m.getLevelsBuffered(); ++l) {
                                        if (m.getGlTexture(l) != 0) {
                                            if (shouldTransfer) {
                                                lm.setGlTexture(l, m.getGlTexture(l));
                                                continue;
                                            }
                                            MinimapProcessor.instance.requestTextureDelete(m.getGlTexture(l));
                                            continue;
                                        }
                                        if (!shouldTransfer || lm.isRefreshRequired(l) || !m.isRefreshRequired(l)) continue;
                                        lm.copyBuffer(l, m.getBuffer(l));
                                        lm.setRefreshRequired(l, true);
                                        m.setRefreshRequired(l, false);
                                    }
                                }
                            }
                        }
                        MinimapWriter i = this;
                        synchronized (i) {
                            MinimapChunk[][] bu = this.loadedBlocks;
                            this.loadedBlocks = this.loadingBlocks;
                            this.loadingBlocks = bu;
                            this.loadedMapChunkX = this.loadingMapChunkX;
                            this.loadedMapChunkZ = this.loadingMapChunkZ;
                            this.loadedLevels = this.loadingLevels;
                            this.loadedTerrainSlopes = this.loadingTerrainSlopes;
                            this.loadedTerrainSlopesExperiment = this.loadingTerrainSlopesExperiment;
                            this.loadedTerrainDepth = this.loadingTerrainDepth;
                            this.loadedRedstone = this.loadingRedstone;
                            this.loadedColours = this.loadingColours;
                            this.loadedTransparency = this.loadingTransparency;
                            this.loadedBiomesVanillaMode = this.loadingBiomesVanillaMode;
                        }
                    }
                    this.loadedCaving = this.loadingCaving;
                    this.forcedRefresh = false;
                    ++this.runNumber;
                }
                ++this.updateChunkZ;
                if (this.updateChunkZ >= this.loadingSideInChunks) {
                    this.updateChunkZ = 0;
                    this.updateChunkX = (this.updateChunkX + 1) % this.loadingSideInChunks;
                    this.lastBlockY = new int[4][16];
                    this.lastSlopeShades = new int[4][16];
                }
            }
        }
        int passed = (int)(System.nanoTime() - processStart);
        return passed;
    }

    private void writeTile(double playerX, double playerY, double playerZ, World world, MinimapChunk mchunk, MinimapChunk oldChunk, int canvasX, int canvasZ, int insideX, int insideZ, boolean onlyLoad) {
        int tileX = mchunk.getX() * 4 + insideX;
        int tileZ = mchunk.getZ() * 4 + insideZ;
        int halfSide = this.loadingSideInChunks / 2;
        int tileFromCenterX = canvasX - halfSide;
        int tileFromCenterZ = canvasZ - halfSide;
        MinimapTile oldTile = null;
        if (oldChunk != null) {
            oldTile = oldChunk.getTile(insideX, insideZ);
        }
        Chunk bchunk = (Chunk)world.func_217353_a(tileX, tileZ, ChunkStatus.field_222617_m, false);
        boolean neighborsLoaded = true;
        block0: for (int i = -1; i < 2; ++i) {
            for (int j = -1; j < 2; ++j) {
                Chunk nChunk;
                if (i == 0 && j == 0 || (nChunk = world.func_212866_a_(tileX + i, tileZ + j)) != null && !(nChunk instanceof EmptyChunk)) continue;
                neighborsLoaded = false;
                continue block0;
            }
        }
        if (bchunk == null || bchunk instanceof EmptyChunk || !neighborsLoaded || (onlyLoad || tileFromCenterX > this.updateRadius || tileFromCenterZ > this.updateRadius || tileFromCenterX < -this.updateRadius || tileFromCenterZ < -this.updateRadius) && oldTile != null && oldTile.isSuccess() && oldChunk.getLevelsBuffered() == this.loadingLevels && !this.settingsChanged) {
            int j;
            if (oldTile != null && oldChunk.getLevelsBuffered() == this.loadingLevels && !this.settingsChanged) {
                mchunk.setTile(insideX, insideZ, oldTile);
                oldTile.setWasTransfered(true);
                for (j = 0; j < 16; ++j) {
                    this.lastBlockY[insideX][j] = oldTile.getLastHeight(j);
                    this.lastSlopeShades[insideX][j] = oldTile.getLastSlopeShade(j);
                }
                mchunk.setHasSomething(oldChunk.isHasSomething());
                if (this.forcedRefresh) {
                    mchunk.setChanged(true);
                }
            } else {
                for (j = 0; j < 16; ++j) {
                    this.lastBlockY[insideX][j] = 0;
                    this.lastSlopeShades[insideX][j] = 0;
                }
            }
            return;
        }
        if (oldTile != null && oldChunk.getLevelsBuffered() != this.loadingLevels) {
            oldTile = null;
        }
        int x1 = tileX * 16;
        int z1 = tileZ * 16;
        for (int blockX = x1; blockX < x1 + 16; ++blockX) {
            for (int blockZ = z1; blockZ < z1 + 16; ++blockZ) {
                MinimapTile tile = this.loadBlockColor(playerX, playerY, playerZ, world, blockX, blockZ, bchunk, canvasX, canvasZ, tileX, tileZ, insideX, insideZ, oldTile, mchunk);
                if ((blockZ & 0xF) != 15 || tile == null) continue;
                tile.setLastHeight(blockX & 0xF, this.lastBlockY[insideX][blockX & 0xF]);
                tile.setLastSlopeShade(blockX & 0xF, this.lastSlopeShades[insideX][blockX & 0xF]);
            }
        }
    }

    private int getShadeValue(int y, int prevY) {
        if (y < prevY) {
            if (this.loadingTerrainSlopesExperiment || this.loadingCaving != -1) {
                return 3 + Math.min(4, prevY - y);
            }
            return 2;
        }
        if (y > prevY) {
            return 3;
        }
        return 1;
    }

    public MinimapTile loadBlockColor(double playerX, double playerY, double playerZ, World world, int par1, int par2, Chunk bchunk, int canvasX, int canvasZ, int tileX, int tileZ, int tileInsideX, int tileInsideZ, MinimapTile oldTile, MinimapChunk mchunk) {
        MinimapTile tile;
        int i;
        boolean reuseColour;
        int lowY;
        int insideX = par1 & 0xF;
        int insideZ = par2 & 0xF;
        int playerYi = (int)playerY;
        int height = bchunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, insideX, insideZ);
        if (height == -1) {
            height = 255;
        }
        int highY = this.loadingCaving != -1 ? this.loadingCaving : height + 3;
        int n = lowY = this.loadingCaving != -1 ? playerYi - 30 : 0;
        if (lowY < 0) {
            lowY = 0;
        }
        this.pixelTransparentSizes.clear();
        this.pixelBlockStates.clear();
        this.pixelBlockLights.clear();
        this.currentComparisonCode = 0L;
        byte currentComparisonCodeAdd = 0;
        byte currentComparisonCodeAdd2 = 0;
        this.blockY = 0;
        for (int i2 = 0; i2 < this.loadingLevels; ++i2) {
            this.underRed[i2] = 0;
            this.underGreen[i2] = 0;
            this.underBlue[i2] = 0;
        }
        this.currentTransparencyMultiplier = 1.0f;
        this.sun = 15;
        this.blockColor = 0;
        this.isglowing = false;
        this.secondaryB = 1.0;
        Block block = this.findBlock(world, bchunk, insideX, insideZ, highY, lowY);
        boolean success = true;
        if (this.lastBlockY[tileInsideX][insideX] <= 0 && this.pixelTransparentSizes.isEmpty()) {
            this.lastBlockY[tileInsideX][insideX] = this.blockY;
            try {
                Chunk prevChunk = world.func_212866_a_(tileX, tileZ - 1);
                if (prevChunk != null) {
                    this.lastBlockY[tileInsideX][insideX] = prevChunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, insideX, 15);
                    int prevPrevY = prevChunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, insideX, 14);
                    this.lastSlopeShades[tileInsideX][insideX] = this.getShadeValue(this.lastBlockY[tileInsideX][insideX], prevPrevY);
                } else {
                    success = false;
                }
            }
            catch (IllegalStateException e) {
                success = false;
            }
        }
        int slopeShade = 1;
        if (this.loadingTerrainSlopes) {
            if (this.lastSlopeShades[tileInsideX][insideX] != 0) {
                slopeShade = this.getShadeValue(this.blockY, this.lastBlockY[tileInsideX][insideX]);
            }
            this.lastSlopeShades[tileInsideX][insideX] = slopeShade;
        }
        this.currentComparisonCode |= (long)(slopeShade << 18);
        for (int i3 = 0; i3 < this.pixelBlockLights.size(); ++i3) {
            int l = this.pixelBlockLights.get(i3);
            if (i3 <= 1) {
                currentComparisonCodeAdd = (byte)(currentComparisonCodeAdd | l << 4 * i3 + 2);
            }
            if (i3 < 1) continue;
            this.currentComparisonCode |= (long)(l << 4 * (i3 - 1) >> 2);
        }
        int add2Calculation = 17;
        add2Calculation = add2Calculation * 37 + this.loadingCaving;
        for (int i4 = 0; i4 < this.pixelTransparentSizes.size(); ++i4) {
            add2Calculation = add2Calculation * 37 + this.pixelTransparentSizes.get(i4);
        }
        currentComparisonCodeAdd = (byte)(currentComparisonCodeAdd | add2Calculation >> 8 & 3);
        currentComparisonCodeAdd2 = (byte)add2Calculation;
        boolean bl = reuseColour = !this.settingsChanged && oldTile != null && !oldTile.pixelChanged(insideX, insideZ, this.currentComparisonCode, currentComparisonCodeAdd, currentComparisonCodeAdd2);
        if (!reuseColour) {
            this.calculateBlockColors(world, bchunk, insideX, insideZ);
            boolean bl2 = this.isglowing = block != null && !(block instanceof OreBlock) && this.isglowing;
            if (!this.isglowing) {
                boolean lighting = this.loadingLevels != 1;
                boolean hasTransparentLayer = !this.pixelTransparentSizes.isEmpty();
                for (int i5 = 0; i5 < this.loadingLevels; ++i5) {
                    this.postBrightness[i5] = 1.0f;
                    if (!lighting && this.loadingCaving != -1) {
                        if (!hasTransparentLayer) {
                            this.brightness[i5] = (float)Math.min((double)this.blockY / (double)height, 1.0);
                            continue;
                        }
                        this.brightness[i5] = 1.0f;
                        this.postBrightness[i5] = (float)Math.min((double)this.blockY / (double)height, 1.0);
                        continue;
                    }
                    this.brightness[i5] = this.getBlockBrightness(5.0f, this.sun, i5, this.pixelBlockLights.isEmpty() ? 0 : this.pixelBlockLights.get(this.pixelBlockLights.size() - 1));
                }
                if (this.loadingCaving == -1 && this.loadingTerrainDepth) {
                    this.secondaryB = (double)this.blockY / 63.0;
                    if (this.secondaryB > 1.15) {
                        this.secondaryB = 1.15;
                    } else if (this.secondaryB < 0.7) {
                        this.secondaryB = 0.7;
                    }
                }
                if (this.loadingTerrainSlopes) {
                    float shadeMultiplier = slopeShade <= 3 ? (slopeShade == 2 ? 0.85f : (slopeShade == 3 ? 1.15f : 1.0f)) : 1.0f + (float)(3 - slopeShade) * 0.1f;
                    this.secondaryB *= (double)shadeMultiplier;
                }
            }
            if (this.isglowing) {
                this.helper.getBrightestColour(this.blockColor >> 16 & 0xFF, this.blockColor >> 8 & 0xFF, this.blockColor & 0xFF, this.tempColor);
            }
            for (i = 0; i < this.loadingLevels; ++i) {
                float b;
                if (this.isglowing) {
                    this.red[i] = this.tempColor[0];
                    this.green[i] = this.tempColor[1];
                    this.blue[i] = this.tempColor[2];
                    b = this.currentTransparencyMultiplier;
                } else {
                    this.red[i] = this.blockColor >> 16 & 0xFF;
                    this.green[i] = this.blockColor >> 8 & 0xFF;
                    this.blue[i] = this.blockColor & 0xFF;
                    b = this.brightness[i] * this.currentTransparencyMultiplier;
                }
                this.red[i] = (int)(((double)((float)this.red[i] * b) * this.secondaryB + (double)this.underRed[i]) * (double)this.postBrightness[i]);
                if (this.red[i] > 255) {
                    this.red[i] = 255;
                }
                this.green[i] = (int)(((double)((float)this.green[i] * b) * this.secondaryB + (double)this.underGreen[i]) * (double)this.postBrightness[i]);
                if (this.green[i] > 255) {
                    this.green[i] = 255;
                }
                this.blue[i] = (int)(((double)((float)this.blue[i] * b) * this.secondaryB + (double)this.underBlue[i]) * (double)this.postBrightness[i]);
                if (this.blue[i] <= 255) continue;
                this.blue[i] = 255;
            }
        } else {
            for (int i6 = 0; i6 < this.loadingLevels; ++i6) {
                this.red[i6] = oldTile.getRed(i6, insideX, insideZ);
                this.green[i6] = oldTile.getGreen(i6, insideX, insideZ);
                this.blue[i6] = oldTile.getBlue(i6, insideX, insideZ);
            }
        }
        this.lastBlockY[tileInsideX][insideX] = this.blockY;
        if (this.notEmptyColor()) {
            mchunk.setHasSomething(true);
        }
        if ((tile = mchunk.getTile(tileInsideX, tileInsideZ)) == null) {
            tile = MinimapTile.getANewTile(this.modMain.getSettings(), tileX, tileZ, this.seedForLoading);
            mchunk.setTile(tileInsideX, tileInsideZ, tile);
        }
        tile.setCode(insideX, insideZ, this.currentComparisonCode, currentComparisonCodeAdd, currentComparisonCodeAdd2);
        tile.setSuccess(success);
        if (oldTile != null) {
            int oldTileDarkestLevel = this.loadedLevels - 1;
            int tileDarkestLevel = this.loadingLevels - 1;
            if (oldTile.getRed(oldTileDarkestLevel, insideX, insideZ) != this.red[tileDarkestLevel] || oldTile.getGreen(oldTileDarkestLevel, insideX, insideZ) != this.green[tileDarkestLevel] || oldTile.getBlue(oldTileDarkestLevel, insideX, insideZ) != this.blue[tileDarkestLevel]) {
                mchunk.setChanged(true);
            }
        } else {
            mchunk.setChanged(true);
        }
        for (i = 0; i < this.loadingLevels; ++i) {
            tile.setRed(i, insideX, insideZ, this.red[i]);
            tile.setGreen(i, insideX, insideZ, this.green[i]);
            tile.setBlue(i, insideX, insideZ, this.blue[i]);
        }
        return tile;
    }

    public Block findBlock(World world, Chunk bchunk, int insideX, int insideZ, int highY, int lowY) {
        this.underair = false;
        this.previousTransparentState = null;
        for (int i = highY; i >= lowY; --i) {
            this.mutableBlockPos.func_181079_c(insideX, i, insideZ);
            BlockState state = bchunk.func_180495_p((BlockPos)this.mutableBlockPos);
            IFluidState fluidFluidState = bchunk.func_205751_b(insideX, i, insideZ);
            BlockState fluidState = fluidFluidState.func_206883_i();
            if (!fluidFluidState.func_206888_e()) {
                this.underair = true;
                if (this.findBlockHelp(world, bchunk, insideX, i, insideZ, fluidState, fluidFluidState)) {
                    return fluidState.func_177230_c();
                }
            }
            if (state == null || state.func_177230_c() != Blocks.field_150350_a && state.func_177230_c() == fluidState.func_177230_c() || !this.findBlockHelp(world, bchunk, insideX, i, insideZ, state, null)) continue;
            return state.func_177230_c();
        }
        return null;
    }

    private boolean findBlockHelp(World world, Chunk bchunk, int insideX, int i, int insideZ, BlockState state, IFluidState fluidFluidState) {
        Block got = state.func_177230_c();
        if (!(got instanceof AirBlock) && (this.underair || this.loadingCaving == -1)) {
            boolean isRedstone = false;
            if (!(got instanceof FlowingFluidBlock) && state.func_185901_i() == BlockRenderType.INVISIBLE) {
                return false;
            }
            if (got == Blocks.field_150478_aa) {
                return false;
            }
            if (got == Blocks.field_150349_c) {
                return false;
            }
            if (got instanceof DoublePlantBlock) {
                return false;
            }
            if (!this.modMain.getSettings().getShowFlowers() && got instanceof BushBlock) {
                return false;
            }
            boolean bl = isRedstone = got == Blocks.field_150429_aA || got == Blocks.field_150488_af || got instanceof RepeaterBlock || got instanceof ComparatorBlock;
            if (!this.loadingRedstone && isRedstone) {
                return false;
            }
            this.blockY = i;
            BlockPos.Mutable globalPos = this.mutableBlockPos2.func_181079_c(bchunk.func_76632_l().field_77276_a * 16 + insideX, this.blockY, bchunk.func_76632_l().field_77275_b * 16 + insideZ);
            BlockPos.Mutable lightPos = this.mutableBlockPos.func_181079_c(globalPos.func_177958_n(), globalPos.func_177956_o() + 1, globalPos.func_177952_p());
            MaterialColor mapColor = state.func_185909_g((IBlockReader)world, (BlockPos)globalPos);
            if (!(isRedstone && this.loadingColours != 1 || mapColor != null && mapColor.field_76291_p != 0)) {
                return false;
            }
            if (this.currentComparisonCode == 0L) {
                this.firstBlockY = this.blockY;
                if (this.loadingLevels != 1 && this.loadingCaving != -1) {
                    this.sun = world.func_226658_a_(LightType.SKY, (BlockPos)lightPos);
                }
            }
            int stateId = Block.func_196246_j((BlockState)state);
            if (this.loadingTransparency && this.isTransparent(state, fluidFluidState)) {
                if (this.pixelBlockStates.size() < 5 && state != this.previousTransparentState) {
                    this.currentComparisonCode += (long)stateId & 0xFFFFFFFFL;
                    this.pixelBlockStates.add(state);
                    this.pixelTransparentSizes.add(1);
                    this.pixelBlockLights.add(this.loadingLevels == 1 ? 0 : world.func_226658_a_(LightType.BLOCK, (BlockPos)lightPos));
                    this.previousTransparentState = state;
                } else {
                    this.pixelTransparentSizes.set(this.pixelTransparentSizes.size() - 1, this.pixelTransparentSizes.get(this.pixelTransparentSizes.size() - 1) + 1);
                }
                return false;
            }
            this.currentComparisonCode += (long)stateId & 0xFFFFFFFFL;
            this.currentComparisonCode <<= 29;
            this.currentComparisonCode |= (long)this.blockY << 21;
            this.pixelBlockLights.add(this.loadingLevels == 1 ? 0 : world.func_226658_a_(LightType.BLOCK, (BlockPos)lightPos));
            this.pixelBlockStates.add(state);
            this.isglowing = this.isGlowing(state, world, (BlockPos)globalPos);
            return true;
        }
        if (got instanceof AirBlock) {
            this.underair = true;
        }
        return false;
    }

    private void calculateBlockColors(World world, Chunk bchunk, int insideX, int insideZ) {
        BlockPos.Mutable globalPos = this.mutableBlockPos2.func_181079_c(bchunk.func_76632_l().field_77276_a * 16 + insideX, this.firstBlockY, bchunk.func_76632_l().field_77275_b * 16 + insideZ);
        if (!this.pixelTransparentSizes.isEmpty()) {
            BlockPos.Mutable lightPos = this.mutableBlockPos.func_181079_c(insideX, this.firstBlockY + 1, insideZ);
            for (int i = 0; i < this.pixelTransparentSizes.size(); ++i) {
                BlockState state = this.pixelBlockStates.get(i);
                Block b = state.func_177230_c();
                int size = this.pixelTransparentSizes.get(i);
                int opacity = state.func_200016_a((IBlockReader)bchunk.func_177412_p(), (BlockPos)globalPos);
                this.applyTransparentLayer(world, bchunk, b, state, opacity * size, (BlockPos)globalPos, this.pixelBlockLights.get(i));
                int nextY = globalPos.func_177956_o() - size;
                globalPos.func_185336_p(nextY);
                lightPos.func_185336_p(nextY + 1);
            }
        }
        if (!this.pixelBlockStates.isEmpty()) {
            BlockState state = this.pixelBlockStates.get(this.pixelBlockStates.size() - 1);
            Block b = state.func_177230_c();
            if (this.loadingColours == 1) {
                MaterialColor minimapColor = state.func_185909_g((IBlockReader)world, (BlockPos)globalPos);
                this.blockColor = minimapColor.field_76291_p;
            } else {
                this.blockColor = this.loadBlockColourFromTexture(world, state, b, (BlockPos)globalPos, true);
            }
            this.blockColor = this.addBlockColorMultipliers(this.blockColor, state, world, (BlockPos)globalPos);
        }
    }

    private boolean isTransparent(BlockState state, IFluidState fluidFluidState) {
        return state.func_177230_c() instanceof GlassBlock || (fluidFluidState == null ? RenderTypeLookup.canRenderInLayer((BlockState)state, (RenderType)RenderType.func_228645_f_()) : RenderTypeLookup.canRenderInLayer((IFluidState)fluidFluidState, (RenderType)RenderType.func_228645_f_()));
    }

    private boolean isGlowing(BlockState state, World world, BlockPos pos) {
        try {
            return state.getLightValue((IBlockReader)world, pos) > 0;
        }
        catch (Exception e) {
            return false;
        }
    }

    private void applyTransparentLayer(World world, Chunk bchunk, Block b, BlockState state, int opacity, BlockPos globalPos, int blockLight) {
        float transparency;
        int red = 0;
        int green = 0;
        int blue = 0;
        float f = b instanceof FlowingFluidBlock ? 0.66f : (transparency = b instanceof IceBlock ? 0.83f : 0.5f);
        int color = this.loadingColours == 0 ? this.loadBlockColourFromTexture(world, state, b, globalPos, true) : (b instanceof FlowingFluidBlock ? -16751391 : state.func_185909_g((IBlockReader)world, (BlockPos)globalPos).field_76291_p);
        color = this.addBlockColorMultipliers(color, state, world, globalPos);
        red = color >> 16 & 0xFF;
        green = color >> 8 & 0xFF;
        blue = color & 0xFF;
        if (this.isGlowing(state, bchunk.func_177412_p(), globalPos)) {
            this.helper.getBrightestColour(red, green, blue, this.tempColor);
            red = this.tempColor[0];
            green = this.tempColor[1];
            blue = this.tempColor[2];
        }
        int i = 0;
        while (i < this.loadingLevels) {
            float overlayIntensity = this.currentTransparencyMultiplier * transparency * this.getBlockBrightness(5.0f, this.sun, i, blockLight);
            int n = i;
            this.underRed[n] = (int)((float)this.underRed[n] + (float)red * overlayIntensity);
            int n2 = i;
            this.underGreen[n2] = (int)((float)this.underGreen[n2] + (float)green * overlayIntensity);
            int n3 = i++;
            this.underBlue[n3] = (int)((float)this.underBlue[n3] + (float)blue * overlayIntensity);
        }
        this.currentTransparencyMultiplier *= 1.0f - transparency;
        this.sun -= opacity;
        if (this.sun < 0) {
            this.sun = 0;
        }
    }

    private int loadBlockColourFromTexture(World world, BlockState state, Block b, BlockPos pos, boolean convert) {
        int stateHash = Block.func_196246_j((BlockState)state);
        Integer c = this.blockColours.get(stateHash);
        int red = 0;
        int green = 0;
        int blue = 0;
        if (c == null) {
            String name = null;
            try {
                Integer cachedColour;
                TextureAtlasSprite texture;
                List upQuads = null;
                BlockModelShapes bms = Minecraft.func_71410_x().func_175602_ab().func_175023_a();
                IBakedModel model = bms.func_178125_b(state);
                if (convert) {
                    upQuads = model.func_200117_a(state, Direction.UP, this.usedRandom);
                }
                TextureAtlasSprite missingTexture = Minecraft.func_71410_x().func_209506_al().func_229356_a_(AtlasTexture.field_110575_b).func_195424_a(null);
                if (upQuads == null || upQuads.isEmpty() || ((BakedQuad)upQuads.get(0)).func_187508_a() == missingTexture) {
                    texture = bms.func_178122_a(state);
                    if (texture == missingTexture) {
                        List quads;
                        for (int i = Direction.values().length - 1; i >= 0 && (i == 1 || (quads = model.func_200117_a(state, Direction.values()[i], this.usedRandom)).isEmpty() || (texture = ((BakedQuad)quads.get(0)).func_187508_a()) == missingTexture); --i) {
                        }
                    }
                } else {
                    texture = ((BakedQuad)upQuads.get(0)).func_187508_a();
                }
                name = texture.func_195668_m() + ".png";
                if (b instanceof OreBlock && b != Blocks.field_196766_fg) {
                    name = "minecraft:block/stone.png";
                }
                c = -1;
                String[] args = name.split(":");
                if (args.length < 2) {
                    args = new String[]{"minecraft", args[0]};
                }
                if ((cachedColour = this.textureColours.get(name)) == null) {
                    ResourceLocation location = new ResourceLocation(args[0], "textures/" + args[1]);
                    IResource resource = Minecraft.func_71410_x().func_195551_G().func_199002_a(location);
                    InputStream input = resource.func_199027_b();
                    BufferedImage img = ImageIO.read(input);
                    red = 0;
                    green = 0;
                    blue = 0;
                    int total = 64;
                    int tw = img.getWidth();
                    int diff = tw / 8;
                    for (int i = 0; i < 8; ++i) {
                        for (int j = 0; j < 8; ++j) {
                            int rgb = img.getRGB(i * diff, j * diff);
                            int alpha = rgb >> 24 & 0xFF;
                            if (rgb == 0 || alpha == 0) {
                                --total;
                                continue;
                            }
                            red += rgb >> 16 & 0xFF;
                            green += rgb >> 8 & 0xFF;
                            blue += rgb & 0xFF;
                        }
                    }
                    input.close();
                    if (total == 0) {
                        total = 1;
                    }
                    if (convert && (red /= total) == 0 && (green /= total) == 0 && (blue /= total) == 0) {
                        throw new Exception("Black texture");
                    }
                    c = 0xFF000000 | red << 16 | green << 8 | blue;
                    this.textureColours.put(name, c);
                } else {
                    c = cachedColour;
                }
            }
            catch (FileNotFoundException e) {
                if (convert) {
                    return this.loadBlockColourFromTexture(world, state, b, pos, false);
                }
                c = 0;
                if (state != null && state.func_185909_g((IBlockReader)world, pos) != null) {
                    c = state.func_185909_g((IBlockReader)world, (BlockPos)pos).field_76291_p;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                System.out.println("Block file not found: " + b.getRegistryName());
            }
            catch (Exception e) {
                if (state.func_185909_g((IBlockReader)world, pos) != null) {
                    c = state.func_185909_g((IBlockReader)world, (BlockPos)pos).field_76291_p;
                }
                if (name != null) {
                    this.textureColours.put(name, c);
                }
                System.out.println("Exception when loading " + b.getRegistryName() + " texture, using material colour.");
            }
            if (c != null) {
                this.blockColours.put(stateHash, c);
            }
        }
        return c;
    }

    private int addBlockColorMultipliers(int c, BlockState state, World world, BlockPos pos) {
        if (this.modMain.getSettings().getBlockColours() == 1 && !this.loadingBiomesVanillaMode) {
            return c;
        }
        int grassColor = 0xFFFFFF;
        try {
            grassColor = Minecraft.func_71410_x().func_184125_al().func_228054_a_(state, (ILightReader)world, pos, 0);
        }
        catch (IllegalArgumentException illegalArgumentException) {
        }
        catch (NullPointerException nullPointerException) {
        }
        catch (IllegalStateException illegalStateException) {
        }
        catch (IndexOutOfBoundsException indexOutOfBoundsException) {
        }
        catch (ReportedException reportedException) {
            // empty catch block
        }
        if (grassColor != 0xFFFFFF) {
            float rMultiplier = (float)(c >> 16 & 0xFF) / 255.0f;
            float gMultiplier = (float)(c >> 8 & 0xFF) / 255.0f;
            float bMultiplier = (float)(c & 0xFF) / 255.0f;
            int red = (int)((float)(grassColor >> 16 & 0xFF) * rMultiplier);
            int green = (int)((float)(grassColor >> 8 & 0xFF) * gMultiplier);
            int blue = (int)((float)(grassColor & 0xFF) * bMultiplier);
            c = 0xFF000000 | red << 16 | green << 8 | blue;
        }
        return c;
    }

    private boolean ignoreWorld(World world) {
        for (int i = 0; i < dimensionsToIgnore.length; ++i) {
            if (!dimensionsToIgnore[i].equals(WaypointsManager.getDimensionKey(world.func_201675_m().func_186058_p()).func_110623_a())) continue;
            return true;
        }
        return false;
    }

    private int getCaving(double playerX, double playerY, double playerZ, World world) {
        if (!this.modMain.getSettings().getCaveMaps()) {
            return -1;
        }
        if (this.ignoreWorld(world)) {
            return this.lastCaving;
        }
        int y = Math.max((int)playerY + 1, 0);
        if (y > 255 || y < 0) {
            return -1;
        }
        int x = OptimizedMath.myFloor(playerX);
        int z = OptimizedMath.myFloor(playerZ);
        this.mutableBlockPos.func_181079_c(x, y, z);
        Chunk bchunk = world.func_212866_a_(x >> 4, z >> 4);
        if (bchunk == null) {
            return -1;
        }
        int skyLight = world.func_226658_a_(LightType.SKY, (BlockPos)this.mutableBlockPos);
        if (skyLight < 15) {
            int roofRadius = this.modMain.getSettings().caveMaps - 1;
            int insideX = x & 0xF;
            int insideZ = z & 0xF;
            int top = bchunk.func_201576_a(Heightmap.Type.WORLD_SURFACE, insideX, insideZ);
            for (int i = y; i <= top; ++i) {
                boolean roofExists = true;
                block1: for (int o = x - roofRadius; o <= x + roofRadius; ++o) {
                    for (int p = z - roofRadius; p <= z + roofRadius; ++p) {
                        this.mutableBlockPos.func_181079_c(o, i, p);
                        BlockState state = world.func_180495_p((BlockPos)this.mutableBlockPos);
                        if (state.func_185904_a().func_76218_k()) continue;
                        roofExists = false;
                        break block1;
                    }
                }
                if (!roofExists) continue;
                this.lastCaving = Math.min(i, y + 3);
                return this.lastCaving;
            }
        }
        return -1;
    }

    public int getLoadSide() {
        return 9;
    }

    public int getUpdateRadiusInChunks() {
        return (int)Math.ceil((double)this.loadingSideInChunks / 2.0 / this.modMain.getInterfaces().getMinimap().getMinimapZoom());
    }

    public int getMapCoord(int side, double coord) {
        return (OptimizedMath.myFloor(coord) >> 6) - side / 2;
    }

    public int getLoadedCaving() {
        return this.loadedCaving;
    }

    private boolean notEmptyColor() {
        return this.red[0] != 0 || this.green[0] != 0 || this.blue[0] != 0;
    }

    public float getBlockBrightness(float min, int sun, int lightLevel, int blockLight) {
        if (this.loadingLevels == 1) {
            return (min + (float)sun) / (15.0f + min);
        }
        return (min + Math.max((lightLevel == -1 || lightLevel == 0 ? 1.0f : ((float)this.loadingLevels - 1.0f - (float)lightLevel) / ((float)this.loadingLevels - 1.0f)) * (float)sun, (float)blockLight)) / (15.0f + min);
    }

    public MinimapChunk[][] getLoadedBlocks() {
        return this.loadedBlocks;
    }

    public int getLoadedMapChunkZ() {
        return this.loadedMapChunkZ;
    }

    public int getLoadedMapChunkX() {
        return this.loadedMapChunkX;
    }

    public int getLoadedLevels() {
        return this.loadedLevels;
    }

    public void setClearBlockColours(boolean clearBlockColours) {
        this.clearBlockColours = clearBlockColours;
    }

    public Long getSeedForLoading() {
        return this.seedForLoading;
    }

    public void setSeedForLoading(Long seedForLoading) {
        this.seedForLoading = seedForLoading;
    }
}

