/*
 * Decompiled with CFR 0.152.
 */
package xaero.pvp.interfaces;

import com.mojang.blaze3d.matrix.MatrixStack;
import com.mojang.blaze3d.systems.RenderSystem;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import net.minecraft.client.Minecraft;
import net.minecraft.client.entity.player.ClientPlayerEntity;
import net.minecraft.client.gui.AbstractGui;
import net.minecraft.client.gui.FontRenderer;
import net.minecraft.client.gui.IngameGui;
import net.minecraft.client.gui.screen.Screen;
import net.minecraft.client.renderer.BufferBuilder;
import net.minecraft.client.renderer.IRenderTypeBuffer;
import net.minecraft.client.renderer.RenderHelper;
import net.minecraft.client.renderer.Tessellator;
import net.minecraft.client.renderer.Vector3f;
import net.minecraft.client.renderer.entity.EntityRendererManager;
import net.minecraft.client.renderer.texture.PotionSpriteUploader;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.renderer.vertex.DefaultVertexFormats;
import net.minecraft.client.resources.I18n;
import net.minecraft.client.world.ClientWorld;
import net.minecraft.enchantment.Enchantment;
import net.minecraft.entity.Entity;
import net.minecraft.entity.LivingEntity;
import net.minecraft.entity.SharedMonsterAttributes;
import net.minecraft.entity.ai.attributes.IAttributeInstance;
import net.minecraft.entity.item.TNTEntity;
import net.minecraft.entity.monster.CreeperEntity;
import net.minecraft.entity.player.PlayerEntity;
import net.minecraft.entity.player.ServerPlayerEntity;
import net.minecraft.entity.projectile.ArrowEntity;
import net.minecraft.inventory.EquipmentSlotType;
import net.minecraft.item.ArrowItem;
import net.minecraft.item.BowItem;
import net.minecraft.item.Food;
import net.minecraft.item.Item;
import net.minecraft.item.ItemStack;
import net.minecraft.item.Items;
import net.minecraft.nbt.ListNBT;
import net.minecraft.potion.Effect;
import net.minecraft.potion.EffectInstance;
import net.minecraft.util.Hand;
import net.minecraft.util.HandSide;
import net.minecraft.util.ResourceLocation;
import net.minecraft.util.StringUtils;
import net.minecraft.util.math.AxisAlignedBB;
import net.minecraft.util.math.EntityRayTraceResult;
import net.minecraft.util.math.MathHelper;
import net.minecraft.util.math.RayTraceResult;
import net.minecraft.util.math.Vec3d;
import net.minecraft.util.text.ITextComponent;
import net.minecraft.util.text.StringTextComponent;
import net.minecraft.world.World;
import net.minecraftforge.fml.client.gui.GuiUtils;
import net.minecraftforge.registries.ForgeRegistries;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.gui.GuiEditMode;
import xaero.common.interfaces.IInterfaceLoader;
import xaero.common.interfaces.Interface;
import xaero.common.interfaces.InterfaceManager;
import xaero.common.interfaces.Preset;
import xaero.common.interfaces.render.InterfaceRenderer;
import xaero.common.minimap.MinimapInterface;
import xaero.common.settings.ModOptions;
import xaero.common.settings.ModSettings;
import xaero.pvp.BetterPVP;
import xaero.pvp.interfaces.BPVPInterfaceHandler;
import xaero.pvp.notifications.Notification;
import xaero.pvp.notifications.NotificationHandler;

public class BPVPInterfaceLoader
implements IInterfaceLoader {
    private BetterPVP modMain;
    private Minecraft mc = Minecraft.func_71410_x();
    public static Random rand = new Random();
    public static long arrowWas = 0L;

    public BPVPInterfaceLoader(BetterPVP modMain) {
        this.modMain = modMain;
    }

    @Override
    public void loadPresets(InterfaceManager interfaces) {
        interfaces.addPreset(new Preset("gui.xaero_preset_fancy", new int[][]{{0, 0}, {0, 0}, {0, 0}, {0, 36}, {0, 0}, {0, 0}, {0, 128}}, new boolean[][]{{true, false, false}, {true, false, true}, {true, false, true}, {true, false, false}, {false, true, false}, {false, false, false}, {false, true, true}}));
        interfaces.addPreset(new Preset("gui.xaero_preset_classic", new int[][]{{0, 0}, {0, 10000}, {0, 10000}, {0, 0}, {0, 0}, {0, 10000}, {0, 186}}, new boolean[][]{{false, true, false}, {false, true, false}, {true, false, false}, {true, false, false}, {false, false, false}, {false, false, false}, {false, true, true}}));
        interfaces.addPreset(new Preset("gui.xaero_preset_social", new int[][]{{0, 0}, {0, 0}, {0, 10000}, {0, 41}, {0, 0}, {0, 10000}, {0, 78}}, new boolean[][]{{true, false, false}, {true, false, false}, {true, false, false}, {true, false, false}, {false, false, false}, {false, false, false}, {false, true, false}}));
    }

    @Override
    public void load(IXaeroMinimap main, InterfaceManager interfaces) throws IOException {
        interfaces.add(new Interface(interfaces, "gui.xaero_potion_status", interfaces.getNextId(), 120, 165, 182, 36, ModOptions.SHOW_EFFECTS){

            @Override
            public void drawInterface(int width, int height, double scale, float partial) {
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                GL11.glEnable((int)3008);
                if (!((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.func_70651_bq().isEmpty()) {
                    BPVPInterfaceLoader.this.displayDebuffEffects(this, width, height);
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.drawInterface(width, height, scale, partial);
            }
        });
        interfaces.add(new Interface(interfaces, "gui.xaero_armour_status", interfaces.getNextId(), 150, 136, 400, 41, ModOptions.SHOW_ARMOR){

            @Override
            public void drawInterface(int width, int height, double scale, float partial) {
                GL11.glEnable((int)3008);
                RenderSystem.enableDepthTest();
                if (!this.isCentered()) {
                    BPVPInterfaceLoader.this.drawClassicArmour(this.getX(), this.getY(), this.getW(), this.getH(), width, height, this.shouldFlip(width));
                } else {
                    BPVPInterfaceLoader.this.drawCenteredArmour(this.getX(), this.getY(), this.getW(), this.getH(), width, height);
                }
                RenderHelper.func_74518_a();
                RenderSystem.disableDepthTest();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.drawInterface(width, height, scale, partial);
            }
        });
        interfaces.add(new Interface(interfaces, "gui.xaero_xp_setting", interfaces.getNextId(), 50, 86, ModOptions.XP){
            private int lastXPCheck;
            public long xpDelay;
            {
                this.lastXPCheck = 0;
                this.xpDelay = 0L;
            }

            @Override
            public void drawInterface(int width, int height, double scale, float partial) {
                ClientPlayerEntity player = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g;
                NotificationHandler nh = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.notifications;
                if (System.currentTimeMillis() - this.xpDelay >= 1000L) {
                    this.xpDelay = System.currentTimeMillis();
                    int totalXP = player.field_71067_cb;
                    if (this.lastXPCheck != totalXP) {
                        String xp = (totalXP - this.lastXPCheck > 0 ? "\u00a7e+" : "\u00a7e") + (totalXP - this.lastXPCheck) + " XP";
                        nh.notifications.add(new Notification(xp, 5000, this.getX() + this.getW() / 2 - ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71466_p.func_78256_a(xp) / 2, this.getY() + 39));
                        this.lastXPCheck = totalXP;
                    }
                }
                ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.notifications.drawNotifications();
                super.drawInterface(width, height, scale, partial);
            }
        });
        interfaces.add(new Interface(interfaces, "gui.xaero_notifications", interfaces.getNextId(), 200, 42, ModOptions.NOTIFICATIONS){

            @Override
            public void drawInterface(int width, int height, double scale, float partial) {
                ArrayList<Integer> notifications = new ArrayList<Integer>();
                if ((float)((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.func_71024_bL().func_75116_a() <= (float)(2 * ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().lowHunger) && BPVPInterfaceLoader.this.modMain.getBPVPSettings().getNotificationHunger()) {
                    notifications.add(0);
                }
                if (((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.func_110143_aJ() <= (float)(2 * ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().lowHealth) && BPVPInterfaceLoader.this.modMain.getBPVPSettings().getNotificationHP()) {
                    notifications.add(1);
                }
                if (BPVPInterfaceLoader.this.tntIsAround() && BPVPInterfaceLoader.this.modMain.getBPVPSettings().getNotificationTNT()) {
                    notifications.add(2);
                }
                if (BPVPInterfaceLoader.this.arrowIsAround() && BPVPInterfaceLoader.this.modMain.getBPVPSettings().getNotificationArrow()) {
                    notifications.add(3);
                }
                if (((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.func_70086_ai() <= 30 * ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().lowAir && BPVPInterfaceLoader.this.modMain.getBPVPSettings().getNotificationAir()) {
                    notifications.add(4);
                }
                int between = 32 - 4 * notifications.size();
                int unitSize = 32 + between;
                int length = notifications.size() * unitSize;
                int drawY = this.getY() + (this.getH() - 32) / 2;
                GL11.glEnable((int)3008);
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                if (length > 0) {
                    BPVPInterfaceLoader.this.mc.func_110434_K().func_110577_a(InterfaceRenderer.guiTextures);
                    if (BPVPInterfaceHandler.blinking) {
                        RenderSystem.color4f((float)0.6f, (float)0.6f, (float)0.6f, (float)1.0f);
                    }
                    for (int i = 0; i < notifications.size(); ++i) {
                        int n = (Integer)notifications.get(i);
                        int drawX = this.getX() + this.getW() / 2 - length / 2 + i * unitSize + between / 2;
                        ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71456_v.blit(drawX, drawY, 17, n * 32, 32, 32);
                    }
                    BPVPInterfaceLoader.this.mc.func_110434_K().func_110577_a(AbstractGui.GUI_ICONS_LOCATION);
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.drawInterface(width, height, scale, partial);
            }
        });
        interfaces.add(new MinimapInterface(this.modMain, interfaces.getNextId(), interfaces));
        interfaces.add(new Interface(interfaces, "gui.xaero_entity_info", interfaces.getNextId(), 148, 70, ModOptions.ENTITY_INFO){
            LivingEntity e;
            long lastFind;
            {
                this.e = null;
                this.lastFind = 0L;
            }

            @Override
            public void drawInterface(int width, int height, double scale, float partial) {
                long time = System.currentTimeMillis();
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                EntityRayTraceResult objectMouseOver = null;
                if (BPVPInterfaceLoader.this.mc.func_71401_C() != null) {
                    ServerPlayerEntity playerServerSide = BPVPInterfaceLoader.this.mc.func_71401_C().func_184103_al().func_177451_a(((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.func_110124_au());
                    if (playerServerSide != null) {
                        objectMouseOver = BPVPInterfaceLoader.this.getMouseOver(playerServerSide.field_70170_p, ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoDistance, partial);
                    }
                } else {
                    objectMouseOver = BPVPInterfaceLoader.this.getMouseOver((World)((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71441_e, ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoDistance, partial);
                }
                if (objectMouseOver != null && objectMouseOver.func_216348_a() instanceof LivingEntity) {
                    this.e = (LivingEntity)objectMouseOver.func_216348_a();
                    this.lastFind = time;
                }
                if (this.e != null && !this.e.func_98034_c((PlayerEntity)((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g) && time - this.lastFind <= (long)(1000 * ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoStay)) {
                    try {
                        int healthOff;
                        boolean vertFlipped = this.getY() + this.getH() / 2 > height / 2;
                        boolean flip = this.shouldFlip(width);
                        float resize = 1.0f;
                        if (this.e.func_213311_cf() > resize) {
                            resize = this.e.func_213311_cf();
                        }
                        if (this.e.func_213302_cg() > resize * 2.0f) {
                            resize = this.e.func_213302_cg() / 2.0f;
                        }
                        if (((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoShowEntityModel) {
                            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)-500.0f);
                            RenderSystem.enableDepthTest();
                            BPVPInterfaceLoader.this.drawEntityOnScreen(this.getX() + (flip ? this.getW() - 25 : 25), this.getY() + 35, (int)(30.0f / resize), this.e, flip);
                            RenderSystem.disableDepthTest();
                            RenderSystem.translatef((float)0.0f, (float)0.0f, (float)500.0f);
                        }
                        int n = healthOff = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoShowEntityModel ? 55 : 5;
                        if (BPVPInterfaceLoader.this.mc.func_71401_C() != null && ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoEffects) {
                            int effectsOffset = (int)BPVPInterfaceLoader.this.drawPotionEffects(this.e, this.getX() + (flip ? this.getW() - 3 : 3), this.getY() + (vertFlipped ? this.getH() - 5 : 5), vertFlipped ? this.getY() + this.getH() : height - this.getY(), flip, vertFlipped, scale);
                            if (healthOff == 5 && effectsOffset != -1) {
                                healthOff = 8 + effectsOffset;
                            }
                        }
                        boolean armourDrawn = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).modMain.getBPVPSettings().entityInfoShowArmour && BPVPInterfaceLoader.this.drawArmourBar(this.e, this.getX() + (flip ? this.getW() - healthOff : healthOff), this.getY() + 15 + (vertFlipped ? 31 : 0), flip, vertFlipped);
                        BPVPInterfaceLoader.this.drawHealthBar(this.e, this.getX() + (flip ? this.getW() - healthOff : healthOff), this.getY() + 15 + (vertFlipped ? 31 : 0) + (armourDrawn ? 10 : 0) * (vertFlipped ? -1 : 1), flip, vertFlipped);
                        String name = this.e.func_195051_bN().func_197037_c();
                        int xCoord = this.getX() + (flip ? this.getW() - healthOff - ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71466_p.func_78256_a(name) : healthOff);
                        ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71466_p.func_175063_a(name, (float)xCoord, (float)(this.getY() + 5 + (vertFlipped ? 52 : 0)), 0xFFFFFF);
                    }
                    catch (Exception e) {
                        System.out.println("Please report this to Xaero96 on PlanetMinecraft/MinecraftForums!!!");
                        e.printStackTrace();
                    }
                }
                RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                super.drawInterface(width, height, scale, partial);
            }
        });
        interfaces.add(new Interface(interfaces, "gui.xaero_item_tooltip", interfaces.getNextId(), 150, 50, ModOptions.ITEM_TOOLTIP){
            private Screen screenInstance;
            private ItemStack previousStack;
            private long itemSwitchTime;
            {
                this.screenInstance = new Screen((ITextComponent)new StringTextComponent("")){

                    public void init(Minecraft p_init_1_, int p_init_2_, int p_init_3_) {
                        this.minecraft = p_init_1_;
                    }
                };
            }

            @Override
            public void drawInterface(int width, int height, double scale, float partial) {
                ItemStack currentStack = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71439_g.field_71071_by.func_70448_g();
                if (currentStack != this.previousStack) {
                    this.itemSwitchTime = System.currentTimeMillis();
                    this.previousStack = currentStack;
                }
                if (currentStack != null && currentStack.func_77973_b() != Items.field_190931_a) {
                    List textLines;
                    this.screenInstance.init(BPVPInterfaceLoader.this.mc, 0, 0);
                    if ((((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71462_r instanceof GuiEditMode || System.currentTimeMillis() - this.itemSwitchTime <= (long)(BPVPInterfaceLoader.this.modMain.getBPVPSettings().getItemTooltipTime() * 1000 / 2)) && (textLines = this.screenInstance.getTooltipFromItem(currentStack)).size() >= BPVPInterfaceLoader.this.modMain.getBPVPSettings().getItemTooltipMinLines()) {
                        int border = 5;
                        int renderX = this.getX() + border;
                        int renderY = this.getY() + border;
                        int renderW = this.getW() - 2 * border;
                        int renderH = this.getH() - 2 * border;
                        int screenWidth = width;
                        int screenHeight = height;
                        if (this.isCentered() || this.isFromRight() && !this.isFlipped() || !this.isFromRight() && this.isFlipped()) {
                            int tooltipTextWidth = 0;
                            for (String textLine : textLines) {
                                int textLineWidth = ((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71466_p.func_78256_a(textLine);
                                if (textLineWidth <= tooltipTextWidth) continue;
                                tooltipTextWidth = textLineWidth;
                            }
                            int tooltipWidth = tooltipTextWidth + 8;
                            if (this.isCentered()) {
                                renderX += (renderW - tooltipWidth) / 2;
                            } else {
                                screenWidth = renderX + renderW;
                                renderX += renderW - tooltipWidth;
                            }
                        }
                        if (this.isFromBottom()) {
                            int tooltipHeight = 16;
                            if (textLines.size() > 1) {
                                tooltipHeight += 2 + (textLines.size() - 1) * 10;
                            }
                            screenHeight = renderY + renderH;
                            renderY += renderH - tooltipHeight;
                        }
                        GuiUtils.preItemToolTip((ItemStack)currentStack);
                        GuiUtils.drawHoveringText((List)textLines, (int)(renderX - 8), (int)(renderY + 16), (int)screenWidth, (int)screenHeight, (int)-1, (FontRenderer)((BPVPInterfaceLoader)BPVPInterfaceLoader.this).mc.field_71466_p);
                        GuiUtils.postItemToolTip();
                        RenderHelper.func_74518_a();
                    }
                }
                super.drawInterface(width, height, scale, partial);
            }
        });
    }

    public EntityRayTraceResult getMouseOver(World world, double reach, float p_78473_1_) {
        Entity entity = this.mc.func_175606_aa();
        if (entity != null && world != null) {
            List list;
            RayTraceResult objectMouseOver = entity.func_213324_a(reach, p_78473_1_, false);
            Vec3d playerEyes = entity.func_174824_e(p_78473_1_);
            double d2 = reach;
            if (objectMouseOver != null) {
                d2 = objectMouseOver.func_216347_e().func_72438_d(playerEyes);
            }
            Vec3d lookVector = entity.func_70676_i(p_78473_1_);
            Vec3d farthestPoint = playerEyes.func_72441_c(lookVector.field_72450_a * d2, lookVector.field_72448_b * d2, lookVector.field_72449_c * d2);
            Entity pointedEntity = null;
            float f1 = 1.0f;
            try {
                list = world.func_72839_b(entity, entity.func_174813_aQ().func_72321_a(lookVector.field_72450_a * d2, lookVector.field_72448_b * d2, lookVector.field_72449_c * d2).func_72321_a((double)f1, (double)f1, (double)f1));
            }
            catch (IndexOutOfBoundsException ioobe) {
                return null;
            }
            for (int i = 0; i < list.size(); ++i) {
                double d3;
                Entity entity1 = (Entity)list.get(i);
                if (!entity1.func_70067_L() || entity1.func_145782_y() == entity.func_145782_y()) continue;
                float f2 = entity1.func_70111_Y();
                AxisAlignedBB axisalignedbb = entity1.func_174813_aQ().func_72321_a((double)f2, (double)f2, (double)f2);
                Optional movingobjectposition = axisalignedbb.func_216365_b(playerEyes, farthestPoint);
                if (axisalignedbb.func_72318_a(playerEyes)) {
                    if (!(d2 >= 0.0)) continue;
                    pointedEntity = entity1;
                    d2 = 0.0;
                    continue;
                }
                if (!movingobjectposition.isPresent() || !((d3 = playerEyes.func_72438_d((Vec3d)movingobjectposition.get())) < d2) && d2 != 0.0) continue;
                if (entity1 == entity.func_184187_bx() && !entity.canRiderInteract()) {
                    if (d2 != 0.0) continue;
                    pointedEntity = entity1;
                    continue;
                }
                pointedEntity = entity1;
                d2 = d3;
            }
            if (pointedEntity != null && (d2 < reach || objectMouseOver == null)) {
                return new EntityRayTraceResult(pointedEntity);
            }
            return null;
        }
        return null;
    }

    public double drawPotionEffects(LivingEntity e, int x, int y, int h, boolean flip, boolean vertFlipped, double scale) {
        ArrayList effects = new ArrayList(e.func_70651_bq());
        if (effects.isEmpty()) {
            return -1.0;
        }
        Collections.sort(effects);
        int place = 0;
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)x, (float)y, (float)0.0f);
        RenderSystem.enableBlend();
        PotionSpriteUploader potionspriteuploader = this.mc.func_213248_ap();
        double pixelSize = (double)this.modMain.getBPVPSettings().entityInfoEffectsScale / scale * (double)this.modMain.getBPVPSettings().getMinimapScale();
        double effectSize = 25.0 * pixelSize;
        int perColumn = (int)((double)h / effectSize);
        for (EffectInstance pe : effects) {
            Effect p;
            RenderSystem.pushMatrix();
            RenderSystem.scaled((double)pixelSize, (double)pixelSize, (double)1.0);
            int column = place / perColumn;
            int row = place % perColumn;
            RenderSystem.translatef((float)(flip ? (float)(-18 - 25 * column) : (float)(25 * column)), (float)(vertFlipped ? (float)(-18 - 25 * row) : (float)(25 * row)), (float)0.0f);
            if (pe == null || (p = pe.func_188419_a()) == null) continue;
            if (p.shouldRender(pe)) {
                TextureAtlasSprite textureatlassprite = potionspriteuploader.func_215288_a(p);
                this.mc.func_110434_K().func_110577_a(textureatlassprite.func_229241_m_().func_229223_g_());
                if (pe.func_76459_b() <= 200 && !BPVPInterfaceHandler.blinking) {
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.4f);
                }
                AbstractGui.blit((int)0, (int)0, (int)0, (int)18, (int)18, (TextureAtlasSprite)textureatlassprite);
            }
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            ++place;
            RenderSystem.popMatrix();
        }
        RenderSystem.popMatrix();
        return effectSize * (double)(1 + effects.size() / perColumn) - 7.0 * pixelSize;
    }

    public boolean drawArmourBar(LivingEntity e, int x, int y, boolean flip, boolean vertFlipped) {
        this.mc.func_110434_K().func_110577_a(IngameGui.GUI_ICONS_LOCATION);
        int k2 = e.func_70658_aO();
        if (k2 > 0) {
            if (this.modMain.getBPVPSettings().entityInfoArmourNumbers) {
                this.mc.field_71456_v.blit(x - (flip ? 8 : 0), y, 34, 9, 9, 9);
                this.mc.field_71466_p.func_175063_a(k2 + "/20", (float)(x + (flip ? -11 - this.mc.field_71466_p.func_78256_a(k2 + "/20") : 11)), (float)y, 0xFFFFFF);
            } else {
                for (int i3 = 0; i3 < 10; ++i3) {
                    int j3 = x + (flip ? -8 - i3 * 8 : i3 * 8);
                    if (i3 * 2 + 1 < k2) {
                        this.mc.field_71456_v.blit(j3, y, 34, 9, 9, 9);
                    }
                    if (i3 * 2 + 1 == k2) {
                        this.mc.field_71456_v.blit(j3, y, 25, 9, 9, 9);
                    }
                    if (i3 * 2 + 1 <= k2) continue;
                    this.mc.field_71456_v.blit(j3, y, 16, 9, 9, 9);
                }
            }
            return true;
        }
        return false;
    }

    public void drawHealthBar(LivingEntity e, int x, int y, boolean flip, boolean vertFlipped) {
        float f1;
        int health = MathHelper.func_76123_f((float)e.func_110143_aJ());
        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        RenderSystem.enableBlend();
        IAttributeInstance iattributeinstance = e.func_110148_a(SharedMonsterAttributes.field_111267_a);
        float maxHealth = (float)iattributeinstance.func_111126_e();
        if (this.modMain.getBPVPSettings().entityInfoHealthNumbers) {
            String text = health + "/" + (int)maxHealth;
            this.mc.field_71466_p.func_175063_a(text, (float)(x + (flip ? -11 - this.mc.field_71466_p.func_78256_a(text) : 11)), (float)y, 0xFFFFFF);
            health = 2;
            maxHealth = 2.0f;
        }
        this.mc.func_110434_K().func_110577_a(IngameGui.GUI_ICONS_LOCATION);
        float f = Math.min((float)(this.modMain.getBPVPSettings().entityInfoMaxHearts * 2), maxHealth);
        int i = (int)((float)health * f / maxHealth);
        float f2 = f1 = e.func_110139_bj();
        int l1 = MathHelper.func_76123_f((float)((f + f1) / 2.0f / 10.0f));
        int i2 = Math.max(10 - (l1 - 2), 3);
        int i1 = x;
        int k1 = y;
        int l2 = -1;
        for (int i3 = MathHelper.func_76123_f((float)((f + f1) / 2.0f)) - 1; i3 >= 0; --i3) {
            int j3 = 16;
            int b0 = 1;
            int k3 = MathHelper.func_76123_f((float)((float)(i3 + 1) / 10.0f)) - 1;
            int xcoord = i3 % 10 * 8;
            int l3 = i1 + (flip ? -xcoord - 9 : xcoord);
            int i4 = k1 + k3 * i2 * (vertFlipped ? -1 : 1);
            if ((double)i <= (double)f * 0.4) {
                i4 += rand.nextInt(2);
            }
            if (i3 == l2) {
                i4 -= 2;
            }
            int b1 = 0;
            if (e.field_70170_p.func_72912_H().func_76093_s()) {
                b1 = 5;
            }
            this.drawMyTexturedModalRect(l3, i4, 16 + b0 * 9, 9 * b1, 9, 9, flip);
            if (f2 > 0.0f) {
                if (f2 == f1 && f1 % 2.0f == 1.0f) {
                    this.drawMyTexturedModalRect(l3, i4, j3 + 153, 9 * b1, 9, 9, flip);
                } else {
                    this.drawMyTexturedModalRect(l3, i4, j3 + 144, 9 * b1, 9, 9, flip);
                }
                f2 -= 2.0f;
                continue;
            }
            if (i3 * 2 + 1 < i) {
                this.drawMyTexturedModalRect(l3, i4, j3 + 36, 9 * b1, 9, 9, flip);
            }
            if (i3 * 2 + 1 != i) continue;
            this.drawMyTexturedModalRect(l3, i4, j3 + 45, 9 * b1, 9, 9, flip);
        }
        RenderSystem.disableBlend();
    }

    public void drawMyTexturedModalRect(int x, int y, int textureX, int textureY, int width, int height, boolean flip) {
        Tessellator tessellator = Tessellator.func_178181_a();
        BufferBuilder vertexbuffer = tessellator.func_178180_c();
        vertexbuffer.func_181668_a(7, DefaultVertexFormats.field_181707_g);
        vertexbuffer.func_225582_a_((double)(x + 0), (double)(y + height), 0.0).func_225583_a_((float)(textureX + (flip ? width : 0)) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        vertexbuffer.func_225582_a_((double)(x + width), (double)(y + height), 0.0).func_225583_a_((float)(textureX + (flip ? 0 : width)) * 0.00390625f, (float)(textureY + height) * 0.00390625f).func_181675_d();
        vertexbuffer.func_225582_a_((double)(x + width), (double)(y + 0), 0.0).func_225583_a_((float)(textureX + (flip ? 0 : width)) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).func_181675_d();
        vertexbuffer.func_225582_a_((double)(x + 0), (double)(y + 0), 0.0).func_225583_a_((float)(textureX + (flip ? width : 0)) * 0.00390625f, (float)(textureY + 0) * 0.00390625f).func_181675_d();
        tessellator.func_78381_a();
    }

    public void drawEntityOnScreen(int p_147046_0_, int p_147046_1_, int p_147046_2_, LivingEntity p_147046_5_, boolean flip) {
        double cos;
        if ((p_147046_5_ = (LivingEntity)this.mc.field_71441_e.func_73045_a(p_147046_5_.func_145782_y())) == null) {
            return;
        }
        RenderSystem.pushMatrix();
        RenderSystem.translatef((float)p_147046_0_, (float)p_147046_1_, (float)50.0f);
        RenderSystem.scaled((double)(-p_147046_2_), (double)p_147046_2_, (double)p_147046_2_);
        RenderSystem.rotatef((float)180.0f, (float)0.0f, (float)0.0f, (float)1.0f);
        MatrixStack matrixStack = new MatrixStack();
        float f2 = p_147046_5_.field_70761_aq;
        float f3 = p_147046_5_.field_70177_z;
        float f6 = p_147046_5_.field_70759_as;
        matrixStack.func_227863_a_(Vector3f.field_229179_b_.func_229187_a_(30.0f));
        float width = p_147046_5_.func_213311_cf() * (float)p_147046_2_ / 30.0f;
        if (width < 1.0f) {
            width = 1.0f;
        }
        if ((cos = Math.sqrt(2.0) / 2.0 / (double)width) > 1.0) {
            cos = 1.0;
        }
        float rotation = (float)Math.toDegrees(Math.acos(cos));
        matrixStack.func_227863_a_(Vector3f.field_229181_d_.func_229187_a_((float)(flip ? 0 : 90) - rotation));
        p_147046_5_.field_70761_aq = 0.0f;
        p_147046_5_.field_70177_z = 0.0f;
        p_147046_5_.field_70759_as = f6 - f2;
        matrixStack.func_227861_a_(0.0, (double)(-p_147046_5_.func_213302_cg() / 2.0f), 0.0);
        EntityRendererManager rendermanager = this.mc.func_175598_ae();
        if (rendermanager.field_217783_c != null) {
            rendermanager.func_178633_a(false);
            boolean hideGUIBU = this.mc.field_71474_y.field_74319_N;
            this.mc.field_71474_y.field_74319_N = true;
            RenderSystem.enableRescaleNormal();
            IRenderTypeBuffer.Impl irendertypebuffer$impl = Minecraft.func_71410_x().func_228019_au_().func_228487_b_();
            rendermanager.func_229084_a_((Entity)p_147046_5_, 0.0, 0.0, 0.0, 0.0f, 1.0f, matrixStack, (IRenderTypeBuffer)irendertypebuffer$impl, 0xF000F0);
            irendertypebuffer$impl.func_228461_a_();
            this.mc.field_71474_y.field_74319_N = hideGUIBU;
            rendermanager.func_178633_a(true);
        }
        RenderSystem.disableBlend();
        p_147046_5_.field_70761_aq = f2;
        p_147046_5_.field_70177_z = f3;
        p_147046_5_.field_70759_as = f6;
        RenderSystem.popMatrix();
    }

    public void drawCenteredArmour(int x, int y, int w, int h, int width, int height) {
        int slot;
        for (slot = 2; slot < 4; ++slot) {
            this.drawItemWithEnchants(false, (ItemStack)this.mc.field_71439_g.field_71071_by.field_70460_b.get(slot), x + w / 2 - 91 - 3, y + 3 + 19 - 19 * (slot - 2), true, false);
        }
        for (slot = 0; slot < 2; ++slot) {
            this.drawItemWithEnchants(false, (ItemStack)this.mc.field_71439_g.field_71071_by.field_70460_b.get(slot), x + w / 2 + 91 + 3, y + 3 + 19 - 19 * slot, false, false);
        }
        ItemStack offhand = this.mc.field_71439_g.func_184582_a(EquipmentSlotType.OFFHAND);
        boolean leftHanded = this.mc.field_71474_y.field_186715_A == HandSide.LEFT;
        int iconY = y > height / 2 ? y - 16 : y + h;
        int bow = this.hasABow();
        if (!(offhand == null || this.isArrows(offhand) && bow != -1)) {
            this.drawItemWithEnchants(false, offhand, leftHanded ? width - 3 : 3, iconY, leftHanded, this.modMain.getBPVPSettings().showFullAmount);
        }
        if (!(this.mc.field_71439_g.field_71071_by.func_70448_g() == null || this.isArrows(this.mc.field_71439_g.field_71071_by.func_70448_g()) && bow != -1)) {
            this.drawItemWithEnchants(false, this.mc.field_71439_g.field_71071_by.func_70448_g(), leftHanded ? 3 : width - 3, iconY, !leftHanded, this.modMain.getBPVPSettings().showFullAmount);
        }
        if (bow != -1 && this.modMain.getBPVPSettings().getArchery()) {
            ItemStack arrow = this.getArrowsStack((PlayerEntity)this.mc.field_71439_g);
            int arrowY = y > height / 2 ? iconY - 19 : iconY + 19;
            boolean onTheRight = bow == 0 && !leftHanded || bow == 1 && leftHanded;
            this.drawItemWithEnchants(true, arrow, onTheRight ? width - 3 : 3, arrowY, onTheRight, false);
        }
    }

    public void drawClassicArmour(int x, int y, int w, int h, int width, int height, boolean flip) {
        ItemStack[] items = new ItemStack[7];
        boolean itemUp = y + h / 2 > height / 2;
        int bow = this.hasABow();
        ItemStack arrows = bow != -1 && this.modMain.getBPVPSettings().getArchery() ? this.getArrowsStack((PlayerEntity)this.mc.field_71439_g) : null;
        ItemStack offhand = this.mc.field_71439_g.func_184582_a(EquipmentSlotType.OFFHAND) == arrows ? null : this.mc.field_71439_g.func_184582_a(EquipmentSlotType.OFFHAND);
        ItemStack mainhand = this.mc.field_71439_g.field_71071_by.func_70448_g() == arrows ? null : this.mc.field_71439_g.field_71071_by.func_70448_g();
        ArrayList<ItemStack> hands = new ArrayList<ItemStack>();
        if (offhand != null) {
            hands.add(offhand);
        }
        if (mainhand != null) {
            hands.add(mainhand);
        }
        if (arrows != null && arrows != offhand && arrows != mainhand) {
            hands.add(arrows);
        }
        ItemStack itemStack = itemUp ? (hands.size() > 2 ? (ItemStack)hands.get(2) : null) : (items[0] = (ItemStack)this.mc.field_71439_g.field_71071_by.field_70460_b.get(3));
        ItemStack itemStack2 = itemUp ? (hands.size() > 1 ? (ItemStack)hands.get(1) : null) : (items[1] = (ItemStack)this.mc.field_71439_g.field_71071_by.field_70460_b.get(2));
        items[2] = itemUp ? (hands.size() > 0 ? (ItemStack)hands.get(0) : null) : (ItemStack)this.mc.field_71439_g.field_71071_by.field_70460_b.get(1);
        items[3] = (ItemStack)this.mc.field_71439_g.field_71071_by.field_70460_b.get(itemUp ? 3 : 0);
        ItemStack itemStack3 = itemUp ? (ItemStack)this.mc.field_71439_g.field_71071_by.field_70460_b.get(2) : (items[4] = hands.size() > 0 ? (ItemStack)hands.get(0) : null);
        ItemStack itemStack4 = itemUp ? (ItemStack)this.mc.field_71439_g.field_71071_by.field_70460_b.get(1) : (items[5] = hands.size() > 1 ? (ItemStack)hands.get(1) : null);
        items[6] = itemUp ? (ItemStack)this.mc.field_71439_g.field_71071_by.field_70460_b.get(0) : (hands.size() > 2 ? (ItemStack)hands.get(2) : null);
        int iconX = x + (flip ? w - 3 : 3);
        for (int i = 0; i < items.length; ++i) {
            int iconY = y + 3 + 19 * i;
            if (items[i] != arrows) {
                this.drawItemWithEnchants(false, items[i], iconX, iconY, flip, this.modMain.getBPVPSettings().showFullAmount && (itemUp && i == 0 || !itemUp && i == 4));
                continue;
            }
            if (arrows == null) continue;
            this.drawItemWithName(true, arrows, this.getArrowAmountString(arrows), null, iconX, iconY, flip, false);
        }
    }

    public void renderArrows(int bow, int iconY, int y, int height, int width) {
        if (this.modMain.getBPVPSettings().getArchery()) {
            ItemStack arrow = this.getArrowsStack((PlayerEntity)this.mc.field_71439_g);
            int arrowY = y > height / 2 ? iconY - 19 : iconY + 19;
            this.drawItemWithEnchants(true, arrow, bow == 0 ? width - 3 : 3, arrowY, bow == 0, false);
        }
    }

    private ItemStack getArrowsStack(PlayerEntity player) {
        if (this.isArrows(player.func_184586_b(Hand.OFF_HAND))) {
            return player.func_184586_b(Hand.OFF_HAND);
        }
        if (this.isArrows(player.func_184586_b(Hand.MAIN_HAND))) {
            return player.func_184586_b(Hand.MAIN_HAND);
        }
        for (int i = 0; i < player.field_71071_by.func_70302_i_(); ++i) {
            ItemStack itemstack = player.field_71071_by.func_70301_a(i);
            if (!this.isArrows(itemstack)) continue;
            return itemstack;
        }
        return null;
    }

    private boolean isArrows(ItemStack stack) {
        return stack != null && stack.func_77973_b() instanceof ArrowItem;
    }

    public void drawItemWithEnchants(boolean arrows, ItemStack stack, int x, int y, boolean flipped, boolean fullSize) {
        if (stack == null || stack.func_77973_b() == Items.field_190931_a) {
            return;
        }
        boolean enchanted = stack.func_77948_v();
        String drawEnchants = this.drawEnchants(enchanted ? stack.func_77986_q() : null);
        String str = !arrows ? this.getDamageString(stack) : this.getArrowAmountString(stack);
        if (!this.modMain.getBPVPSettings().getShowEnchants()) {
            drawEnchants = null;
        }
        this.drawItemWithName(arrows, stack, str, drawEnchants, x, y, flipped, fullSize);
    }

    public void drawItemWithName(boolean arrows, ItemStack stack, String name, String name1, int x, int y, boolean flipped, boolean fullSize) {
        if (stack == null || stack.func_77973_b() == Items.field_190931_a) {
            return;
        }
        int iconX = x - (flipped ? 16 : 0);
        int iconY = y;
        int stringX = iconX + (flipped ? -3 - this.mc.field_71466_p.func_78256_a(name) : 19);
        int stringY = iconY;
        int enchantX = iconX + (flipped ? -3 - this.mc.field_71466_p.func_78256_a(name1) : 19);
        int enchantY = iconY + 9;
        this.mc.field_71466_p.func_175063_a(name, (float)stringX, (float)stringY, 0xFFFFFF);
        if (name1 != null) {
            this.mc.field_71466_p.func_175063_a(name1, (float)enchantX, (float)enchantY, 0xFFFFFF);
        }
        RenderHelper.func_227780_a_();
        this.mc.func_175599_af().field_77023_b -= 1000.0f;
        this.mc.func_175599_af().func_180450_b(stack, iconX, iconY);
        this.mc.func_175599_af().field_77023_b += 1000.0f;
        int size = stack.func_190916_E();
        if (fullSize) {
            size = this.getFullItemAmount(stack.func_77973_b());
        }
        if (size <= 1 || arrows) {
            size = -1;
        }
        this.mc.func_175599_af().func_180453_a(this.mc.field_71466_p, stack, iconX, iconY, size != -1 ? "" + size : "");
        RenderHelper.func_74518_a();
    }

    public boolean tntIsAround() {
        Iterable worldEntities = ((ClientWorld)this.mc.field_71439_g.field_70170_p).func_217416_b();
        for (Entity e : worldEntities) {
            if (!(e instanceof TNTEntity) && (!(e instanceof CreeperEntity) || ((CreeperEntity)e).func_70832_p() != 1) || !(e.func_226277_ct_() - this.mc.field_71439_g.func_226277_ct_() < 5.0) || !(e.func_226277_ct_() - this.mc.field_71439_g.func_226277_ct_() > -5.0) || !(e.func_226278_cu_() - this.mc.field_71439_g.func_226278_cu_() < 5.0) || !(e.func_226278_cu_() - this.mc.field_71439_g.func_226278_cu_() > -5.0) || !(e.func_226281_cx_() - this.mc.field_71439_g.func_226281_cx_() < 5.0) || !(e.func_226281_cx_() - this.mc.field_71439_g.func_226281_cx_() > -5.0)) continue;
            return true;
        }
        return false;
    }

    public boolean arrowIsAround() {
        if (System.currentTimeMillis() - arrowWas < 5000L) {
            return true;
        }
        Iterable worldEntities = ((ClientWorld)this.mc.field_71439_g.field_70170_p).func_217416_b();
        for (Entity e : worldEntities) {
            if (!(e instanceof ArrowEntity) || e.field_70142_S == e.func_226277_ct_() && e.field_70137_T == e.func_226278_cu_() && e.field_70136_U == e.func_226281_cx_() || this.mc.field_71439_g.func_110124_au().equals(((ArrowEntity)e).field_70250_c) || !(e.func_226277_ct_() - this.mc.field_71439_g.func_226277_ct_() < 5.0) || !(e.func_226277_ct_() - this.mc.field_71439_g.func_226277_ct_() > -5.0) || !(e.func_226278_cu_() - this.mc.field_71439_g.func_226278_cu_() < 5.0) || !(e.func_226278_cu_() - this.mc.field_71439_g.func_226278_cu_() > -5.0) || !(e.func_226281_cx_() - this.mc.field_71439_g.func_226281_cx_() < 5.0) || !(e.func_226281_cx_() - this.mc.field_71439_g.func_226281_cx_() > -5.0)) continue;
            arrowWas = System.currentTimeMillis();
            return true;
        }
        return false;
    }

    public int getFullItemAmount(Item item) {
        int toReturn = 0;
        for (int i = 0; i < this.mc.field_71439_g.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)this.mc.field_71439_g.field_71071_by.field_70462_a.get(i);
            if (stack == null || stack.func_77973_b() != item) continue;
            toReturn += stack.func_190916_E();
        }
        ItemStack offhand = this.mc.field_71439_g.func_184582_a(EquipmentSlotType.OFFHAND);
        if (offhand != null && offhand.func_77973_b() == item) {
            toReturn += offhand.func_190916_E();
        }
        return toReturn;
    }

    public String getArrowAmountString(ItemStack used) {
        String toReturn = null;
        int arrows = 0;
        for (int i = 0; i < this.mc.field_71439_g.field_71071_by.field_70462_a.size(); ++i) {
            ItemStack stack = (ItemStack)this.mc.field_71439_g.field_71071_by.field_70462_a.get(i);
            if (!this.isArrows(stack)) continue;
            arrows += stack.func_190916_E();
        }
        ItemStack offhand = this.mc.field_71439_g.func_184582_a(EquipmentSlotType.OFFHAND);
        if (this.isArrows(offhand)) {
            arrows += offhand.func_190916_E();
        }
        toReturn = used.func_190916_E() + "/" + arrows;
        return toReturn;
    }

    public int hasABow() {
        ItemStack offhand = this.mc.field_71439_g.func_184582_a(EquipmentSlotType.OFFHAND);
        ItemStack mainhand = this.mc.field_71439_g.func_184582_a(EquipmentSlotType.MAINHAND);
        if (offhand != null && offhand.func_77973_b() instanceof BowItem && (mainhand == null || !(mainhand.func_77973_b() instanceof BowItem))) {
            return 1;
        }
        for (int i = 0; i < 9; ++i) {
            ItemStack stack = (ItemStack)this.mc.field_71439_g.field_71071_by.field_70462_a.get(i);
            if (stack == null || !(stack.func_77973_b() instanceof BowItem)) continue;
            return 0;
        }
        return -1;
    }

    public void displayDebuffEffects(Interface in, int width, int height) {
        block13: {
            int var1 = in.getX();
            int var2 = in.getY();
            int w = in.getW();
            int h = in.getH();
            boolean flippedVer = in.isFlipped();
            boolean flippedHor = in.shouldFlip(width);
            if (flippedVer) {
                var2 = var2 + h - 30;
            }
            Collection var4 = this.mc.field_71439_g.func_70651_bq();
            PotionSpriteUploader potionspriteuploader = this.mc.func_213248_ap();
            if (var4.isEmpty()) break block13;
            RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            GL11.glDisable((int)2896);
            RenderSystem.enableBlend();
            if (!in.isCentered()) {
                int var5 = 25;
                if (var4.size() > 6) {
                    var5 = 135 / (var4.size() - 1);
                }
                for (EffectInstance var7 : this.mc.field_71439_g.func_70651_bq()) {
                    Effect var8;
                    int duration = var7.func_76459_b();
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (duration <= 200 && !BPVPInterfaceHandler.blinking && this.modMain.getBPVPSettings().potionEffectsBlink) {
                        System.out.println("SUP");
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                    }
                    if ((var8 = var7.func_188419_a()).shouldRender(var7)) {
                        TextureAtlasSprite effectSprite = potionspriteuploader.func_215288_a(var8);
                        this.mc.func_110434_K().func_110577_a(effectSprite.func_229241_m_().func_229223_g_());
                        AbstractGui.blit((int)(flippedHor ? var1 + w - 24 : var1 + 6), (int)(var2 + 7), (int)0, (int)18, (int)18, (TextureAtlasSprite)effectSprite);
                    }
                    String potionName = I18n.func_135052_a((String)var8.func_76393_a(), (Object[])new Object[0]);
                    if (var7.func_76458_c() >= 1 && var7.func_76458_c() <= 9) {
                        potionName = potionName + ' ' + I18n.func_135052_a((String)("enchantment.level." + (var7.func_76458_c() + 1)), (Object[])new Object[0]);
                    }
                    String durationString = StringUtils.func_76337_a((int)var7.func_76459_b());
                    if (!this.modMain.getBPVPSettings().getShowEffectNames()) {
                        potionName = durationString;
                        durationString = "";
                    }
                    this.mc.field_71466_p.func_175063_a(potionName, flippedHor ? (float)(var1 + w - 28 - this.mc.field_71466_p.func_78256_a(potionName)) : (float)(var1 + 10 + 18), (float)(var2 + 6), 0xFFFFFF);
                    this.mc.field_71466_p.func_175063_a(durationString, flippedHor ? (float)(var1 + w - 28 - this.mc.field_71466_p.func_78256_a(durationString)) : (float)(var1 + 10 + 18), (float)(var2 + 6 + 10), 0xFFFFFF);
                    RenderSystem.enableBlend();
                    var2 += flippedVer ? -var5 : var5;
                }
            } else {
                int var5 = 27;
                int defaultEffectAmount = 182 / var5;
                if (var4.size() > defaultEffectAmount) {
                    var5 = 182 / var4.size();
                }
                int totalSize = var4.size() * var5;
                int currentX = var1 + w / 2 - totalSize / 2 + (var5 - 18) / 2;
                int currentY = in.getY() + 7;
                for (EffectInstance var7 : this.mc.field_71439_g.func_70651_bq()) {
                    Effect var8;
                    int duration = var7.func_76459_b();
                    RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
                    if (duration <= 200 && !BPVPInterfaceHandler.blinking && this.modMain.getBPVPSettings().potionEffectsBlink) {
                        RenderSystem.color4f((float)1.0f, (float)1.0f, (float)1.0f, (float)0.2f);
                    }
                    if ((var8 = var7.func_188419_a()).shouldRender(var7)) {
                        TextureAtlasSprite effectSprite = potionspriteuploader.func_215288_a(var8);
                        this.mc.func_110434_K().func_110577_a(effectSprite.func_229241_m_().func_229223_g_());
                        AbstractGui.blit((int)currentX, (int)currentY, (int)0, (int)18, (int)18, (TextureAtlasSprite)effectSprite);
                    }
                    String var10 = StringUtils.func_76337_a((int)var7.func_76459_b());
                    this.mc.field_71466_p.func_175063_a(var10, (float)(currentX + 10 - this.mc.field_71466_p.func_78256_a(var10) / 2), (float)(currentY + 15), 0xFFFFFF);
                    RenderSystem.enableBlend();
                    currentX += var5;
                }
            }
        }
    }

    public String getDamageString(ItemStack stack) {
        Food food;
        String toReturn = stack.func_200301_q().func_150254_d();
        if (stack.func_77973_b().func_219971_r() && (food = stack.func_77973_b().func_219967_s()).func_221466_a() > 0) {
            return I18n.func_135052_a((String)"gui.xaero_restores", (Object[])new Object[0]) + " " + (double)food.func_221466_a() / 2.0;
        }
        if (stack.func_77958_k() == 0) {
            return toReturn;
        }
        int percent = (stack.func_77958_k() - stack.func_77952_i()) * 100 / stack.func_77958_k();
        if (this.modMain.getBPVPSettings().durability == 0) {
            toReturn = percent + "%";
        } else if (this.modMain.getBPVPSettings().durability == 1) {
            toReturn = stack.func_77958_k() - stack.func_77952_i() + 1 + "/" + (stack.func_77958_k() + 1);
        } else if (this.modMain.getBPVPSettings().durability == 2) {
            toReturn = stack.func_77958_k() - stack.func_77952_i() + 1 + "/" + (stack.func_77958_k() + 1) + " (" + percent + "%)";
        }
        if (percent <= 5) {
            toReturn = "\u00a7d" + toReturn;
        } else if (percent <= 25) {
            toReturn = "\u00a7c" + toReturn;
        } else if (percent <= 50) {
            toReturn = "\u00a76" + toReturn;
        } else if (percent <= 75) {
            toReturn = "\u00a7e" + toReturn;
        }
        return toReturn;
    }

    private String drawEnchants(ListNBT etl) {
        if (etl == null) {
            return null;
        }
        String s = "";
        int count = etl.size();
        for (int i = 0; i < count; ++i) {
            String id = etl.func_150305_b(i).func_74779_i("id");
            short short2 = etl.func_150305_b(i).func_74765_d("lvl");
            String e = "";
            Enchantment enchantment = (Enchantment)ForgeRegistries.ENCHANTMENTS.getValue(ResourceLocation.func_208304_a((String)id));
            if (enchantment != null) {
                e = enchantment.func_200305_d((int)short2).getString();
            }
            e = this.translateEchant(e, count);
            s = s + e + ", ";
        }
        if (s.length() >= 2) {
            s = s.substring(0, s.length() - 2);
        }
        return "\u00a7" + ModSettings.ENCHANT_COLORS[this.modMain.getBPVPSettings().enchantColor] + s;
    }

    private String translateEchant(String s, int count) {
        if (s == null || s.length() == 0) {
            return "";
        }
        if (count <= 1) {
            return s;
        }
        String[] words = s.split(" ");
        s = "";
        for (int i = 0; i < words.length; ++i) {
            String s1 = words[i];
            s = s + (i == words.length - 1 ? " " + s1 : (s1.length() > 0 ? s1.substring(0, 1).toUpperCase() : ""));
        }
        return s;
    }
}

