/*
 * Decompiled with CFR 0.152.
 */
package xaero.common.events;

import cpw.mods.fml.common.eventhandler.SubscribeEvent;
import cpw.mods.fml.common.gameevent.InputEvent;
import cpw.mods.fml.common.gameevent.TickEvent;
import cpw.mods.fml.relauncher.Side;
import java.util.ArrayList;
import net.minecraft.client.Minecraft;
import org.lwjgl.opengl.GL11;
import xaero.common.IXaeroMinimap;
import xaero.common.api.spigot.ServerWaypointStorage;
import xaero.common.controls.event.KeyEventHandler;
import xaero.common.minimap.MinimapProcessor;
import xaero.common.minimap.waypoints.WaypointsManager;
import xaero.patreon.Patreon4;

public class FMLEventHandler {
    private IXaeroMinimap modMain;
    private MinimapProcessor minimap;
    protected WaypointsManager waypointsManager;
    private KeyEventHandler keyEventHandler;

    public FMLEventHandler(IXaeroMinimap modMain, KeyEventHandler keyEventHandler) {
        this.modMain = modMain;
        this.minimap = modMain.getInterfaces().getMinimap();
        this.waypointsManager = modMain.getWaypointsManager();
        this.keyEventHandler = keyEventHandler;
    }

    @SubscribeEvent
    public void handleClientTickEvent(TickEvent.ClientTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ServerWaypointStorage.update(this.modMain, this.waypointsManager);
            this.minimap.onClientTick();
            this.waypointsManager.onClientTick();
        }
    }

    @SubscribeEvent
    public void handlePlayerTickEvent(TickEvent.PlayerTickEvent event) {
        if (event.side == Side.CLIENT && event.player == Minecraft.func_71410_x().field_71439_g && event.phase == TickEvent.Phase.START) {
            this.waypointsManager.updateWorldIds();
            this.minimap.onPlayerTick();
            if (this.modMain.getSettings() != null && (this.modMain.getSettings().getDeathpoints() || this.modMain.getSettings().getShowWaypoints() || this.modMain.getSettings().getShowIngameWaypoints())) {
                this.waypointsManager.updateWaypoints();
            } else if (this.waypointsManager.getWaypoints() != null) {
                this.waypointsManager.setWaypoints(null);
            }
            Minecraft mc = Minecraft.func_71410_x();
            this.keyEventHandler.handleEvents(mc, this.modMain);
            this.playerTickPostOverridable();
        }
    }

    protected void playerTickPostOverridable() {
    }

    @SubscribeEvent
    public void handleKeyInputEvent(InputEvent.KeyInputEvent event) {
        if (Minecraft.func_71410_x().field_71439_g != null) {
            Minecraft mc = Minecraft.func_71410_x();
            if (mc.field_71462_r == null) {
                this.keyEventHandler.onKeyInput(mc, this.modMain);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @SubscribeEvent
    public void handleRenderTickEvent(TickEvent.RenderTickEvent event) {
        if (event.phase == TickEvent.Phase.START) {
            ArrayList<Integer> arrayList = this.minimap.getTexturesToDelete();
            synchronized (arrayList) {
                if (!this.minimap.getTexturesToDelete().isEmpty()) {
                    int toDelete = this.minimap.getTexturesToDelete().get(0);
                    GL11.glDeleteTextures((int)toDelete);
                    this.minimap.getTexturesToDelete().remove(0);
                }
            }
            this.minimap.setMainValues();
        }
        if (event.phase == TickEvent.Phase.END) {
            Patreon4.renderingGUI = false;
        }
    }
}

